/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.uiautomator;

import android.os.Process;
import com.android.commands.uiautomator.DumpCommand;
import com.android.commands.uiautomator.EventsCommand;
import com.android.commands.uiautomator.RunTestCommand;
import java.util.Arrays;

public class Launcher {
    private static Command HELP_COMMAND = new Command("help"){

        public void run(String[] args) {
            System.err.println("Usage: uiautomator <subcommand> [options]\n");
            System.err.println("Available subcommands:\n");
            for (Command command : COMMANDS) {
                String shortHelp = command.shortHelp();
                String detailedOptions = command.detailedOptions();
                if (shortHelp == null) {
                    shortHelp = "";
                }
                if (detailedOptions == null) {
                    detailedOptions = "";
                }
                System.err.println(String.format("%s: %s", command.name(), shortHelp));
                System.err.println(detailedOptions);
            }
        }

        public String detailedOptions() {
            return null;
        }

        public String shortHelp() {
            return "displays help message";
        }
    };
    private static Command[] COMMANDS = new Command[]{HELP_COMMAND, new RunTestCommand(), new DumpCommand(), new EventsCommand()};

    public static void main(String[] args) {
        Command command;
        Process.setArgV0("uiautomator");
        if (args.length >= 1 && (command = Launcher.findCommand(args[0])) != null) {
            String[] args2 = new String[]{};
            if (args.length > 1) {
                args2 = Arrays.copyOfRange(args, 1, args.length);
            }
            command.run(args2);
            return;
        }
        HELP_COMMAND.run(args);
    }

    private static Command findCommand(String name) {
        for (Command command : COMMANDS) {
            if (!command.name().equals(name)) continue;
            return command;
        }
        return null;
    }

    public static abstract class Command {
        private String mName;

        public Command(String name) {
            this.mName = name;
        }

        public String name() {
            return this.mName;
        }

        public abstract String shortHelp();

        public abstract String detailedOptions();

        public abstract void run(String[] var1);
    }
}

