/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.uiautomator;

import android.os.Bundle;
import android.util.Log;
import com.android.commands.uiautomator.Launcher;
import com.android.uiautomator.testrunner.UiAutomatorTestRunner;
import dalvik.system.DexFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class RunTestCommand
extends Launcher.Command {
    private static final String LOGTAG = RunTestCommand.class.getSimpleName();
    private static final String OUTPUT_SIMPLE = "simple";
    private static final String OUTPUT_FORMAT_KEY = "outputFormat";
    private static final String CLASS_PARAM = "class";
    private static final String JARS_PARAM = "jars";
    private static final String DEBUG_PARAM = "debug";
    private static final String RUNNER_PARAM = "runner";
    private static final String CLASS_SEPARATOR = ",";
    private static final String JARS_SEPARATOR = ":";
    private static final int ARG_OK = 0;
    private static final int ARG_FAIL_INCOMPLETE_E = -1;
    private static final int ARG_FAIL_INCOMPLETE_C = -2;
    private static final int ARG_FAIL_NO_CLASS = -3;
    private static final int ARG_FAIL_RUNNER = -4;
    private static final int ARG_FAIL_UNSUPPORTED = -99;
    private final Bundle mParams = new Bundle();
    private final List<String> mTestClasses = new ArrayList<String>();
    private boolean mDebug;
    private boolean mMonkey = false;
    private String mRunnerClassName;
    private UiAutomatorTestRunner mRunner;

    public RunTestCommand() {
        super("runtest");
    }

    public void run(String[] args) {
        int ret = this.parseArgs(args);
        switch (ret) {
            case -2: {
                System.err.println("Incomplete '-c' parameter.");
                System.exit(-2);
                break;
            }
            case -1: {
                System.err.println("Incomplete '-e' parameter.");
                System.exit(-1);
                break;
            }
            case -99: {
                System.err.println("Unsupported standalone parameter.");
                System.exit(-99);
                break;
            }
        }
        if (this.mTestClasses.isEmpty()) {
            this.addTestClassesFromJars();
            if (this.mTestClasses.isEmpty()) {
                System.err.println("No test classes found.");
                System.exit(-3);
            }
        }
        this.getRunner().run(this.mTestClasses, this.mParams, this.mDebug, this.mMonkey);
    }

    private int parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-e")) {
                if (i + 2 < args.length) {
                    String key = args[++i];
                    String value = args[++i];
                    if (CLASS_PARAM.equals(key)) {
                        this.addTestClasses(value);
                        continue;
                    }
                    if (DEBUG_PARAM.equals(key)) {
                        this.mDebug = "true".equals(value) || "1".equals(value);
                        continue;
                    }
                    if (RUNNER_PARAM.equals(key)) {
                        this.mRunnerClassName = value;
                        continue;
                    }
                    this.mParams.putString(key, value);
                    continue;
                }
                return -1;
            }
            if (args[i].equals("-c")) {
                if (i + 1 < args.length) {
                    this.addTestClasses(args[++i]);
                    continue;
                }
                return -2;
            }
            if (args[i].equals("--monkey")) {
                this.mMonkey = true;
                continue;
            }
            if (args[i].equals("-s")) {
                this.mParams.putString(OUTPUT_FORMAT_KEY, OUTPUT_SIMPLE);
                continue;
            }
            return -99;
        }
        return 0;
    }

    protected UiAutomatorTestRunner getRunner() {
        if (this.mRunner != null) {
            return this.mRunner;
        }
        if (this.mRunnerClassName == null) {
            this.mRunner = new UiAutomatorTestRunner();
            return this.mRunner;
        }
        Object o = null;
        try {
            Class<?> clazz = Class.forName(this.mRunnerClassName);
            o = clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Cannot find runner: " + this.mRunnerClassName);
            System.exit(-4);
        }
        catch (InstantiationException ie) {
            System.err.println("Cannot instantiate runner: " + this.mRunnerClassName);
            System.exit(-4);
        }
        catch (IllegalAccessException iae) {
            System.err.println("Constructor of runner " + this.mRunnerClassName + " is not accessibile");
            System.exit(-4);
        }
        try {
            UiAutomatorTestRunner runner;
            this.mRunner = runner = (UiAutomatorTestRunner)o;
            return runner;
        }
        catch (ClassCastException cce) {
            System.err.println("Specified runner is not subclass of " + UiAutomatorTestRunner.class.getSimpleName());
            System.exit(-4);
            return null;
        }
    }

    private void addTestClasses(String classes) {
        String[] classArray;
        for (String clazz : classArray = classes.split(CLASS_SEPARATOR)) {
            this.mTestClasses.add(clazz);
        }
    }

    private void addTestClassesFromJars() {
        String[] jarFileNames;
        String jars = this.mParams.getString(JARS_PARAM);
        if (jars == null) {
            return;
        }
        for (String fileName : jarFileNames = jars.split(JARS_SEPARATOR)) {
            if ((fileName = fileName.trim()).isEmpty()) continue;
            try {
                DexFile dexFile = new DexFile(fileName);
                Enumeration<String> e = dexFile.entries();
                while (e.hasMoreElements()) {
                    String className = e.nextElement();
                    if (!this.isTestClass(className)) continue;
                    this.mTestClasses.add(className);
                }
                dexFile.close();
            }
            catch (IOException e) {
                Log.w(LOGTAG, String.format("Could not read %s: %s", fileName, e.getMessage()));
            }
        }
    }

    private boolean isTestClass(String className) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            if (clazz.getEnclosingClass() != null) {
                return false;
            }
            return this.getRunner().getTestCaseFilter().accept(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String detailedOptions() {
        return "    runtest <class spec> [options]\n    <class spec>: <JARS> < -c <CLASSES> | -e class <CLASSES> >\n      <JARS>: a list of jar files containing test classes and dependencies. If\n        the path is relative, it's assumed to be under /data/local/tmp. Use\n        absolute path if the file is elsewhere. Multiple files can be\n        specified, separated by space.\n      <CLASSES>: a list of test class names to run, separated by comma. To\n        a single method, use TestClass#testMethod format. The -e or -c option\n        may be repeated. This option is not required and if not provided then\n        all the tests in provided jars will be run automatically.\n    options:\n      --nohup: trap SIG_HUP, so test won't terminate even if parent process\n               is terminated, e.g. USB is disconnected.\n      -e debug [true|false]: wait for debugger to connect before starting.\n      -e runner [CLASS]: use specified test runner class instead. If\n        unspecified, framework default runner will be used.\n      -e <NAME> <VALUE>: other name-value pairs to be passed to test classes.\n        May be repeated.\n      -e outputFormat simple | -s: enabled less verbose JUnit style output.\n";
    }

    public String shortHelp() {
        return "executes UI automation tests";
    }
}

