/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import com.android.internal.content.PackageMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverActivity
extends AlertActivity
implements AdapterView.OnItemClickListener {
    private static final String TAG = "ResolverActivity";
    private static final boolean DEBUG = false;
    private int mLaunchedFromUid;
    private ResolveListAdapter mAdapter;
    private PackageManager mPm;
    private boolean mAlwaysUseOption;
    private boolean mShowExtended;
    private ListView mListView;
    private Button mAlwaysButton;
    private Button mOnceButton;
    private int mIconDpi;
    private int mIconSize;
    private int mMaxColumns;
    private int mLastSelected = -1;
    private boolean mRegistered;
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        public void onSomePackagesChanged() {
            ResolverActivity.this.mAdapter.handlePackagesChanged();
        }
    };

    private Intent makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setComponent(null);
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = this.makeMyIntent();
        Set<String> categories = intent.getCategories();
        int titleResource = "android.intent.action.MAIN".equals(intent.getAction()) && categories != null && categories.size() == 1 && categories.contains("android.intent.category.HOME") ? 17040374 : 17040373;
        this.onCreate(savedInstanceState, intent, this.getResources().getText(titleResource), null, null, true);
    }

    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean alwaysUseOption) {
        this.setTheme(16974619);
        super.onCreate(savedInstanceState);
        try {
            this.mLaunchedFromUid = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
        }
        catch (RemoteException e) {
            this.mLaunchedFromUid = -1;
        }
        this.mPm = this.getPackageManager();
        this.mAlwaysUseOption = alwaysUseOption;
        this.mMaxColumns = this.getResources().getInteger(17694786);
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mTitle = title;
        this.mPackageMonitor.register(this, this.getMainLooper(), false);
        this.mRegistered = true;
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        this.mIconDpi = am.getLauncherLargeIconDensity();
        this.mIconSize = am.getLauncherLargeIconSize();
        this.mAdapter = new ResolveListAdapter(this, intent, initialIntents, rList, this.mLaunchedFromUid);
        int count = this.mAdapter.getCount();
        if (this.mLaunchedFromUid < 0 || UserHandle.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        }
        if (count > 1) {
            ap.mView = this.getLayoutInflater().inflate(17367176, null);
            this.mListView = (ListView)ap.mView.findViewById(16909060);
            this.mListView.setAdapter(this.mAdapter);
            this.mListView.setOnItemClickListener(this);
            this.mListView.setOnItemLongClickListener(new ItemLongClickListener());
            if (alwaysUseOption) {
                this.mListView.setChoiceMode(1);
            }
        } else {
            if (count == 1) {
                this.startActivity(this.mAdapter.intentForPosition(0));
                this.mPackageMonitor.unregister();
                this.mRegistered = false;
                this.finish();
                return;
            }
            ap.mMessage = this.getResources().getText(17040379);
        }
        this.setupAlert();
        if (alwaysUseOption) {
            ViewGroup buttonLayout = (ViewGroup)this.findViewById(16908929);
            if (buttonLayout != null) {
                buttonLayout.setVisibility(0);
                this.mAlwaysButton = (Button)buttonLayout.findViewById(16909061);
                this.mOnceButton = (Button)buttonLayout.findViewById(16909062);
            } else {
                this.mAlwaysUseOption = false;
            }
            int initialHighlight = this.mAdapter.getInitialHighlight();
            if (initialHighlight >= 0) {
                this.mListView.setItemChecked(initialHighlight, true);
                this.onItemClick(null, null, initialHighlight, 0L);
            }
        }
    }

    Drawable getIcon(Resources res, int resId) {
        Drawable result;
        try {
            result = res.getDrawableForDensity(resId, this.mIconDpi);
        }
        catch (Resources.NotFoundException e) {
            result = null;
        }
        return result;
    }

    Drawable loadIconForResolveInfo(ResolveInfo ri) {
        try {
            Drawable dr;
            if (ri.resolvePackageName != null && ri.icon != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.resolvePackageName), ri.icon)) != null) {
                return dr;
            }
            int iconRes = ri.getIconResource();
            if (iconRes != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.activityInfo.packageName), iconRes)) != null) {
                return dr;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Couldn't find resources for package", e);
        }
        return ri.loadIcon(this.mPm);
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        if (!this.mRegistered) {
            this.mPackageMonitor.register(this, this.getMainLooper(), false);
            this.mRegistered = true;
        }
        this.mAdapter.handlePackagesChanged();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mRegistered) {
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
        }
        if ((this.getIntent().getFlags() & 0x10000000) != 0 && !this.isChangingConfigurations()) {
            this.finish();
        }
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.mAlwaysUseOption) {
            int checkedPos = this.mListView.getCheckedItemPosition();
            boolean enabled = checkedPos != -1;
            this.mLastSelected = checkedPos;
            this.mAlwaysButton.setEnabled(enabled);
            this.mOnceButton.setEnabled(enabled);
            if (enabled) {
                this.mListView.setSelection(checkedPos);
            }
        }
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        boolean hasValidSelection;
        int checkedPos = this.mListView.getCheckedItemPosition();
        boolean bl = hasValidSelection = checkedPos != -1;
        if (this.mAlwaysUseOption && (!hasValidSelection || this.mLastSelected != checkedPos)) {
            this.mAlwaysButton.setEnabled(hasValidSelection);
            this.mOnceButton.setEnabled(hasValidSelection);
            if (hasValidSelection) {
                this.mListView.smoothScrollToPosition(checkedPos);
            }
            this.mLastSelected = checkedPos;
        } else {
            this.startSelected(position, false);
        }
    }

    public void onButtonClick(View v) {
        int id2 = v.getId();
        this.startSelected(this.mListView.getCheckedItemPosition(), id2 == 16909061);
        this.dismiss();
    }

    void startSelected(int which, boolean always) {
        if (this.isFinishing()) {
            return;
        }
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which);
        Intent intent = this.mAdapter.intentForPosition(which);
        this.onIntentSelected(ri, intent, always);
        this.finish();
    }

    protected void onIntentSelected(ResolveInfo ri, Intent intent, boolean alwaysCheck) {
        if (this.mAlwaysUseOption && this.mAdapter.mOrigResolveList != null) {
            String mimeType;
            Set<String> categories;
            IntentFilter filter = new IntentFilter();
            if (intent.getAction() != null) {
                filter.addAction(intent.getAction());
            }
            if ((categories = intent.getCategories()) != null) {
                for (String cat : categories) {
                    filter.addCategory(cat);
                }
            }
            filter.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = intent.getData();
            if (cat == 0x600000 && (mimeType = intent.resolveType(this)) != null) {
                try {
                    filter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w(TAG, e);
                    filter = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator<IntentFilter.AuthorityEntry> aIt;
                filter.addDataScheme(data.getScheme());
                Iterator<PatternMatcher> pIt = ri.filter.schemeSpecificPartsIterator();
                if (pIt != null) {
                    String ssp = data.getSchemeSpecificPart();
                    while (ssp != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(ssp)) continue;
                        filter.addDataSchemeSpecificPart(p.getPath(), p.getType());
                        break;
                    }
                }
                if ((aIt = ri.filter.authoritiesIterator()) != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(path)) continue;
                        filter.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter != null) {
                int N = this.mAdapter.mOrigResolveList.size();
                ComponentName[] set = new ComponentName[N];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = this.mAdapter.mOrigResolveList.get(i);
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                if (alwaysCheck) {
                    this.getPackageManager().addPreferredActivity(filter, bestMatch, set, intent.getComponent());
                } else {
                    try {
                        AppGlobals.getPackageManager().setLastChosenActivity(intent, intent.resolveTypeIfNeeded(this.getContentResolver()), 65536, filter, bestMatch, intent.getComponent());
                    }
                    catch (RemoteException re) {
                        Log.d(TAG, "Error calling setLastChosenActivity\n" + re);
                    }
                }
            }
        }
        if (intent != null) {
            this.startActivity(intent);
        }
    }

    void showAppDetails(ResolveInfo ri) {
        Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", ri.activityInfo.packageName, null)).addFlags(524288);
        this.startActivity(in);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoadIconTask
    extends AsyncTask<DisplayResolveInfo, Void, DisplayResolveInfo> {
        LoadIconTask() {
        }

        protected DisplayResolveInfo doInBackground(DisplayResolveInfo ... params) {
            DisplayResolveInfo info = params[0];
            if (info.displayIcon == null) {
                info.displayIcon = ResolverActivity.this.loadIconForResolveInfo(info.ri);
            }
            return info;
        }

        @Override
        protected void onPostExecute(DisplayResolveInfo info) {
            ResolverActivity.this.mAdapter.notifyDataSetChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemLongClickListener
    implements AdapterView.OnItemLongClickListener {
        ItemLongClickListener() {
        }

        @Override
        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            ResolveInfo ri = ResolverActivity.this.mAdapter.resolveInfoForPosition(position);
            ResolverActivity.this.showAppDetails(ri);
            return true;
        }
    }

    static class ViewHolder {
        public TextView text;
        public TextView text2;
        public ImageView icon;

        public ViewHolder(View view) {
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResolveListAdapter
    extends BaseAdapter {
        private final Intent[] mInitialIntents;
        private final List<ResolveInfo> mBaseResolveList;
        private ResolveInfo mLastChosen;
        private final Intent mIntent;
        private final int mLaunchedFromUid;
        private final LayoutInflater mInflater;
        List<DisplayResolveInfo> mList;
        List<ResolveInfo> mOrigResolveList;
        private int mInitialHighlight = -1;

        public ResolveListAdapter(Context context, Intent intent, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid) {
            this.mIntent = new Intent(intent);
            this.mInitialIntents = initialIntents;
            this.mBaseResolveList = rList;
            this.mLaunchedFromUid = launchedFromUid;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mList = new ArrayList<DisplayResolveInfo>();
            this.rebuildList();
        }

        public void handlePackagesChanged() {
            int oldItemCount = this.getCount();
            this.rebuildList();
            this.notifyDataSetChanged();
            int newItemCount = this.getCount();
            if (newItemCount == 0) {
                ResolverActivity.this.finish();
            }
        }

        public int getInitialHighlight() {
            return this.mInitialHighlight;
        }

        private void rebuildList() {
            int N;
            List<ResolveInfo> currentResolveList;
            try {
                this.mLastChosen = AppGlobals.getPackageManager().getLastChosenActivity(this.mIntent, this.mIntent.resolveTypeIfNeeded(ResolverActivity.this.getContentResolver()), 65536);
            }
            catch (RemoteException re) {
                Log.d(ResolverActivity.TAG, "Error calling setLastChosenActivity\n" + re);
            }
            this.mList.clear();
            if (this.mBaseResolveList != null) {
                currentResolveList = this.mBaseResolveList;
                this.mOrigResolveList = null;
            } else {
                this.mOrigResolveList = ResolverActivity.this.mPm.queryIntentActivities(this.mIntent, 0x10000 | (ResolverActivity.this.mAlwaysUseOption ? 64 : 0));
                currentResolveList = this.mOrigResolveList;
                if (currentResolveList != null) {
                    for (int i = currentResolveList.size() - 1; i >= 0; --i) {
                        ActivityInfo ai = currentResolveList.get((int)i).activityInfo;
                        int granted = ActivityManager.checkComponentPermission(ai.permission, this.mLaunchedFromUid, ai.applicationInfo.uid, ai.exported);
                        if (granted == 0) continue;
                        if (this.mOrigResolveList == currentResolveList) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        currentResolveList.remove(i);
                    }
                }
            }
            if (currentResolveList != null && (N = currentResolveList.size()) > 0) {
                ResolveInfo ri;
                ResolveInfo r0 = currentResolveList.get(0);
                for (int i = 1; i < N; ++i) {
                    ResolveInfo ri2 = currentResolveList.get(i);
                    if (r0.priority == ri2.priority && r0.isDefault == ri2.isDefault) continue;
                    while (i < N) {
                        if (this.mOrigResolveList == currentResolveList) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        currentResolveList.remove(i);
                        --N;
                    }
                }
                if (N > 1) {
                    ResolveInfo.DisplayNameComparator rComparator = new ResolveInfo.DisplayNameComparator(ResolverActivity.this.mPm);
                    Collections.sort(currentResolveList, rComparator);
                }
                if (this.mInitialIntents != null) {
                    for (int i = 0; i < this.mInitialIntents.length; ++i) {
                        Intent ii = this.mInitialIntents[i];
                        if (ii == null) continue;
                        ActivityInfo ai = ii.resolveActivityInfo(ResolverActivity.this.getPackageManager(), 0);
                        if (ai == null) {
                            Log.w(ResolverActivity.TAG, "No activity found for " + ii);
                            continue;
                        }
                        ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        if (ii instanceof LabeledIntent) {
                            LabeledIntent li = (LabeledIntent)ii;
                            ri.resolvePackageName = li.getSourcePackage();
                            ri.labelRes = li.getLabelResource();
                            ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                            ri.icon = li.getIconResource();
                        }
                        this.mList.add(new DisplayResolveInfo(ri, ri.loadLabel(ResolverActivity.this.getPackageManager()), null, ii));
                    }
                }
                r0 = currentResolveList.get(0);
                int start = 0;
                CharSequence r0Label = r0.loadLabel(ResolverActivity.this.mPm);
                ResolverActivity.this.mShowExtended = false;
                for (int i = 1; i < N; ++i) {
                    CharSequence riLabel;
                    if (r0Label == null) {
                        r0Label = r0.activityInfo.packageName;
                    }
                    if ((riLabel = (ri = currentResolveList.get(i)).loadLabel(ResolverActivity.this.mPm)) == null) {
                        riLabel = ri.activityInfo.packageName;
                    }
                    if (riLabel.equals(r0Label)) continue;
                    this.processGroup(currentResolveList, start, i - 1, r0, r0Label);
                    r0 = ri;
                    r0Label = riLabel;
                    start = i;
                }
                this.processGroup(currentResolveList, start, N - 1, r0, r0Label);
            }
        }

        private void processGroup(List<ResolveInfo> rList, int start, int end, ResolveInfo ro, CharSequence roLabel) {
            int num = end - start + 1;
            if (num == 1) {
                if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(ro.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(ro.activityInfo.name)) {
                    this.mInitialHighlight = this.mList.size();
                }
                this.mList.add(new DisplayResolveInfo(ro, roLabel, null, null));
            } else {
                ResolverActivity.this.mShowExtended = true;
                boolean usePkg = false;
                CharSequence startApp = ro.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                if (startApp == null) {
                    usePkg = true;
                }
                if (!usePkg) {
                    HashSet<CharSequence> duplicates = new HashSet<CharSequence>();
                    duplicates.add(startApp);
                    for (int j = start + 1; j <= end; ++j) {
                        ResolveInfo jRi = rList.get(j);
                        CharSequence jApp = jRi.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                        if (jApp == null || duplicates.contains(jApp)) {
                            usePkg = true;
                            break;
                        }
                        duplicates.add(jApp);
                    }
                    duplicates.clear();
                }
                for (int k = start; k <= end; ++k) {
                    ResolveInfo add = rList.get(k);
                    if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(add.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(add.activityInfo.name)) {
                        this.mInitialHighlight = this.mList.size();
                    }
                    if (usePkg) {
                        this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.packageName, null));
                        continue;
                    }
                    this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm), null));
                }
            }
        }

        public ResolveInfo resolveInfoForPosition(int position) {
            return this.mList.get((int)position).ri;
        }

        public Intent intentForPosition(int position) {
            DisplayResolveInfo dri = this.mList.get(position);
            Intent intent = new Intent(dri.origIntent != null ? dri.origIntent : this.mIntent);
            intent.addFlags(0x3000000);
            ActivityInfo ai = dri.ri.activityInfo;
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            return intent;
        }

        @Override
        public int getCount() {
            return this.mList.size();
        }

        @Override
        public Object getItem(int position) {
            return this.mList.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            if (convertView == null) {
                view = this.mInflater.inflate(17367175, parent, false);
                ViewHolder holder = new ViewHolder(view);
                view.setTag(holder);
                ViewGroup.LayoutParams lp = holder.icon.getLayoutParams();
                lp.width = lp.height = ResolverActivity.this.mIconSize;
            } else {
                view = convertView;
            }
            this.bindView(view, this.mList.get(position));
            return view;
        }

        private final void bindView(View view, DisplayResolveInfo info) {
            ViewHolder holder = (ViewHolder)view.getTag();
            holder.text.setText(info.displayLabel);
            if (ResolverActivity.this.mShowExtended) {
                holder.text2.setVisibility(0);
                holder.text2.setText(info.extendedInfo);
            } else {
                holder.text2.setVisibility(8);
            }
            if (info.displayIcon == null) {
                new LoadIconTask().execute(info);
            }
            holder.icon.setImageDrawable(info.displayIcon);
        }
    }

    private final class DisplayResolveInfo {
        ResolveInfo ri;
        CharSequence displayLabel;
        Drawable displayIcon;
        CharSequence extendedInfo;
        Intent origIntent;

        DisplayResolveInfo(ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent pOrigIntent) {
            this.ri = pri;
            this.displayLabel = pLabel;
            this.extendedInfo = pInfo;
            this.origIntent = pOrigIntent;
        }
    }
}

