/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.dreams.IDreamManager;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.AlertController;
import com.android.internal.policy.impl.EnableAccessibilityController;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GlobalActions
implements DialogInterface.OnDismissListener,
DialogInterface.OnClickListener {
    private static final String TAG = "GlobalActions";
    private static final boolean SHOW_SILENT_TOGGLE = true;
    private final Context mContext;
    private final WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    private final AudioManager mAudioManager;
    private final IDreamManager mDreamManager;
    private ArrayList<Action> mItems;
    private GlobalActionsDialog mDialog;
    private Action mSilentModeAction;
    private ToggleAction mAirplaneModeOn;
    private MyAdapter mAdapter;
    private boolean mKeyguardShowing = false;
    private boolean mDeviceProvisioned = false;
    private ToggleAction.State mAirplaneState = ToggleAction.State.Off;
    private boolean mIsWaitingForEcmExit = false;
    private boolean mHasTelephony;
    private boolean mHasVibrator;
    private final boolean mShowSilentToggle;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) || "android.intent.action.SCREEN_OFF".equals(action)) {
                String reason = intent.getStringExtra("reason");
                if (!"globalactions".equals(reason)) {
                    GlobalActions.this.mHandler.sendEmptyMessage(0);
                }
            } else if ("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED".equals(action) && !intent.getBooleanExtra("PHONE_IN_ECM_STATE", false) && GlobalActions.this.mIsWaitingForEcmExit) {
                GlobalActions.this.mIsWaitingForEcmExit = false;
                GlobalActions.this.changeAirplaneModeSystemSetting(true);
            }
        }
    };
    PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        public void onServiceStateChanged(ServiceState serviceState) {
            if (!GlobalActions.this.mHasTelephony) {
                return;
            }
            boolean inAirplaneMode = serviceState.getState() == 3;
            GlobalActions.this.mAirplaneState = inAirplaneMode ? ToggleAction.State.On : ToggleAction.State.Off;
            GlobalActions.this.mAirplaneModeOn.updateState(GlobalActions.this.mAirplaneState);
            GlobalActions.this.mAdapter.notifyDataSetChanged();
        }
    };
    private BroadcastReceiver mRingerModeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.media.RINGER_MODE_CHANGED")) {
                GlobalActions.this.mHandler.sendEmptyMessage(1);
            }
        }
    };
    private ContentObserver mAirplaneModeObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            GlobalActions.this.onAirplaneModeChanged();
        }
    };
    private static final int MESSAGE_DISMISS = 0;
    private static final int MESSAGE_REFRESH = 1;
    private static final int MESSAGE_SHOW = 2;
    private static final int DIALOG_DISMISS_DELAY = 300;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (GlobalActions.this.mDialog == null) break;
                    GlobalActions.this.mDialog.dismiss();
                    GlobalActions.this.mDialog = null;
                    break;
                }
                case 1: {
                    GlobalActions.this.refreshSilentMode();
                    GlobalActions.this.mAdapter.notifyDataSetChanged();
                    break;
                }
                case 2: {
                    GlobalActions.this.handleShow();
                }
            }
        }
    };

    public GlobalActions(Context context, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.mContext = context;
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mDreamManager = IDreamManager.Stub.asInterface(ServiceManager.getService("dreams"));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        context.registerReceiver(this.mBroadcastReceiver, filter);
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        telephonyManager.listen(this.mPhoneStateListener, 1);
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.mHasTelephony = cm.isNetworkSupported(0);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("airplane_mode_on"), true, this.mAirplaneModeObserver);
        Vibrator vibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        this.mHasVibrator = vibrator != null && vibrator.hasVibrator();
        this.mShowSilentToggle = !this.mContext.getResources().getBoolean(17891415);
    }

    public void showDialog(boolean keyguardShowing, boolean isDeviceProvisioned) {
        this.mKeyguardShowing = keyguardShowing;
        this.mDeviceProvisioned = isDeviceProvisioned;
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
            this.mHandler.sendEmptyMessage(2);
        } else {
            this.handleShow();
        }
    }

    private void awakenIfNecessary() {
        if (this.mDreamManager != null) {
            try {
                if (this.mDreamManager.isDreaming()) {
                    this.mDreamManager.awaken();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void handleShow() {
        this.awakenIfNecessary();
        this.mDialog = this.createDialog();
        this.prepareDialog();
        WindowManager.LayoutParams attrs = this.mDialog.getWindow().getAttributes();
        attrs.setTitle(TAG);
        this.mDialog.getWindow().setAttributes(attrs);
        this.mDialog.show();
        this.mDialog.getWindow().getDecorView().setSystemUiVisibility(65536);
    }

    private GlobalActionsDialog createDialog() {
        this.mSilentModeAction = !this.mHasVibrator ? new SilentModeToggleAction() : new SilentModeTriStateAction(this.mContext, this.mAudioManager, this.mHandler);
        this.mAirplaneModeOn = new ToggleAction(17302249, 17302250, 17039565, 17039566, 17039567){

            void onToggle(boolean on) {
                if (GlobalActions.this.mHasTelephony && Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"))) {
                    GlobalActions.this.mIsWaitingForEcmExit = true;
                    Intent ecmDialogIntent = new Intent("android.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS", null);
                    ecmDialogIntent.addFlags(0x10000000);
                    GlobalActions.this.mContext.startActivity(ecmDialogIntent);
                } else {
                    GlobalActions.this.changeAirplaneModeSystemSetting(on);
                }
            }

            protected void changeStateFromPress(boolean buttonOn) {
                if (!GlobalActions.this.mHasTelephony) {
                    return;
                }
                if (!Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"))) {
                    this.mState = buttonOn ? ToggleAction.State.TurningOn : ToggleAction.State.TurningOff;
                    GlobalActions.this.mAirplaneState = this.mState;
                }
            }

            public boolean showDuringKeyguard() {
                return true;
            }

            public boolean showBeforeProvisioning() {
                return false;
            }
        };
        this.onAirplaneModeChanged();
        this.mItems = new ArrayList();
        this.mItems.add(new SinglePressAction(17301552, 17039558){

            public void onPress() {
                GlobalActions.this.mWindowManagerFuncs.shutdown(true);
            }

            public boolean onLongPress() {
                GlobalActions.this.mWindowManagerFuncs.rebootSafeMode(true);
                return true;
            }

            public boolean showDuringKeyguard() {
                return true;
            }

            public boolean showBeforeProvisioning() {
                return true;
            }
        });
        this.mItems.add(this.mAirplaneModeOn);
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "bugreport_in_power_menu", 0) != 0 && this.isCurrentUserOwner()) {
            this.mItems.add(new SinglePressAction(17302925, 17039559){

                public void onPress() {
                    AlertDialog.Builder builder = new AlertDialog.Builder(GlobalActions.this.mContext);
                    builder.setTitle(17039560);
                    builder.setMessage(17039561);
                    builder.setNegativeButton(0x1040000, null);
                    builder.setPositiveButton(17040389, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            GlobalActions.this.mHandler.postDelayed(new Runnable(){

                                public void run() {
                                    try {
                                        ActivityManagerNative.getDefault().requestBugReport();
                                    }
                                    catch (RemoteException remoteException) {
                                        // empty catch block
                                    }
                                }
                            }, 500L);
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.getWindow().setType(2009);
                    dialog.show();
                }

                public boolean onLongPress() {
                    return false;
                }

                public boolean showDuringKeyguard() {
                    return true;
                }

                public boolean showBeforeProvisioning() {
                    return false;
                }
            });
        }
        if (this.mShowSilentToggle) {
            this.mItems.add(this.mSilentModeAction);
        }
        if (SystemProperties.getBoolean("fw.power_user_switcher", false)) {
            this.addUsersToMenu(this.mItems);
        }
        this.mAdapter = new MyAdapter();
        AlertController.AlertParams params = new AlertController.AlertParams(this.mContext);
        params.mAdapter = this.mAdapter;
        params.mOnClickListener = this;
        params.mForceInverseBackground = true;
        GlobalActionsDialog dialog = new GlobalActionsDialog(this.mContext, params);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getListView().setItemsCanFocus(true);
        dialog.getListView().setLongClickable(true);
        dialog.getListView().setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                return GlobalActions.this.mAdapter.getItem(position).onLongPress();
            }
        });
        dialog.getWindow().setType(2009);
        dialog.setOnDismissListener(this);
        return dialog;
    }

    private UserInfo getCurrentUser() {
        try {
            return ActivityManagerNative.getDefault().getCurrentUser();
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private boolean isCurrentUserOwner() {
        UserInfo currentUser = this.getCurrentUser();
        return currentUser == null || currentUser.isPrimary();
    }

    private void addUsersToMenu(ArrayList<Action> items) {
        List<UserInfo> users = ((UserManager)this.mContext.getSystemService("user")).getUsers();
        if (users.size() > 1) {
            UserInfo currentUser = this.getCurrentUser();
            for (final UserInfo user : users) {
                boolean isCurrentUser = currentUser == null ? user.id == 0 : currentUser.id == user.id;
                Drawable icon = user.iconPath != null ? Drawable.createFromPath(user.iconPath) : null;
                SinglePressAction switchToUser = new SinglePressAction(17302328, icon, (user.name != null ? user.name : "Primary") + (isCurrentUser ? " \u2714" : "")){

                    public void onPress() {
                        try {
                            ActivityManagerNative.getDefault().switchUser(user.id);
                        }
                        catch (RemoteException re) {
                            Log.e(GlobalActions.TAG, "Couldn't switch user " + re);
                        }
                    }

                    public boolean showDuringKeyguard() {
                        return true;
                    }

                    public boolean showBeforeProvisioning() {
                        return false;
                    }
                };
                items.add(switchToUser);
            }
        }
    }

    private void prepareDialog() {
        this.refreshSilentMode();
        this.mAirplaneModeOn.updateState(this.mAirplaneState);
        this.mAdapter.notifyDataSetChanged();
        this.mDialog.getWindow().setType(2009);
        if (this.mShowSilentToggle) {
            IntentFilter filter = new IntentFilter("android.media.RINGER_MODE_CHANGED");
            this.mContext.registerReceiver(this.mRingerModeReceiver, filter);
        }
    }

    private void refreshSilentMode() {
        if (!this.mHasVibrator) {
            boolean silentModeOn = this.mAudioManager.getRingerMode() != 2;
            ((ToggleAction)this.mSilentModeAction).updateState(silentModeOn ? ToggleAction.State.On : ToggleAction.State.Off);
        }
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        if (this.mShowSilentToggle) {
            try {
                this.mContext.unregisterReceiver(this.mRingerModeReceiver);
            }
            catch (IllegalArgumentException ie) {
                Log.w(TAG, ie);
            }
        }
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (!(this.mAdapter.getItem(which) instanceof SilentModeTriStateAction)) {
            dialog.dismiss();
        }
        this.mAdapter.getItem(which).onPress();
    }

    private void onAirplaneModeChanged() {
        if (this.mHasTelephony) {
            return;
        }
        boolean airplaneModeOn = Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
        this.mAirplaneState = airplaneModeOn ? ToggleAction.State.On : ToggleAction.State.Off;
        this.mAirplaneModeOn.updateState(this.mAirplaneState);
    }

    private void changeAirplaneModeSystemSetting(boolean on) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "airplane_mode_on", on ? 1 : 0);
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.addFlags(0x20000000);
        intent.putExtra("state", on);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        if (!this.mHasTelephony) {
            this.mAirplaneState = on ? ToggleAction.State.On : ToggleAction.State.Off;
        }
    }

    private static final class GlobalActionsDialog
    extends Dialog
    implements DialogInterface {
        private final Context mContext;
        private final int mWindowTouchSlop;
        private final AlertController mAlert;
        private EnableAccessibilityController mEnableAccessibilityController;
        private boolean mIntercepted;
        private boolean mCancelOnUp;

        public GlobalActionsDialog(Context context, AlertController.AlertParams params) {
            super(context, GlobalActionsDialog.getDialogTheme(context));
            this.mContext = context;
            this.mAlert = new AlertController(this.mContext, this, this.getWindow());
            this.mWindowTouchSlop = ViewConfiguration.get(context).getScaledWindowTouchSlop();
            params.apply(this.mAlert);
        }

        private static int getDialogTheme(Context context) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(16843529, outValue, true);
            return outValue.resourceId;
        }

        protected void onStart() {
            if (EnableAccessibilityController.canEnableAccessibilityViaGesture(this.mContext)) {
                this.mEnableAccessibilityController = new EnableAccessibilityController(this.mContext);
                super.setCanceledOnTouchOutside(false);
            } else {
                this.mEnableAccessibilityController = null;
                super.setCanceledOnTouchOutside(true);
            }
            super.onStart();
        }

        protected void onStop() {
            if (this.mEnableAccessibilityController != null) {
                this.mEnableAccessibilityController.onDestroy();
            }
            super.onStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dispatchTouchEvent(MotionEvent event) {
            block10: {
                if (this.mEnableAccessibilityController != null) {
                    int action = event.getActionMasked();
                    if (action == 0) {
                        View decor = this.getWindow().getDecorView();
                        int eventX = (int)event.getX();
                        int eventY = (int)event.getY();
                        if (eventX < -this.mWindowTouchSlop || eventY < -this.mWindowTouchSlop || eventX >= decor.getWidth() + this.mWindowTouchSlop || eventY >= decor.getHeight() + this.mWindowTouchSlop) {
                            this.mCancelOnUp = true;
                        }
                    }
                    try {
                        if (!this.mIntercepted) {
                            this.mIntercepted = this.mEnableAccessibilityController.onInterceptTouchEvent(event);
                            if (this.mIntercepted) {
                                long now = SystemClock.uptimeMillis();
                                event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                                event.setSource(4098);
                                this.mCancelOnUp = true;
                            }
                            break block10;
                        }
                        boolean bl = this.mEnableAccessibilityController.onTouchEvent(event);
                        return bl;
                    }
                    finally {
                        if (action == 1) {
                            if (this.mCancelOnUp) {
                                this.cancel();
                            }
                            this.mCancelOnUp = false;
                            this.mIntercepted = false;
                        }
                    }
                }
            }
            return super.dispatchTouchEvent(event);
        }

        public ListView getListView() {
            return this.mAlert.getListView();
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.mAlert.installContent();
        }

        public boolean onKeyDown(int keyCode, KeyEvent event) {
            if (this.mAlert.onKeyDown(keyCode, event)) {
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }

        public boolean onKeyUp(int keyCode, KeyEvent event) {
            if (this.mAlert.onKeyUp(keyCode, event)) {
                return true;
            }
            return super.onKeyUp(keyCode, event);
        }
    }

    private static class SilentModeTriStateAction
    implements Action,
    View.OnClickListener {
        private final int[] ITEM_IDS = new int[]{16908955, 16908956, 16908957};
        private final AudioManager mAudioManager;
        private final Handler mHandler;
        private final Context mContext;

        SilentModeTriStateAction(Context context, AudioManager audioManager, Handler handler) {
            this.mAudioManager = audioManager;
            this.mHandler = handler;
            this.mContext = context;
        }

        private int ringerModeToIndex(int ringerMode) {
            return ringerMode;
        }

        private int indexToRingerMode(int index) {
            return index;
        }

        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367110, parent, false);
            int selectedIndex = this.ringerModeToIndex(this.mAudioManager.getRingerMode());
            for (int i = 0; i < 3; ++i) {
                View itemView = v.findViewById(this.ITEM_IDS[i]);
                itemView.setSelected(selectedIndex == i);
                itemView.setTag(i);
                itemView.setOnClickListener(this);
            }
            return v;
        }

        public void onPress() {
        }

        public boolean onLongPress() {
            return false;
        }

        public boolean showDuringKeyguard() {
            return true;
        }

        public boolean showBeforeProvisioning() {
            return false;
        }

        public boolean isEnabled() {
            return true;
        }

        void willCreate() {
        }

        public void onClick(View v) {
            if (!(v.getTag() instanceof Integer)) {
                return;
            }
            int index = (Integer)v.getTag();
            this.mAudioManager.setRingerMode(this.indexToRingerMode(index));
            this.mHandler.sendEmptyMessageDelayed(0, 300L);
        }
    }

    private class SilentModeToggleAction
    extends ToggleAction {
        public SilentModeToggleAction() {
            super(17302190, 17302188, 17039562, 17039563, 17039564);
        }

        void onToggle(boolean on) {
            if (on) {
                GlobalActions.this.mAudioManager.setRingerMode(0);
            } else {
                GlobalActions.this.mAudioManager.setRingerMode(2);
            }
        }

        public boolean showDuringKeyguard() {
            return true;
        }

        public boolean showBeforeProvisioning() {
            return false;
        }
    }

    private static abstract class ToggleAction
    implements Action {
        protected State mState = State.Off;
        protected int mEnabledIconResId;
        protected int mDisabledIconResid;
        protected int mMessageResId;
        protected int mEnabledStatusMessageResId;
        protected int mDisabledStatusMessageResId;

        public ToggleAction(int enabledIconResId, int disabledIconResid, int message, int enabledStatusMessageResId, int disabledStatusMessageResId) {
            this.mEnabledIconResId = enabledIconResId;
            this.mDisabledIconResid = disabledIconResid;
            this.mMessageResId = message;
            this.mEnabledStatusMessageResId = enabledStatusMessageResId;
            this.mDisabledStatusMessageResId = disabledStatusMessageResId;
        }

        void willCreate() {
        }

        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            boolean on;
            this.willCreate();
            View v = inflater.inflate(17367109, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            TextView statusView = (TextView)v.findViewById(16908954);
            boolean enabled = this.isEnabled();
            if (messageView != null) {
                messageView.setText(this.mMessageResId);
                messageView.setEnabled(enabled);
            }
            boolean bl = on = this.mState == State.On || this.mState == State.TurningOn;
            if (icon != null) {
                icon.setImageDrawable(context.getResources().getDrawable(on ? this.mEnabledIconResId : this.mDisabledIconResid));
                icon.setEnabled(enabled);
            }
            if (statusView != null) {
                statusView.setText(on ? this.mEnabledStatusMessageResId : this.mDisabledStatusMessageResId);
                statusView.setVisibility(0);
                statusView.setEnabled(enabled);
            }
            v.setEnabled(enabled);
            return v;
        }

        public final void onPress() {
            if (this.mState.inTransition()) {
                Log.w(GlobalActions.TAG, "shouldn't be able to toggle when in transition");
                return;
            }
            boolean nowOn = this.mState != State.On;
            this.onToggle(nowOn);
            this.changeStateFromPress(nowOn);
        }

        public boolean onLongPress() {
            return false;
        }

        public boolean isEnabled() {
            return !this.mState.inTransition();
        }

        protected void changeStateFromPress(boolean buttonOn) {
            this.mState = buttonOn ? State.On : State.Off;
        }

        abstract void onToggle(boolean var1);

        public void updateState(State state) {
            this.mState = state;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            Off(false),
            TurningOn(true),
            TurningOff(true),
            On(false);

            private final boolean inTransition;

            private State(boolean intermediate) {
                this.inTransition = intermediate;
            }

            public boolean inTransition() {
                return this.inTransition;
            }
        }
    }

    private static abstract class SinglePressAction
    implements Action {
        private final int mIconResId;
        private final Drawable mIcon;
        private final int mMessageResId;
        private final CharSequence mMessage;

        protected SinglePressAction(int iconResId, int messageResId) {
            this.mIconResId = iconResId;
            this.mMessageResId = messageResId;
            this.mMessage = null;
            this.mIcon = null;
        }

        protected SinglePressAction(int iconResId, Drawable icon, CharSequence message) {
            this.mIconResId = iconResId;
            this.mMessageResId = 0;
            this.mMessage = message;
            this.mIcon = icon;
        }

        protected SinglePressAction(int iconResId, CharSequence message) {
            this.mIconResId = iconResId;
            this.mMessageResId = 0;
            this.mMessage = message;
            this.mIcon = null;
        }

        public boolean isEnabled() {
            return true;
        }

        public abstract void onPress();

        public boolean onLongPress() {
            return false;
        }

        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367109, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            v.findViewById(16908954).setVisibility(8);
            if (this.mIcon != null) {
                icon.setImageDrawable(this.mIcon);
                icon.setScaleType(ImageView.ScaleType.CENTER_CROP);
            } else if (this.mIconResId != 0) {
                icon.setImageDrawable(context.getResources().getDrawable(this.mIconResId));
            }
            if (this.mMessage != null) {
                messageView.setText(this.mMessage);
            } else {
                messageView.setText(this.mMessageResId);
            }
            return v;
        }
    }

    private static interface Action {
        public View create(Context var1, View var2, ViewGroup var3, LayoutInflater var4);

        public void onPress();

        public boolean onLongPress();

        public boolean showDuringKeyguard();

        public boolean showBeforeProvisioning();

        public boolean isEnabled();
    }

    private class MyAdapter
    extends BaseAdapter {
        private MyAdapter() {
        }

        public int getCount() {
            int count = 0;
            for (int i = 0; i < GlobalActions.this.mItems.size(); ++i) {
                Action action = (Action)GlobalActions.this.mItems.get(i);
                if (GlobalActions.this.mKeyguardShowing && !action.showDuringKeyguard() || !GlobalActions.this.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                ++count;
            }
            return count;
        }

        public boolean isEnabled(int position) {
            return this.getItem(position).isEnabled();
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public Action getItem(int position) {
            int filteredPos = 0;
            for (int i = 0; i < GlobalActions.this.mItems.size(); ++i) {
                Action action = (Action)GlobalActions.this.mItems.get(i);
                if (GlobalActions.this.mKeyguardShowing && !action.showDuringKeyguard() || !GlobalActions.this.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                if (filteredPos == position) {
                    return action;
                }
                ++filteredPos;
            }
            throw new IllegalArgumentException("position " + position + " out of range of showable actions" + ", filtered count=" + this.getCount() + ", keyguardshowing=" + GlobalActions.this.mKeyguardShowing + ", provisioned=" + GlobalActions.this.mDeviceProvisioned);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Action action = this.getItem(position);
            return action.create(GlobalActions.this.mContext, convertView, parent, LayoutInflater.from(GlobalActions.this.mContext));
        }
    }
}

