/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl.keyguard;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import com.android.internal.policy.IKeyguardExitCallback;
import com.android.internal.policy.IKeyguardService;
import com.android.internal.policy.IKeyguardShowCallback;
import com.android.internal.policy.impl.keyguard.KeyguardServiceWrapper;
import com.android.internal.widget.LockPatternUtils;

public class KeyguardServiceDelegate {
    public static final String KEYGUARD_PACKAGE = "com.android.keyguard";
    public static final String KEYGUARD_CLASS = "com.android.keyguard.KeyguardService";
    private static final String TAG = "KeyguardServiceDelegate";
    private static final boolean DEBUG = true;
    protected KeyguardServiceWrapper mKeyguardService;
    private View mScrim;
    private KeyguardState mKeyguardState = new KeyguardState();
    private final ServiceConnection mKeyguardConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.v(KeyguardServiceDelegate.TAG, "*** Keyguard connected (yay!)");
            KeyguardServiceDelegate.this.mKeyguardService = new KeyguardServiceWrapper(IKeyguardService.Stub.asInterface(service));
            if (((KeyguardServiceDelegate)KeyguardServiceDelegate.this).mKeyguardState.systemIsReady) {
                KeyguardServiceDelegate.this.mKeyguardService.onSystemReady();
                KeyguardServiceDelegate.this.mKeyguardService.onScreenTurnedOn(new KeyguardShowDelegate(null));
            }
            if (((KeyguardServiceDelegate)KeyguardServiceDelegate.this).mKeyguardState.bootCompleted) {
                KeyguardServiceDelegate.this.mKeyguardService.onBootCompleted();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.v(KeyguardServiceDelegate.TAG, "*** Keyguard disconnected (boo!)");
            KeyguardServiceDelegate.this.mKeyguardService = null;
        }
    };

    public KeyguardServiceDelegate(Context context, LockPatternUtils lockPatternUtils) {
        Intent intent = new Intent();
        intent.setClassName(KEYGUARD_PACKAGE, KEYGUARD_CLASS);
        this.mScrim = KeyguardServiceDelegate.createScrim(context);
        if (!context.bindServiceAsUser(intent, this.mKeyguardConnection, 1, UserHandle.OWNER)) {
            Log.v(TAG, "*** Keyguard: can't bind to com.android.keyguard.KeyguardService");
        } else {
            Log.v(TAG, "*** Keyguard started");
        }
    }

    public boolean isShowing() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.showing = this.mKeyguardService.isShowing();
        }
        return this.mKeyguardState.showing;
    }

    public boolean isShowingAndNotHidden() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.showingAndNotHidden = this.mKeyguardService.isShowingAndNotHidden();
        }
        return this.mKeyguardState.showingAndNotHidden;
    }

    public boolean isInputRestricted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.inputRestricted = this.mKeyguardService.isInputRestricted();
        }
        return this.mKeyguardState.inputRestricted;
    }

    public void verifyUnlock(WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.verifyUnlock(new KeyguardExitDelegate(onKeyguardExitResult));
        }
    }

    public void keyguardDone(boolean authenticated, boolean wakeup) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.keyguardDone(authenticated, wakeup);
        }
    }

    public void setHidden(boolean isHidden) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setHidden(isHidden);
        }
        this.mKeyguardState.hidden = isHidden;
    }

    public void dismiss() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.dismiss();
        }
    }

    public boolean isSecure() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.secure = this.mKeyguardService.isSecure();
        }
        return this.mKeyguardState.secure;
    }

    public void onDreamingStarted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onDreamingStarted();
        }
        this.mKeyguardState.dreaming = true;
    }

    public void onDreamingStopped() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onDreamingStopped();
        }
        this.mKeyguardState.dreaming = false;
    }

    public void onScreenTurnedOn(ShowListener showListener) {
        if (this.mKeyguardService != null) {
            Log.v(TAG, "onScreenTurnedOn(showListener = " + showListener + ")");
            this.mKeyguardService.onScreenTurnedOn(new KeyguardShowDelegate(showListener));
        } else {
            Slog.w(TAG, "onScreenTurnedOn(): no keyguard service!");
            showListener.onShown(null);
        }
        this.mKeyguardState.screenIsOn = true;
    }

    public void onScreenTurnedOff(int why) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onScreenTurnedOff(why);
        }
        this.mKeyguardState.offReason = why;
        this.mKeyguardState.screenIsOn = false;
    }

    public void setKeyguardEnabled(boolean enabled) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setKeyguardEnabled(enabled);
        }
        this.mKeyguardState.enabled = enabled;
    }

    public boolean isDismissable() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.dismissable = this.mKeyguardService.isDismissable();
        }
        return this.mKeyguardState.dismissable;
    }

    public void onSystemReady() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onSystemReady();
        } else {
            Log.v(TAG, "onSystemReady() called before keyguard service was ready");
            this.mKeyguardState.systemIsReady = true;
        }
    }

    public void doKeyguardTimeout(Bundle options) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.doKeyguardTimeout(options);
        }
    }

    public void showAssistant() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.showAssistant();
        }
    }

    public void setCurrentUser(int newUserId) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setCurrentUser(newUserId);
        }
        this.mKeyguardState.currentUser = newUserId;
    }

    private static final View createScrim(Context context) {
        View view = new View(context);
        int flags = 0x110900;
        int stretch = -1;
        int type = 2029;
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1, 2029, flags, -3);
        lp.softInputMode = 16;
        lp.screenOrientation = 5;
        lp.setTitle("KeyguardScrim");
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.addView(view, lp);
        view.setVisibility(8);
        view.setSystemUiVisibility(56688640);
        return view;
    }

    public void showScrim() {
        this.mScrim.post(new Runnable(){

            public void run() {
                KeyguardServiceDelegate.this.mScrim.setVisibility(0);
            }
        });
    }

    public void hideScrim() {
        this.mScrim.post(new Runnable(){

            public void run() {
                KeyguardServiceDelegate.this.mScrim.setVisibility(8);
            }
        });
    }

    public void onBootCompleted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onBootCompleted();
        }
        this.mKeyguardState.bootCompleted = true;
    }

    private final class KeyguardExitDelegate
    extends IKeyguardExitCallback.Stub {
        private WindowManagerPolicy.OnKeyguardExitResult mOnKeyguardExitResult;

        KeyguardExitDelegate(WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
            this.mOnKeyguardExitResult = onKeyguardExitResult;
        }

        public void onKeyguardExitResult(boolean success) throws RemoteException {
            Log.v(KeyguardServiceDelegate.TAG, "**** onKeyguardExitResult(" + success + ") CALLED ****");
            if (this.mOnKeyguardExitResult != null) {
                this.mOnKeyguardExitResult.onKeyguardExitResult(success);
            }
        }
    }

    private final class KeyguardShowDelegate
    extends IKeyguardShowCallback.Stub {
        private ShowListener mShowListener;

        KeyguardShowDelegate(ShowListener showListener) {
            this.mShowListener = showListener;
        }

        public void onShown(IBinder windowToken) throws RemoteException {
            Log.v(KeyguardServiceDelegate.TAG, "**** SHOWN CALLED ****");
            if (this.mShowListener != null) {
                this.mShowListener.onShown(windowToken);
            }
            KeyguardServiceDelegate.this.hideScrim();
        }
    }

    public static interface ShowListener {
        public void onShown(IBinder var1);
    }

    static final class KeyguardState {
        boolean showing = true;
        boolean showingAndNotHidden = true;
        boolean inputRestricted;
        boolean hidden;
        boolean secure = true;
        boolean dreaming;
        boolean systemIsReady;
        public boolean enabled;
        public boolean dismissable;
        public int offReason;
        public int currentUser;
        public boolean screenIsOn;
        public boolean bootCompleted;

        KeyguardState() {
        }
    }
}

