/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.telephony.SmsCbMessage;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.WakeLockStateMachine;

public class CellBroadcastHandler
extends WakeLockStateMachine {
    private CellBroadcastHandler(Context context) {
        this("CellBroadcastHandler", context, null);
    }

    protected CellBroadcastHandler(String debugTag, Context context, PhoneBase phone) {
        super(debugTag, context, phone);
    }

    public static CellBroadcastHandler makeCellBroadcastHandler(Context context) {
        CellBroadcastHandler handler = new CellBroadcastHandler(context);
        handler.start();
        return handler;
    }

    protected boolean handleSmsMessage(Message message) {
        if (message.obj instanceof SmsCbMessage) {
            this.handleBroadcastSms((SmsCbMessage)message.obj);
            return true;
        }
        this.loge("handleMessage got object of type: " + message.obj.getClass().getName());
        return false;
    }

    protected void handleBroadcastSms(SmsCbMessage message) {
        int appOp;
        String receiverPermission;
        Intent intent;
        if (message.isEmergencyMessage()) {
            this.log("Dispatching emergency SMS CB");
            intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
            receiverPermission = "android.permission.RECEIVE_EMERGENCY_BROADCAST";
            appOp = 17;
        } else {
            this.log("Dispatching SMS CB");
            intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
            receiverPermission = "android.permission.RECEIVE_SMS";
            appOp = 16;
        }
        intent.putExtra("message", message);
        this.mContext.sendOrderedBroadcast(intent, receiverPermission, appOp, this.mReceiver, this.getHandler(), -1, null, null);
    }
}

