/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.util.Log;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.IntRangeManager;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.util.HexDump;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IccSmsInterfaceManager
extends ISms.Stub {
    static final String LOG_TAG = "IccSmsInterfaceManager";
    static final boolean DBG = true;
    protected final Object mLock = new Object();
    protected boolean mSuccess;
    private List<SmsRawData> mSms;
    private CellBroadcastRangeManager mCellBroadcastRangeManager = new CellBroadcastRangeManager();
    private CdmaBroadcastRangeManager mCdmaBroadcastRangeManager = new CdmaBroadcastRangeManager();
    private static final int EVENT_LOAD_DONE = 1;
    private static final int EVENT_UPDATE_DONE = 2;
    protected static final int EVENT_SET_BROADCAST_ACTIVATION_DONE = 3;
    protected static final int EVENT_SET_BROADCAST_CONFIG_DONE = 4;
    private static final int SMS_CB_CODE_SCHEME_MIN = 0;
    private static final int SMS_CB_CODE_SCHEME_MAX = 255;
    protected PhoneBase mPhone;
    protected final Context mContext;
    protected final AppOpsManager mAppOps;
    protected SMSDispatcher mDispatcher;
    protected Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        IccSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        IccSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        if (ar.exception == null) {
                            IccSmsInterfaceManager.this.mSms = IccSmsInterfaceManager.this.buildValidRawData((ArrayList)ar.result);
                            IccSmsInterfaceManager.this.markMessagesAsRead((ArrayList)ar.result);
                        } else {
                            if (Rlog.isLoggable("SMS", 3)) {
                                IccSmsInterfaceManager.this.log("Cannot load Sms records");
                            }
                            if (IccSmsInterfaceManager.this.mSms != null) {
                                IccSmsInterfaceManager.this.mSms.clear();
                            }
                        }
                        IccSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 3: 
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        IccSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        IccSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
            }
        }
    };

    protected IccSmsInterfaceManager(PhoneBase phone) {
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mDispatcher = new ImsSMSDispatcher(phone, phone.mSmsStorageMonitor, phone.mSmsUsageMonitor);
        if (ServiceManager.getService("isms") == null) {
            ServiceManager.addService("isms", this);
        }
    }

    protected void markMessagesAsRead(ArrayList<byte[]> messages) {
        if (messages == null) {
            return;
        }
        IccFileHandler fh = this.mPhone.getIccFileHandler();
        if (fh == null) {
            if (Rlog.isLoggable("SMS", 3)) {
                this.log("markMessagesAsRead - aborting, no icc card present.");
            }
            return;
        }
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] != 3) continue;
            int n = ba.length;
            byte[] nba = new byte[n - 1];
            System.arraycopy(ba, 1, nba, 0, n - 1);
            byte[] record = this.makeSmsRecordData(1, nba);
            fh.updateEFLinearFixed(28476, i + 1, record, null, null);
            if (!Rlog.isLoggable("SMS", 3)) continue;
            this.log("SMS " + (i + 1) + " marked as read");
        }
    }

    protected void updatePhoneObject(PhoneBase phone) {
        this.mPhone = phone;
        this.mDispatcher.updatePhoneObject(phone);
    }

    protected void enforceReceiveAndSend(String message) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", message);
        this.mContext.enforceCallingPermission("android.permission.SEND_SMS", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateMessageOnIccEf(String callingPackage, int index, int status, byte[] pdu) {
        this.log("updateMessageOnIccEf: index=" + index + " status=" + status + " ==> " + "(" + Arrays.toString(pdu) + ")");
        this.enforceReceiveAndSend("Updating message on Icc");
        if (this.mAppOps.noteOp(22, Binder.getCallingUid(), callingPackage) != 0) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (status == 0) {
                if (1 == this.mPhone.getPhoneType()) {
                    this.mPhone.mCi.deleteSmsOnSim(index, response);
                } else {
                    this.mPhone.mCi.deleteSmsOnRuim(index, response);
                }
            } else {
                IccFileHandler fh = this.mPhone.getIccFileHandler();
                if (fh == null) {
                    response.recycle();
                    return this.mSuccess;
                }
                byte[] record = this.makeSmsRecordData(status, pdu);
                fh.updateEFLinearFixed(28476, index, record, null, response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyMessageToIccEf(String callingPackage, int status, byte[] pdu, byte[] smsc) {
        this.log("copyMessageToIccEf: status=" + status + " ==> " + "pdu=(" + Arrays.toString(pdu) + "), smsc=(" + Arrays.toString(smsc) + ")");
        this.enforceReceiveAndSend("Copying message to Icc");
        if (this.mAppOps.noteOp(22, Binder.getCallingUid(), callingPackage) != 0) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (1 == this.mPhone.getPhoneType()) {
                this.mPhone.mCi.writeSmsToSim(status, IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), response);
            } else {
                this.mPhone.mCi.writeSmsToRuim(status, IccUtils.bytesToHexString(pdu), response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SmsRawData> getAllMessagesFromIccEf(String callingPackage) {
        this.log("getAllMessagesFromEF");
        this.mContext.enforceCallingOrSelfPermission("android.permission.RECEIVE_SMS", "Reading messages from Icc");
        if (this.mAppOps.noteOp(21, Binder.getCallingUid(), callingPackage) != 0) {
            return new ArrayList<SmsRawData>();
        }
        Object object = this.mLock;
        synchronized (object) {
            IccFileHandler fh = this.mPhone.getIccFileHandler();
            if (fh == null) {
                Rlog.e(LOG_TAG, "Cannot load Sms records. No icc card?");
                if (this.mSms != null) {
                    this.mSms.clear();
                    return this.mSms;
                }
            }
            Message response = this.mHandler.obtainMessage(1);
            fh.loadEFLinearFixedAll(28476, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to load from the Icc");
            }
        }
        return this.mSms;
    }

    @Override
    public void sendData(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendData: destAddr=" + destAddr + " scAddr=" + scAddr + " destPort=" + destPort + " data='" + HexDump.toHexString(data) + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        this.mDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
    }

    @Override
    public void sendText(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendText: destAddr=" + destAddr + " scAddr=" + scAddr + " text='" + text + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        this.mDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent);
    }

    @Override
    public void sendMultipartText(String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Rlog.isLoggable("SMS", 2)) {
            int i = 0;
            for (String part : parts) {
                this.log("sendMultipartText: destAddr=" + destAddr + ", srAddr=" + scAddr + ", part[" + i++ + "]=" + part);
            }
        }
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        this.mDispatcher.sendMultipartText(destAddr, scAddr, (ArrayList)parts, (ArrayList)sentIntents, (ArrayList)deliveryIntents);
    }

    @Override
    public int getPremiumSmsPermission(String packageName) {
        return this.mDispatcher.getPremiumSmsPermission(packageName);
    }

    @Override
    public void setPremiumSmsPermission(String packageName, int permission2) {
        this.mDispatcher.setPremiumSmsPermission(packageName, permission2);
    }

    protected ArrayList<SmsRawData> buildValidRawData(ArrayList<byte[]> messages) {
        int count = messages.size();
        ArrayList<SmsRawData> ret = new ArrayList<SmsRawData>(count);
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] == 0) {
                ret.add(null);
                continue;
            }
            ret.add(new SmsRawData(messages.get(i)));
        }
        return ret;
    }

    protected byte[] makeSmsRecordData(int status, byte[] pdu) {
        byte[] data = 1 == this.mPhone.getPhoneType() ? new byte[176] : new byte[255];
        data[0] = (byte)(status & 7);
        System.arraycopy(pdu, 0, data, 1, pdu.length);
        for (int j = pdu.length + 1; j < data.length; ++j) {
            data[j] = -1;
        }
        return data;
    }

    @Override
    public boolean enableCellBroadcast(int messageIdentifier) {
        return this.enableCellBroadcastRange(messageIdentifier, messageIdentifier);
    }

    @Override
    public boolean disableCellBroadcast(int messageIdentifier) {
        return this.disableCellBroadcastRange(messageIdentifier, messageIdentifier);
    }

    @Override
    public boolean enableCellBroadcastRange(int startMessageId, int endMessageId) {
        if (1 == this.mPhone.getPhoneType()) {
            return this.enableGsmBroadcastRange(startMessageId, endMessageId);
        }
        return this.enableCdmaBroadcastRange(startMessageId, endMessageId);
    }

    @Override
    public boolean disableCellBroadcastRange(int startMessageId, int endMessageId) {
        if (1 == this.mPhone.getPhoneType()) {
            return this.disableGsmBroadcastRange(startMessageId, endMessageId);
        }
        return this.disableCdmaBroadcastRange(startMessageId, endMessageId);
    }

    public synchronized boolean enableGsmBroadcastRange(int startMessageId, int endMessageId) {
        this.log("enableGsmBroadcastRange");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Enabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.enableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to add cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Added cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCellBroadcastActivation(!this.mCellBroadcastRangeManager.isEmpty());
        return true;
    }

    public synchronized boolean disableGsmBroadcastRange(int startMessageId, int endMessageId) {
        this.log("disableGsmBroadcastRange");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Disabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.disableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to remove cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Removed cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCellBroadcastActivation(!this.mCellBroadcastRangeManager.isEmpty());
        return true;
    }

    public synchronized boolean enableCdmaBroadcastRange(int startMessageId, int endMessageId) {
        this.log("enableCdmaBroadcastRange");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Enabling cdma broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCdmaBroadcastRangeManager.enableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to add cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Added cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCdmaBroadcastActivation(!this.mCdmaBroadcastRangeManager.isEmpty());
        return true;
    }

    public synchronized boolean disableCdmaBroadcastRange(int startMessageId, int endMessageId) {
        this.log("disableCdmaBroadcastRange");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Disabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCdmaBroadcastRangeManager.disableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to remove cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Removed cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCdmaBroadcastActivation(!this.mCdmaBroadcastRangeManager.isEmpty());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCellBroadcastConfig(SmsBroadcastConfigInfo[] configs) {
        this.log("Calling setGsmBroadcastConfig with " + configs.length + " configurations");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(4);
            this.mSuccess = false;
            this.mPhone.mCi.setGsmBroadcastConfig(configs, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast config");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCellBroadcastActivation(boolean activate) {
        this.log("Calling setCellBroadcastActivation(" + activate + ')');
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(3);
            this.mSuccess = false;
            this.mPhone.mCi.setGsmBroadcastActivation(activate, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast activation");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs) {
        this.log("Calling setCdmaBroadcastConfig with " + configs.length + " configurations");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(4);
            this.mSuccess = false;
            this.mPhone.mCi.setCdmaBroadcastConfig(configs, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cdma broadcast config");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCdmaBroadcastActivation(boolean activate) {
        this.log("Calling setCdmaBroadcastActivation(" + activate + ")");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(3);
            this.mSuccess = false;
            this.mPhone.mCi.setCdmaBroadcastActivation(activate, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cdma broadcast activation");
            }
        }
        return this.mSuccess;
    }

    protected void log(String msg) {
        Log.d(LOG_TAG, "[IccSmsInterfaceManager] " + msg);
    }

    @Override
    public boolean isImsSmsSupported() {
        return this.mDispatcher.isIms();
    }

    @Override
    public String getImsSmsFormat() {
        return this.mDispatcher.getImsSmsFormat();
    }

    class CdmaBroadcastRangeManager
    extends IntRangeManager {
        private ArrayList<CdmaSmsBroadcastConfigInfo> mConfigList = new ArrayList();

        CdmaBroadcastRangeManager() {
        }

        protected void startUpdate() {
            this.mConfigList.clear();
        }

        protected void addRange(int startId, int endId, boolean selected) {
            this.mConfigList.add(new CdmaSmsBroadcastConfigInfo(startId, endId, 1, selected));
        }

        protected boolean finishUpdate() {
            if (this.mConfigList.isEmpty()) {
                return true;
            }
            CdmaSmsBroadcastConfigInfo[] configs = this.mConfigList.toArray(new CdmaSmsBroadcastConfigInfo[this.mConfigList.size()]);
            return IccSmsInterfaceManager.this.setCdmaBroadcastConfig(configs);
        }
    }

    class CellBroadcastRangeManager
    extends IntRangeManager {
        private ArrayList<SmsBroadcastConfigInfo> mConfigList = new ArrayList();

        CellBroadcastRangeManager() {
        }

        protected void startUpdate() {
            this.mConfigList.clear();
        }

        protected void addRange(int startId, int endId, boolean selected) {
            this.mConfigList.add(new SmsBroadcastConfigInfo(startId, endId, 0, 255, selected));
        }

        protected boolean finishUpdate() {
            if (this.mConfigList.isEmpty()) {
                return true;
            }
            SmsBroadcastConfigInfo[] configs = this.mConfigList.toArray(new SmsBroadcastConfigInfo[this.mConfigList.size()]);
            return IccSmsInterfaceManager.this.setCellBroadcastConfig(configs);
        }
    }
}

