/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.Html;
import android.text.Spanned;
import android.util.EventLog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.SmsUsageMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMSDispatcher
extends Handler {
    static final String TAG = "SMSDispatcher";
    static final boolean DBG = false;
    private static final String SEND_NEXT_MSG_EXTRA = "SendNextMsg";
    private static final String SEND_SMS_NO_CONFIRMATION_PERMISSION = "android.permission.SEND_SMS_NO_CONFIRMATION";
    private static final int PREMIUM_RULE_USE_SIM = 1;
    private static final int PREMIUM_RULE_USE_NETWORK = 2;
    private static final int PREMIUM_RULE_USE_BOTH = 3;
    private final AtomicInteger mPremiumSmsRule = new AtomicInteger(1);
    private final SettingsObserver mSettingsObserver;
    protected static final int EVENT_SEND_SMS_COMPLETE = 2;
    private static final int EVENT_SEND_RETRY = 3;
    private static final int EVENT_SEND_LIMIT_REACHED_CONFIRMATION = 4;
    static final int EVENT_SEND_CONFIRMED_SMS = 5;
    static final int EVENT_STOP_SENDING = 7;
    private static final int EVENT_CONFIRM_SEND_TO_POSSIBLE_PREMIUM_SHORT_CODE = 8;
    private static final int EVENT_CONFIRM_SEND_TO_PREMIUM_SHORT_CODE = 9;
    protected static final int EVENT_HANDLE_STATUS_REPORT = 10;
    protected static final int EVENT_RADIO_ON = 11;
    protected static final int EVENT_IMS_STATE_CHANGED = 12;
    protected static final int EVENT_IMS_STATE_DONE = 13;
    protected static final int EVENT_NEW_ICC_SMS = 14;
    protected static final int EVENT_ICC_CHANGED = 15;
    protected PhoneBase mPhone;
    protected final Context mContext;
    protected final ContentResolver mResolver;
    protected final CommandsInterface mCi;
    protected final TelephonyManager mTelephonyManager;
    private static final int MAX_SEND_RETRIES = 3;
    private static final int SEND_RETRY_DELAY = 2000;
    private static final int SINGLE_PART_SMS = 1;
    private static final int MO_MSG_QUEUE_LIMIT = 5;
    private static int sConcatenatedRef = new Random().nextInt(256);
    private SmsUsageMonitor mUsageMonitor;
    private ImsSMSDispatcher mImsSMSDispatcher;
    private int mPendingTrackerCount;
    protected boolean mSmsCapable = true;
    protected boolean mSmsSendDisabled;
    protected int mRemainingMessages = -1;
    protected final ArrayList<SmsTracker> deliveryPendingList = new ArrayList();

    protected static int getNextConcatenatedRef() {
        return ++sConcatenatedRef;
    }

    protected SMSDispatcher(PhoneBase phone, SmsUsageMonitor usageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        this.mPhone = phone;
        this.mImsSMSDispatcher = imsSMSDispatcher;
        this.mContext = phone.getContext();
        this.mResolver = this.mContext.getContentResolver();
        this.mCi = phone.mCi;
        this.mUsageMonitor = usageMonitor;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mSettingsObserver = new SettingsObserver(this, this.mPremiumSmsRule, this.mContext);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("sms_short_code_rule"), false, this.mSettingsObserver);
        this.mSmsCapable = this.mContext.getResources().getBoolean(17891386);
        this.mSmsSendDisabled = !SystemProperties.getBoolean("telephony.sms.send", this.mSmsCapable);
        Rlog.d(TAG, "SMSDispatcher: ctor mSmsCapable=" + this.mSmsCapable + " format=" + this.getFormat() + " mSmsSendDisabled=" + this.mSmsSendDisabled);
    }

    protected void updatePhoneObject(PhoneBase phone) {
        this.mPhone = phone;
        this.mUsageMonitor = phone.mSmsUsageMonitor;
        Rlog.d(TAG, "Active phone changed to " + this.mPhone.getPhoneName());
    }

    public void dispose() {
        this.mContext.getContentResolver().unregisterContentObserver(this.mSettingsObserver);
    }

    protected abstract String getFormat();

    protected void handleStatusReport(Object o) {
        Rlog.d(TAG, "handleStatusReport() called with no subclass.");
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                this.handleSendComplete((AsyncResult)msg.obj);
                break;
            }
            case 3: {
                Rlog.d(TAG, "SMS retry..");
                this.sendRetrySms((SmsTracker)msg.obj);
                break;
            }
            case 4: {
                this.handleReachSentLimit((SmsTracker)msg.obj);
                break;
            }
            case 8: {
                this.handleConfirmShortCode(false, (SmsTracker)msg.obj);
                break;
            }
            case 9: {
                this.handleConfirmShortCode(true, (SmsTracker)msg.obj);
                break;
            }
            case 5: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                if (tracker.isMultipart()) {
                    this.sendMultipartSms(tracker);
                } else {
                    this.sendSms(tracker);
                }
                --this.mPendingTrackerCount;
                break;
            }
            case 7: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                if (tracker.mSentIntent != null) {
                    try {
                        tracker.mSentIntent.send(5);
                    }
                    catch (PendingIntent.CanceledException ex) {
                        Rlog.e(TAG, "failed to send RESULT_ERROR_LIMIT_EXCEEDED");
                    }
                }
                --this.mPendingTrackerCount;
                break;
            }
            case 10: {
                this.handleStatusReport(msg.obj);
                break;
            }
            default: {
                Rlog.e(TAG, "handleMessage() ignoring message of unexpected type " + msg.what);
            }
        }
    }

    protected void handleSendComplete(AsyncResult ar) {
        block23: {
            SmsTracker tracker = (SmsTracker)ar.userObj;
            PendingIntent sentIntent = tracker.mSentIntent;
            if (ar.result != null) {
                tracker.mMessageRef = ((SmsResponse)ar.result).mMessageRef;
            } else {
                Rlog.d(TAG, "SmsResponse was null");
            }
            if (ar.exception == null) {
                if (SmsApplication.shouldWriteMessageForPackage(tracker.mAppInfo.applicationInfo.packageName, this.mContext)) {
                    tracker.writeSentMessage(this.mContext);
                }
                if (tracker.mDeliveryIntent != null) {
                    this.deliveryPendingList.add(tracker);
                }
                if (sentIntent != null) {
                    try {
                        if (this.mRemainingMessages > -1) {
                            --this.mRemainingMessages;
                        }
                        if (this.mRemainingMessages == 0) {
                            Intent sendNext = new Intent();
                            sendNext.putExtra(SEND_NEXT_MSG_EXTRA, true);
                            sentIntent.send(this.mContext, -1, sendNext);
                            break block23;
                        }
                        sentIntent.send(-1);
                    }
                    catch (PendingIntent.CanceledException ex) {}
                }
            } else {
                int ss = this.mPhone.getServiceState().getState();
                if (tracker.mImsRetry > 0 && ss != 0) {
                    tracker.mRetryCount = 3;
                    Rlog.d(TAG, "handleSendComplete: Skipping retry:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS= " + this.mPhone.getServiceState().getState());
                }
                if (!this.isIms() && ss != 0) {
                    SMSDispatcher.handleNotInService(ss, tracker.mSentIntent);
                } else if (((CommandException)ar.exception).getCommandError() == CommandException.Error.SMS_FAIL_RETRY && tracker.mRetryCount < 3) {
                    ++tracker.mRetryCount;
                    Message retryMsg = this.obtainMessage(3, tracker);
                    this.sendMessageDelayed(retryMsg, 2000L);
                } else if (tracker.mSentIntent != null) {
                    int error = 1;
                    if (((CommandException)ar.exception).getCommandError() == CommandException.Error.FDN_CHECK_FAILURE) {
                        error = 6;
                    }
                    try {
                        Intent fillIn = new Intent();
                        if (ar.result != null) {
                            fillIn.putExtra("errorCode", ((SmsResponse)ar.result).mErrorCode);
                        }
                        if (this.mRemainingMessages > -1) {
                            --this.mRemainingMessages;
                        }
                        if (this.mRemainingMessages == 0) {
                            fillIn.putExtra(SEND_NEXT_MSG_EXTRA, true);
                        }
                        tracker.mSentIntent.send(this.mContext, error, fillIn);
                    }
                    catch (PendingIntent.CanceledException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected static void handleNotInService(int ss, PendingIntent sentIntent) {
        if (sentIntent != null) {
            try {
                if (ss == 3) {
                    sentIntent.send(2);
                } else {
                    sentIntent.send(4);
                }
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    protected abstract void sendData(String var1, String var2, int var3, byte[] var4, PendingIntent var5, PendingIntent var6);

    protected abstract void sendText(String var1, String var2, String var3, PendingIntent var4, PendingIntent var5);

    protected abstract GsmAlphabet.TextEncodingDetails calculateLength(CharSequence var1, boolean var2);

    protected void sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        int i;
        int refNumber = SMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        int encoding = 0;
        this.mRemainingMessages = msgCount;
        GsmAlphabet.TextEncodingDetails[] encodingForParts = new GsmAlphabet.TextEncodingDetails[msgCount];
        for (i = 0; i < msgCount; ++i) {
            GsmAlphabet.TextEncodingDetails details = this.calculateLength(parts.get(i), false);
            if (encoding != details.codeUnitSize && (encoding == 0 || encoding == 1)) {
                encoding = details.codeUnitSize;
            }
            encodingForParts[i] = details;
        }
        for (i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            if (encoding == 1) {
                smsHeader.languageTable = encodingForParts[i].languageTable;
                smsHeader.languageShiftTable = encodingForParts[i].languageShiftTable;
            }
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            this.sendNewSubmitPdu(destAddr, scAddr, parts.get(i), smsHeader, encoding, sentIntent, deliveryIntent, i == msgCount - 1);
        }
    }

    protected abstract void sendNewSubmitPdu(String var1, String var2, String var3, SmsHeader var4, int var5, PendingIntent var6, PendingIntent var7, boolean var8);

    protected void sendRawPdu(SmsTracker tracker) {
        PackageInfo appInfo;
        HashMap<String, Object> map = tracker.mData;
        byte[] pdu = (byte[])map.get("pdu");
        PendingIntent sentIntent = tracker.mSentIntent;
        if (this.mSmsSendDisabled) {
            if (sentIntent != null) {
                try {
                    sentIntent.send(4);
                }
                catch (PendingIntent.CanceledException ex) {
                    // empty catch block
                }
            }
            Rlog.d(TAG, "Device does not support sending sms.");
            return;
        }
        if (pdu == null) {
            if (sentIntent != null) {
                try {
                    sentIntent.send(3);
                }
                catch (PendingIntent.CanceledException ex) {
                    // empty catch block
                }
            }
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        if (packageNames == null || packageNames.length == 0) {
            Rlog.e(TAG, "Can't get calling app package name: refusing to send SMS");
            if (sentIntent != null) {
                try {
                    sentIntent.send(1);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e(TAG, "failed to send error result");
                }
            }
            return;
        }
        try {
            appInfo = pm.getPackageInfo(packageNames[0], 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e(TAG, "Can't get calling app package info: refusing to send SMS");
            if (sentIntent != null) {
                try {
                    sentIntent.send(1);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e(TAG, "failed to send error result");
                }
            }
            return;
        }
        if (this.checkDestination(tracker)) {
            if (!this.mUsageMonitor.check(appInfo.packageName, 1)) {
                this.sendMessage(this.obtainMessage(4, tracker));
                return;
            }
            int ss = this.mPhone.getServiceState().getState();
            if (!this.isIms() && ss != 0) {
                SMSDispatcher.handleNotInService(ss, tracker.mSentIntent);
            } else {
                this.sendSms(tracker);
            }
        }
    }

    boolean checkDestination(SmsTracker tracker) {
        if (this.mContext.checkCallingOrSelfPermission(SEND_SMS_NO_CONFIRMATION_PERMISSION) == 0) {
            return true;
        }
        int rule = this.mPremiumSmsRule.get();
        int smsCategory = 0;
        if (rule == 1 || rule == 3) {
            String simCountryIso = this.mTelephonyManager.getSimCountryIso();
            if (simCountryIso == null || simCountryIso.length() != 2) {
                Rlog.e(TAG, "Can't get SIM country Iso: trying network country Iso");
                simCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            }
            smsCategory = this.mUsageMonitor.checkDestination(tracker.mDestAddress, simCountryIso);
        }
        if (rule == 2 || rule == 3) {
            String networkCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            if (networkCountryIso == null || networkCountryIso.length() != 2) {
                Rlog.e(TAG, "Can't get Network country Iso: trying SIM country Iso");
                networkCountryIso = this.mTelephonyManager.getSimCountryIso();
            }
            smsCategory = SmsUsageMonitor.mergeShortCodeCategories(smsCategory, this.mUsageMonitor.checkDestination(tracker.mDestAddress, networkCountryIso));
        }
        if (smsCategory == 0 || smsCategory == 1 || smsCategory == 2) {
            return true;
        }
        int premiumSmsPermission = this.mUsageMonitor.getPremiumSmsPermission(tracker.mAppInfo.packageName);
        if (premiumSmsPermission == 0) {
            premiumSmsPermission = 1;
        }
        switch (premiumSmsPermission) {
            case 3: {
                Rlog.d(TAG, "User approved this app to send to premium SMS");
                return true;
            }
            case 2: {
                Rlog.w(TAG, "User denied this app from sending to premium SMS");
                this.sendMessage(this.obtainMessage(7, tracker));
                return false;
            }
        }
        int event = smsCategory == 3 ? 8 : 9;
        this.sendMessage(this.obtainMessage(event, tracker));
        return false;
    }

    private boolean denyIfQueueLimitReached(SmsTracker tracker) {
        if (this.mPendingTrackerCount >= 5) {
            try {
                if (tracker.mSentIntent != null) {
                    tracker.mSentIntent.send(5);
                }
            }
            catch (PendingIntent.CanceledException ex) {
                Rlog.e(TAG, "failed to send back RESULT_ERROR_LIMIT_EXCEEDED");
            }
            return true;
        }
        ++this.mPendingTrackerCount;
        return false;
    }

    private CharSequence getAppLabel(String appPackage) {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(appPackage, 0);
            return appInfo.loadLabel(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e(TAG, "PackageManager Name Not Found for package " + appPackage);
            return appPackage;
        }
    }

    protected void handleReachSentLimit(SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        CharSequence appLabel = this.getAppLabel(tracker.mAppInfo.packageName);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040454, appLabel));
        ConfirmDialogListener listener = new ConfirmDialogListener(tracker, null);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setTitle(17040453).setIcon(17301642).setMessage(messageText).setPositiveButton(r.getString(17040455), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040456), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
    }

    protected void handleConfirmShortCode(boolean isPremium, SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        int detailsId = isPremium ? 17040459 : 17040458;
        CharSequence appLabel = this.getAppLabel(tracker.mAppInfo.packageName);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040457, appLabel, tracker.mDestAddress));
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View layout2 = inflater.inflate(17367201, null);
        ConfirmDialogListener listener = new ConfirmDialogListener(tracker, (TextView)layout2.findViewById(16909101));
        TextView messageView = (TextView)layout2.findViewById(16909095);
        messageView.setText(messageText);
        ViewGroup detailsLayout = (ViewGroup)layout2.findViewById(16909096);
        TextView detailsView = (TextView)detailsLayout.findViewById(16909098);
        detailsView.setText(detailsId);
        CheckBox rememberChoice = (CheckBox)layout2.findViewById(16909099);
        rememberChoice.setOnCheckedChangeListener(listener);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setView(layout2).setPositiveButton(r.getString(17040460), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040461), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
        listener.setPositiveButton(d.getButton(-1));
        listener.setNegativeButton(d.getButton(-2));
    }

    public int getPremiumSmsPermission(String packageName) {
        return this.mUsageMonitor.getPremiumSmsPermission(packageName);
    }

    public void setPremiumSmsPermission(String packageName, int permission2) {
        this.mUsageMonitor.setPremiumSmsPermission(packageName, permission2);
    }

    protected abstract void sendSms(SmsTracker var1);

    public void sendRetrySms(SmsTracker tracker) {
        if (this.mImsSMSDispatcher != null) {
            this.mImsSMSDispatcher.sendRetrySms(tracker);
        } else {
            Rlog.e(TAG, this.mImsSMSDispatcher + " is null. Retry failed");
        }
    }

    private void sendMultipartSms(SmsTracker tracker) {
        HashMap<String, Object> map = tracker.mData;
        String destinationAddress = (String)map.get("destination");
        String scAddress = (String)map.get("scaddress");
        ArrayList parts = (ArrayList)map.get("parts");
        ArrayList sentIntents = (ArrayList)map.get("sentIntents");
        ArrayList deliveryIntents = (ArrayList)map.get("deliveryIntents");
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            int count = parts.size();
            for (int i = 0; i < count; ++i) {
                PendingIntent sentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    sentIntent = (PendingIntent)sentIntents.get(i);
                }
                SMSDispatcher.handleNotInService(ss, sentIntent);
            }
            return;
        }
        this.sendMultipartText(destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format) {
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        PackageInfo appInfo = null;
        if (packageNames != null && packageNames.length > 0) {
            try {
                appInfo = pm.getPackageInfo(packageNames[0], 64);
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
        String destAddr = PhoneNumberUtils.extractNetworkPortion((String)data.get("destAddr"));
        return new SmsTracker(data, sentIntent, deliveryIntent, appInfo, destAddr, format);
    }

    protected HashMap<String, Object> getSmsTrackerMap(String destAddr, String scAddr, String text, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("text", text);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    protected HashMap<String, Object> getSmsTrackerMap(String destAddr, String scAddr, int destPort, byte[] data, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("destPort", destPort);
        map.put("data", data);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    public boolean isIms() {
        if (this.mImsSMSDispatcher != null) {
            return this.mImsSMSDispatcher.isIms();
        }
        Rlog.e(TAG, this.mImsSMSDispatcher + " is null");
        return false;
    }

    public String getImsSmsFormat() {
        if (this.mImsSMSDispatcher != null) {
            return this.mImsSMSDispatcher.getImsSmsFormat();
        }
        Rlog.e(TAG, this.mImsSMSDispatcher + " is null");
        return null;
    }

    private final class ConfirmDialogListener
    implements DialogInterface.OnClickListener,
    DialogInterface.OnCancelListener,
    CompoundButton.OnCheckedChangeListener {
        private final SmsTracker mTracker;
        private Button mPositiveButton;
        private Button mNegativeButton;
        private boolean mRememberChoice;
        private final TextView mRememberUndoInstruction;

        ConfirmDialogListener(SmsTracker tracker, TextView textView) {
            this.mTracker = tracker;
            this.mRememberUndoInstruction = textView;
        }

        void setPositiveButton(Button button) {
            this.mPositiveButton = button;
        }

        void setNegativeButton(Button button) {
            this.mNegativeButton = button;
        }

        public void onClick(DialogInterface dialog, int which) {
            int newSmsPermission = 1;
            if (which == -1) {
                Rlog.d(SMSDispatcher.TAG, "CONFIRM sending SMS");
                EventLog.writeEvent(50128, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(5, this.mTracker));
                if (this.mRememberChoice) {
                    newSmsPermission = 3;
                }
            } else if (which == -2) {
                Rlog.d(SMSDispatcher.TAG, "DENY sending SMS");
                EventLog.writeEvent(50125, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(7, this.mTracker));
                if (this.mRememberChoice) {
                    newSmsPermission = 2;
                }
            }
            SMSDispatcher.this.setPremiumSmsPermission(this.mTracker.mAppInfo.packageName, newSmsPermission);
        }

        public void onCancel(DialogInterface dialog) {
            Rlog.d(SMSDispatcher.TAG, "dialog dismissed: don't send SMS");
            SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(7, this.mTracker));
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            Rlog.d(SMSDispatcher.TAG, "remember this choice: " + isChecked);
            this.mRememberChoice = isChecked;
            if (isChecked) {
                this.mPositiveButton.setText(17040464);
                this.mNegativeButton.setText(17040465);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText(17040463);
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 32);
                }
            } else {
                this.mPositiveButton.setText(17040460);
                this.mNegativeButton.setText(17040461);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText("");
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 0);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class SmsTracker {
        public final HashMap<String, Object> mData;
        public int mRetryCount;
        public int mImsRetry;
        public int mMessageRef;
        String mFormat;
        public final PendingIntent mSentIntent;
        public final PendingIntent mDeliveryIntent;
        public final PackageInfo mAppInfo;
        public final String mDestAddress;
        private long mTimestamp = System.currentTimeMillis();
        private Uri mSentMessageUri;

        private SmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, PackageInfo appInfo, String destAddr, String format) {
            this.mData = data;
            this.mSentIntent = sentIntent;
            this.mDeliveryIntent = deliveryIntent;
            this.mRetryCount = 0;
            this.mAppInfo = appInfo;
            this.mDestAddress = destAddr;
            this.mFormat = format;
            this.mImsRetry = 0;
            this.mMessageRef = 0;
        }

        boolean isMultipart() {
            return this.mData.containsKey("parts");
        }

        void writeSentMessage(Context context) {
            String text = (String)this.mData.get("text");
            if (text != null) {
                boolean deliveryReport = this.mDeliveryIntent != null;
                this.mSentMessageUri = Telephony.Sms.addMessageToUri(context.getContentResolver(), Telephony.Sms.Sent.CONTENT_URI, this.mDestAddress, text, null, this.mTimestamp, true, deliveryReport, 0L);
            }
        }

        public void updateSentMessageStatus(Context context, int status) {
            if (this.mSentMessageUri != null) {
                ContentValues values = new ContentValues(1);
                values.put("status", status);
                SqliteWrapper.update(context, context.getContentResolver(), this.mSentMessageUri, values, null, null);
            }
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final AtomicInteger mPremiumSmsRule;
        private final Context mContext;

        SettingsObserver(Handler handler, AtomicInteger premiumSmsRule, Context context) {
            super(handler);
            this.mPremiumSmsRule = premiumSmsRule;
            this.mContext = context;
            this.onChange(false);
        }

        public void onChange(boolean selfChange) {
            this.mPremiumSmsRule.set(Settings.Global.getInt(this.mContext.getContentResolver(), "sms_short_code_rule", 1));
        }
    }
}

