/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Message;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaLteServiceStateTracker;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class CDMALTEPhone
extends CDMAPhone {
    static final String LOG_LTE_TAG = "CDMALTEPhone";
    private static final boolean DBG = true;
    private SIMRecords mSimRecords;
    private IsimUiccRecords mIsimUiccRecords;

    public CDMALTEPhone(Context context, CommandsInterface ci, PhoneNotifier notifier) {
        super(context, ci, notifier, false);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 16: {
                this.handleSetSelectNetwork((AsyncResult)msg.obj);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected void initSstIcc() {
        this.mSST = new CdmaLteServiceStateTracker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
        }
    }

    public void removeReferences() {
        super.removeReferences();
    }

    public PhoneConstants.DataState getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!this.mDcTracker.isApnTypeEnabled(apnType)) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (this.mDcTracker.getState(apnType)) {
                case RETRYING: 
                case FAILED: 
                case IDLE: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case CONNECTED: 
                case DISCONNECTING: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case CONNECTING: 
                case SCANNING: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        this.log("getDataConnectionState apnType=" + apnType + " ret=" + (Object)((Object)ret));
        return ret;
    }

    public void selectNetworkManually(OperatorInfo network, Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = network.getOperatorNumeric();
        nsm.operatorAlphaLong = network.getOperatorAlphaLong();
        Message msg = this.obtainMessage(16, nsm);
        this.mCi.setNetworkSelectionModeManual(network.getOperatorNumeric(), msg);
    }

    private void handleSetSelectNetwork(AsyncResult ar) {
        if (!(ar.userObj instanceof NetworkSelectMessage)) {
            this.loge("unexpected result from user object.");
            return;
        }
        NetworkSelectMessage nsm = (NetworkSelectMessage)ar.userObj;
        if (nsm.message != null) {
            this.log("sending original message to recipient");
            AsyncResult.forMessage(nsm.message, ar.result, ar.exception);
            nsm.message.sendToTarget();
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("network_selection_key", nsm.operatorNumeric);
        editor.putString("network_selection_name_key", nsm.operatorAlphaLong);
        if (!editor.commit()) {
            this.loge("failed to commit network selection preference");
        }
    }

    boolean updateCurrentCarrierInProvider(String operatorNumeric) {
        boolean retVal;
        if (this.mUiccController.getUiccCardApplication(1) == null) {
            this.log("updateCurrentCarrierInProvider APP_FAM_3GPP == null");
            retVal = super.updateCurrentCarrierInProvider(operatorNumeric);
        } else {
            this.log("updateCurrentCarrierInProvider not updated");
            retVal = true;
        }
        this.log("updateCurrentCarrierInProvider X retVal=" + retVal);
        return retVal;
    }

    public boolean updateCurrentCarrierInProvider() {
        if (this.mSimRecords != null) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues map = new ContentValues();
                String operatorNumeric = this.mSimRecords.getOperatorNumeric();
                map.put("numeric", operatorNumeric);
                this.log("updateCurrentCarrierInProvider from UICC: numeric=" + operatorNumeric);
                this.mContext.getContentResolver().insert(uri, map);
                return true;
            }
            catch (SQLException e) {
                this.loge("Can't store current operator ret false", e);
            }
        } else {
            this.log("updateCurrentCarrierInProvider mIccRecords == null ret false");
        }
        return false;
    }

    public String getSubscriberId() {
        return this.mSimRecords != null ? this.mSimRecords.getIMSI() : "";
    }

    public String getGroupIdLevel1() {
        return this.mSimRecords != null ? this.mSimRecords.getGid1() : "";
    }

    public String getImei() {
        return this.mImei;
    }

    public String getDeviceSvn() {
        return this.mImeiSv;
    }

    public IsimRecords getIsimRecords() {
        return this.mIsimUiccRecords;
    }

    public String getMsisdn() {
        return this.mSimRecords != null ? this.mSimRecords.getMsisdnNumber() : null;
    }

    public void getAvailableNetworks(Message response) {
        this.mCi.getAvailableNetworks(response);
    }

    public void requestIsimAuthentication(String nonce, Message result) {
        this.mCi.requestIsimAuthentication(nonce, result);
    }

    protected void onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.mUiccController.getUiccCardApplication(3);
        IsimUiccRecords newIsimUiccRecords = null;
        if (newUiccApplication != null) {
            newIsimUiccRecords = (IsimUiccRecords)newUiccApplication.getIccRecords();
        }
        this.mIsimUiccRecords = newIsimUiccRecords;
        newUiccApplication = this.mUiccController.getUiccCardApplication(1);
        SIMRecords newSimRecords = null;
        if (newUiccApplication != null) {
            newSimRecords = (SIMRecords)newUiccApplication.getIccRecords();
        }
        if (this.mSimRecords != newSimRecords) {
            if (this.mSimRecords != null) {
                this.log("Removing stale SIMRecords object.");
                this.mSimRecords = null;
            }
            if (newSimRecords != null) {
                this.log("New SIMRecords found");
                this.mSimRecords = newSimRecords;
            }
        }
        super.onUpdateIccAvailability();
    }

    protected void log(String s) {
        Rlog.d(LOG_LTE_TAG, s);
    }

    protected void loge(String s) {
        Rlog.e(LOG_LTE_TAG, s);
    }

    protected void loge(String s, Throwable e) {
        Rlog.e(LOG_LTE_TAG, s, e);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CDMALTEPhone extends:");
        super.dump(fd, pw, args);
    }

    private static class NetworkSelectMessage {
        public Message message;
        public String operatorNumeric;
        public String operatorAlphaLong;

        private NetworkSelectMessage() {
        }
    }
}

