/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.Rlog;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import java.util.HashMap;

public class CdmaSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "CdmaSMSDispatcher";
    private static final boolean VDBG = false;

    public CdmaSMSDispatcher(PhoneBase phone, SmsUsageMonitor usageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        super(phone, usageMonitor, imsSMSDispatcher);
        Rlog.d(TAG, "CdmaSMSDispatcher created");
    }

    protected String getFormat() {
        return "3gpp2";
    }

    void sendStatusReportMessage(SmsMessage sms) {
        this.sendMessage(this.obtainMessage(10, sms));
    }

    protected void handleStatusReport(Object o) {
        if (o instanceof SmsMessage) {
            this.handleCdmaStatusReport((SmsMessage)o);
        } else {
            Rlog.e(TAG, "handleStatusReport() called for object type " + o.getClass().getName());
        }
    }

    void handleCdmaStatusReport(SmsMessage sms) {
        int count = this.deliveryPendingList.size();
        for (int i = 0; i < count; ++i) {
            SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
            if (tracker.mMessageRef != sms.mMessageRef) continue;
            this.deliveryPendingList.remove(i);
            tracker.updateSentMessageStatus(this.mContext, 0);
            PendingIntent intent = tracker.mDeliveryIntent;
            Intent fillIn = new Intent();
            fillIn.putExtra("pdu", sms.getPdu());
            fillIn.putExtra("format", this.getFormat());
            try {
                intent.send(this.mContext, -1, fillIn);
            }
            catch (PendingIntent.CanceledException ex) {}
            break;
        }
    }

    protected void sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, destPort, data, pdu);
        SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat());
        this.sendSubmitPdu(tracker);
    }

    protected void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null, null);
        HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, text, pdu);
        SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat());
        this.sendSubmitPdu(tracker);
    }

    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength(messageBody, use7bitOnly);
    }

    protected void sendNewSubmitPdu(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int encoding, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart) {
        UserData uData = new UserData();
        uData.payloadStr = message;
        uData.userDataHeader = smsHeader;
        uData.msgEncoding = encoding == 1 ? 9 : 4;
        uData.msgEncodingSet = true;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(destinationAddress, uData, deliveryIntent != null && lastPart);
        HashMap<String, Object> map = this.getSmsTrackerMap(destinationAddress, scAddress, message, submitPdu);
        SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat());
        this.sendSubmitPdu(tracker);
    }

    protected void sendSubmitPdu(SMSDispatcher.SmsTracker tracker) {
        if (SystemProperties.getBoolean("ril.cdma.inecmmode", false)) {
            if (tracker.mSentIntent != null) {
                try {
                    tracker.mSentIntent.send(4);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    // empty catch block
                }
            }
            return;
        }
        this.sendRawPdu(tracker);
    }

    protected void sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap<String, Object> map = tracker.mData;
        byte[] pdu = (byte[])map.get("pdu");
        Message reply = this.obtainMessage(2, tracker);
        Rlog.d(TAG, "sendSms:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        if (0 == tracker.mImsRetry && !this.isIms()) {
            this.mCi.sendCdmaSms(pdu, reply);
        } else {
            this.mCi.sendImsCdmaSms(pdu, tracker.mImsRetry, tracker.mMessageRef, reply);
            ++tracker.mImsRetry;
        }
    }
}

