/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellLocation;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RestrictedState;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

final class GsmServiceStateTracker
extends ServiceStateTracker {
    private static final String LOG_TAG = "GsmSST";
    private static final boolean VDBG = false;
    GSMPhone mPhone;
    GsmCellLocation mCellLoc;
    GsmCellLocation mNewCellLoc;
    int mPreferredNetworkType;
    private int mMaxDataCalls = 1;
    private int mNewMaxDataCalls = 1;
    private int mReasonDataDenied = -1;
    private int mNewReasonDataDenied = -1;
    private boolean mGsmRoaming = false;
    private boolean mDataRoaming = false;
    private boolean mEmergencyOnly = false;
    private boolean mNeedFixZoneAfterNitz = false;
    private int mZoneOffset;
    private boolean mZoneDst;
    private long mZoneTime;
    private boolean mGotCountryCode = false;
    private ContentResolver mCr;
    private boolean mNitzUpdatedTime = false;
    String mSavedTimeZone;
    long mSavedTime;
    long mSavedAtTime;
    private boolean mStartedGprsRegCheck = false;
    private boolean mReportedGprsNoReg = false;
    private Notification mNotification;
    private PowerManager.WakeLock mWakeLock;
    private static final String WAKELOCK_TAG = "ServiceStateTracker";
    private String mCurSpn = null;
    private String mCurPlmn = null;
    private boolean mCurShowPlmn = false;
    private boolean mCurShowSpn = false;
    static final int PS_ENABLED = 1001;
    static final int PS_DISABLED = 1002;
    static final int CS_ENABLED = 1003;
    static final int CS_DISABLED = 1004;
    static final int CS_NORMAL_ENABLED = 1005;
    static final int CS_EMERGENCY_ENABLED = 1006;
    static final int PS_NOTIFICATION = 888;
    static final int CS_NOTIFICATION = 999;
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!GsmServiceStateTracker.this.mPhone.mIsTheCurrentActivePhone) {
                Rlog.e(GsmServiceStateTracker.LOG_TAG, "Received Intent " + intent + " while being destroyed. Ignoring.");
                return;
            }
            if (intent.getAction().equals("android.intent.action.LOCALE_CHANGED")) {
                GsmServiceStateTracker.this.updateSpnDisplay();
            }
        }
    };
    private ContentObserver mAutoTimeObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            Rlog.i("GsmServiceStateTracker", "Auto time state changed");
            GsmServiceStateTracker.this.revertToNitzTime();
        }
    };
    private ContentObserver mAutoTimeZoneObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            Rlog.i("GsmServiceStateTracker", "Auto time zone state changed");
            GsmServiceStateTracker.this.revertToNitzTimeZone();
        }
    };

    public GsmServiceStateTracker(GSMPhone phone) {
        super(phone, phone.mCi, new CellInfoGsm());
        this.mPhone = phone;
        this.mCellLoc = new GsmCellLocation();
        this.mNewCellLoc = new GsmCellLocation();
        PowerManager powerManager = (PowerManager)phone.getContext().getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.mCi.registerForAvailable(this, 13, null);
        this.mCi.registerForRadioStateChanged(this, 1, null);
        this.mCi.registerForVoiceNetworkStateChanged(this, 2, null);
        this.mCi.setOnNITZTime(this, 11, null);
        this.mCi.setOnRestrictedStateChanged(this, 23, null);
        int airplaneMode = Settings.Global.getInt(phone.getContext().getContentResolver(), "airplane_mode_on", 0);
        this.mDesiredPowerState = airplaneMode <= 0;
        this.mCr = phone.getContext().getContentResolver();
        this.mCr.registerContentObserver(Settings.Global.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.mCr.registerContentObserver(Settings.Global.getUriFor("auto_time_zone"), true, this.mAutoTimeZoneObserver);
        this.setSignalStrengthDefaultValues();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.LOCALE_CHANGED");
        phone.getContext().registerReceiver(this.mIntentReceiver, filter);
        phone.notifyOtaspChanged(3);
    }

    public void dispose() {
        this.checkCorrectThread();
        this.log("ServiceStateTracker dispose");
        this.mCi.unregisterForAvailable(this);
        this.mCi.unregisterForRadioStateChanged(this);
        this.mCi.unregisterForVoiceNetworkStateChanged(this);
        if (this.mUiccApplcation != null) {
            this.mUiccApplcation.unregisterForReady(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForRecordsLoaded(this);
        }
        this.mCi.unSetOnRestrictedStateChanged(this);
        this.mCi.unSetOnNITZTime(this);
        this.mCr.unregisterContentObserver(this.mAutoTimeObserver);
        this.mCr.unregisterContentObserver(this.mAutoTimeZoneObserver);
        this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        super.dispose();
    }

    protected void finalize() {
        this.log("finalize");
    }

    protected Phone getPhone() {
        return this.mPhone;
    }

    public void handleMessage(Message msg) {
        if (!this.mPhone.mIsTheCurrentActivePhone) {
            Rlog.e(LOG_TAG, "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 13: {
                break;
            }
            case 17: {
                this.mCi.setCurrentPreferredNetworkType();
                boolean skipRestoringSelection = this.mPhone.getContext().getResources().getBoolean(17891390);
                if (!skipRestoringSelection) {
                    this.mPhone.restoreSavedNetworkSelection(null);
                }
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 1: {
                this.setPowerStateToDesired();
                this.pollState();
                break;
            }
            case 2: {
                this.pollState();
                break;
            }
            case 3: {
                if (!this.mCi.getRadioState().isOn()) {
                    return;
                }
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSignalStrengthResult(ar, true);
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 15: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    String[] states = (String[])ar.result;
                    int lac = -1;
                    int cid = -1;
                    if (states.length >= 3) {
                        try {
                            if (states[1] != null && states[1].length() > 0) {
                                lac = Integer.parseInt(states[1], 16);
                            }
                            if (states[2] != null && states[2].length() > 0) {
                                cid = Integer.parseInt(states[2], 16);
                            }
                        }
                        catch (NumberFormatException ex) {
                            Rlog.w(LOG_TAG, "error parsing location: " + ex);
                        }
                    }
                    this.mCellLoc.setLacAndCid(lac, cid);
                    this.mPhone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 10: {
                this.mCi.getSignalStrength(this.obtainMessage(3));
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String nitzString = (String)((Object[])ar.result)[0];
                long nitzReceiveTime = (Long)((Object[])ar.result)[1];
                this.setTimeFromNITZString(nitzString, nitzReceiveTime);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mDontPollSignalStrength = true;
                this.onSignalStrengthResult(ar, true);
                break;
            }
            case 16: {
                this.log("EVENT_SIM_RECORDS_LOADED: what=" + msg.what);
                this.updatePhoneObject();
                this.updateSpnDisplay();
                break;
            }
            case 18: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(15, null));
                break;
            }
            case 20: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Message message = this.obtainMessage(21, ar.userObj);
                this.mCi.setPreferredNetworkType(this.mPreferredNetworkType, message);
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj == null) break;
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 19: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mPreferredNetworkType = ar.exception == null ? ((int[])ar.result)[0] : 7;
                Message message = this.obtainMessage(20, ar.userObj);
                int toggledNetworkType = 7;
                this.mCi.setPreferredNetworkType(toggledNetworkType, message);
                break;
            }
            case 22: {
                if (this.mSS != null && !this.isGprsConsistent(this.mSS.getDataRegState(), this.mSS.getVoiceRegState())) {
                    GsmCellLocation loc = (GsmCellLocation)this.mPhone.getCellLocation();
                    EventLog.writeEvent(50107, this.mSS.getOperatorNumeric(), loc != null ? loc.getCid() : -1);
                    this.mReportedGprsNoReg = true;
                }
                this.mStartedGprsRegCheck = false;
                break;
            }
            case 23: {
                this.log("EVENT_RESTRICTED_STATE_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onRestrictedStateChanged(ar);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected void setPowerStateToDesired() {
        if (this.mDesiredPowerState && this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.mCi.setRadioPower(true, null);
        } else if (!this.mDesiredPowerState && this.mCi.getRadioState().isOn()) {
            DcTrackerBase dcTracker = this.mPhone.mDcTracker;
            this.powerOffRadioSafely(dcTracker);
        }
    }

    protected void hangupAndPowerOff() {
        if (this.mPhone.isInCall()) {
            this.mPhone.mCT.mRingingCall.hangupIfAlive();
            this.mPhone.mCT.mBackgroundCall.hangupIfAlive();
            this.mPhone.mCT.mForegroundCall.hangupIfAlive();
        }
        this.mCi.setRadioPower(false, null);
    }

    protected void updateSpnDisplay() {
        boolean showSpn;
        int rule;
        IccRecords iccRecords = this.mIccRecords;
        String plmn = null;
        boolean showPlmn = false;
        int n = rule = iccRecords != null ? iccRecords.getDisplayRule(this.mSS.getOperatorNumeric()) : 0;
        if (this.mSS.getVoiceRegState() == 1 || this.mSS.getVoiceRegState() == 2) {
            showPlmn = true;
            plmn = this.mEmergencyOnly ? ((Object)Resources.getSystem().getText(17040162)).toString() : ((Object)Resources.getSystem().getText(17040136)).toString();
            this.log("updateSpnDisplay: radio is on but out of service, set plmn='" + plmn + "'");
        } else if (this.mSS.getVoiceRegState() == 0) {
            plmn = this.mSS.getOperatorAlphaLong();
            showPlmn = !TextUtils.isEmpty(plmn) && (rule & 2) == 2;
        } else {
            this.log("updateSpnDisplay: radio is off w/ showPlmn=" + showPlmn + " plmn=" + plmn);
        }
        String spn = iccRecords != null ? iccRecords.getServiceProviderName() : "";
        boolean bl = showSpn = !TextUtils.isEmpty(spn) && (rule & 1) == 1;
        if (showPlmn != this.mCurShowPlmn || showSpn != this.mCurShowSpn || !TextUtils.equals(spn, this.mCurSpn) || !TextUtils.equals(plmn, this.mCurPlmn)) {
            this.log(String.format("updateSpnDisplay: changed sending intent rule=" + rule + " showPlmn='%b' plmn='%s' showSpn='%b' spn='%s'", showPlmn, plmn, showSpn, spn));
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.addFlags(0x20000000);
            intent.putExtra("showSpn", showSpn);
            intent.putExtra("spn", spn);
            intent.putExtra("showPlmn", showPlmn);
            intent.putExtra("plmn", plmn);
            this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        this.mCurShowSpn = showSpn;
        this.mCurShowPlmn = showPlmn;
        this.mCurSpn = spn;
        this.mCurPlmn = plmn;
    }

    protected void handlePollStateResult(int what, AsyncResult ar) {
        if (ar.userObj != this.mPollingContext) {
            return;
        }
        if (ar.exception != null) {
            CommandException.Error err = null;
            if (ar.exception instanceof CommandException) {
                err = ((CommandException)ar.exception).getCommandError();
            }
            if (err == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.cancelPollState();
                return;
            }
            if (!this.mCi.getRadioState().isOn()) {
                this.cancelPollState();
                return;
            }
            if (err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) {
                this.loge("RIL implementation has returned an error where it must succeed" + ar.exception);
            }
        } else {
            try {
                switch (what) {
                    case 4: {
                        String[] states = (String[])ar.result;
                        int lac = -1;
                        int cid = -1;
                        int type = 0;
                        int regState = 4;
                        int reasonRegStateDenied = -1;
                        int psc = -1;
                        if (states.length > 0) {
                            try {
                                regState = Integer.parseInt(states[0]);
                                if (states.length >= 3) {
                                    if (states[1] != null && states[1].length() > 0) {
                                        lac = Integer.parseInt(states[1], 16);
                                    }
                                    if (states[2] != null && states[2].length() > 0) {
                                        cid = Integer.parseInt(states[2], 16);
                                    }
                                    if (states.length >= 4 && states[3] != null) {
                                        type = Integer.parseInt(states[3]);
                                    }
                                }
                                if (states.length > 14 && states[14] != null && states[14].length() > 0) {
                                    psc = Integer.parseInt(states[14], 16);
                                }
                            }
                            catch (NumberFormatException ex) {
                                this.loge("error parsing RegistrationState: " + ex);
                            }
                        }
                        this.mGsmRoaming = this.regCodeIsRoaming(regState);
                        this.mNewSS.setState(this.regCodeToServiceState(regState));
                        this.mNewSS.setRilVoiceRadioTechnology(type);
                        boolean isVoiceCapable = this.mPhoneBase.getContext().getResources().getBoolean(17891385);
                        this.mEmergencyOnly = (regState == 13 || regState == 10 || regState == 12 || regState == 14) && isVoiceCapable;
                        this.mNewCellLoc.setLacAndCid(lac, cid);
                        this.mNewCellLoc.setPsc(psc);
                        break;
                    }
                    case 5: {
                        String[] states = (String[])ar.result;
                        int type = 0;
                        int regState = 4;
                        this.mNewReasonDataDenied = -1;
                        this.mNewMaxDataCalls = 1;
                        if (states.length > 0) {
                            try {
                                regState = Integer.parseInt(states[0]);
                                if (states.length >= 4 && states[3] != null) {
                                    type = Integer.parseInt(states[3]);
                                }
                                if (states.length >= 5 && regState == 3) {
                                    this.mNewReasonDataDenied = Integer.parseInt(states[4]);
                                }
                                if (states.length >= 6) {
                                    this.mNewMaxDataCalls = Integer.parseInt(states[5]);
                                }
                            }
                            catch (NumberFormatException ex) {
                                this.loge("error parsing GprsRegistrationState: " + ex);
                            }
                        }
                        int dataRegState = this.regCodeToServiceState(regState);
                        this.mNewSS.setDataRegState(dataRegState);
                        this.mDataRoaming = this.regCodeIsRoaming(regState);
                        this.mNewSS.setRilDataRadioTechnology(type);
                        this.log("handlPollStateResultMessage: GsmSST setDataRegState=" + dataRegState + " regState=" + regState + " dataRadioTechnology=" + type);
                        break;
                    }
                    case 6: {
                        String[] opNames = (String[])ar.result;
                        if (opNames == null || opNames.length < 3) break;
                        this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                        break;
                    }
                    case 14: {
                        int[] ints = (int[])ar.result;
                        this.mNewSS.setIsManualSelection(ints[0] == 1);
                    }
                }
            }
            catch (RuntimeException ex) {
                this.loge("Exception while polling service state. Probably malformed RIL response." + ex);
            }
        }
        this.mPollingContext[0] = this.mPollingContext[0] - 1;
        if (this.mPollingContext[0] == 0) {
            boolean roaming;
            boolean bl = roaming = this.mGsmRoaming || this.mDataRoaming;
            if (this.mGsmRoaming && this.isSameNamedOperators(this.mNewSS) && !this.isSameNamedOperatorConsideredRoaming(this.mNewSS) || this.isOperatorConsideredNonRoaming(this.mNewSS)) {
                roaming = false;
            }
            this.mNewSS.setRoaming(roaming);
            this.mNewSS.setEmergencyOnly(this.mEmergencyOnly);
            this.pollStateDone();
        }
    }

    private void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(true);
    }

    private void pollState() {
        this.mPollingContext = new int[1];
        this.mPollingContext[0] = 0;
        switch (this.mCi.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.mNewSS.setStateOutOfService();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.mNitzUpdatedTime = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.mNewSS.setStateOff();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.mNitzUpdatedTime = false;
                this.pollStateDone();
                break;
            }
            default: {
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getOperator(this.obtainMessage(6, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getDataRegistrationState(this.obtainMessage(5, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(4, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getNetworkSelectionMode(this.obtainMessage(14, this.mPollingContext));
            }
        }
    }

    private void pollStateDone() {
        boolean hasLocationChanged;
        this.log("Poll ServiceState done:  oldSS=[" + this.mSS + "] newSS=[" + this.mNewSS + "]" + " oldMaxDataCalls=" + this.mMaxDataCalls + " mNewMaxDataCalls=" + this.mNewMaxDataCalls + " oldReasonDataDenied=" + this.mReasonDataDenied + " mNewReasonDataDenied=" + this.mNewReasonDataDenied);
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean("telephony.test.forceRoaming", false)) {
            this.mNewSS.setRoaming(true);
        }
        this.useDataRegStateForDataOnlyDevices();
        boolean hasRegistered = this.mSS.getVoiceRegState() != 0 && this.mNewSS.getVoiceRegState() == 0;
        boolean hasDeregistered = this.mSS.getVoiceRegState() == 0 && this.mNewSS.getVoiceRegState() != 0;
        boolean hasGprsAttached = this.mSS.getDataRegState() != 0 && this.mNewSS.getDataRegState() == 0;
        boolean hasGprsDetached = this.mSS.getDataRegState() == 0 && this.mNewSS.getDataRegState() != 0;
        boolean hasDataRegStateChanged = this.mSS.getDataRegState() != this.mNewSS.getDataRegState();
        boolean hasVoiceRegStateChanged = this.mSS.getVoiceRegState() != this.mNewSS.getVoiceRegState();
        boolean hasRilVoiceRadioTechnologyChanged = this.mSS.getRilVoiceRadioTechnology() != this.mNewSS.getRilVoiceRadioTechnology();
        boolean hasRilDataRadioTechnologyChanged = this.mSS.getRilDataRadioTechnology() != this.mNewSS.getRilDataRadioTechnology();
        boolean hasChanged = !this.mNewSS.equals(this.mSS);
        boolean hasRoamingOn = !this.mSS.getRoaming() && this.mNewSS.getRoaming();
        boolean hasRoamingOff = this.mSS.getRoaming() && !this.mNewSS.getRoaming();
        boolean bl = hasLocationChanged = !this.mNewCellLoc.equals(this.mCellLoc);
        if (hasVoiceRegStateChanged || hasDataRegStateChanged) {
            EventLog.writeEvent(50114, this.mSS.getVoiceRegState(), this.mSS.getDataRegState(), this.mNewSS.getVoiceRegState(), this.mNewSS.getDataRegState());
        }
        if (hasRilVoiceRadioTechnologyChanged) {
            int cid = -1;
            GsmCellLocation loc = this.mNewCellLoc;
            if (loc != null) {
                cid = loc.getCid();
            }
            EventLog.writeEvent(50123, cid, this.mSS.getRilVoiceRadioTechnology(), this.mNewSS.getRilVoiceRadioTechnology());
            this.log("RAT switched " + ServiceState.rilRadioTechnologyToString(this.mSS.getRilVoiceRadioTechnology()) + " -> " + ServiceState.rilRadioTechnologyToString(this.mNewSS.getRilVoiceRadioTechnology()) + " at cell " + cid);
        }
        ServiceState tss = this.mSS;
        this.mSS = this.mNewSS;
        this.mNewSS = tss;
        this.mNewSS.setStateOutOfService();
        GsmCellLocation tcl = this.mCellLoc;
        this.mCellLoc = this.mNewCellLoc;
        this.mNewCellLoc = tcl;
        this.mReasonDataDenied = this.mNewReasonDataDenied;
        this.mMaxDataCalls = this.mNewMaxDataCalls;
        if (hasRilVoiceRadioTechnologyChanged) {
            this.updatePhoneObject();
        }
        if (hasRilDataRadioTechnologyChanged) {
            this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(this.mSS.getRilVoiceRadioTechnology()));
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
            this.log("pollStateDone: registering current mNitzUpdatedTime=" + this.mNitzUpdatedTime + " changing to false");
            this.mNitzUpdatedTime = false;
        }
        if (hasChanged) {
            this.updateSpnDisplay();
            this.mPhone.setSystemProperty("gsm.operator.alpha", this.mSS.getOperatorAlphaLong());
            String prevOperatorNumeric = SystemProperties.get("gsm.operator.numeric", "");
            String operatorNumeric = this.mSS.getOperatorNumeric();
            this.mPhone.setSystemProperty("gsm.operator.numeric", operatorNumeric);
            if (operatorNumeric == null) {
                this.log("operatorNumeric is null");
                this.mPhone.setSystemProperty("gsm.operator.iso-country", "");
                this.mGotCountryCode = false;
                this.mNitzUpdatedTime = false;
            } else {
                String iso = "";
                String mcc = "";
                try {
                    mcc = operatorNumeric.substring(0, 3);
                    iso = MccTable.countryCodeForMcc(Integer.parseInt(mcc));
                }
                catch (NumberFormatException ex) {
                    this.loge("pollStateDone: countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    this.loge("pollStateDone: countryCodeForMcc error" + ex);
                }
                this.mPhone.setSystemProperty("gsm.operator.iso-country", iso);
                this.mGotCountryCode = true;
                TimeZone zone = null;
                if (!this.mNitzUpdatedTime && !mcc.equals("000") && !TextUtils.isEmpty(iso) && this.getAutoTimeZone()) {
                    boolean testOneUniqueOffsetPath = SystemProperties.getBoolean("telephony.test.ignore.nitz", false) && (SystemClock.uptimeMillis() & 1L) == 0L;
                    ArrayList<TimeZone> uniqueZones = TimeUtils.getTimeZonesWithUniqueOffsets(iso);
                    if (uniqueZones.size() == 1 || testOneUniqueOffsetPath) {
                        zone = uniqueZones.get(0);
                        this.log("pollStateDone: no nitz but one TZ for iso-cc=" + iso + " with zone.getID=" + zone.getID() + " testOneUniqueOffsetPath=" + testOneUniqueOffsetPath);
                        this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                    } else {
                        this.log("pollStateDone: there are " + uniqueZones.size() + " unique offsets for iso-cc='" + iso + " testOneUniqueOffsetPath=" + testOneUniqueOffsetPath + "', do nothing");
                    }
                }
                if (this.shouldFixTimeZoneNow(this.mPhone, operatorNumeric, prevOperatorNumeric, this.mNeedFixZoneAfterNitz)) {
                    String zoneName = SystemProperties.get("persist.sys.timezone");
                    this.log("pollStateDone: fix time zone zoneName='" + zoneName + "' mZoneOffset=" + this.mZoneOffset + " mZoneDst=" + this.mZoneDst + " iso-cc='" + iso + "' iso-cc-idx=" + Arrays.binarySearch(GMT_COUNTRY_CODES, iso));
                    if (this.mZoneOffset == 0 && !this.mZoneDst && zoneName != null && zoneName.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, iso) < 0) {
                        zone = TimeZone.getDefault();
                        if (this.mNeedFixZoneAfterNitz) {
                            long ctm = System.currentTimeMillis();
                            long tzOffset = zone.getOffset(ctm);
                            this.log("pollStateDone: tzOffset=" + tzOffset + " ltod=" + TimeUtils.logTimeOfDay(ctm));
                            if (this.getAutoTime()) {
                                long adj = ctm - tzOffset;
                                this.log("pollStateDone: adj ltod=" + TimeUtils.logTimeOfDay(adj));
                                this.setAndBroadcastNetworkSetTime(adj);
                            } else {
                                this.mSavedTime -= tzOffset;
                            }
                        }
                        this.log("pollStateDone: using default TimeZone");
                    } else if (iso.equals("")) {
                        zone = this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime);
                        this.log("pollStateDone: using NITZ TimeZone");
                    } else {
                        zone = TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, iso);
                        this.log("pollStateDone: using getTimeZone(off, dst, time, iso)");
                    }
                    this.mNeedFixZoneAfterNitz = false;
                    if (zone != null) {
                        this.log("pollStateDone: zone != null zone.getID=" + zone.getID());
                        if (this.getAutoTimeZone()) {
                            this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                        }
                        this.saveNitzTimeZone(zone.getID());
                    } else {
                        this.log("pollStateDone: zone == null");
                    }
                }
            }
            this.mPhone.setSystemProperty("gsm.operator.isroaming", this.mSS.getRoaming() ? "true" : "false");
            this.mPhone.notifyServiceStateChanged(this.mSS);
        }
        if (hasGprsAttached) {
            this.mAttachedRegistrants.notifyRegistrants();
        }
        if (hasGprsDetached) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        if (hasDataRegStateChanged || hasRilDataRadioTechnologyChanged) {
            this.notifyDataRegStateRilRadioTechnologyChanged();
            this.mPhone.notifyDataConnection(null);
        }
        if (hasRoamingOn) {
            this.mRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasRoamingOff) {
            this.mRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.mPhone.notifyLocationChanged();
        }
        if (!this.isGprsConsistent(this.mSS.getDataRegState(), this.mSS.getVoiceRegState())) {
            if (!this.mStartedGprsRegCheck && !this.mReportedGprsNoReg) {
                this.mStartedGprsRegCheck = true;
                int check_period = Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "gprs_register_check_period_ms", 60000);
                this.sendMessageDelayed(this.obtainMessage(22), check_period);
            }
        } else {
            this.mReportedGprsNoReg = false;
        }
    }

    private boolean isGprsConsistent(int dataRegState, int voiceRegState) {
        return voiceRegState != 0 || dataRegState == 0;
    }

    private TimeZone getNitzTimeZone(int offset, boolean dst, long when) {
        TimeZone guess = this.findTimeZone(offset, dst, when);
        if (guess == null) {
            guess = this.findTimeZone(offset, !dst, when);
        }
        this.log("getNitzTimeZone returning " + (guess == null ? guess : guess.getID()));
        return guess;
    }

    private TimeZone findTimeZone(int offset, boolean dst, long when) {
        int rawOffset = offset;
        if (dst) {
            rawOffset -= 3600000;
        }
        String[] zones = TimeZone.getAvailableIDs(rawOffset);
        TimeZone guess = null;
        Date d = new Date(when);
        for (String zone : zones) {
            TimeZone tz = TimeZone.getTimeZone(zone);
            if (tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            guess = tz;
            break;
        }
        return guess;
    }

    private void queueNextSignalStrengthPoll() {
        if (this.mDontPollSignalStrength) {
            return;
        }
        Message msg = this.obtainMessage();
        msg.what = 10;
        this.sendMessageDelayed(msg, 20000L);
    }

    private void onRestrictedStateChanged(AsyncResult ar) {
        RestrictedState newRs = new RestrictedState();
        this.log("onRestrictedStateChanged: E rs " + this.mRestrictedState);
        if (ar.exception == null) {
            int[] ints = (int[])ar.result;
            int state = ints[0];
            newRs.setCsEmergencyRestricted((state & 1) != 0 || (state & 4) != 0);
            if (this.mUiccApplcation != null && this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY) {
                newRs.setCsNormalRestricted((state & 2) != 0 || (state & 4) != 0);
                newRs.setPsRestricted((state & 0x10) != 0);
            }
            this.log("onRestrictedStateChanged: new rs " + newRs);
            if (!this.mRestrictedState.isPsRestricted() && newRs.isPsRestricted()) {
                this.mPsRestrictEnabledRegistrants.notifyRegistrants();
                this.setNotification(1001);
            } else if (this.mRestrictedState.isPsRestricted() && !newRs.isPsRestricted()) {
                this.mPsRestrictDisabledRegistrants.notifyRegistrants();
                this.setNotification(1002);
            }
            if (this.mRestrictedState.isCsRestricted()) {
                if (!newRs.isCsRestricted()) {
                    this.setNotification(1004);
                } else if (!newRs.isCsNormalRestricted()) {
                    this.setNotification(1006);
                } else if (!newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1005);
                }
            } else if (this.mRestrictedState.isCsEmergencyRestricted() && !this.mRestrictedState.isCsNormalRestricted()) {
                if (!newRs.isCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsNormalRestricted()) {
                    this.setNotification(1005);
                }
            } else if (!this.mRestrictedState.isCsEmergencyRestricted() && this.mRestrictedState.isCsNormalRestricted()) {
                if (!newRs.isCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1006);
                }
            } else if (newRs.isCsRestricted()) {
                this.setNotification(1003);
            } else if (newRs.isCsEmergencyRestricted()) {
                this.setNotification(1006);
            } else if (newRs.isCsNormalRestricted()) {
                this.setNotification(1005);
            }
            this.mRestrictedState = newRs;
        }
        this.log("onRestrictedStateChanged: X rs " + this.mRestrictedState);
    }

    private int regCodeToServiceState(int code) {
        switch (code) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        this.loge("regCodeToServiceState: unexpected service state " + code);
        return 1;
    }

    private boolean regCodeIsRoaming(int code) {
        return 5 == code;
    }

    private boolean isSameNamedOperators(ServiceState s) {
        String spn = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String onsl = s.getOperatorAlphaLong();
        String onss = s.getOperatorAlphaShort();
        boolean equalsOnsl = onsl != null && spn.equals(onsl);
        boolean equalsOnss = onss != null && spn.equals(onss);
        return this.currentMccEqualsSimMcc(s) && (equalsOnsl || equalsOnss);
    }

    private boolean currentMccEqualsSimMcc(ServiceState s) {
        String simNumeric = SystemProperties.get("gsm.sim.operator.numeric", "");
        String operatorNumeric = s.getOperatorNumeric();
        boolean equalsMcc = true;
        try {
            equalsMcc = simNumeric.substring(0, 3).equals(operatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            // empty catch block
        }
        return equalsMcc;
    }

    private boolean isOperatorConsideredNonRoaming(ServiceState s) {
        String operatorNumeric = s.getOperatorNumeric();
        String[] numericArray = this.mPhone.getContext().getResources().getStringArray(17236013);
        if (numericArray.length == 0 || operatorNumeric == null) {
            return false;
        }
        for (String numeric : numericArray) {
            if (!operatorNumeric.startsWith(numeric)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameNamedOperatorConsideredRoaming(ServiceState s) {
        String operatorNumeric = s.getOperatorNumeric();
        String[] numericArray = this.mPhone.getContext().getResources().getStringArray(17236014);
        if (numericArray.length == 0 || operatorNumeric == null) {
            return false;
        }
        int i$ = 0;
        String[] arr$ = numericArray;
        int len$ = arr$.length;
        if (i$ < len$) {
            String numeric = arr$[i$];
            return operatorNumeric.startsWith(numeric);
        }
        return false;
    }

    public int getCurrentDataConnectionState() {
        return this.mSS.getDataRegState();
    }

    public boolean isConcurrentVoiceAndDataAllowed() {
        return this.mSS.getRilVoiceRadioTechnology() >= 3;
    }

    public CellLocation getCellLocation() {
        if (this.mCellLoc.getLac() >= 0 && this.mCellLoc.getCid() >= 0) {
            this.log("getCellLocation(): X good mCellLoc=" + this.mCellLoc);
            return this.mCellLoc;
        }
        List<CellInfo> result = this.getAllCellInfo();
        if (result != null) {
            GsmCellLocation cellLocOther = new GsmCellLocation();
            for (CellInfo ci : result) {
                CellInfoLte cellInfoLte;
                CellIdentityLte cellIdentityLte;
                if (ci instanceof CellInfoGsm) {
                    CellInfoGsm cellInfoGsm = (CellInfoGsm)ci;
                    CellIdentityGsm cellIdentityGsm = cellInfoGsm.getCellIdentity();
                    cellLocOther.setLacAndCid(cellIdentityGsm.getLac(), cellIdentityGsm.getCid());
                    cellLocOther.setPsc(cellIdentityGsm.getPsc());
                    this.log("getCellLocation(): X ret GSM info=" + cellLocOther);
                    return cellLocOther;
                }
                if (ci instanceof CellInfoWcdma) {
                    CellInfoWcdma cellInfoWcdma = (CellInfoWcdma)ci;
                    CellIdentityWcdma cellIdentityWcdma = cellInfoWcdma.getCellIdentity();
                    cellLocOther.setLacAndCid(cellIdentityWcdma.getLac(), cellIdentityWcdma.getCid());
                    cellLocOther.setPsc(cellIdentityWcdma.getPsc());
                    this.log("getCellLocation(): X ret WCDMA info=" + cellLocOther);
                    return cellLocOther;
                }
                if (!(ci instanceof CellInfoLte) || cellLocOther.getLac() >= 0 && cellLocOther.getCid() >= 0 || (cellIdentityLte = (cellInfoLte = (CellInfoLte)ci).getCellIdentity()).getTac() == Integer.MAX_VALUE || cellIdentityLte.getCi() == Integer.MAX_VALUE) continue;
                cellLocOther.setLacAndCid(cellIdentityLte.getTac(), cellIdentityLte.getCi());
                cellLocOther.setPsc(0);
                this.log("getCellLocation(): possible LTE cellLocOther=" + cellLocOther);
            }
            this.log("getCellLocation(): X ret best answer cellLocOther=" + cellLocOther);
            return cellLocOther;
        }
        this.log("getCellLocation(): X empty mCellLoc and CellInfo mCellLoc=" + this.mCellLoc);
        return this.mCellLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeFromNITZString(String nitz, long nitzReceiveTime) {
        long start = SystemClock.elapsedRealtime();
        this.log("NITZ: " + nitz + "," + nitzReceiveTime + " start=" + start + " delay=" + (start - nitzReceiveTime));
        try {
            block14: {
                block13: {
                    String ignore;
                    Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    c.clear();
                    c.set(16, 0);
                    String[] nitzSubs = nitz.split("[/:,+-]");
                    int year = 2000 + Integer.parseInt(nitzSubs[0]);
                    c.set(1, year);
                    int month = Integer.parseInt(nitzSubs[1]) - 1;
                    c.set(2, month);
                    int date = Integer.parseInt(nitzSubs[2]);
                    c.set(5, date);
                    int hour = Integer.parseInt(nitzSubs[3]);
                    c.set(10, hour);
                    int minute = Integer.parseInt(nitzSubs[4]);
                    c.set(12, minute);
                    int second = Integer.parseInt(nitzSubs[5]);
                    c.set(13, second);
                    boolean sign = nitz.indexOf(45) == -1;
                    int tzOffset = Integer.parseInt(nitzSubs[6]);
                    int dst = nitzSubs.length >= 8 ? Integer.parseInt(nitzSubs[7]) : 0;
                    tzOffset = (sign ? 1 : -1) * tzOffset * 15 * 60 * 1000;
                    TimeZone zone = null;
                    if (nitzSubs.length >= 9) {
                        String tzname = nitzSubs[8].replace('!', '/');
                        zone = TimeZone.getTimeZone(tzname);
                    }
                    String iso = SystemProperties.get("gsm.operator.iso-country");
                    if (zone == null && this.mGotCountryCode) {
                        zone = iso != null && iso.length() > 0 ? TimeUtils.getTimeZone(tzOffset, dst != 0, c.getTimeInMillis(), iso) : this.getNitzTimeZone(tzOffset, dst != 0, c.getTimeInMillis());
                    }
                    if (zone == null || this.mZoneOffset != tzOffset || this.mZoneDst != (dst != 0)) {
                        this.mNeedFixZoneAfterNitz = true;
                        this.mZoneOffset = tzOffset;
                        this.mZoneDst = dst != 0;
                        this.mZoneTime = c.getTimeInMillis();
                    }
                    if (zone != null) {
                        if (this.getAutoTimeZone()) {
                            this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                        }
                        this.saveNitzTimeZone(zone.getID());
                    }
                    if ((ignore = SystemProperties.get("gsm.ignore-nitz")) != null && ignore.equals("yes")) {
                        this.log("NITZ: Not setting clock because gsm.ignore-nitz is set");
                        return;
                    }
                    try {
                        this.mWakeLock.acquire();
                        if (this.getAutoTime()) {
                            long millisSinceNitzReceived = SystemClock.elapsedRealtime() - nitzReceiveTime;
                            if (millisSinceNitzReceived < 0L) {
                                this.log("NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + nitz);
                                Object var23_20 = null;
                                this.mWakeLock.release();
                                return;
                            }
                            if (millisSinceNitzReceived > Integer.MAX_VALUE) {
                                this.log("NITZ: not setting time, processing has taken " + millisSinceNitzReceived / 86400000L + " days");
                                break block13;
                            }
                            c.add(14, (int)millisSinceNitzReceived);
                            this.log("NITZ: Setting time of day to " + c.getTime() + " NITZ receive delay(ms): " + millisSinceNitzReceived + " gained(ms): " + (c.getTimeInMillis() - System.currentTimeMillis()) + " from " + nitz);
                            this.setAndBroadcastNetworkSetTime(c.getTimeInMillis());
                            Rlog.i(LOG_TAG, "NITZ: after Setting time of day");
                        }
                        SystemProperties.set("gsm.nitz.time", String.valueOf(c.getTimeInMillis()));
                        this.saveNitzTime(c.getTimeInMillis());
                        this.mNitzUpdatedTime = true;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var23_23 = null;
                        this.mWakeLock.release();
                        throw throwable;
                    }
                }
                Object var23_21 = null;
                this.mWakeLock.release();
                return;
            }
            Object var23_22 = null;
            this.mWakeLock.release();
            return;
        }
        catch (RuntimeException ex) {
            this.loge("NITZ: Parsing NITZ time " + nitz + " ex=" + ex);
        }
    }

    private boolean getAutoTime() {
        try {
            return Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "auto_time") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private boolean getAutoTimeZone() {
        try {
            return Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "auto_time_zone") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private void saveNitzTimeZone(String zoneId) {
        this.mSavedTimeZone = zoneId;
    }

    private void saveNitzTime(long time) {
        this.mSavedTime = time;
        this.mSavedAtTime = SystemClock.elapsedRealtime();
    }

    private void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        this.log("setAndBroadcastNetworkSetTimeZone: setTimeZone=" + zoneId);
        AlarmManager alarm = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
        alarm.setTimeZone(zoneId);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.addFlags(0x20000000);
        intent.putExtra("time-zone", zoneId);
        this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        this.log("setAndBroadcastNetworkSetTimeZone: call alarm.setTimeZone and broadcast zoneId=" + zoneId);
    }

    private void setAndBroadcastNetworkSetTime(long time) {
        this.log("setAndBroadcastNetworkSetTime: time=" + time + "ms");
        SystemClock.setCurrentTimeMillis(time);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.addFlags(0x20000000);
        intent.putExtra("time", time);
        this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void revertToNitzTime() {
        if (Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "auto_time", 0) == 0) {
            return;
        }
        this.log("Reverting to NITZ Time: mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
        if (this.mSavedTime != 0L && this.mSavedAtTime != 0L) {
            this.setAndBroadcastNetworkSetTime(this.mSavedTime + (SystemClock.elapsedRealtime() - this.mSavedAtTime));
        }
    }

    private void revertToNitzTimeZone() {
        if (Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "auto_time_zone", 0) == 0) {
            return;
        }
        this.log("Reverting to NITZ TimeZone: tz='" + this.mSavedTimeZone);
        if (this.mSavedTimeZone != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
        }
    }

    private void setNotification(int notifyType) {
        this.log("setNotification: create notification " + notifyType);
        Context context = this.mPhone.getContext();
        this.mNotification = new Notification();
        this.mNotification.when = System.currentTimeMillis();
        this.mNotification.flags = 16;
        this.mNotification.icon = 17301642;
        Intent intent = new Intent();
        this.mNotification.contentIntent = PendingIntent.getActivity(context, 0, intent, 0x10000000);
        CharSequence details = "";
        CharSequence title = context.getText(17039479);
        int notificationId = 999;
        switch (notifyType) {
            case 1001: {
                notificationId = 888;
                details = context.getText(17039480);
                break;
            }
            case 1002: {
                notificationId = 888;
                break;
            }
            case 1003: {
                details = context.getText(17039483);
                break;
            }
            case 1005: {
                details = context.getText(17039482);
                break;
            }
            case 1006: {
                details = context.getText(17039481);
                break;
            }
        }
        this.log("setNotification: put notification " + title + " / " + details);
        this.mNotification.tickerText = title;
        this.mNotification.setLatestEventInfo(context, title, details, this.mNotification.contentIntent);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notifyType == 1002 || notifyType == 1004) {
            notificationManager.cancel(notificationId);
        } else {
            notificationManager.notify(notificationId, this.mNotification);
        }
    }

    protected void onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.mUiccController.getUiccCardApplication(1);
        if (this.mUiccApplcation != newUiccApplication) {
            if (this.mUiccApplcation != null) {
                this.log("Removing stale icc objects.");
                this.mUiccApplcation.unregisterForReady(this);
                if (this.mIccRecords != null) {
                    this.mIccRecords.unregisterForRecordsLoaded(this);
                }
                this.mIccRecords = null;
                this.mUiccApplcation = null;
            }
            if (newUiccApplication != null) {
                this.log("New card found");
                this.mUiccApplcation = newUiccApplication;
                this.mIccRecords = this.mUiccApplcation.getIccRecords();
                this.mUiccApplcation.registerForReady(this, 17, null);
                if (this.mIccRecords != null) {
                    this.mIccRecords.registerForRecordsLoaded(this, 16, null);
                }
            }
        }
    }

    protected void log(String s) {
        Rlog.d(LOG_TAG, "[GsmSST] " + s);
    }

    protected void loge(String s) {
        Rlog.e(LOG_TAG, "[GsmSST] " + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("GsmServiceStateTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mSS=" + this.mSS);
        pw.println(" mNewSS=" + this.mNewSS);
        pw.println(" mCellLoc=" + this.mCellLoc);
        pw.println(" mNewCellLoc=" + this.mNewCellLoc);
        pw.println(" mPreferredNetworkType=" + this.mPreferredNetworkType);
        pw.println(" mMaxDataCalls=" + this.mMaxDataCalls);
        pw.println(" mNewMaxDataCalls=" + this.mNewMaxDataCalls);
        pw.println(" mReasonDataDenied=" + this.mReasonDataDenied);
        pw.println(" mNewReasonDataDenied=" + this.mNewReasonDataDenied);
        pw.println(" mGsmRoaming=" + this.mGsmRoaming);
        pw.println(" mDataRoaming=" + this.mDataRoaming);
        pw.println(" mEmergencyOnly=" + this.mEmergencyOnly);
        pw.println(" mNeedFixZoneAfterNitz=" + this.mNeedFixZoneAfterNitz);
        pw.println(" mZoneOffset=" + this.mZoneOffset);
        pw.println(" mZoneDst=" + this.mZoneDst);
        pw.println(" mZoneTime=" + this.mZoneTime);
        pw.println(" mGotCountryCode=" + this.mGotCountryCode);
        pw.println(" mNitzUpdatedTime=" + this.mNitzUpdatedTime);
        pw.println(" mSavedTimeZone=" + this.mSavedTimeZone);
        pw.println(" mSavedTime=" + this.mSavedTime);
        pw.println(" mSavedAtTime=" + this.mSavedAtTime);
        pw.println(" mStartedGprsRegCheck=" + this.mStartedGprsRegCheck);
        pw.println(" mReportedGprsNoReg=" + this.mReportedGprsNoReg);
        pw.println(" mNotification=" + this.mNotification);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mCurSpn=" + this.mCurSpn);
        pw.println(" mCurShowSpn=" + this.mCurShowSpn);
        pw.println(" mCurPlmn=" + this.mCurPlmn);
        pw.println(" mCurShowPlmn=" + this.mCurShowPlmn);
    }
}

