/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;

public abstract class BaseMenuPresenter
implements MenuPresenter {
    protected Context mSystemContext;
    protected Context mContext;
    protected MenuBuilder mMenu;
    protected LayoutInflater mSystemInflater;
    protected LayoutInflater mInflater;
    private MenuPresenter.Callback mCallback;
    private int mMenuLayoutRes;
    private int mItemLayoutRes;
    protected MenuView mMenuView;
    private int mId;

    public BaseMenuPresenter(Context context, int menuLayoutRes, int itemLayoutRes) {
        this.mSystemContext = context;
        this.mSystemInflater = LayoutInflater.from(context);
        this.mMenuLayoutRes = menuLayoutRes;
        this.mItemLayoutRes = itemLayoutRes;
    }

    public void initForMenu(Context context, MenuBuilder menu2) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from(this.mContext);
        this.mMenu = menu2;
    }

    public MenuView getMenuView(ViewGroup root) {
        if (this.mMenuView == null) {
            this.mMenuView = (MenuView)((Object)this.mSystemInflater.inflate(this.mMenuLayoutRes, root, false));
            this.mMenuView.initialize(this.mMenu);
            this.updateMenuView(true);
        }
        return this.mMenuView;
    }

    public void updateMenuView(boolean cleared) {
        ViewGroup parent = (ViewGroup)((Object)this.mMenuView);
        if (parent == null) {
            return;
        }
        int childIndex = 0;
        if (this.mMenu != null) {
            this.mMenu.flagActionItems();
            ArrayList<MenuItemImpl> visibleItems = this.mMenu.getVisibleItems();
            int itemCount = visibleItems.size();
            for (int i = 0; i < itemCount; ++i) {
                MenuItemImpl item = visibleItems.get(i);
                if (!this.shouldIncludeItem(childIndex, item)) continue;
                View convertView = parent.getChildAt(childIndex);
                MenuItemImpl oldItem = convertView instanceof MenuView.ItemView ? ((MenuView.ItemView)((Object)convertView)).getItemData() : null;
                View itemView = this.getItemView(item, convertView, parent);
                if (item != oldItem) {
                    itemView.setPressed(false);
                    itemView.jumpDrawablesToCurrentState();
                }
                if (itemView != convertView) {
                    this.addItemView(itemView, childIndex);
                }
                ++childIndex;
            }
        }
        while (childIndex < parent.getChildCount()) {
            if (this.filterLeftoverView(parent, childIndex)) continue;
            ++childIndex;
        }
    }

    protected void addItemView(View itemView, int childIndex) {
        ViewGroup currentParent = (ViewGroup)itemView.getParent();
        if (currentParent != null) {
            currentParent.removeView(itemView);
        }
        ((ViewGroup)((Object)this.mMenuView)).addView(itemView, childIndex);
    }

    protected boolean filterLeftoverView(ViewGroup parent, int childIndex) {
        parent.removeViewAt(childIndex);
        return true;
    }

    public void setCallback(MenuPresenter.Callback cb) {
        this.mCallback = cb;
    }

    public MenuPresenter.Callback getCallback() {
        return this.mCallback;
    }

    public MenuView.ItemView createItemView(ViewGroup parent) {
        return (MenuView.ItemView)((Object)this.mSystemInflater.inflate(this.mItemLayoutRes, parent, false));
    }

    public View getItemView(MenuItemImpl item, View convertView, ViewGroup parent) {
        MenuView.ItemView itemView = convertView instanceof MenuView.ItemView ? (MenuView.ItemView)((Object)convertView) : this.createItemView(parent);
        this.bindItemView(item, itemView);
        return (View)((Object)itemView);
    }

    public abstract void bindItemView(MenuItemImpl var1, MenuView.ItemView var2);

    public boolean shouldIncludeItem(int childIndex, MenuItemImpl item) {
        return true;
    }

    public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        if (this.mCallback != null) {
            this.mCallback.onCloseMenu(menu2, allMenusAreClosing);
        }
    }

    public boolean onSubMenuSelected(SubMenuBuilder menu2) {
        if (this.mCallback != null) {
            return this.mCallback.onOpenSubMenu(menu2);
        }
        return false;
    }

    public boolean flagActionItems() {
        return false;
    }

    public boolean expandItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    public boolean collapseItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int id2) {
        this.mId = id2;
    }
}

