/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActivityManagerNative;
import android.app.admin.DevicePolicyManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.IWindowManager;
import android.widget.Button;
import com.android.internal.telephony.ITelephony;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockPatternUtils {
    private static final String TAG = "LockPatternUtils";
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 4;
    public static final String KEYGUARD_SHOW_USER_SWITCHER = "showuserswitcher";
    public static final String KEYGUARD_SHOW_SECURITY_CHALLENGE = "showsecuritychallenge";
    public static final String KEYGUARD_SHOW_APPWIDGET = "showappwidget";
    public static final int FLAG_BIOMETRIC_WEAK_LIVELINESS = 1;
    public static final int ID_DEFAULT_STATUS_WIDGET = -2;
    public static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    public static final String PASSWORD_TYPE_ALTERNATE_KEY = "lockscreen.password_type_alternate";
    public static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public static final String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    public static final String LOCKSCREEN_OPTIONS = "lockscreen.options";
    public static final String LOCKSCREEN_BIOMETRIC_WEAK_FALLBACK = "lockscreen.biometric_weak_fallback";
    public static final String BIOMETRIC_WEAK_EVER_CHOSEN_KEY = "lockscreen.biometricweakeverchosen";
    public static final String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    public static final String LOCKSCREEN_WIDGETS_ENABLED = "lockscreen.widgets_enabled";
    public static final String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    private static final String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static final String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;
    private final boolean mMultiUserMode;
    private static volatile int sCurrentUserId = -10000;

    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    public LockPatternUtils(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mMultiUserMode = context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0;
    }

    private ILockSettings getLockSettings() {
        if (this.mLockSettingsService == null) {
            this.mLockSettingsService = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        }
        return this.mLockSettingsService;
    }

    public int getRequestedMinimumPasswordLength() {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordQuality() {
        return this.getDevicePolicyManager().getPasswordQuality(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordHistoryLength() {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumLetters() {
        return this.getDevicePolicyManager().getPasswordMinimumLetters(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumUpperCase() {
        return this.getDevicePolicyManager().getPasswordMinimumUpperCase(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumLowerCase() {
        return this.getDevicePolicyManager().getPasswordMinimumLowerCase(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumNumeric() {
        return this.getDevicePolicyManager().getPasswordMinimumNumeric(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumSymbols() {
        return this.getDevicePolicyManager().getPasswordMinimumSymbols(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumNonLetter() {
        return this.getDevicePolicyManager().getPasswordMinimumNonLetter(null, this.getCurrentOrCallingUserId());
    }

    public void reportFailedPasswordAttempt() {
        this.getDevicePolicyManager().reportFailedPasswordAttempt(this.getCurrentOrCallingUserId());
    }

    public void reportSuccessfulPasswordAttempt() {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(this.getCurrentOrCallingUserId());
    }

    public void setCurrentUser(int userId) {
        sCurrentUserId = userId;
    }

    public int getCurrentUser() {
        if (sCurrentUserId != -10000) {
            return sCurrentUserId;
        }
        try {
            return ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException re) {
            return 0;
        }
    }

    public void removeUser(int userId) {
        try {
            this.getLockSettings().removeUser(userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't remove lock settings for user " + userId);
        }
    }

    private int getCurrentOrCallingUserId() {
        if (this.mMultiUserMode) {
            return this.getCurrentUser();
        }
        return UserHandle.getCallingUserId();
    }

    public boolean checkPattern(List<LockPatternView.Cell> pattern) {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkPattern(LockPatternUtils.patternToString(pattern), userId);
        }
        catch (RemoteException re) {
            return true;
        }
    }

    public boolean checkPassword(String password) {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkPassword(password, userId);
        }
        catch (RemoteException re) {
            return true;
        }
    }

    public boolean checkPasswordHistory(String password) {
        String passwordHashString = new String(this.passwordToHash(password));
        String passwordHistory = this.getString(PASSWORD_HISTORY_KEY);
        if (passwordHistory == null) {
            return false;
        }
        int passwordHashLength = passwordHashString.length();
        int passwordHistoryLength = this.getRequestedPasswordHistoryLength();
        if (passwordHistoryLength == 0) {
            return false;
        }
        int neededPasswordHistoryLength = passwordHashLength * passwordHistoryLength + passwordHistoryLength - 1;
        if (passwordHistory.length() > neededPasswordHistoryLength) {
            passwordHistory = passwordHistory.substring(0, neededPasswordHistoryLength);
        }
        return passwordHistory.contains(passwordHashString);
    }

    public boolean savedPatternExists() {
        try {
            return this.getLockSettings().havePattern(this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean savedPasswordExists() {
        try {
            return this.getLockSettings().havePassword(this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY, false);
    }

    public boolean isBiometricWeakEverChosen() {
        return this.getBoolean(BIOMETRIC_WEAK_EVER_CHOSEN_KEY, false);
    }

    public int getActivePasswordQuality() {
        int activePasswordQuality = 0;
        int quality = (int)this.getLong(PASSWORD_TYPE_KEY, 65536L);
        switch (quality) {
            case 65536: {
                if (!this.isLockPatternEnabled()) break;
                activePasswordQuality = 65536;
                break;
            }
            case 32768: {
                if (!this.isBiometricWeakInstalled()) break;
                activePasswordQuality = 32768;
                break;
            }
            case 131072: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 131072;
                break;
            }
            case 262144: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 262144;
                break;
            }
            case 327680: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 327680;
                break;
            }
            case 393216: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 393216;
            }
        }
        return activePasswordQuality;
    }

    public void clearLock(boolean isFallback) {
        if (!isFallback) {
            this.deleteGallery();
        }
        this.saveLockPassword(null, 65536);
        this.setLockPatternEnabled(false);
        this.saveLockPattern(null);
        this.setLong(PASSWORD_TYPE_KEY, 0L);
        this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L);
    }

    public void setLockScreenDisabled(boolean disable) {
        this.setLong(DISABLE_LOCKSCREEN_KEY, disable ? 1L : 0L);
    }

    public boolean isLockScreenDisabled() {
        return !this.isSecure() && this.getLong(DISABLE_LOCKSCREEN_KEY, 0L) != 0L;
    }

    public void deleteTempGallery() {
        Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
        intent.putExtra("deleteTempGallery", true);
        this.mContext.sendBroadcast(intent);
    }

    void deleteGallery() {
        if (this.usingBiometricWeak()) {
            Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
            intent.putExtra("deleteGallery", true);
            this.mContext.sendBroadcast(intent);
        }
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern) {
        this.saveLockPattern(pattern, false);
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern, boolean isFallback) {
        try {
            this.getLockSettings().setLockPattern(LockPatternUtils.patternToString(pattern), this.getCurrentOrCallingUserId());
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (pattern != null) {
                this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true);
                if (!isFallback) {
                    this.deleteGallery();
                    this.setLong(PASSWORD_TYPE_KEY, 65536L);
                    dpm.setActivePasswordState(65536, pattern.size(), 0, 0, 0, 0, 0, 0, this.getCurrentOrCallingUserId());
                } else {
                    this.setLong(PASSWORD_TYPE_KEY, 32768L);
                    this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 65536L);
                    this.finishBiometricWeak();
                    dpm.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, this.getCurrentOrCallingUserId());
                }
            } else {
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, this.getCurrentOrCallingUserId());
            }
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't save lock pattern " + re);
        }
    }

    public void setOwnerInfo(String info, int userId) {
        this.setString(LOCK_SCREEN_OWNER_INFO, info, userId);
    }

    public void setOwnerInfoEnabled(boolean enabled) {
        this.setBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, enabled);
    }

    public String getOwnerInfo(int userId) {
        return this.getString(LOCK_SCREEN_OWNER_INFO);
    }

    public boolean isOwnerInfoEnabled() {
        return this.getBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, false);
    }

    public static int computePasswordQuality(String password) {
        boolean hasDigit = false;
        boolean hasNonDigit = false;
        int len = password.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(password.charAt(i))) {
                hasDigit = true;
                continue;
            }
            hasNonDigit = true;
        }
        if (hasNonDigit && hasDigit) {
            return 327680;
        }
        if (hasNonDigit) {
            return 262144;
        }
        if (hasDigit) {
            return 131072;
        }
        return 0;
    }

    private void updateEncryptionPassword(String password) {
        DevicePolicyManager dpm = this.getDevicePolicyManager();
        if (dpm.getStorageEncryptionStatus(this.getCurrentOrCallingUserId()) != 3) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the encryption password");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            mountService.changeEncryptionPassword(password);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing encryption password", e);
        }
    }

    public void saveLockPassword(String password, int quality) {
        this.saveLockPassword(password, quality, false, this.getCurrentOrCallingUserId());
    }

    public void saveLockPassword(String password, int quality, boolean isFallback) {
        this.saveLockPassword(password, quality, isFallback, this.getCurrentOrCallingUserId());
    }

    public void saveLockPassword(String password, int quality, boolean isFallback, int userHandle) {
        try {
            this.getLockSettings().setLockPassword(password, userHandle);
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (password != null) {
                int passwordHistoryLength;
                if (userHandle == 0) {
                    this.updateEncryptionPassword(password);
                }
                int computedQuality = LockPatternUtils.computePasswordQuality(password);
                if (!isFallback) {
                    this.deleteGallery();
                    this.setLong(PASSWORD_TYPE_KEY, Math.max(quality, computedQuality), userHandle);
                    if (computedQuality != 0) {
                        int letters = 0;
                        int uppercase = 0;
                        int lowercase = 0;
                        int numbers = 0;
                        int symbols = 0;
                        int nonletter = 0;
                        for (int i = 0; i < password.length(); ++i) {
                            char c = password.charAt(i);
                            if (c >= 'A' && c <= 'Z') {
                                ++letters;
                                ++uppercase;
                                continue;
                            }
                            if (c >= 'a' && c <= 'z') {
                                ++letters;
                                ++lowercase;
                                continue;
                            }
                            if (c >= '0' && c <= '9') {
                                ++numbers;
                                ++nonletter;
                                continue;
                            }
                            ++symbols;
                            ++nonletter;
                        }
                        dpm.setActivePasswordState(Math.max(quality, computedQuality), password.length(), letters, uppercase, lowercase, numbers, symbols, nonletter, userHandle);
                    } else {
                        dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
                    }
                } else {
                    this.setLong(PASSWORD_TYPE_KEY, 32768L, userHandle);
                    this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, Math.max(quality, computedQuality), userHandle);
                    this.finishBiometricWeak();
                    dpm.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, userHandle);
                }
                String passwordHistory = this.getString(PASSWORD_HISTORY_KEY, userHandle);
                if (passwordHistory == null) {
                    passwordHistory = new String();
                }
                if ((passwordHistoryLength = this.getRequestedPasswordHistoryLength()) == 0) {
                    passwordHistory = "";
                } else {
                    byte[] hash = this.passwordToHash(password);
                    passwordHistory = new String(hash) + "," + passwordHistory;
                    passwordHistory = passwordHistory.substring(0, Math.min(hash.length * passwordHistoryLength + passwordHistoryLength - 1, passwordHistory.length()));
                }
                this.setString(PASSWORD_HISTORY_KEY, passwordHistory, userHandle);
            } else {
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
            }
        }
        catch (RemoteException re) {
            Log.e(TAG, "Unable to save lock password " + re);
        }
    }

    public int getKeyguardStoredPasswordQuality() {
        int quality = (int)this.getLong(PASSWORD_TYPE_KEY, 65536L);
        if (quality == 32768) {
            quality = (int)this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 65536L);
        }
        return quality;
    }

    public boolean usingBiometricWeak() {
        int quality = (int)this.getLong(PASSWORD_TYPE_KEY, 65536L);
        return quality == 32768;
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        byte[] bytes = string2.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    public static String patternToString(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        return new String(res);
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    private String getSalt() {
        long salt = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong(LOCK_PASSWORD_SALT_KEY, salt);
                Log.v(TAG, "Initialized lock password salt");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    public byte[] passwordToHash(String password) {
        if (password == null) {
            return null;
        }
        String algo = null;
        byte[] hashed = null;
        try {
            byte[] saltedPassword = (password + this.getSalt()).getBytes();
            algo = "SHA-1";
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            algo = "MD5";
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            hashed = (LockPatternUtils.toHex(sha1) + LockPatternUtils.toHex(md5)).getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            Log.w(TAG, "Failed to encode string because of missing algorithm: " + algo);
        }
        return hashed;
    }

    private static String toHex(byte[] ary) {
        String hex = "0123456789ABCDEF";
        String ret = "";
        for (int i = 0; i < ary.length; ++i) {
            ret = ret + "0123456789ABCDEF".charAt(ary[i] >> 4 & 0xF);
            ret = ret + "0123456789ABCDEF".charAt(ary[i] & 0xF);
        }
        return ret;
    }

    public boolean isLockPasswordEnabled() {
        long mode = this.getLong(PASSWORD_TYPE_KEY, 0L);
        long backupMode = this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L);
        boolean passwordEnabled = mode == 262144L || mode == 131072L || mode == 327680L || mode == 393216L;
        boolean backupEnabled = backupMode == 262144L || backupMode == 131072L || backupMode == 327680L || backupMode == 393216L;
        return this.savedPasswordExists() && (passwordEnabled || this.usingBiometricWeak() && backupEnabled);
    }

    public boolean isLockPatternEnabled() {
        boolean backupEnabled = this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 65536L) == 65536L;
        return this.getBoolean("lock_pattern_autolock", false) && (this.getLong(PASSWORD_TYPE_KEY, 65536L) == 65536L || this.usingBiometricWeak() && backupEnabled);
    }

    public boolean isBiometricWeakInstalled() {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pm.getPackageInfo("com.android.facelock", 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        if (!pm.hasSystemFeature("android.hardware.camera.front")) {
            return false;
        }
        return !this.getDevicePolicyManager().getCameraDisabled(null, this.getCurrentOrCallingUserId());
    }

    public void setBiometricWeakLivelinessEnabled(boolean enabled) {
        long currentFlag = this.getLong("lock_biometric_weak_flags", 0L);
        long newFlag = enabled ? currentFlag | 1L : currentFlag & 0xFFFFFFFFFFFFFFFEL;
        this.setLong("lock_biometric_weak_flags", newFlag);
    }

    public boolean isBiometricWeakLivelinessEnabled() {
        long currentFlag = this.getLong("lock_biometric_weak_flags", 0L);
        return (currentFlag & 1L) != 0L;
    }

    public void setLockPatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_autolock", enabled);
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern", false);
    }

    public void setVisiblePatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_visible_pattern", enabled);
    }

    public boolean isTactileFeedbackEnabled() {
        return Settings.System.getIntForUser(this.mContentResolver, "haptic_feedback_enabled", 1, -2) != 0;
    }

    public long setLockoutAttemptDeadline() {
        long deadline = SystemClock.elapsedRealtime() + 30000L;
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, deadline);
        return deadline;
    }

    public long getLockoutAttemptDeadline() {
        long now;
        long deadline = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
        if (deadline < (now = SystemClock.elapsedRealtime()) || deadline > now + 30000L) {
            return 0L;
        }
        return deadline;
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY, false);
    }

    public void setPermanentlyLocked(boolean locked) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, locked);
    }

    public boolean isEmergencyCallCapable() {
        return this.mContext.getResources().getBoolean(17891385);
    }

    public boolean isPukUnlockScreenEnable() {
        return this.mContext.getResources().getBoolean(17891373);
    }

    public boolean isEmergencyCallEnabledWhileSimLocked() {
        return this.mContext.getResources().getBoolean(17891374);
    }

    public String getNextAlarm() {
        String nextAlarm = Settings.System.getStringForUser(this.mContentResolver, "next_alarm_formatted", -2);
        if (nextAlarm == null || TextUtils.isEmpty(nextAlarm)) {
            return null;
        }
        return nextAlarm;
    }

    private boolean getBoolean(String secureSettingKey, boolean defaultValue, int userId) {
        try {
            return this.getLockSettings().getBoolean(secureSettingKey, defaultValue, userId);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private boolean getBoolean(String secureSettingKey, boolean defaultValue) {
        return this.getBoolean(secureSettingKey, defaultValue, this.getCurrentOrCallingUserId());
    }

    private void setBoolean(String secureSettingKey, boolean enabled, int userId) {
        try {
            this.getLockSettings().setBoolean(secureSettingKey, enabled, userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write boolean " + secureSettingKey + re);
        }
    }

    private void setBoolean(String secureSettingKey, boolean enabled) {
        this.setBoolean(secureSettingKey, enabled, this.getCurrentOrCallingUserId());
    }

    public int[] getAppWidgets() {
        return this.getAppWidgets(-2);
    }

    private int[] getAppWidgets(int userId) {
        String appWidgetIdString = Settings.Secure.getStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", userId);
        String delims = ",";
        if (appWidgetIdString != null && appWidgetIdString.length() > 0) {
            String[] appWidgetStringIds = appWidgetIdString.split(delims);
            int[] appWidgetIds = new int[appWidgetStringIds.length];
            for (int i = 0; i < appWidgetStringIds.length; ++i) {
                String appWidget = appWidgetStringIds[i];
                try {
                    appWidgetIds[i] = Integer.decode(appWidget);
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.d(TAG, "Error when parsing widget id " + appWidget);
                    return null;
                }
            }
            return appWidgetIds;
        }
        return new int[0];
    }

    private static String combineStrings(int[] list, String separator) {
        int listLength = list.length;
        switch (listLength) {
            case 0: {
                return "";
            }
            case 1: {
                return Integer.toString(list[0]);
            }
        }
        int strLength = 0;
        int separatorLength = separator.length();
        String[] stringList = new String[list.length];
        for (int i = 0; i < listLength; ++i) {
            stringList[i] = Integer.toString(list[i]);
            strLength += stringList[i].length();
            if (i >= listLength - 1) continue;
            strLength += separatorLength;
        }
        StringBuilder sb = new StringBuilder(strLength);
        for (int i = 0; i < listLength; ++i) {
            sb.append(list[i]);
            if (i >= listLength - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public void writeFallbackAppWidgetId(int appWidgetId) {
        Settings.Secure.putIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", appWidgetId, -2);
    }

    public int getFallbackAppWidgetId() {
        return Settings.Secure.getIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", 0, -2);
    }

    private void writeAppWidgets(int[] appWidgetIds) {
        Settings.Secure.putStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", LockPatternUtils.combineStrings(appWidgetIds, ","), -2);
    }

    public boolean addAppWidget(int widgetId, int index) {
        int[] widgets = this.getAppWidgets();
        if (widgets == null) {
            return false;
        }
        if (index < 0 || index > widgets.length) {
            return false;
        }
        int[] newWidgets = new int[widgets.length + 1];
        int j = 0;
        for (int i = 0; i < newWidgets.length; ++i) {
            if (index == i) {
                newWidgets[i] = widgetId;
                ++i;
            }
            if (i >= newWidgets.length) continue;
            newWidgets[i] = widgets[j];
            ++j;
        }
        this.writeAppWidgets(newWidgets);
        return true;
    }

    public boolean removeAppWidget(int widgetId) {
        int[] widgets = this.getAppWidgets();
        if (widgets.length == 0) {
            return false;
        }
        int[] newWidgets = new int[widgets.length - 1];
        int j = 0;
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i] == widgetId) continue;
            if (j >= newWidgets.length) {
                return false;
            }
            newWidgets[j] = widgets[i];
            ++j;
        }
        this.writeAppWidgets(newWidgets);
        return true;
    }

    private long getLong(String secureSettingKey, long defaultValue) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private void setLong(String secureSettingKey, long value) {
        this.setLong(secureSettingKey, value, this.getCurrentOrCallingUserId());
    }

    private void setLong(String secureSettingKey, long value, int userHandle) {
        try {
            this.getLockSettings().setLong(secureSettingKey, value, this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write long " + secureSettingKey + re);
        }
    }

    private String getString(String secureSettingKey) {
        return this.getString(secureSettingKey, this.getCurrentOrCallingUserId());
    }

    private String getString(String secureSettingKey, int userHandle) {
        try {
            return this.getLockSettings().getString(secureSettingKey, null, userHandle);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private void setString(String secureSettingKey, String value, int userHandle) {
        try {
            this.getLockSettings().setString(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write string " + secureSettingKey + re);
        }
    }

    public boolean isSecure() {
        long mode = this.getKeyguardStoredPasswordQuality();
        boolean isPattern = mode == 65536L;
        boolean isPassword = mode == 131072L || mode == 262144L || mode == 327680L || mode == 393216L;
        boolean secure = isPattern && this.isLockPatternEnabled() && this.savedPatternExists() || isPassword && this.savedPasswordExists();
        return secure;
    }

    public void updateEmergencyCallButtonState(Button button, int phoneState, boolean shown, boolean showIcon) {
        int textId;
        if (!this.isEmergencyCallCapable() || !shown) {
            button.setVisibility(8);
            return;
        }
        button.setVisibility(0);
        if (phoneState == 2) {
            textId = 17040142;
            int phoneCallIcon = showIcon ? 17301636 : 0;
            button.setCompoundDrawablesWithIntrinsicBounds(phoneCallIcon, 0, 0, 0);
        } else {
            textId = 17040141;
            int emergencyIcon = showIcon ? 17302232 : 0;
            button.setCompoundDrawablesWithIntrinsicBounds(emergencyIcon, 0, 0, 0);
        }
        button.setText(textId);
    }

    public boolean resumeCall() {
        ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        try {
            if (phone != null && phone.showCallScreen()) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private void finishBiometricWeak() {
        this.setBoolean(BIOMETRIC_WEAK_EVER_CHOSEN_KEY, true);
        Intent intent = new Intent();
        intent.setClassName("com.android.facelock", "com.android.facelock.SetupEndScreen");
        this.mContext.startActivity(intent);
    }

    public void setPowerButtonInstantlyLocks(boolean enabled) {
        this.setBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, enabled);
    }

    public boolean getPowerButtonInstantlyLocks() {
        return this.getBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, true);
    }

    public static boolean isSafeModeEnabled() {
        try {
            return IWindowManager.Stub.asInterface(ServiceManager.getService("window")).isSafeModeEnabled();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean hasWidgetsEnabledInKeyguard(int userid) {
        int[] widgets = this.getAppWidgets(userid);
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean getWidgetsEnabled() {
        return this.getWidgetsEnabled(this.getCurrentOrCallingUserId());
    }

    public boolean getWidgetsEnabled(int userId) {
        return this.getBoolean(LOCKSCREEN_WIDGETS_ENABLED, false, userId);
    }

    public void setWidgetsEnabled(boolean enabled) {
        this.setWidgetsEnabled(enabled, this.getCurrentOrCallingUserId());
    }

    public void setWidgetsEnabled(boolean enabled, int userId) {
        this.setBoolean(LOCKSCREEN_WIDGETS_ENABLED, enabled, userId);
    }
}

