/*
 * Decompiled with CFR 0.152.
 */
package com.android.location.provider;

import android.hardware.location.IFusedLocationHardware;
import android.hardware.location.IFusedLocationHardwareSink;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.location.provider.FusedLocationHardwareSink;
import com.android.location.provider.GmsFusedBatchOptions;
import java.util.HashMap;
import java.util.Map;

public final class FusedLocationHardware {
    private final String TAG = "FusedLocationHardware";
    private IFusedLocationHardware mLocationHardware;
    HashMap<FusedLocationHardwareSink, DispatcherHandler> mSinkList = new HashMap();
    private IFusedLocationHardwareSink mInternalSink = new IFusedLocationHardwareSink.Stub(){

        public void onLocationAvailable(Location[] locations) {
            FusedLocationHardware.this.dispatchLocations(locations);
        }

        public void onDiagnosticDataAvailable(String data) {
            FusedLocationHardware.this.dispatchDiagnosticData(data);
        }
    };

    public FusedLocationHardware(IFusedLocationHardware locationHardware) {
        this.mLocationHardware = locationHardware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSink(FusedLocationHardwareSink sink, Looper looper) {
        boolean registerSink;
        if (sink == null || looper == null) {
            throw new IllegalArgumentException("Parameter sink and looper cannot be null.");
        }
        HashMap<FusedLocationHardwareSink, DispatcherHandler> hashMap = this.mSinkList;
        synchronized (hashMap) {
            boolean bl = registerSink = this.mSinkList.size() == 0;
            if (this.mSinkList.containsKey(sink)) {
                return;
            }
            HashMap<FusedLocationHardwareSink, DispatcherHandler> newSinkList = new HashMap<FusedLocationHardwareSink, DispatcherHandler>(this.mSinkList);
            newSinkList.put(sink, new DispatcherHandler(looper));
            this.mSinkList = newSinkList;
        }
        if (registerSink) {
            try {
                this.mLocationHardware.registerSink(this.mInternalSink);
            }
            catch (RemoteException e) {
                Log.e("FusedLocationHardware", "RemoteException at registerSink");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSink(FusedLocationHardwareSink sink) {
        boolean unregisterSink;
        if (sink == null) {
            throw new IllegalArgumentException("Parameter sink cannot be null.");
        }
        HashMap<FusedLocationHardwareSink, DispatcherHandler> hashMap = this.mSinkList;
        synchronized (hashMap) {
            if (!this.mSinkList.containsKey(sink)) {
                return;
            }
            HashMap<FusedLocationHardwareSink, DispatcherHandler> newSinkList = new HashMap<FusedLocationHardwareSink, DispatcherHandler>(this.mSinkList);
            newSinkList.remove(sink);
            unregisterSink = newSinkList.size() == 0;
            this.mSinkList = newSinkList;
        }
        if (unregisterSink) {
            try {
                this.mLocationHardware.unregisterSink(this.mInternalSink);
            }
            catch (RemoteException e) {
                Log.e("FusedLocationHardware", "RemoteException at unregisterSink");
            }
        }
    }

    public int getSupportedBatchSize() {
        try {
            return this.mLocationHardware.getSupportedBatchSize();
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at getSupportedBatchSize");
            return 0;
        }
    }

    public void startBatching(int id2, GmsFusedBatchOptions batchOptions) {
        try {
            this.mLocationHardware.startBatching(id2, batchOptions.getParcelableOptions());
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at startBatching");
        }
    }

    public void stopBatching(int id2) {
        try {
            this.mLocationHardware.stopBatching(id2);
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at stopBatching");
        }
    }

    public void updateBatchingOptions(int id2, GmsFusedBatchOptions batchOptions) {
        try {
            this.mLocationHardware.updateBatchingOptions(id2, batchOptions.getParcelableOptions());
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at updateBatchingOptions");
        }
    }

    public void requestBatchOfLocations(int batchSizeRequest) {
        try {
            this.mLocationHardware.requestBatchOfLocations(batchSizeRequest);
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at requestBatchOfLocations");
        }
    }

    public boolean supportsDiagnosticDataInjection() {
        try {
            return this.mLocationHardware.supportsDiagnosticDataInjection();
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at supportsDiagnisticDataInjection");
            return false;
        }
    }

    public void injectDiagnosticData(String data) {
        try {
            this.mLocationHardware.injectDiagnosticData(data);
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at injectDiagnosticData");
        }
    }

    public boolean supportsDeviceContextInjection() {
        try {
            return this.mLocationHardware.supportsDeviceContextInjection();
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at supportsDeviceContextInjection");
            return false;
        }
    }

    public void injectDeviceContext(int deviceEnabledContext) {
        try {
            this.mLocationHardware.injectDeviceContext(deviceEnabledContext);
        }
        catch (RemoteException e) {
            Log.e("FusedLocationHardware", "RemoteException at injectDeviceContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchLocations(Location[] locations) {
        HashMap<FusedLocationHardwareSink, DispatcherHandler> sinks;
        HashMap<FusedLocationHardwareSink, DispatcherHandler> hashMap = this.mSinkList;
        synchronized (hashMap) {
            sinks = this.mSinkList;
        }
        for (Map.Entry<FusedLocationHardwareSink, DispatcherHandler> entry : sinks.entrySet()) {
            Message message = Message.obtain(entry.getValue(), 1, new MessageCommand(entry.getKey(), locations, null));
            message.sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDiagnosticData(String data) {
        HashMap<FusedLocationHardwareSink, DispatcherHandler> sinks;
        HashMap<FusedLocationHardwareSink, DispatcherHandler> hashMap = this.mSinkList;
        synchronized (hashMap) {
            sinks = this.mSinkList;
        }
        for (Map.Entry<FusedLocationHardwareSink, DispatcherHandler> entry : sinks.entrySet()) {
            Message message = Message.obtain(entry.getValue(), 2, new MessageCommand(entry.getKey(), null, data));
            message.sendToTarget();
        }
    }

    private class MessageCommand {
        private final FusedLocationHardwareSink mSink;
        private final Location[] mLocations;
        private final String mData;

        public MessageCommand(FusedLocationHardwareSink sink, Location[] locations, String data) {
            this.mSink = sink;
            this.mLocations = locations;
            this.mData = data;
        }

        public void dispatchLocation() {
            this.mSink.onLocationAvailable(this.mLocations);
        }

        public void dispatchDiagnosticData() {
            this.mSink.onDiagnosticDataAvailable(this.mData);
        }
    }

    private class DispatcherHandler
    extends Handler {
        public static final int DISPATCH_LOCATION = 1;
        public static final int DISPATCH_DIAGNOSTIC_DATA = 2;

        public DispatcherHandler(Looper looper) {
            super(looper, null, true);
        }

        public void handleMessage(Message message) {
            MessageCommand command = (MessageCommand)message.obj;
            switch (message.what) {
                case 1: {
                    command.dispatchLocation();
                    break;
                }
                case 2: {
                    command.dispatchDiagnosticData();
                }
                default: {
                    Log.e("FusedLocationHardware", "Invalid dispatch message");
                }
            }
        }
    }
}

