/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppOpsService
extends IAppOpsService.Stub {
    static final String TAG = "AppOps";
    static final boolean DEBUG = false;
    static final long WRITE_DELAY = 1800000L;
    Context mContext;
    final AtomicFile mFile;
    final Handler mHandler;
    boolean mWriteScheduled;
    final Runnable mWriteRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                AppOpsService.this.mWriteScheduled = false;
                AsyncTask<Void, Void, Void> task = new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... params) {
                        AppOpsService.this.writeState();
                        return null;
                    }
                };
                task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            }
        }
    };
    final SparseArray<HashMap<String, Ops>> mUidOps = new SparseArray();
    final SparseArray<ArrayList<Callback>> mOpModeWatchers = new SparseArray();
    final ArrayMap<String, ArrayList<Callback>> mPackageModeWatchers = new ArrayMap();
    final ArrayMap<IBinder, Callback> mModeWatchers = new ArrayMap();
    final ArrayMap<IBinder, ClientState> mClients = new ArrayMap();

    public AppOpsService(File storagePath) {
        this.mFile = new AtomicFile(storagePath);
        this.mHandler = new Handler();
        this.readState();
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService("appops", this.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            boolean changed = false;
            for (int i = 0; i < this.mUidOps.size(); ++i) {
                HashMap<String, Ops> pkgs = this.mUidOps.valueAt(i);
                Iterator<Ops> it = pkgs.values().iterator();
                while (it.hasNext()) {
                    int curUid;
                    Ops ops = it.next();
                    try {
                        curUid = this.mContext.getPackageManager().getPackageUid(ops.packageName, UserHandle.getUserId(ops.uid));
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        curUid = -1;
                    }
                    if (curUid == ops.uid) continue;
                    Slog.i(TAG, "Pruning old package " + ops.packageName + "/" + ops.uid + ": new uid=" + curUid);
                    it.remove();
                    changed = true;
                }
                if (pkgs.size() > 0) continue;
                this.mUidOps.removeAt(i);
            }
            if (changed) {
                this.scheduleWriteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageRemoved(int uid, String packageName) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            HashMap<String, Ops> pkgs = this.mUidOps.get(uid);
            if (pkgs != null && pkgs.remove(packageName) != null) {
                if (pkgs.size() <= 0) {
                    this.mUidOps.remove(uid);
                }
                this.scheduleWriteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uidRemoved(int uid) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.mUidOps.indexOfKey(uid) >= 0) {
                this.mUidOps.remove(uid);
                this.scheduleWriteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w(TAG, "Writing app ops before shutdown...");
        boolean doWrite = false;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.mWriteScheduled) {
                this.mWriteScheduled = false;
                doWrite = true;
            }
        }
        if (doWrite) {
            this.writeState();
        }
    }

    private ArrayList<AppOpsManager.OpEntry> collectOps(Ops pkgOps, int[] ops) {
        ArrayList<AppOpsManager.OpEntry> resOps = null;
        if (ops == null) {
            resOps = new ArrayList<AppOpsManager.OpEntry>();
            for (int j = 0; j < pkgOps.size(); ++j) {
                Op curOp = (Op)pkgOps.valueAt(j);
                resOps.add(new AppOpsManager.OpEntry(curOp.op, curOp.mode, curOp.time, curOp.rejectTime, curOp.duration));
            }
        } else {
            for (int j = 0; j < ops.length; ++j) {
                Op curOp = (Op)pkgOps.get(ops[j]);
                if (curOp == null) continue;
                if (resOps == null) {
                    resOps = new ArrayList();
                }
                resOps.add(new AppOpsManager.OpEntry(curOp.op, curOp.mode, curOp.time, curOp.rejectTime, curOp.duration));
            }
        }
        return resOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getPackagesForOps(int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        ArrayList<AppOpsManager.PackageOps> res = null;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            for (int i = 0; i < this.mUidOps.size(); ++i) {
                HashMap<String, Ops> packages = this.mUidOps.valueAt(i);
                for (Ops pkgOps : packages.values()) {
                    ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(pkgOps, ops);
                    if (resOps == null) continue;
                    if (res == null) {
                        res = new ArrayList<AppOpsManager.PackageOps>();
                    }
                    AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(pkgOps.packageName, pkgOps.uid, resOps);
                    res.add(resPackage);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Ops pkgOps = this.getOpsLocked(uid, packageName, false);
            if (pkgOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(pkgOps, ops);
            if (resOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.PackageOps> res = new ArrayList<AppOpsManager.PackageOps>();
            AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(pkgOps.packageName, pkgOps.uid, resOps);
            res.add(resPackage);
            return res;
        }
    }

    private void pruneOp(Op op, int uid, String packageName) {
        Ops ops;
        if (op.time == 0L && op.rejectTime == 0L && (ops = this.getOpsLocked(uid, packageName, false)) != null) {
            HashMap<String, Ops> pkgOps;
            ops.remove(op.op);
            if (ops.size() <= 0 && (pkgOps = this.mUidOps.get(uid)) != null) {
                pkgOps.remove(ops.packageName);
                if (pkgOps.size() <= 0) {
                    this.mUidOps.remove(uid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(int code, int uid, String packageName, int mode) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        ArrayList<Callback> repCbs = null;
        code = AppOpsManager.opToSwitch(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op op = this.getOpLocked(code, uid, packageName, true);
            if (op != null && op.mode != mode) {
                op.mode = mode;
                ArrayList<Callback> cbs = this.mOpModeWatchers.get(code);
                if (cbs != null) {
                    if (repCbs == null) {
                        repCbs = new ArrayList<Callback>();
                    }
                    repCbs.addAll(cbs);
                }
                if ((cbs = this.mPackageModeWatchers.get(packageName)) != null) {
                    if (repCbs == null) {
                        repCbs = new ArrayList();
                    }
                    repCbs.addAll(cbs);
                }
                if (mode == AppOpsManager.opToDefaultMode(op.op)) {
                    this.pruneOp(op, uid, packageName);
                }
                this.scheduleWriteNowLocked();
            }
        }
        if (repCbs != null) {
            for (int i = 0; i < repCbs.size(); ++i) {
                try {
                    ((Callback)repCbs.get((int)i)).mCallback.opChanged(code, packageName);
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    private static HashMap<Callback, ArrayList<Pair<String, Integer>>> addCallbacks(HashMap<Callback, ArrayList<Pair<String, Integer>>> callbacks, String packageName, int op, ArrayList<Callback> cbs) {
        if (cbs == null) {
            return callbacks;
        }
        if (callbacks == null) {
            callbacks = new HashMap();
        }
        for (int i = 0; i < cbs.size(); ++i) {
            Callback cb = cbs.get(i);
            ArrayList<Pair<String, Integer>> reports = callbacks.get(cb);
            if (reports == null) {
                reports = new ArrayList();
                callbacks.put(cb, reports);
            }
            reports.add(new Pair<String, Integer>(packageName, op));
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllModes() {
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        HashMap<Callback, ArrayList<Pair<String, Integer>>> callbacks = null;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            boolean changed = false;
            for (int i = this.mUidOps.size() - 1; i >= 0; --i) {
                HashMap<String, Ops> packages = this.mUidOps.valueAt(i);
                Iterator<Map.Entry<String, Ops>> it = packages.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Ops> ent = it.next();
                    String packageName = ent.getKey();
                    Ops pkgOps = ent.getValue();
                    for (int j = pkgOps.size() - 1; j >= 0; --j) {
                        Op curOp = (Op)pkgOps.valueAt(j);
                        if (!AppOpsManager.opAllowsReset(curOp.op) || curOp.mode == AppOpsManager.opToDefaultMode(curOp.op)) continue;
                        curOp.mode = AppOpsManager.opToDefaultMode(curOp.op);
                        changed = true;
                        callbacks = AppOpsService.addCallbacks(callbacks, packageName, curOp.op, this.mOpModeWatchers.get(curOp.op));
                        callbacks = AppOpsService.addCallbacks(callbacks, packageName, curOp.op, this.mPackageModeWatchers.get(packageName));
                        if (curOp.time != 0L || curOp.rejectTime != 0L) continue;
                        pkgOps.removeAt(j);
                    }
                    if (pkgOps.size() != 0) continue;
                    it.remove();
                }
                if (packages.size() != 0) continue;
                this.mUidOps.removeAt(i);
            }
            if (changed) {
                this.scheduleWriteNowLocked();
            }
        }
        if (callbacks != null) {
            for (Map.Entry ent : callbacks.entrySet()) {
                Callback cb = (Callback)ent.getKey();
                ArrayList reports = (ArrayList)ent.getValue();
                for (int i = 0; i < reports.size(); ++i) {
                    Pair rep = (Pair)reports.get(i);
                    try {
                        cb.mCallback.opChanged((Integer)rep.second, (String)rep.first);
                        continue;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWatchingMode(int op, String packageName, IAppOpsCallback callback) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ArrayList<Callback> cbs;
            op = AppOpsManager.opToSwitch(op);
            Callback cb = this.mModeWatchers.get(callback.asBinder());
            if (cb == null) {
                cb = new Callback(callback);
                this.mModeWatchers.put(callback.asBinder(), cb);
            }
            if (op != -1) {
                cbs = this.mOpModeWatchers.get(op);
                if (cbs == null) {
                    cbs = new ArrayList();
                    this.mOpModeWatchers.put(op, cbs);
                }
                cbs.add(cb);
            }
            if (packageName != null) {
                cbs = this.mPackageModeWatchers.get(packageName);
                if (cbs == null) {
                    cbs = new ArrayList();
                    this.mPackageModeWatchers.put(packageName, cbs);
                }
                cbs.add(cb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWatchingMode(IAppOpsCallback callback) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Callback cb = this.mModeWatchers.remove(callback.asBinder());
            if (cb != null) {
                ArrayList<Callback> cbs;
                int i;
                cb.unlinkToDeath();
                for (i = this.mOpModeWatchers.size() - 1; i >= 0; --i) {
                    cbs = this.mOpModeWatchers.valueAt(i);
                    cbs.remove(cb);
                    if (cbs.size() > 0) continue;
                    this.mOpModeWatchers.removeAt(i);
                }
                for (i = this.mPackageModeWatchers.size() - 1; i >= 0; --i) {
                    cbs = this.mPackageModeWatchers.valueAt(i);
                    cbs.remove(cb);
                    if (cbs.size() > 0) continue;
                    this.mPackageModeWatchers.removeAt(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getToken(IBinder clientToken) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ClientState cs = this.mClients.get(clientToken);
            if (cs == null) {
                cs = new ClientState(clientToken);
                this.mClients.put(clientToken, cs);
            }
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkOperation(int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op op = this.getOpLocked(AppOpsManager.opToSwitch(code), uid, packageName, false);
            if (op == null) {
                return AppOpsManager.opToDefaultMode(code);
            }
            return op.mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPackage(int uid, String packageName) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.getOpsLocked(uid, packageName, true) != null) {
                return 0;
            }
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int noteOperation(int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op switchOp;
            Ops ops = this.getOpsLocked(uid, packageName, true);
            if (ops == null) {
                return 2;
            }
            Op op = this.getOpLocked(ops, code, true);
            if (op.duration == -1) {
                Slog.w(TAG, "Noting op not finished: uid " + uid + " pkg " + packageName + " code " + code + " time=" + op.time + " duration=" + op.duration);
            }
            op.duration = 0;
            int switchCode = AppOpsManager.opToSwitch(code);
            Op op2 = switchOp = switchCode != code ? this.getOpLocked(ops, switchCode, true) : op;
            if (switchOp.mode != 0) {
                op.rejectTime = System.currentTimeMillis();
                return switchOp.mode;
            }
            op.time = System.currentTimeMillis();
            op.rejectTime = 0L;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startOperation(IBinder token, int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        ClientState client = (ClientState)token;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op switchOp;
            Ops ops = this.getOpsLocked(uid, packageName, true);
            if (ops == null) {
                return 2;
            }
            Op op = this.getOpLocked(ops, code, true);
            int switchCode = AppOpsManager.opToSwitch(code);
            Op op2 = switchOp = switchCode != code ? this.getOpLocked(ops, switchCode, true) : op;
            if (switchOp.mode != 0) {
                op.rejectTime = System.currentTimeMillis();
                return switchOp.mode;
            }
            if (op.nesting == 0) {
                op.time = System.currentTimeMillis();
                op.rejectTime = 0L;
                op.duration = -1;
            }
            ++op.nesting;
            if (client.mStartedOps != null) {
                client.mStartedOps.add(op);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishOperation(IBinder token, int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        ClientState client = (ClientState)token;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op op = this.getOpLocked(code, uid, packageName, true);
            if (op == null) {
                return;
            }
            if (client.mStartedOps != null && !client.mStartedOps.remove(op)) {
                throw new IllegalStateException("Operation not started: uid" + op.uid + " pkg=" + op.packageName + " op=" + op.op);
            }
            this.finishOperationLocked(op);
        }
    }

    void finishOperationLocked(Op op) {
        if (op.nesting <= 1) {
            if (op.nesting == 1) {
                op.duration = (int)(System.currentTimeMillis() - op.time);
                op.time += (long)op.duration;
            } else {
                Slog.w(TAG, "Finishing op nesting under-run: uid " + op.uid + " pkg " + op.packageName + " code " + op.op + " time=" + op.time + " duration=" + op.duration + " nesting=" + op.nesting);
            }
            op.nesting = 0;
        } else {
            --op.nesting;
        }
    }

    private void verifyIncomingUid(int uid) {
        if (uid == Binder.getCallingUid()) {
            return;
        }
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private void verifyIncomingOp(int op) {
        if (op >= 0 && op < 43) {
            return;
        }
        throw new IllegalArgumentException("Bad operation #" + op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ops getOpsLocked(int uid, String packageName, boolean edit) {
        HashMap<String, Ops> pkgOps = this.mUidOps.get(uid);
        if (pkgOps == null) {
            if (!edit) {
                return null;
            }
            pkgOps = new HashMap();
            this.mUidOps.put(uid, pkgOps);
        }
        if (uid == 0) {
            packageName = "root";
        } else if (uid == 2000) {
            packageName = "com.android.shell";
        }
        Ops ops = pkgOps.get(packageName);
        if (ops == null) {
            if (!edit) {
                return null;
            }
            if (uid != 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    int pkgUid;
                    block14: {
                        pkgUid = -1;
                        try {
                            pkgUid = this.mContext.getPackageManager().getPackageUid(packageName, UserHandle.getUserId(uid));
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            if (!"media".equals(packageName)) break block14;
                            pkgUid = 1013;
                        }
                    }
                    if (pkgUid != uid) {
                        Slog.w(TAG, "Bad call: specified package " + packageName + " under uid " + uid + " but it is really " + pkgUid);
                        Ops ops2 = null;
                        return ops2;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            ops = new Ops(packageName, uid);
            pkgOps.put(packageName, ops);
        }
        return ops;
    }

    private void scheduleWriteLocked() {
        if (!this.mWriteScheduled) {
            this.mWriteScheduled = true;
            this.mHandler.postDelayed(this.mWriteRunner, 1800000L);
        }
    }

    private void scheduleWriteNowLocked() {
        if (!this.mWriteScheduled) {
            this.mWriteScheduled = true;
        }
        this.mHandler.removeCallbacks(this.mWriteRunner);
        this.mHandler.post(this.mWriteRunner);
    }

    private Op getOpLocked(int code, int uid, String packageName, boolean edit) {
        Ops ops = this.getOpsLocked(uid, packageName, edit);
        if (ops == null) {
            return null;
        }
        return this.getOpLocked(ops, code, edit);
    }

    private Op getOpLocked(Ops ops, int code, boolean edit) {
        Op op = (Op)ops.get(code);
        if (op == null) {
            if (!edit) {
                return null;
            }
            op = new Op(ops.uid, ops.packageName, code);
            ops.put(code, op);
        }
        if (edit) {
            this.scheduleWriteLocked();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readState() {
        AtomicFile atomicFile = this.mFile;
        synchronized (atomicFile) {
            AppOpsService appOpsService = this;
            synchronized (appOpsService) {
                FileInputStream stream;
                try {
                    stream = this.mFile.openRead();
                }
                catch (FileNotFoundException e) {
                    Slog.i(TAG, "No existing app ops " + this.mFile.getBaseFile() + "; starting empty");
                    return;
                }
                boolean success = false;
                try {
                    int type;
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput(stream, null);
                    while ((type = parser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        throw new IllegalStateException("no start tag found");
                    }
                    int outerDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                        if (type == 3 || type == 4) continue;
                        String tagName = parser.getName();
                        if (tagName.equals("pkg")) {
                            this.readPackage(parser);
                            continue;
                        }
                        Slog.w(TAG, "Unknown element under <app-ops>: " + parser.getName());
                        XmlUtils.skipCurrentTag(parser);
                    }
                    success = true;
                }
                catch (IllegalStateException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (NullPointerException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (NumberFormatException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (XmlPullParserException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (IndexOutOfBoundsException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                finally {
                    if (!success) {
                        this.mUidOps.clear();
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    void readPackage(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        String pkgName = parser.getAttributeValue(null, "n");
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("uid")) {
                this.readUid(parser, pkgName);
                continue;
            }
            Slog.w(TAG, "Unknown element under <pkg>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readUid(XmlPullParser parser, String pkgName) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        int uid = Integer.parseInt(parser.getAttributeValue(null, "n"));
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("op")) {
                Ops ops;
                HashMap<String, Ops> pkgOps;
                String dur;
                String time;
                Op op = new Op(uid, pkgName, Integer.parseInt(parser.getAttributeValue(null, "n")));
                String mode = parser.getAttributeValue(null, "m");
                if (mode != null) {
                    op.mode = Integer.parseInt(mode);
                }
                if ((time = parser.getAttributeValue(null, "t")) != null) {
                    op.time = Long.parseLong(time);
                }
                if ((time = parser.getAttributeValue(null, "r")) != null) {
                    op.rejectTime = Long.parseLong(time);
                }
                if ((dur = parser.getAttributeValue(null, "d")) != null) {
                    op.duration = Integer.parseInt(dur);
                }
                if ((pkgOps = this.mUidOps.get(uid)) == null) {
                    pkgOps = new HashMap();
                    this.mUidOps.put(uid, pkgOps);
                }
                if ((ops = pkgOps.get(pkgName)) == null) {
                    ops = new Ops(pkgName, uid);
                    pkgOps.put(pkgName, ops);
                }
                ops.put(op.op, op);
                continue;
            }
            Slog.w(TAG, "Unknown element under <pkg>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeState() {
        AtomicFile atomicFile = this.mFile;
        synchronized (atomicFile) {
            FileOutputStream stream;
            List<AppOpsManager.PackageOps> allOps = this.getPackagesForOps(null);
            try {
                stream = this.mFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write state: " + e);
                return;
            }
            try {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(stream, "utf-8");
                out.startDocument(null, true);
                out.startTag(null, "app-ops");
                if (allOps != null) {
                    String lastPkg = null;
                    for (int i = 0; i < allOps.size(); ++i) {
                        AppOpsManager.PackageOps pkg = allOps.get(i);
                        if (!pkg.getPackageName().equals(lastPkg)) {
                            if (lastPkg != null) {
                                out.endTag(null, "pkg");
                            }
                            lastPkg = pkg.getPackageName();
                            out.startTag(null, "pkg");
                            out.attribute(null, "n", lastPkg);
                        }
                        out.startTag(null, "uid");
                        out.attribute(null, "n", Integer.toString(pkg.getUid()));
                        List<AppOpsManager.OpEntry> ops = pkg.getOps();
                        for (int j = 0; j < ops.size(); ++j) {
                            int dur;
                            long time;
                            AppOpsManager.OpEntry op = ops.get(j);
                            out.startTag(null, "op");
                            out.attribute(null, "n", Integer.toString(op.getOp()));
                            if (op.getMode() != AppOpsManager.opToDefaultMode(op.getOp())) {
                                out.attribute(null, "m", Integer.toString(op.getMode()));
                            }
                            if ((time = op.getTime()) != 0L) {
                                out.attribute(null, "t", Long.toString(time));
                            }
                            if ((time = op.getRejectTime()) != 0L) {
                                out.attribute(null, "r", Long.toString(time));
                            }
                            if ((dur = op.getDuration()) != 0) {
                                out.attribute(null, "d", Integer.toString(dur));
                            }
                            out.endTag(null, "op");
                        }
                        out.endTag(null, "uid");
                    }
                    if (lastPkg != null) {
                        out.endTag(null, "pkg");
                    }
                }
                out.endTag(null, "app-ops");
                out.endDocument();
                this.mFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write state, restoring backup.", e);
                this.mFile.failWrite(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ApOps service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int j;
            ArrayList<Callback> callbacks;
            int i;
            pw.println("Current AppOps Service state:");
            long now = System.currentTimeMillis();
            boolean needSep = false;
            if (this.mOpModeWatchers.size() > 0) {
                needSep = true;
                pw.println("  Op mode watchers:");
                for (i = 0; i < this.mOpModeWatchers.size(); ++i) {
                    pw.print("    Op ");
                    pw.print(AppOpsManager.opToName(this.mOpModeWatchers.keyAt(i)));
                    pw.println(":");
                    callbacks = this.mOpModeWatchers.valueAt(i);
                    for (j = 0; j < callbacks.size(); ++j) {
                        pw.print("      #");
                        pw.print(j);
                        pw.print(": ");
                        pw.println(callbacks.get(j));
                    }
                }
            }
            if (this.mPackageModeWatchers.size() > 0) {
                needSep = true;
                pw.println("  Package mode watchers:");
                for (i = 0; i < this.mPackageModeWatchers.size(); ++i) {
                    pw.print("    Pkg ");
                    pw.print(this.mPackageModeWatchers.keyAt(i));
                    pw.println(":");
                    callbacks = this.mPackageModeWatchers.valueAt(i);
                    for (j = 0; j < callbacks.size(); ++j) {
                        pw.print("      #");
                        pw.print(j);
                        pw.print(": ");
                        pw.println(callbacks.get(j));
                    }
                }
            }
            if (this.mModeWatchers.size() > 0) {
                needSep = true;
                pw.println("  All mode watchers:");
                for (i = 0; i < this.mModeWatchers.size(); ++i) {
                    pw.print("    ");
                    pw.print(this.mModeWatchers.keyAt(i));
                    pw.print(" -> ");
                    pw.println(this.mModeWatchers.valueAt(i));
                }
            }
            if (this.mClients.size() > 0) {
                needSep = true;
                pw.println("  Clients:");
                for (i = 0; i < this.mClients.size(); ++i) {
                    pw.print("    ");
                    pw.print(this.mClients.keyAt(i));
                    pw.println(":");
                    ClientState cs = this.mClients.valueAt(i);
                    pw.print("      ");
                    pw.println(cs);
                    if (cs.mStartedOps == null || cs.mStartedOps.size() <= 0) continue;
                    pw.println("      Started ops:");
                    for (j = 0; j < cs.mStartedOps.size(); ++j) {
                        Op op = cs.mStartedOps.get(j);
                        pw.print("        ");
                        pw.print("uid=");
                        pw.print(op.uid);
                        pw.print(" pkg=");
                        pw.print(op.packageName);
                        pw.print(" op=");
                        pw.println(AppOpsManager.opToName(op.op));
                    }
                }
            }
            if (needSep) {
                pw.println();
            }
            for (i = 0; i < this.mUidOps.size(); ++i) {
                pw.print("  Uid ");
                UserHandle.formatUid(pw, this.mUidOps.keyAt(i));
                pw.println(":");
                HashMap<String, Ops> pkgOps = this.mUidOps.valueAt(i);
                for (Ops ops : pkgOps.values()) {
                    pw.print("    Package ");
                    pw.print(ops.packageName);
                    pw.println(":");
                    for (int j2 = 0; j2 < ops.size(); ++j2) {
                        Op op = (Op)ops.valueAt(j2);
                        pw.print("      ");
                        pw.print(AppOpsManager.opToName(op.op));
                        pw.print(": mode=");
                        pw.print(op.mode);
                        if (op.time != 0L) {
                            pw.print("; time=");
                            TimeUtils.formatDuration(now - op.time, pw);
                            pw.print(" ago");
                        }
                        if (op.rejectTime != 0L) {
                            pw.print("; rejectTime=");
                            TimeUtils.formatDuration(now - op.rejectTime, pw);
                            pw.print(" ago");
                        }
                        if (op.duration == -1) {
                            pw.println(" (running)");
                            continue;
                        }
                        pw.print("; duration=");
                        TimeUtils.formatDuration((long)op.duration, pw);
                        pw.println();
                    }
                }
            }
        }
    }

    public final class ClientState
    extends Binder
    implements IBinder.DeathRecipient {
        final IBinder mAppToken;
        final int mPid;
        final ArrayList<Op> mStartedOps;

        public ClientState(IBinder appToken) {
            this.mAppToken = appToken;
            this.mPid = Binder.getCallingPid();
            if (appToken instanceof Binder) {
                this.mStartedOps = null;
            } else {
                this.mStartedOps = new ArrayList();
                try {
                    this.mAppToken.linkToDeath(this, 0);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "ClientState{mAppToken=" + this.mAppToken + ", " + (this.mStartedOps != null ? "pid=" + this.mPid : "local") + '}';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                for (int i = this.mStartedOps.size() - 1; i >= 0; --i) {
                    AppOpsService.this.finishOperationLocked(this.mStartedOps.get(i));
                }
                AppOpsService.this.mClients.remove(this.mAppToken);
            }
        }
    }

    public final class Callback
    implements IBinder.DeathRecipient {
        final IAppOpsCallback mCallback;

        public Callback(IAppOpsCallback callback) {
            this.mCallback = callback;
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void unlinkToDeath() {
            this.mCallback.asBinder().unlinkToDeath(this, 0);
        }

        public void binderDied() {
            AppOpsService.this.stopWatchingMode(this.mCallback);
        }
    }

    public static final class Op {
        public final int uid;
        public final String packageName;
        public final int op;
        public int mode;
        public int duration;
        public long time;
        public long rejectTime;
        public int nesting;

        public Op(int _uid, String _packageName, int _op) {
            this.uid = _uid;
            this.packageName = _packageName;
            this.op = _op;
            this.mode = AppOpsManager.opToDefaultMode(this.op);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Ops
    extends SparseArray<Op> {
        public final String packageName;
        public final int uid;

        public Ops(String _packageName, int _uid) {
            this.packageName = _packageName;
            this.uid = _uid;
        }
    }
}

