/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IBackupAgent;
import android.app.PendingIntent;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.IBackupManager;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreSet;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.StringBuilderPrinter;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.backup.IObbBackupService;
import com.android.server.PackageManagerBackupAgent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BackupManagerService
extends IBackupManager.Stub {
    private static final String TAG = "BackupManagerService";
    private static final boolean DEBUG = true;
    private static final boolean MORE_DEBUG = false;
    static final String BACKUP_MANIFEST_FILENAME = "_manifest";
    static final int BACKUP_MANIFEST_VERSION = 1;
    static final String BACKUP_FILE_HEADER_MAGIC = "ANDROID BACKUP\n";
    static final int BACKUP_FILE_VERSION = 1;
    static final boolean COMPRESS_FULL_BACKUPS = true;
    static final String SHARED_BACKUP_AGENT_PACKAGE = "com.android.sharedstoragebackup";
    static final String SERVICE_ACTION_TRANSPORT_HOST = "android.backup.TRANSPORT_HOST";
    private static final long BACKUP_INTERVAL = 3600000L;
    private static final int FUZZ_MILLIS = 300000;
    private static final long FIRST_BACKUP_INTERVAL = 43200000L;
    private static final String RUN_BACKUP_ACTION = "android.app.backup.intent.RUN";
    private static final String RUN_INITIALIZE_ACTION = "android.app.backup.intent.INIT";
    private static final String RUN_CLEAR_ACTION = "android.app.backup.intent.CLEAR";
    private static final int MSG_RUN_BACKUP = 1;
    private static final int MSG_RUN_FULL_BACKUP = 2;
    private static final int MSG_RUN_RESTORE = 3;
    private static final int MSG_RUN_CLEAR = 4;
    private static final int MSG_RUN_INITIALIZE = 5;
    private static final int MSG_RUN_GET_RESTORE_SETS = 6;
    private static final int MSG_TIMEOUT = 7;
    private static final int MSG_RESTORE_TIMEOUT = 8;
    private static final int MSG_FULL_CONFIRMATION_TIMEOUT = 9;
    private static final int MSG_RUN_FULL_RESTORE = 10;
    static final int MSG_BACKUP_RESTORE_STEP = 20;
    static final int MSG_OP_COMPLETE = 21;
    static final long TIMEOUT_INTERVAL = 10000L;
    static final long TIMEOUT_BACKUP_INTERVAL = 30000L;
    static final long TIMEOUT_FULL_BACKUP_INTERVAL = 300000L;
    static final long TIMEOUT_SHARED_BACKUP_INTERVAL = 1800000L;
    static final long TIMEOUT_RESTORE_INTERVAL = 60000L;
    static final long TIMEOUT_FULL_CONFIRMATION = 60000L;
    private Context mContext;
    private PackageManager mPackageManager;
    IPackageManager mPackageManagerBinder;
    private IActivityManager mActivityManager;
    private PowerManager mPowerManager;
    private AlarmManager mAlarmManager;
    private IMountService mMountService;
    IBackupManager mBackupManagerBinder;
    boolean mEnabled;
    boolean mProvisioned;
    boolean mAutoRestore;
    PowerManager.WakeLock mWakelock;
    HandlerThread mHandlerThread;
    BackupHandler mBackupHandler;
    PendingIntent mRunBackupIntent;
    PendingIntent mRunInitIntent;
    BroadcastReceiver mRunBackupReceiver;
    BroadcastReceiver mRunInitReceiver;
    final SparseArray<HashSet<String>> mBackupParticipants;
    HashMap<String, BackupRequest> mPendingBackups;
    static final String PACKAGE_MANAGER_SENTINEL = "@pm@";
    final Object mQueueLock;
    final Object mAgentConnectLock;
    IBackupAgent mConnectedAgent;
    volatile boolean mBackupRunning;
    volatile boolean mConnecting;
    volatile long mLastBackupPass;
    volatile long mNextBackupPass;
    static final boolean DEBUG_BACKUP_TRACE = true;
    final List<String> mBackupTrace;
    final Object mClearDataLock;
    volatile boolean mClearingData;
    final HashMap<String, String> mTransportNames;
    final HashMap<String, IBackupTransport> mTransports;
    final ArrayList<TransportConnection> mTransportConnections;
    String mCurrentTransport;
    ActiveRestoreSession mActiveRestoreSession;
    ContentObserver mProvisionedObserver;
    static final int OP_PENDING = 0;
    static final int OP_ACKNOWLEDGED = 1;
    static final int OP_TIMEOUT = -1;
    final SparseArray<Operation> mCurrentOperations;
    final Object mCurrentOpLock;
    final Random mTokenGenerator;
    final SparseArray<FullParams> mFullConfirmations;
    File mBaseStateDir;
    File mDataDir;
    File mJournalDir;
    File mJournal;
    private final SecureRandom mRng;
    private String mPasswordHash;
    private File mPasswordHashFile;
    private byte[] mPasswordSalt;
    static final int PBKDF2_HASH_ROUNDS = 10000;
    static final int PBKDF2_KEY_SIZE = 256;
    static final int PBKDF2_SALT_SIZE = 512;
    static final String ENCRYPTION_ALGORITHM_NAME = "AES-256";
    private File mEverStored;
    HashSet<String> mEverStoredApps;
    static final int CURRENT_ANCESTRAL_RECORD_VERSION = 1;
    File mTokenFile;
    Set<String> mAncestralPackages;
    long mAncestralToken;
    long mCurrentToken;
    static final String INIT_SENTINEL_FILE_NAME = "_need_init_";
    HashSet<String> mPendingInits;
    BroadcastReceiver mBroadcastReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateToken() {
        int token;
        do {
            Random random = this.mTokenGenerator;
            synchronized (random) {
                token = this.mTokenGenerator.nextInt();
            }
        } while (token < 0);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBackupTrace(String s) {
        List<String> list = this.mBackupTrace;
        synchronized (list) {
            this.mBackupTrace.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBackupTrace() {
        List<String> list = this.mBackupTrace;
        synchronized (list) {
            this.mBackupTrace.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BackupManagerService(Context context) {
        Object salt;
        boolean areEnabled;
        block25: {
            this.mBackupParticipants = new SparseArray();
            this.mPendingBackups = new HashMap();
            this.mQueueLock = new Object();
            this.mAgentConnectLock = new Object();
            this.mBackupTrace = new ArrayList<String>();
            this.mClearDataLock = new Object();
            this.mTransportNames = new HashMap();
            this.mTransports = new HashMap();
            this.mTransportConnections = new ArrayList();
            this.mCurrentOperations = new SparseArray();
            this.mCurrentOpLock = new Object();
            this.mTokenGenerator = new Random();
            this.mFullConfirmations = new SparseArray();
            this.mRng = new SecureRandom();
            this.mEverStoredApps = new HashSet();
            this.mAncestralPackages = null;
            this.mAncestralToken = 0L;
            this.mCurrentToken = 0L;
            this.mPendingInits = new HashSet();
            this.mBroadcastReceiver = new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onReceive(Context context, Intent intent) {
                    SparseArray<HashSet<String>> sparseArray;
                    Slog.d(BackupManagerService.TAG, "Received broadcast " + intent);
                    String action = intent.getAction();
                    boolean replacing = false;
                    boolean added = false;
                    Bundle extras = intent.getExtras();
                    String[] pkgList = null;
                    if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action)) {
                        Uri uri = intent.getData();
                        if (uri == null) {
                            return;
                        }
                        String pkgName = uri.getSchemeSpecificPart();
                        if (pkgName != null) {
                            pkgList = new String[]{pkgName};
                        }
                        added = "android.intent.action.PACKAGE_ADDED".equals(action);
                        replacing = extras.getBoolean("android.intent.extra.REPLACING", false);
                    } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
                        added = true;
                        pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                        added = false;
                        pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    }
                    if (pkgList == null || pkgList.length == 0) {
                        return;
                    }
                    int uid = extras.getInt("android.intent.extra.UID");
                    if (added) {
                        sparseArray = BackupManagerService.this.mBackupParticipants;
                        synchronized (sparseArray) {
                            if (replacing) {
                                BackupManagerService.this.removePackageParticipantsLocked(pkgList, uid);
                            }
                            BackupManagerService.this.addPackageParticipantsLocked(pkgList);
                        }
                    }
                    if (!replacing) {
                        sparseArray = BackupManagerService.this.mBackupParticipants;
                        synchronized (sparseArray) {
                            BackupManagerService.this.removePackageParticipantsLocked(pkgList, uid);
                        }
                    }
                }
            };
            this.mContext = context;
            this.mPackageManager = context.getPackageManager();
            this.mPackageManagerBinder = AppGlobals.getPackageManager();
            this.mActivityManager = ActivityManagerNative.getDefault();
            this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
            this.mPowerManager = (PowerManager)context.getSystemService("power");
            this.mMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            this.mBackupManagerBinder = BackupManagerService.asInterface(this.asBinder());
            this.mHandlerThread = new HandlerThread("backup", 10);
            this.mHandlerThread.start();
            this.mBackupHandler = new BackupHandler(this.mHandlerThread.getLooper());
            ContentResolver resolver = context.getContentResolver();
            areEnabled = Settings.Secure.getInt(resolver, "backup_enabled", 0) != 0;
            this.mProvisioned = Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
            this.mAutoRestore = Settings.Secure.getInt(resolver, "backup_auto_restore", 1) != 0;
            this.mProvisionedObserver = new ProvisionedObserver(this.mBackupHandler);
            resolver.registerContentObserver(Settings.Global.getUriFor("device_provisioned"), false, this.mProvisionedObserver);
            this.mBaseStateDir = new File(Environment.getSecureDataDirectory(), "backup");
            this.mBaseStateDir.mkdirs();
            if (!SELinux.restorecon(this.mBaseStateDir)) {
                Slog.e(TAG, "SELinux restorecon failed on " + this.mBaseStateDir);
            }
            this.mDataDir = Environment.getDownloadCacheDirectory();
            this.mPasswordHashFile = new File(this.mBaseStateDir, "pwhash");
            if (this.mPasswordHashFile.exists()) {
                FileInputStream fin = null;
                FilterInputStream in = null;
                fin = new FileInputStream(this.mPasswordHashFile);
                in = new DataInputStream(new BufferedInputStream(fin));
                int saltLen = ((DataInputStream)in).readInt();
                salt = new byte[saltLen];
                ((DataInputStream)in).readFully((byte[])salt);
                this.mPasswordHash = ((DataInputStream)in).readUTF();
                this.mPasswordSalt = salt;
                Object var9_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fin != null) {
                        fin.close();
                    }
                    break block25;
                }
                catch (IOException e2) {
                    Slog.w(TAG, "Unable to close streams");
                }
                break block25;
                {
                    catch (IOException e) {
                        Slog.e(TAG, "Unable to read saved backup pw hash");
                        var9_10 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (fin != null) {
                                fin.close();
                            }
                            break block25;
                        }
                        catch (IOException e2) {
                            Slog.w(TAG, "Unable to close streams");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e2) {
                        Slog.w(TAG, "Unable to close streams");
                    }
                    throw throwable;
                }
            }
        }
        this.mRunBackupReceiver = new RunBackupReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(RUN_BACKUP_ACTION);
        context.registerReceiver(this.mRunBackupReceiver, filter, "android.permission.BACKUP", null);
        this.mRunInitReceiver = new RunInitializeReceiver();
        filter = new IntentFilter();
        filter.addAction(RUN_INITIALIZE_ACTION);
        context.registerReceiver(this.mRunInitReceiver, filter, "android.permission.BACKUP", null);
        Intent backupIntent = new Intent(RUN_BACKUP_ACTION);
        backupIntent.addFlags(0x40000000);
        this.mRunBackupIntent = PendingIntent.getBroadcast(context, 1, backupIntent, 0);
        Intent initIntent = new Intent(RUN_INITIALIZE_ACTION);
        backupIntent.addFlags(0x40000000);
        this.mRunInitIntent = PendingIntent.getBroadcast(context, 5, initIntent, 0);
        this.mJournalDir = new File(this.mBaseStateDir, "pending");
        this.mJournalDir.mkdirs();
        this.mJournal = null;
        this.initPackageTracking();
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        salt = sparseArray;
        synchronized (sparseArray) {
            this.addPackageParticipantsLocked(null);
            // ** MonitorExit[salt /* !! */ ] (shouldn't be in output)
            this.mCurrentTransport = Settings.Secure.getString(context.getContentResolver(), "backup_transport");
            if ("".equals(this.mCurrentTransport)) {
                this.mCurrentTransport = null;
            }
            Slog.v(TAG, "Starting with transport " + this.mCurrentTransport);
            Intent transportServiceIntent = new Intent(SERVICE_ACTION_TRANSPORT_HOST);
            List<ResolveInfo> hosts = this.mPackageManager.queryIntentServicesAsUser(transportServiceIntent, 0, 0);
            Slog.v(TAG, "Found transports: " + (hosts == null ? "null" : Integer.valueOf(hosts.size())));
            if (hosts != null) {
                for (int i = 0; i < hosts.size(); ++i) {
                    try {
                        ServiceInfo info = hosts.get((int)i).serviceInfo;
                        PackageInfo packInfo = this.mPackageManager.getPackageInfo(info.packageName, 0);
                        if ((packInfo.applicationInfo.flags & 0x40000000) != 0) {
                            ComponentName svcName = new ComponentName(info.packageName, info.name);
                            Slog.i(TAG, "Binding to transport host " + svcName);
                            Intent intent = new Intent(transportServiceIntent);
                            intent.setComponent(svcName);
                            TransportConnection connection = new TransportConnection();
                            this.mTransportConnections.add(connection);
                            context.bindServiceAsUser(intent, connection, 1, UserHandle.OWNER);
                            continue;
                        }
                        Slog.w(TAG, "Transport package not privileged: " + info.packageName);
                        continue;
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Problem resolving transport service: " + e.getMessage());
                    }
                }
            }
            this.parseLeftoverJournals();
            this.mWakelock = this.mPowerManager.newWakeLock(1, "*backup*");
            this.setBackupEnabled(areEnabled);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPackageTracking() {
        Slog.v(TAG, "Initializing package tracking");
        this.mTokenFile = new File(this.mBaseStateDir, "ancestral");
        try {
            RandomAccessFile tf = new RandomAccessFile(this.mTokenFile, "r");
            int version = tf.readInt();
            if (version == 1) {
                this.mAncestralToken = tf.readLong();
                this.mCurrentToken = tf.readLong();
                int numPackages = tf.readInt();
                if (numPackages >= 0) {
                    this.mAncestralPackages = new HashSet<String>();
                    for (int i = 0; i < numPackages; ++i) {
                        String pkgName = tf.readUTF();
                        this.mAncestralPackages.add(pkgName);
                    }
                }
            }
            tf.close();
        }
        catch (FileNotFoundException fnf) {
            Slog.v(TAG, "No ancestral data");
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to read token file", e);
        }
        this.mEverStored = new File(this.mBaseStateDir, "processed");
        File tempProcessedFile = new File(this.mBaseStateDir, "processed.new");
        if (tempProcessedFile.exists()) {
            tempProcessedFile.delete();
        }
        if (this.mEverStored.exists()) {
            RandomAccessFile temp = null;
            RandomAccessFile in = null;
            try {
                try {
                    temp = new RandomAccessFile(tempProcessedFile, "rws");
                    in = new RandomAccessFile(this.mEverStored, "r");
                    while (true) {
                        String pkg = in.readUTF();
                        try {
                            PackageInfo info = this.mPackageManager.getPackageInfo(pkg, 0);
                            this.mEverStoredApps.add(pkg);
                            temp.writeUTF(pkg);
                        }
                        catch (PackageManager.NameNotFoundException e) {}
                    }
                }
                catch (EOFException e) {
                    if (!tempProcessedFile.renameTo(this.mEverStored)) {
                        Slog.e(TAG, "Error renaming " + tempProcessedFile + " to " + this.mEverStored);
                    }
                    Object var8_16 = null;
                    try {
                        if (temp != null) {
                            temp.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {}
                }
                catch (IOException e) {
                    Slog.e(TAG, "Error in processed file", e);
                    Object var8_17 = null;
                    try {
                        if (temp != null) {
                            temp.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_18 = null;
                try {
                    if (temp != null) {
                        temp.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mBroadcastReceiver, sdFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLeftoverJournals() {
        for (File f : this.mJournalDir.listFiles()) {
            IOException e3;
            Object var8_9;
            if (this.mJournal != null && f.compareTo(this.mJournal) == 0) continue;
            RandomAccessFile in = null;
            try {
                try {
                    Slog.i(TAG, "Found stale backup journal, scheduling");
                    in = new RandomAccessFile(f, "r");
                    while (true) {
                        String packageName = in.readUTF();
                        Slog.i(TAG, "  " + packageName);
                        this.dataChangedImpl(packageName);
                    }
                }
                catch (EOFException e2) {
                    var8_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    f.delete();
                }
                catch (Exception e4) {
                    Slog.e(TAG, "Can't read " + f, e4);
                    var8_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    f.delete();
                }
            }
            catch (Throwable throwable) {
                var8_9 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e3) {
                    // empty catch block
                }
                f.delete();
                throw throwable;
            }
        }
    }

    private SecretKey buildPasswordKey(String pw, byte[] salt, int rounds) {
        return this.buildCharArrayKey(pw.toCharArray(), salt, rounds);
    }

    private SecretKey buildCharArrayKey(char[] pwArray, byte[] salt, int rounds) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec ks = new PBEKeySpec(pwArray, salt, rounds, 256);
            return keyFactory.generateSecret(ks);
        }
        catch (InvalidKeySpecException e) {
            Slog.e(TAG, "Invalid key spec for PBKDF2!");
        }
        catch (NoSuchAlgorithmException e) {
            Slog.e(TAG, "PBKDF2 unavailable!");
        }
        return null;
    }

    private String buildPasswordHash(String pw, byte[] salt, int rounds) {
        SecretKey key = this.buildPasswordKey(pw, salt, rounds);
        if (key != null) {
            return this.byteArrayToHex(key.getEncoded());
        }
        return null;
    }

    private String byteArrayToHex(byte[] data) {
        StringBuilder buf = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            buf.append(Byte.toHexString(data[i], true));
        }
        return buf.toString();
    }

    private byte[] hexToByteArray(String digits) {
        int bytes = digits.length() / 2;
        if (2 * bytes != digits.length()) {
            throw new IllegalArgumentException("Hex string must have an even number of digits");
        }
        byte[] result = new byte[bytes];
        for (int i = 0; i < digits.length(); i += 2) {
            result[i / 2] = (byte)Integer.parseInt(digits.substring(i, i + 2), 16);
        }
        return result;
    }

    private byte[] makeKeyChecksum(byte[] pwBytes, byte[] salt, int rounds) {
        char[] mkAsChar = new char[pwBytes.length];
        for (int i = 0; i < pwBytes.length; ++i) {
            mkAsChar[i] = (char)pwBytes[i];
        }
        SecretKey checksum = this.buildCharArrayKey(mkAsChar, salt, rounds);
        return checksum.getEncoded();
    }

    private byte[] randomBytes(int bits) {
        byte[] array2 = new byte[bits / 8];
        this.mRng.nextBytes(array2);
        return array2;
    }

    boolean passwordMatchesSaved(String candidatePw, int rounds) {
        String currentPwHash;
        try {
            boolean isEncrypted;
            boolean bl = isEncrypted = this.mMountService.getEncryptionState() != 1;
            if (isEncrypted) {
                Slog.i(TAG, "Device encrypted; verifying against device data pw");
                int result = this.mMountService.verifyEncryptionPassword(candidatePw);
                if (result == 0) {
                    return true;
                }
                if (result != -2) {
                    return false;
                }
                Slog.e(TAG, "verified encryption state mismatch against query; no match allowed");
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return this.mPasswordHash == null ? candidatePw == null || "".equals(candidatePw) : candidatePw != null && candidatePw.length() > 0 && this.mPasswordHash.equalsIgnoreCase(currentPwHash = this.buildPasswordHash(candidatePw, this.mPasswordSalt, rounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setBackupPassword(String currentPw, String newPw) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupPassword");
        if (!this.passwordMatchesSaved(currentPw, 10000)) {
            return false;
        }
        if (newPw == null || newPw.isEmpty()) {
            if (this.mPasswordHashFile.exists() && !this.mPasswordHashFile.delete()) {
                Slog.e(TAG, "Unable to clear backup password");
                return false;
            }
            this.mPasswordHash = null;
            this.mPasswordSalt = null;
            return true;
        }
        try {
            boolean bl;
            BufferedOutputStream buffer;
            FileOutputStream pwf;
            block12: {
                byte[] salt = this.randomBytes(512);
                String newPwHash = this.buildPasswordHash(newPw, salt, 10000);
                pwf = null;
                buffer = null;
                FilterOutputStream out = null;
                try {
                    pwf = new FileOutputStream(this.mPasswordHashFile);
                    buffer = new BufferedOutputStream(pwf);
                    out = new DataOutputStream(buffer);
                    ((DataOutputStream)out).writeInt(salt.length);
                    out.write(salt);
                    ((DataOutputStream)out).writeUTF(newPwHash);
                    ((DataOutputStream)out).flush();
                    this.mPasswordHash = newPwHash;
                    this.mPasswordSalt = salt;
                    bl = true;
                    Object var10_10 = null;
                    if (out == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (out != null) {
                        out.close();
                    }
                    if (buffer != null) {
                        ((OutputStream)buffer).close();
                    }
                    if (pwf != null) {
                        ((OutputStream)pwf).close();
                    }
                    throw throwable;
                }
                out.close();
            }
            if (buffer != null) {
                ((OutputStream)buffer).close();
            }
            if (pwf != null) {
                ((OutputStream)pwf).close();
            }
            return bl;
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to set backup password");
            return false;
        }
    }

    @Override
    public boolean hasBackupPassword() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "hasBackupPassword");
        try {
            return this.mMountService.getEncryptionState() != 1 || this.mPasswordHash != null && this.mPasswordHash.length() > 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    void recordInitPendingLocked(boolean isPending, String transportName) {
        Slog.i(TAG, "recordInitPendingLocked: " + isPending + " on transport " + transportName);
        try {
            IBackupTransport transport = this.getTransport(transportName);
            String transportDirName = transport.transportDirName();
            File stateDir = new File(this.mBaseStateDir, transportDirName);
            File initPendingFile = new File(stateDir, INIT_SENTINEL_FILE_NAME);
            if (isPending) {
                this.mPendingInits.add(transportName);
                try {
                    new FileOutputStream(initPendingFile).close();
                }
                catch (IOException ioe) {}
            } else {
                initPendingFile.delete();
                this.mPendingInits.remove(transportName);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBackupState(File stateFileDir) {
        SparseArray<HashSet<String>> sparseArray = this.mQueueLock;
        synchronized (sparseArray) {
            this.mEverStoredApps.clear();
            this.mEverStored.delete();
            this.mCurrentToken = 0L;
            this.writeRestoreTokens();
            for (File sf : stateFileDir.listFiles()) {
                if (sf.getName().equals(INIT_SENTINEL_FILE_NAME)) continue;
                sf.delete();
            }
        }
        sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            int N = this.mBackupParticipants.size();
            for (int i = 0; i < N; ++i) {
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                if (participants == null) continue;
                for (String packageName : participants) {
                    this.dataChangedImpl(packageName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTransport(String name, String component, IBackupTransport transport) {
        block9: {
            HashMap<String, IBackupTransport> hashMap = this.mTransports;
            synchronized (hashMap) {
                Slog.v(TAG, "Registering transport " + component + "::" + name + " = " + transport);
                if (transport == null) {
                    this.mTransports.remove(this.mTransportNames.get(component));
                    this.mTransportNames.remove(component);
                    return;
                }
                this.mTransports.put(name, transport);
                this.mTransportNames.put(component, name);
            }
            try {
                String transportName = transport.transportDirName();
                File stateDir = new File(this.mBaseStateDir, transportName);
                stateDir.mkdirs();
                File initSentinel = new File(stateDir, INIT_SENTINEL_FILE_NAME);
                if (!initSentinel.exists()) break block9;
                Object object = this.mQueueLock;
                synchronized (object) {
                    this.mPendingInits.add(transportName);
                    long delay = 60000L;
                    this.mAlarmManager.set(0, System.currentTimeMillis() + delay, this.mRunInitIntent);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    void addPackageParticipantsLocked(String[] packageNames) {
        List<PackageInfo> targetApps = this.allAgentPackages();
        if (packageNames != null) {
            Slog.v(TAG, "addPackageParticipantsLocked: #" + packageNames.length);
            for (String packageName : packageNames) {
                this.addPackageParticipantsLockedInner(packageName, targetApps);
            }
        } else {
            Slog.v(TAG, "addPackageParticipantsLocked: all");
            this.addPackageParticipantsLockedInner(null, targetApps);
        }
    }

    private void addPackageParticipantsLockedInner(String packageName, List<PackageInfo> targetPkgs) {
        for (PackageInfo pkg : targetPkgs) {
            if (packageName != null && !pkg.packageName.equals(packageName)) continue;
            int uid = pkg.applicationInfo.uid;
            HashSet<String> set = this.mBackupParticipants.get(uid);
            if (set == null) {
                set = new HashSet();
                this.mBackupParticipants.put(uid, set);
            }
            set.add(pkg.packageName);
            Slog.i(TAG, "Scheduling backup for new app " + pkg.packageName);
            this.dataChangedImpl(pkg.packageName);
        }
    }

    void removePackageParticipantsLocked(String[] packageNames, int oldUid) {
        if (packageNames == null) {
            Slog.w(TAG, "removePackageParticipants with null list");
            return;
        }
        Slog.v(TAG, "removePackageParticipantsLocked: uid=" + oldUid + " #" + packageNames.length);
        for (String pkg : packageNames) {
            HashSet<String> set = this.mBackupParticipants.get(oldUid);
            if (set == null || !set.contains(pkg)) continue;
            this.removePackageFromSetLocked(set, pkg);
            if (!set.isEmpty()) continue;
            this.mBackupParticipants.remove(oldUid);
        }
    }

    private void removePackageFromSetLocked(HashSet<String> set, String packageName) {
        if (set.contains(packageName)) {
            set.remove(packageName);
            this.mPendingBackups.remove(packageName);
        }
    }

    List<PackageInfo> allAgentPackages() {
        int flags = 64;
        List<PackageInfo> packages = this.mPackageManager.getInstalledPackages(flags);
        int N = packages.size();
        for (int a = N - 1; a >= 0; --a) {
            PackageInfo pkg = packages.get(a);
            try {
                ApplicationInfo app = pkg.applicationInfo;
                if ((app.flags & 0x8000) == 0 || app.backupAgentName == null) {
                    packages.remove(a);
                    continue;
                }
                app = this.mPackageManager.getApplicationInfo(pkg.packageName, 1024);
                pkg.applicationInfo.sharedLibraryFiles = app.sharedLibraryFiles;
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                packages.remove(a);
            }
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void logBackupComplete(String packageName) {
        if (packageName.equals(PACKAGE_MANAGER_SENTINEL)) {
            return;
        }
        HashSet<String> hashSet = this.mEverStoredApps;
        synchronized (hashSet) {
            block16: {
                if (!this.mEverStoredApps.add(packageName)) {
                    return;
                }
                RandomAccessFile out = null;
                out = new RandomAccessFile(this.mEverStored, "rws");
                out.seek(out.length());
                out.writeUTF(packageName);
                Object var6_4 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                    break block16;
                }
                catch (IOException e2) {}
                break block16;
                {
                    catch (IOException e) {
                        Slog.e(TAG, "Can't log backup of " + packageName + " to " + this.mEverStored);
                        Object var6_5 = null;
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block16;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void removeEverBackedUp(String packageName) {
        Slog.v(TAG, "Removing backed-up knowledge of " + packageName);
        HashSet<String> hashSet = this.mEverStoredApps;
        synchronized (hashSet) {
            block16: {
                File tempKnownFile = new File(this.mBaseStateDir, "processed.new");
                RandomAccessFile known = null;
                known = new RandomAccessFile(tempKnownFile, "rws");
                this.mEverStoredApps.remove(packageName);
                for (String s : this.mEverStoredApps) {
                    known.writeUTF(s);
                }
                known.close();
                known = null;
                if (!tempKnownFile.renameTo(this.mEverStored)) {
                    throw new IOException("Can't rename " + tempKnownFile + " to " + this.mEverStored);
                }
                Object var8_8 = null;
                try {
                    if (known != null) {
                        known.close();
                    }
                    break block16;
                }
                catch (IOException e2) {}
                break block16;
                {
                    catch (IOException e) {
                        Slog.w(TAG, "Error rewriting " + this.mEverStored, e);
                        this.mEverStoredApps.clear();
                        tempKnownFile.delete();
                        this.mEverStored.delete();
                        Object var8_9 = null;
                        try {
                            if (known != null) {
                                known.close();
                            }
                            break block16;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (known != null) {
                            known.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    void writeRestoreTokens() {
        try {
            RandomAccessFile af = new RandomAccessFile(this.mTokenFile, "rwd");
            af.writeInt(1);
            af.writeLong(this.mAncestralToken);
            af.writeLong(this.mCurrentToken);
            if (this.mAncestralPackages == null) {
                af.writeInt(-1);
            } else {
                af.writeInt(this.mAncestralPackages.size());
                Slog.v(TAG, "Ancestral packages:  " + this.mAncestralPackages.size());
                for (String pkgName : this.mAncestralPackages) {
                    af.writeUTF(pkgName);
                }
            }
            af.close();
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to write token file:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBackupTransport getTransport(String transportName) {
        HashMap<String, IBackupTransport> hashMap = this.mTransports;
        synchronized (hashMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport == null) {
                Slog.w(TAG, "Requested unavailable transport: " + transportName);
            }
            return transport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBackupAgent bindToAgentSynchronous(ApplicationInfo app, int mode) {
        IBackupAgent agent = null;
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            this.mConnecting = true;
            this.mConnectedAgent = null;
            try {
                if (this.mActivityManager.bindBackupAgent(app, mode)) {
                    Slog.d(TAG, "awaiting agent for " + app);
                    long timeoutMark = System.currentTimeMillis() + 10000L;
                    while (this.mConnecting && this.mConnectedAgent == null && System.currentTimeMillis() < timeoutMark) {
                        try {
                            this.mAgentConnectLock.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            Slog.w(TAG, "Interrupted: " + e);
                            this.mActivityManager.clearPendingBackup();
                            return null;
                        }
                    }
                    if (this.mConnecting) {
                        Slog.w(TAG, "Timeout waiting for agent " + app);
                        this.mActivityManager.clearPendingBackup();
                        return null;
                    }
                    Slog.i(TAG, "got agent " + this.mConnectedAgent);
                    agent = this.mConnectedAgent;
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearApplicationDataSynchronous(String packageName) {
        try {
            PackageInfo info = this.mPackageManager.getPackageInfo(packageName, 0);
            if ((info.applicationInfo.flags & 0x40) == 0) {
                return;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Tried to clear data for " + packageName + " but not found");
            return;
        }
        ClearDataObserver observer = new ClearDataObserver();
        Object object = this.mClearDataLock;
        synchronized (object) {
            this.mClearingData = true;
            try {
                this.mActivityManager.clearApplicationUserData(packageName, observer, 0);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            long timeoutMark = System.currentTimeMillis() + 10000L;
            while (this.mClearingData && System.currentTimeMillis() < timeoutMark) {
                try {
                    this.mClearDataLock.wait(5000L);
                }
                catch (InterruptedException e) {
                    this.mClearingData = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getAvailableRestoreToken(String packageName) {
        long token = this.mAncestralToken;
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mEverStoredApps.contains(packageName)) {
                token = this.mCurrentToken;
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareOperationTimeout(int token, long interval, BackupRestoreTask callback) {
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            this.mCurrentOperations.put(token, new Operation(0, callback));
            Message msg = this.mBackupHandler.obtainMessage(7, token, 0, callback);
            this.mBackupHandler.sendMessageDelayed(msg, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitUntilOperationComplete(int token) {
        int finalState = 0;
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            while ((op = this.mCurrentOperations.get(token)) != null) {
                if (op.state == 0) {
                    try {
                        this.mCurrentOpLock.wait();
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                finalState = op.state;
                break;
            }
        }
        this.mBackupHandler.removeMessages(7);
        return finalState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTimeout(int token, Object obj) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            int state;
            op = this.mCurrentOperations.get(token);
            int n = state = op != null ? op.state : -1;
            if (state == 0) {
                Slog.v(TAG, "TIMEOUT: token=" + Integer.toHexString(token));
                op.state = -1;
                this.mCurrentOperations.put(token, op);
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            op.callback.handleTimeout();
        }
    }

    private void routeSocketDataToOutput(ParcelFileDescriptor inPipe, OutputStream out) throws IOException {
        int chunkTotal;
        FileInputStream raw2 = new FileInputStream(inPipe.getFileDescriptor());
        DataInputStream in = new DataInputStream(raw2);
        byte[] buffer = new byte[32768];
        while ((chunkTotal = in.readInt()) > 0) {
            while (chunkTotal > 0) {
                int toRead = chunkTotal > buffer.length ? buffer.length : chunkTotal;
                int nRead = in.read(buffer, 0, toRead);
                out.write(buffer, 0, nRead);
                chunkTotal -= nRead;
            }
        }
    }

    private boolean signaturesMatch(Signature[] storedSigs, PackageInfo target) {
        if ((target.applicationInfo.flags & 1) != 0) {
            Slog.v(TAG, "System app " + target.packageName + " - skipping sig check");
            return true;
        }
        Signature[] deviceSigs = target.signatures;
        if (!(storedSigs != null && storedSigs.length != 0 || deviceSigs != null && deviceSigs.length != 0)) {
            return true;
        }
        if (storedSigs == null || deviceSigs == null) {
            return false;
        }
        int nStored = storedSigs.length;
        int nDevice = deviceSigs.length;
        for (int i = 0; i < nStored; ++i) {
            boolean match = false;
            for (int j = 0; j < nDevice; ++j) {
                if (!storedSigs[i].equals(deviceSigs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private void dataChangedImpl(String packageName) {
        HashSet<String> targets = this.dataChangedTargets(packageName);
        this.dataChangedImpl(packageName, targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataChangedImpl(String packageName, HashSet<String> targets) {
        EventLog.writeEvent(2820, packageName);
        if (targets == null) {
            Slog.w(TAG, "dataChanged but no participant pkg='" + packageName + "'" + " uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mQueueLock;
        synchronized (object) {
            BackupRequest req;
            if (targets.contains(packageName) && this.mPendingBackups.put(packageName, req = new BackupRequest(packageName)) == null) {
                Slog.d(TAG, "Now staging backup of " + packageName);
                this.writeToJournalLocked(packageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> dataChangedTargets(String packageName) {
        if (this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1) {
            SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
            synchronized (sparseArray) {
                return this.mBackupParticipants.get(Binder.getCallingUid());
            }
        }
        HashSet<String> targets = new HashSet<String>();
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            int N = this.mBackupParticipants.size();
            for (int i = 0; i < N; ++i) {
                HashSet<String> s = this.mBackupParticipants.valueAt(i);
                if (s == null) continue;
                targets.addAll(s);
            }
        }
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeToJournalLocked(String str) {
        block12: {
            RandomAccessFile out = null;
            if (this.mJournal == null) {
                this.mJournal = File.createTempFile("journal", null, this.mJournalDir);
            }
            out = new RandomAccessFile(this.mJournal, "rws");
            out.seek(out.length());
            out.writeUTF(str);
            Object var5_3 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block12;
            }
            catch (IOException e2) {}
            break block12;
            {
                catch (IOException e) {
                    Slog.e(TAG, "Can't write " + str + " to backup journal", e);
                    this.mJournal = null;
                    Object var5_4 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block12;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    @Override
    public void dataChanged(final String packageName) {
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            return;
        }
        final HashSet<String> targets = this.dataChangedTargets(packageName);
        if (targets == null) {
            Slog.w(TAG, "dataChanged but no participant pkg='" + packageName + "'" + " uid=" + Binder.getCallingUid());
            return;
        }
        this.mBackupHandler.post(new Runnable(){

            public void run() {
                BackupManagerService.this.dataChangedImpl(packageName, targets);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackupData(String packageName) {
        HashSet<String> apps;
        PackageInfo info;
        Slog.v(TAG, "clearBackupData() of " + packageName);
        try {
            info = this.mPackageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.d(TAG, "No such package '" + packageName + "' - not clearing backup data");
            return;
        }
        if (this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1) {
            apps = this.mBackupParticipants.get(Binder.getCallingUid());
        } else {
            Slog.v(TAG, "Privileged caller, allowing clear of other apps");
            apps = new HashSet();
            int N = this.mBackupParticipants.size();
            for (int i = 0; i < N; ++i) {
                HashSet<String> s = this.mBackupParticipants.valueAt(i);
                if (s == null) continue;
                apps.addAll(s);
            }
        }
        if (apps.contains(packageName)) {
            Slog.v(TAG, "Found the app - running clear process");
            Object object = this.mQueueLock;
            synchronized (object) {
                long oldId = Binder.clearCallingIdentity();
                this.mWakelock.acquire();
                Message msg = this.mBackupHandler.obtainMessage(4, new ClearParams(this.getTransport(this.mCurrentTransport), info));
                this.mBackupHandler.sendMessage(msg);
                Binder.restoreCallingIdentity(oldId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupNow() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "backupNow");
        Slog.v(TAG, "Scheduling immediate backup pass");
        Object object = this.mQueueLock;
        synchronized (object) {
            this.startBackupAlarmsLocked(3600000L);
            try {
                this.mRunBackupIntent.send();
            }
            catch (PendingIntent.CanceledException e) {
                Slog.e(TAG, "run-backup intent cancelled!");
            }
        }
    }

    boolean deviceIsProvisioned() {
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fullBackup(ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doAllApps, boolean includeSystem, String[] pkgList) {
        block20: {
            block16: {
                block19: {
                    block15: {
                        block18: {
                            block14: {
                                this.mContext.enforceCallingPermission("android.permission.BACKUP", "fullBackup");
                                callingUserHandle = UserHandle.getCallingUserId();
                                if (callingUserHandle != 0) {
                                    throw new IllegalStateException("Backup supported only for the device owner");
                                }
                                if (!doAllApps && !includeShared) {
                                    if (pkgList == null) throw new IllegalArgumentException("Backup requested but neither shared nor any apps named");
                                    if (pkgList.length == 0) {
                                        throw new IllegalArgumentException("Backup requested but neither shared nor any apps named");
                                    }
                                }
                                oldId = Binder.clearCallingIdentity();
                                try {
                                    if (!this.deviceIsProvisioned()) {
                                        Slog.i("BackupManagerService", "Full backup not supported before setup");
                                        var16_10 = null;
                                        break block14;
                                    }
                                    Slog.v("BackupManagerService", "Requesting full backup: apks=" + includeApks + " obb=" + includeObbs + " shared=" + includeShared + " all=" + doAllApps + " pkgs=" + pkgList);
                                    Slog.i("BackupManagerService", "Beginning full backup...");
                                    params = new FullBackupParams(fd, includeApks, includeObbs, includeShared, doAllApps, includeSystem, pkgList);
                                    token = this.generateToken();
                                    var13_20 = this.mFullConfirmations;
                                    synchronized (var13_20) {
                                        this.mFullConfirmations.put(token, params);
                                    }
                                    Slog.d("BackupManagerService", "Starting backup confirmation UI, token=" + token);
                                    if (!this.startConfirmationUi(token, "fullback")) {
                                        Slog.e("BackupManagerService", "Unable to launch full backup confirmation");
                                        this.mFullConfirmations.delete(token);
                                        break block15;
                                    }
                                    this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
                                    this.startConfirmationTimeout(token, params);
                                    Slog.d("BackupManagerService", "Waiting for full backup completion...");
                                    this.waitForCompletion(params);
                                    break block16;
                                }
                                catch (Throwable var15_21) {
                                    var16_13 = null;
                                    try {
                                        fd.close();
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    Binder.restoreCallingIdentity(oldId);
                                    Slog.d("BackupManagerService", "Full backup processing complete.");
                                    throw var15_21;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [6 : 339->346)] { 
lbl56:
                            // 1 sources

                            fd.close();
                            break block18;
lbl58:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        Binder.restoreCallingIdentity(oldId);
                        Slog.d("BackupManagerService", "Full backup processing complete.");
                        return;
                    }
                    var16_11 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 339->346)] { 
lbl68:
                    // 1 sources

                    fd.close();
                    break block19;
lbl70:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                }
                Binder.restoreCallingIdentity(oldId);
                Slog.d("BackupManagerService", "Full backup processing complete.");
                return;
            }
            var16_12 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 339->346)] { 
lbl80:
            // 1 sources

            fd.close();
            break block20;
lbl82:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        Binder.restoreCallingIdentity(oldId);
        Slog.d("BackupManagerService", "Full backup processing complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fullRestore(ParcelFileDescriptor fd) {
        block18: {
            block14: {
                block17: {
                    block13: {
                        block16: {
                            block12: {
                                this.mContext.enforceCallingPermission("android.permission.BACKUP", "fullRestore");
                                callingUserHandle = UserHandle.getCallingUserId();
                                if (callingUserHandle != 0) {
                                    throw new IllegalStateException("Restore supported only for the device owner");
                                }
                                oldId = Binder.clearCallingIdentity();
                                try {
                                    if (!this.deviceIsProvisioned()) {
                                        Slog.i("BackupManagerService", "Full restore not permitted before setup");
                                        var10_4 = null;
                                        break block12;
                                    }
                                    Slog.i("BackupManagerService", "Beginning full restore...");
                                    params = new FullRestoreParams(fd);
                                    token = this.generateToken();
                                    var7_14 = this.mFullConfirmations;
                                    synchronized (var7_14) {
                                        this.mFullConfirmations.put(token, params);
                                    }
                                    Slog.d("BackupManagerService", "Starting restore confirmation UI, token=" + token);
                                    if (!this.startConfirmationUi(token, "fullrest")) {
                                        Slog.e("BackupManagerService", "Unable to launch full restore confirmation");
                                        this.mFullConfirmations.delete(token);
                                        break block13;
                                    }
                                    this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
                                    this.startConfirmationTimeout(token, params);
                                    Slog.d("BackupManagerService", "Waiting for full restore completion...");
                                    this.waitForCompletion(params);
                                    break block14;
                                }
                                catch (Throwable var9_15) {
                                    var10_7 = null;
                                    try {
                                        fd.close();
                                    }
                                    catch (IOException e) {
                                        Slog.w("BackupManagerService", "Error trying to close fd after full restore: " + e);
                                    }
                                    Binder.restoreCallingIdentity(oldId);
                                    Slog.i("BackupManagerService", "Full restore processing complete.");
                                    throw var9_15;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [6 : 225->232)] { 
lbl51:
                            // 1 sources

                            fd.close();
                            break block16;
lbl53:
                            // 1 sources

                            catch (IOException e) {
                                Slog.w("BackupManagerService", "Error trying to close fd after full restore: " + e);
                            }
                        }
                        Binder.restoreCallingIdentity(oldId);
                        Slog.i("BackupManagerService", "Full restore processing complete.");
                        return;
                    }
                    var10_5 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 225->232)] { 
lbl64:
                    // 1 sources

                    fd.close();
                    break block17;
lbl66:
                    // 1 sources

                    catch (IOException e) {
                        Slog.w("BackupManagerService", "Error trying to close fd after full restore: " + e);
                    }
                }
                Binder.restoreCallingIdentity(oldId);
                Slog.i("BackupManagerService", "Full restore processing complete.");
                return;
            }
            var10_6 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 225->232)] { 
lbl77:
            // 1 sources

            fd.close();
            break block18;
lbl79:
            // 1 sources

            catch (IOException e) {
                Slog.w("BackupManagerService", "Error trying to close fd after full restore: " + e);
            }
        }
        Binder.restoreCallingIdentity(oldId);
        Slog.i("BackupManagerService", "Full restore processing complete.");
    }

    boolean startConfirmationUi(int token, String action) {
        try {
            Intent confIntent = new Intent(action);
            confIntent.setClassName("com.android.backupconfirm", "com.android.backupconfirm.BackupRestoreConfirmation");
            confIntent.putExtra("conftoken", token);
            confIntent.addFlags(0x10000000);
            this.mContext.startActivity(confIntent);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    void startConfirmationTimeout(int token, FullParams params) {
        Message msg = this.mBackupHandler.obtainMessage(9, token, 0, params);
        this.mBackupHandler.sendMessageDelayed(msg, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion(FullParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            while (!params.latch.get()) {
                try {
                    params.latch.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalFullBackupRestoreCompletion(FullParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            params.latch.set(true);
            params.latch.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encPpassword, IFullBackupRestoreObserver observer) {
        Slog.d(TAG, "acknowledgeFullBackupOrRestore : token=" + token + " allow=" + allow);
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "acknowledgeFullBackupOrRestore");
        long oldId = Binder.clearCallingIdentity();
        try {
            SparseArray<FullParams> sparseArray = this.mFullConfirmations;
            synchronized (sparseArray) {
                FullParams params = this.mFullConfirmations.get(token);
                if (params != null) {
                    this.mBackupHandler.removeMessages(9, params);
                    this.mFullConfirmations.delete(token);
                    if (allow) {
                        boolean isEncrypted;
                        int verb = params instanceof FullBackupParams ? 2 : 10;
                        params.observer = observer;
                        params.curPassword = curPassword;
                        try {
                            boolean bl = isEncrypted = this.mMountService.getEncryptionState() != 1;
                            if (isEncrypted) {
                                Slog.w(TAG, "Device is encrypted; forcing enc password");
                            }
                        }
                        catch (RemoteException e) {
                            Slog.e(TAG, "Unable to contact mount service!");
                            isEncrypted = true;
                        }
                        params.encryptPassword = isEncrypted ? curPassword : encPpassword;
                        Slog.d(TAG, "Sending conf message with verb " + verb);
                        this.mWakelock.acquire();
                        Message msg = this.mBackupHandler.obtainMessage(verb, params);
                        this.mBackupHandler.sendMessage(msg);
                    } else {
                        Slog.w(TAG, "User rejected full backup/restore operation");
                        this.signalFullBackupRestoreCompletion(params);
                    }
                } else {
                    Slog.w(TAG, "Attempted to ack full backup/restore with invalid token");
                }
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            Binder.restoreCallingIdentity(oldId);
            throw throwable;
        }
        Binder.restoreCallingIdentity(oldId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackupEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupEnabled");
        Slog.i(TAG, "Backup enabled => " + enable);
        long oldId = Binder.clearCallingIdentity();
        try {
            boolean wasEnabled = this.mEnabled;
            Object object = this;
            synchronized (object) {
                Settings.Secure.putInt(this.mContext.getContentResolver(), "backup_enabled", enable ? 1 : 0);
                this.mEnabled = enable;
            }
            object = this.mQueueLock;
            synchronized (object) {
                if (enable && !wasEnabled && this.mProvisioned) {
                    this.startBackupAlarmsLocked(3600000L);
                } else if (!enable) {
                    Slog.i(TAG, "Opting out of backup");
                    this.mAlarmManager.cancel(this.mRunBackupIntent);
                    if (wasEnabled && this.mProvisioned) {
                        HashSet<String> allTransports;
                        HashMap<String, IBackupTransport> hashMap = this.mTransports;
                        synchronized (hashMap) {
                            allTransports = new HashSet<String>(this.mTransports.keySet());
                        }
                        for (String transport : allTransports) {
                            this.recordInitPendingLocked(true, transport);
                        }
                        this.mAlarmManager.set(0, System.currentTimeMillis(), this.mRunInitIntent);
                    }
                }
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Binder.restoreCallingIdentity(oldId);
            throw throwable;
        }
        Binder.restoreCallingIdentity(oldId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoRestore(boolean doAutoRestore) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setAutoRestore");
        Slog.i(TAG, "Auto restore => " + doAutoRestore);
        BackupManagerService backupManagerService = this;
        synchronized (backupManagerService) {
            Settings.Secure.putInt(this.mContext.getContentResolver(), "backup_auto_restore", doAutoRestore ? 1 : 0);
            this.mAutoRestore = doAutoRestore;
        }
    }

    @Override
    public void setBackupProvisioned(boolean available) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupProvisioned");
    }

    private void startBackupAlarmsLocked(long delayBeforeFirstBackup) {
        Random random = new Random();
        long when = System.currentTimeMillis() + delayBeforeFirstBackup + (long)random.nextInt(300000);
        this.mAlarmManager.setRepeating(0, when, 3600000L + (long)random.nextInt(300000), this.mRunBackupIntent);
        this.mNextBackupPass = when;
    }

    @Override
    public boolean isBackupEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "isBackupEnabled");
        return this.mEnabled;
    }

    @Override
    public String getCurrentTransport() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getCurrentTransport");
        return this.mCurrentTransport;
    }

    @Override
    public String[] listAllTransports() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "listAllTransports");
        String[] list = null;
        ArrayList<String> known = new ArrayList<String>();
        for (Map.Entry<String, IBackupTransport> entry : this.mTransports.entrySet()) {
            if (entry.getValue() == null) continue;
            known.add(entry.getKey());
        }
        if (known.size() > 0) {
            list = new String[known.size()];
            known.toArray(list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String selectBackupTransport(String transport) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "selectBackupTransport");
        HashMap<String, IBackupTransport> hashMap = this.mTransports;
        synchronized (hashMap) {
            String prevTransport = null;
            if (this.mTransports.get(transport) != null) {
                prevTransport = this.mCurrentTransport;
                this.mCurrentTransport = transport;
                Settings.Secure.putString(this.mContext.getContentResolver(), "backup_transport", transport);
                Slog.v(TAG, "selectBackupTransport() set " + this.mCurrentTransport + " returning " + prevTransport);
            } else {
                Slog.w(TAG, "Attempt to select unavailable transport " + transport);
            }
            return prevTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent getConfigurationIntent(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getConfigurationIntent");
        HashMap<String, IBackupTransport> hashMap = this.mTransports;
        synchronized (hashMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport != null) {
                try {
                    Intent intent = transport.configurationIntent();
                    return intent;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDestinationString(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDestinationString");
        HashMap<String, IBackupTransport> hashMap = this.mTransports;
        synchronized (hashMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport != null) {
                try {
                    String text = transport.currentDestinationString();
                    return text;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentConnected(String packageName, IBinder agentBinder) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                IBackupAgent agent;
                Slog.d(TAG, "agentConnected pkg=" + packageName + " agent=" + agentBinder);
                this.mConnectedAgent = agent = IBackupAgent.Stub.asInterface(agentBinder);
                this.mConnecting = false;
            } else {
                Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " claiming agent connected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentDisconnected(String packageName) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                this.mConnectedAgent = null;
                this.mConnecting = false;
            } else {
                Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " claiming agent disconnected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    @Override
    public void restoreAtInstall(String packageName, int token) {
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " attemping install-time restore");
            return;
        }
        long restoreSet = this.getAvailableRestoreToken(packageName);
        Slog.v(TAG, "restoreAtInstall pkg=" + packageName + " token=" + Integer.toHexString(token) + " restoreSet=" + Long.toHexString(restoreSet));
        if (this.mAutoRestore && this.mProvisioned && restoreSet != 0L) {
            PackageInfo pkg = new PackageInfo();
            pkg.packageName = packageName;
            this.mWakelock.acquire();
            Message msg = this.mBackupHandler.obtainMessage(3);
            msg.obj = new RestoreParams(this.getTransport(this.mCurrentTransport), null, restoreSet, pkg, token, true);
            this.mBackupHandler.sendMessage(msg);
        } else {
            Slog.v(TAG, "No restore set -- skipping restore");
            try {
                this.mPackageManagerBinder.finishPackageInstall(token);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRestoreSession beginRestoreSession(String packageName, String transport) {
        Slog.v(TAG, "beginRestoreSession: pkg=" + packageName + " transport=" + transport);
        boolean needPermission = true;
        if (transport == null) {
            transport = this.mCurrentTransport;
            if (packageName != null) {
                PackageInfo app = null;
                try {
                    app = this.mPackageManager.getPackageInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException nnf) {
                    Slog.w(TAG, "Asked to restore nonexistent pkg " + packageName);
                    throw new IllegalArgumentException("Package " + packageName + " not found");
                }
                if (app.applicationInfo.uid == Binder.getCallingUid()) {
                    needPermission = false;
                }
            }
        }
        if (needPermission) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "beginRestoreSession");
        } else {
            Slog.d(TAG, "restoring self on current transport; no permission needed");
        }
        BackupManagerService backupManagerService = this;
        synchronized (backupManagerService) {
            if (this.mActiveRestoreSession != null) {
                Slog.d(TAG, "Restore session requested but one already active");
                return null;
            }
            this.mActiveRestoreSession = new ActiveRestoreSession(packageName, transport);
            this.mBackupHandler.sendEmptyMessageDelayed(8, 60000L);
        }
        return this.mActiveRestoreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRestoreSession(ActiveRestoreSession currentSession) {
        BackupManagerService backupManagerService = this;
        synchronized (backupManagerService) {
            if (currentSession != this.mActiveRestoreSession) {
                Slog.e(TAG, "ending non-current restore session");
            } else {
                Slog.v(TAG, "Clearing restore session and halting timeout");
                this.mActiveRestoreSession = null;
                this.mBackupHandler.removeMessages(8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opComplete(int token) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            op = this.mCurrentOperations.get(token);
            if (op != null) {
                op.state = 1;
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            Message msg = this.mBackupHandler.obtainMessage(21, op.callback);
            this.mBackupHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        long identityToken = Binder.clearCallingIdentity();
        try {
            this.dumpInternal(pw);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(PrintWriter pw) {
        Object object = this.mQueueLock;
        synchronized (object) {
            pw.println("Backup Manager is " + (this.mEnabled ? "enabled" : "disabled") + " / " + (!this.mProvisioned ? "not " : "") + "provisioned / " + (this.mPendingInits.size() == 0 ? "not " : "") + "pending init");
            pw.println("Auto-restore is " + (this.mAutoRestore ? "enabled" : "disabled"));
            if (this.mBackupRunning) {
                pw.println("Backup currently running");
            }
            pw.println("Last backup pass started: " + this.mLastBackupPass + " (now = " + System.currentTimeMillis() + ')');
            pw.println("  next scheduled: " + this.mNextBackupPass);
            pw.println("Available transports:");
            for (String t : this.listAllTransports()) {
                pw.println((t.equals(this.mCurrentTransport) ? "  * " : "    ") + t);
                try {
                    IBackupTransport transport = this.getTransport(t);
                    File dir = new File(this.mBaseStateDir, transport.transportDirName());
                    pw.println("       destination: " + transport.currentDestinationString());
                    pw.println("       intent: " + transport.configurationIntent());
                    for (File f : dir.listFiles()) {
                        pw.println("       " + f.getName() + " - " + f.length() + " state bytes");
                    }
                }
                catch (Exception e) {
                    Slog.e(TAG, "Error in transport", e);
                    pw.println("        Error: " + e);
                }
            }
            pw.println("Pending init: " + this.mPendingInits.size());
            for (String s : this.mPendingInits) {
                pw.println("    " + s);
            }
            List<String> i$ = this.mBackupTrace;
            synchronized (i$) {
                if (!this.mBackupTrace.isEmpty()) {
                    pw.println("Most recent backup trace:");
                    for (String s : this.mBackupTrace) {
                        pw.println("   " + s);
                    }
                }
            }
            int N = this.mBackupParticipants.size();
            pw.println("Participants:");
            for (int i = 0; i < N; ++i) {
                int uid = this.mBackupParticipants.keyAt(i);
                pw.print("  uid: ");
                pw.println(uid);
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                for (String app : participants) {
                    pw.println("    " + app);
                }
            }
            pw.println("Ancestral packages: " + (this.mAncestralPackages == null ? "none" : Integer.valueOf(this.mAncestralPackages.size())));
            if (this.mAncestralPackages != null) {
                for (String pkg : this.mAncestralPackages) {
                    pw.println("    " + pkg);
                }
            }
            pw.println("Ever backed up: " + this.mEverStoredApps.size());
            for (String pkg : this.mEverStoredApps) {
                pw.println("    " + pkg);
            }
            pw.println("Pending backup: " + this.mPendingBackups.size());
            for (BackupRequest req : this.mPendingBackups.values()) {
                pw.println("    " + req);
            }
        }
    }

    class ActiveRestoreSession
    extends IRestoreSession.Stub {
        private static final String TAG = "RestoreSession";
        private String mPackageName;
        private IBackupTransport mRestoreTransport = null;
        RestoreSet[] mRestoreSets = null;
        boolean mEnded = false;

        ActiveRestoreSession(String packageName, String transport) {
            this.mPackageName = packageName;
            this.mRestoreTransport = BackupManagerService.this.getTransport(transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int getAvailableRestoreSets(IRestoreObserver observer) {
            int n;
            long oldId;
            block7: {
                BackupManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getAvailableRestoreSets");
                if (observer == null) {
                    throw new IllegalArgumentException("Observer must not be null");
                }
                if (this.mEnded) {
                    throw new IllegalStateException("Restore session already ended");
                }
                oldId = Binder.clearCallingIdentity();
                if (this.mRestoreTransport != null) break block7;
                Slog.w(TAG, "Null transport getting restore sets");
                int n2 = -1;
                Object var7_6 = null;
                Binder.restoreCallingIdentity(oldId);
                return n2;
            }
            try {
                BackupManagerService.this.mWakelock.acquire();
                Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(6, new RestoreGetSetsParams(this.mRestoreTransport, this, observer));
                BackupManagerService.this.mBackupHandler.sendMessage(msg);
                n = 0;
                Object var7_7 = null;
            }
            catch (Exception e) {
                int n3;
                try {
                    Slog.e(TAG, "Error in getAvailableRestoreSets", e);
                    n3 = -1;
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    Binder.restoreCallingIdentity(oldId);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(oldId);
                return n3;
            }
            Binder.restoreCallingIdentity(oldId);
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int restoreAll(long token, IRestoreObserver observer) {
            BackupManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
            Slog.d(TAG, "restoreAll token=" + Long.toHexString(token) + " observer=" + observer);
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            if (this.mRestoreTransport == null || this.mRestoreSets == null) {
                Slog.e(TAG, "Ignoring restoreAll() with no restore set");
                return -1;
            }
            if (this.mPackageName != null) {
                Slog.e(TAG, "Ignoring restoreAll() on single-package session");
                return -1;
            }
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                for (int i = 0; i < this.mRestoreSets.length; ++i) {
                    if (token != this.mRestoreSets[i].token) continue;
                    long oldId = Binder.clearCallingIdentity();
                    BackupManagerService.this.mWakelock.acquire();
                    Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(3);
                    msg.obj = new RestoreParams(this.mRestoreTransport, observer, token, true);
                    BackupManagerService.this.mBackupHandler.sendMessage(msg);
                    Binder.restoreCallingIdentity(oldId);
                    return 0;
                }
            }
            Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int restoreSome(long token, IRestoreObserver observer, String[] packages) {
            BackupManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
            StringBuilder b = new StringBuilder(128);
            b.append("restoreSome token=");
            b.append(Long.toHexString(token));
            b.append(" observer=");
            b.append(observer.toString());
            b.append(" packages=");
            if (packages == null) {
                b.append("null");
            } else {
                b.append('{');
                boolean first = true;
                for (String s : packages) {
                    if (!first) {
                        b.append(", ");
                    } else {
                        first = false;
                    }
                    b.append(s);
                }
                b.append('}');
            }
            Slog.d(TAG, b.toString());
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            if (this.mRestoreTransport == null || this.mRestoreSets == null) {
                Slog.e(TAG, "Ignoring restoreAll() with no restore set");
                return -1;
            }
            if (this.mPackageName != null) {
                Slog.e(TAG, "Ignoring restoreAll() on single-package session");
                return -1;
            }
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                for (int i = 0; i < this.mRestoreSets.length; ++i) {
                    if (token != this.mRestoreSets[i].token) continue;
                    long oldId = Binder.clearCallingIdentity();
                    BackupManagerService.this.mWakelock.acquire();
                    Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(3);
                    msg.obj = new RestoreParams(this.mRestoreTransport, observer, token, packages, true);
                    BackupManagerService.this.mBackupHandler.sendMessage(msg);
                    Binder.restoreCallingIdentity(oldId);
                    return 0;
                }
            }
            Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
            return -1;
        }

        public synchronized int restorePackage(String packageName, IRestoreObserver observer) {
            Slog.v(TAG, "restorePackage pkg=" + packageName + " obs=" + observer);
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            if (this.mPackageName != null && !this.mPackageName.equals(packageName)) {
                Slog.e(TAG, "Ignoring attempt to restore pkg=" + packageName + " on session for package " + this.mPackageName);
                return -1;
            }
            PackageInfo app = null;
            try {
                app = BackupManagerService.this.mPackageManager.getPackageInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nnf) {
                Slog.w(TAG, "Asked to restore nonexistent pkg " + packageName);
                return -1;
            }
            int perm = BackupManagerService.this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid());
            if (perm == -1 && app.applicationInfo.uid != Binder.getCallingUid()) {
                Slog.w(TAG, "restorePackage: bad packageName=" + packageName + " or calling uid=" + Binder.getCallingUid());
                throw new SecurityException("No permission to restore other packages");
            }
            if (app.applicationInfo.backupAgentName == null) {
                Slog.w(TAG, "Asked to restore package " + packageName + " with no agent");
                return -1;
            }
            long token = BackupManagerService.this.getAvailableRestoreToken(packageName);
            if (token == 0L) {
                Slog.w(TAG, "No data available for this package; not restoring");
                return -1;
            }
            long oldId = Binder.clearCallingIdentity();
            BackupManagerService.this.mWakelock.acquire();
            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(3);
            msg.obj = new RestoreParams(this.mRestoreTransport, observer, token, app, 0, false);
            BackupManagerService.this.mBackupHandler.sendMessage(msg);
            Binder.restoreCallingIdentity(oldId);
            return 0;
        }

        public synchronized void endRestoreSession() {
            Slog.d(TAG, "endRestoreSession");
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            BackupManagerService.this.mBackupHandler.post(new EndRestoreRunnable(BackupManagerService.this, this));
        }

        class EndRestoreRunnable
        implements Runnable {
            BackupManagerService mBackupManager;
            ActiveRestoreSession mSession;

            EndRestoreRunnable(BackupManagerService manager, ActiveRestoreSession session) {
                this.mBackupManager = manager;
                this.mSession = session;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block7: {
                    ActiveRestoreSession activeRestoreSession = this.mSession;
                    synchronized (activeRestoreSession) {
                        try {
                            block6: {
                                try {
                                    if (this.mSession.mRestoreTransport == null) break block6;
                                    this.mSession.mRestoreTransport.finishRestore();
                                }
                                catch (Exception e) {
                                    Slog.e(ActiveRestoreSession.TAG, "Error in finishRestore", e);
                                    Object var4_3 = null;
                                    this.mSession.mRestoreTransport = null;
                                    this.mSession.mEnded = true;
                                    break block7;
                                }
                            }
                            Object var4_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            this.mSession.mRestoreTransport = null;
                            this.mSession.mEnded = true;
                            throw throwable;
                        }
                        this.mSession.mRestoreTransport = null;
                        this.mSession.mEnded = true;
                    }
                }
                this.mBackupManager.clearRestoreSession(this.mSession);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PerformInitializeTask
    implements Runnable {
        HashSet<String> mQueue;

        PerformInitializeTask(HashSet<String> transportNames) {
            this.mQueue = transportNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    for (String transportName : this.mQueue) {
                        IBackupTransport transport = BackupManagerService.this.getTransport(transportName);
                        if (transport == null) {
                            Slog.e(BackupManagerService.TAG, "Requested init for " + transportName + " but not found");
                            continue;
                        }
                        Slog.i(BackupManagerService.TAG, "Initializing (wiping) backup transport storage: " + transportName);
                        EventLog.writeEvent(2821, transport.transportDirName());
                        long startRealtime = SystemClock.elapsedRealtime();
                        int status = transport.initializeDevice();
                        if (status == 0) {
                            status = transport.finishBackup();
                        }
                        if (status == 0) {
                            Slog.i(BackupManagerService.TAG, "Device init successful");
                            int millis = (int)(SystemClock.elapsedRealtime() - startRealtime);
                            EventLog.writeEvent(2827, new Object[0]);
                            BackupManagerService.this.resetBackupState(new File(BackupManagerService.this.mBaseStateDir, transport.transportDirName()));
                            EventLog.writeEvent(2825, 0, millis);
                            Object object = BackupManagerService.this.mQueueLock;
                            synchronized (object) {
                                BackupManagerService.this.recordInitPendingLocked(false, transportName);
                                continue;
                            }
                        }
                        Slog.e(BackupManagerService.TAG, "Transport error in initializeDevice()");
                        EventLog.writeEvent(2822, "(initialize)");
                        Object millis = BackupManagerService.this.mQueueLock;
                        synchronized (millis) {
                            BackupManagerService.this.recordInitPendingLocked(true, transportName);
                        }
                        long delay = transport.requestBackupTime();
                        Slog.w(BackupManagerService.TAG, "init failed on " + transportName + " resched in " + delay);
                        BackupManagerService.this.mAlarmManager.set(0, System.currentTimeMillis() + delay, BackupManagerService.this.mRunInitIntent);
                    }
                    Object var12_14 = null;
                    BackupManagerService.this.mWakelock.release();
                }
                catch (RemoteException e) {
                    Object var12_15 = null;
                    BackupManagerService.this.mWakelock.release();
                }
                catch (Exception e) {
                    Slog.e(BackupManagerService.TAG, "Unexpected error performing init", e);
                    Object var12_16 = null;
                    BackupManagerService.this.mWakelock.release();
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                BackupManagerService.this.mWakelock.release();
                throw throwable;
            }
        }
    }

    class PerformClearTask
    implements Runnable {
        IBackupTransport mTransport;
        PackageInfo mPackage;

        PerformClearTask(IBackupTransport transport, PackageInfo packageInfo) {
            this.mTransport = transport;
            this.mPackage = packageInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block11: {
                File stateDir = new File(BackupManagerService.this.mBaseStateDir, this.mTransport.transportDirName());
                File stateFile = new File(stateDir, this.mPackage.packageName);
                stateFile.delete();
                this.mTransport.clearBackupData(this.mPackage);
                Object var4_5 = null;
                try {
                    this.mTransport.finishBackup();
                }
                catch (RemoteException e2) {
                    // empty catch block
                }
                BackupManagerService.this.mWakelock.release();
                {
                    break block11;
                    catch (RemoteException e) {
                        Object var4_6 = null;
                        try {
                            this.mTransport.finishBackup();
                        }
                        catch (RemoteException e2) {
                            // empty catch block
                        }
                        BackupManagerService.this.mWakelock.release();
                        break block11;
                    }
                    catch (Exception e) {
                        Slog.e(BackupManagerService.TAG, "Transport threw attempting to clear data for " + this.mPackage);
                        Object var4_7 = null;
                        try {
                            this.mTransport.finishBackup();
                        }
                        catch (RemoteException e2) {
                            // empty catch block
                        }
                        BackupManagerService.this.mWakelock.release();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    try {
                        this.mTransport.finishBackup();
                    }
                    catch (RemoteException e2) {
                        // empty catch block
                    }
                    BackupManagerService.this.mWakelock.release();
                    throw throwable;
                }
            }
        }
    }

    class PerformRestoreTask
    implements BackupRestoreTask {
        private IBackupTransport mTransport;
        private IRestoreObserver mObserver;
        private long mToken;
        private PackageInfo mTargetPackage;
        private File mStateDir;
        private int mPmToken;
        private boolean mNeedFullBackup;
        private HashSet<String> mFilterSet;
        private long mStartRealtime;
        private PackageManagerBackupAgent mPmAgent = null;
        private List<PackageInfo> mAgentPackages;
        private ArrayList<PackageInfo> mRestorePackages;
        private RestoreState mCurrentState = RestoreState.INITIAL;
        private int mCount;
        private boolean mFinished = false;
        private int mStatus;
        private File mBackupDataName;
        private File mNewStateName;
        private File mSavedStateName;
        private ParcelFileDescriptor mBackupData;
        private ParcelFileDescriptor mNewState;
        private PackageInfo mCurrentPackage;

        PerformRestoreTask(IBackupTransport transport, IRestoreObserver observer, long restoreSetToken, PackageInfo targetPackage, int pmToken, boolean needFullBackup, String[] filterSet) {
            this.mTransport = transport;
            this.mObserver = observer;
            this.mToken = restoreSetToken;
            this.mTargetPackage = targetPackage;
            this.mPmToken = pmToken;
            this.mNeedFullBackup = needFullBackup;
            if (filterSet != null) {
                this.mFilterSet = new HashSet();
                for (String pkg : filterSet) {
                    this.mFilterSet.add(pkg);
                }
            } else {
                this.mFilterSet = null;
            }
            try {
                this.mStateDir = new File(BackupManagerService.this.mBaseStateDir, transport.transportDirName());
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        public void execute() {
            switch (this.mCurrentState) {
                case INITIAL: {
                    this.beginRestore();
                    break;
                }
                case DOWNLOAD_DATA: {
                    this.downloadRestoreData();
                    break;
                }
                case PM_METADATA: {
                    this.restorePmMetadata();
                    break;
                }
                case RUNNING_QUEUE: {
                    this.restoreNextAgent();
                    break;
                }
                case FINAL: {
                    if (!this.mFinished) {
                        this.finalizeRestore();
                    } else {
                        Slog.e(BackupManagerService.TAG, "Duplicate finish");
                    }
                    this.mFinished = true;
                }
            }
        }

        void beginRestore() {
            BackupManagerService.this.mBackupHandler.removeMessages(8);
            this.mStatus = 1;
            try {
                EventLog.writeEvent(2830, this.mTransport.transportDirName(), this.mToken);
                this.mRestorePackages = new ArrayList();
                PackageInfo omPackage = new PackageInfo();
                omPackage.packageName = BackupManagerService.PACKAGE_MANAGER_SENTINEL;
                this.mRestorePackages.add(omPackage);
                this.mAgentPackages = BackupManagerService.this.allAgentPackages();
                if (this.mTargetPackage == null) {
                    if (this.mFilterSet != null) {
                        for (int i = this.mAgentPackages.size() - 1; i >= 0; --i) {
                            PackageInfo pkg = this.mAgentPackages.get(i);
                            if (this.mFilterSet.contains(pkg.packageName)) continue;
                            this.mAgentPackages.remove(i);
                        }
                    }
                    this.mRestorePackages.addAll(this.mAgentPackages);
                } else {
                    this.mRestorePackages.add(this.mTargetPackage);
                }
                if (this.mObserver != null) {
                    try {
                        this.mObserver.restoreStarting(this.mRestorePackages.size());
                    }
                    catch (RemoteException e) {
                        Slog.d(BackupManagerService.TAG, "Restore observer died at restoreStarting");
                        this.mObserver = null;
                    }
                }
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Error communicating with transport for restore");
                this.executeNextState(RestoreState.FINAL);
                return;
            }
            this.mStatus = 0;
            this.executeNextState(RestoreState.DOWNLOAD_DATA);
        }

        void downloadRestoreData() {
            try {
                this.mStatus = this.mTransport.startRestore(this.mToken, this.mRestorePackages.toArray(new PackageInfo[0]));
                if (this.mStatus != 0) {
                    Slog.e(BackupManagerService.TAG, "Error starting restore operation");
                    EventLog.writeEvent(2831, new Object[0]);
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Error communicating with transport for restore");
                EventLog.writeEvent(2831, new Object[0]);
                this.mStatus = 1;
                this.executeNextState(RestoreState.FINAL);
                return;
            }
            this.executeNextState(RestoreState.PM_METADATA);
        }

        void restorePmMetadata() {
            try {
                String packageName = this.mTransport.nextRestorePackage();
                if (packageName == null) {
                    Slog.e(BackupManagerService.TAG, "Error getting first restore package");
                    EventLog.writeEvent(2831, new Object[0]);
                    this.mStatus = 1;
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
                if (packageName.equals("")) {
                    Slog.i(BackupManagerService.TAG, "No restore data available");
                    int millis = (int)(SystemClock.elapsedRealtime() - this.mStartRealtime);
                    EventLog.writeEvent(2834, 0, millis);
                    this.mStatus = 0;
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
                if (!packageName.equals(BackupManagerService.PACKAGE_MANAGER_SENTINEL)) {
                    Slog.e(BackupManagerService.TAG, "Expected restore data for \"@pm@\", found only \"" + packageName + "\"");
                    EventLog.writeEvent(2832, BackupManagerService.PACKAGE_MANAGER_SENTINEL, "Package manager data missing");
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
                PackageInfo omPackage = new PackageInfo();
                omPackage.packageName = BackupManagerService.PACKAGE_MANAGER_SENTINEL;
                this.mPmAgent = new PackageManagerBackupAgent(BackupManagerService.this.mPackageManager, this.mAgentPackages);
                this.initiateOneRestore(omPackage, 0, IBackupAgent.Stub.asInterface(this.mPmAgent.onBind()), this.mNeedFullBackup);
                if (!this.mPmAgent.hasMetadata()) {
                    Slog.e(BackupManagerService.TAG, "No restore metadata available, so not restoring settings");
                    EventLog.writeEvent(2832, BackupManagerService.PACKAGE_MANAGER_SENTINEL, "Package manager restore metadata missing");
                    this.mStatus = 1;
                    BackupManagerService.this.mBackupHandler.removeMessages(20, this);
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Error communicating with transport for restore");
                EventLog.writeEvent(2831, new Object[0]);
                this.mStatus = 1;
                BackupManagerService.this.mBackupHandler.removeMessages(20, this);
                this.executeNextState(RestoreState.FINAL);
                return;
            }
        }

        void restoreNextAgent() {
            try {
                PackageInfo packageInfo;
                PackageManagerBackupAgent.Metadata metaInfo;
                String packageName = this.mTransport.nextRestorePackage();
                if (packageName == null) {
                    Slog.e(BackupManagerService.TAG, "Error getting next restore package");
                    EventLog.writeEvent(2831, new Object[0]);
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
                if (packageName.equals("")) {
                    Slog.v(BackupManagerService.TAG, "No next package, finishing restore");
                    int millis = (int)(SystemClock.elapsedRealtime() - this.mStartRealtime);
                    EventLog.writeEvent(2834, this.mCount, millis);
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
                if (this.mObserver != null) {
                    try {
                        this.mObserver.onUpdate(this.mCount, packageName);
                    }
                    catch (RemoteException e) {
                        Slog.d(BackupManagerService.TAG, "Restore observer died in onUpdate");
                        this.mObserver = null;
                    }
                }
                if ((metaInfo = this.mPmAgent.getRestoredMetadata(packageName)) == null) {
                    Slog.e(BackupManagerService.TAG, "Missing metadata for " + packageName);
                    EventLog.writeEvent(2832, packageName, "Package metadata missing");
                    this.executeNextState(RestoreState.RUNNING_QUEUE);
                    return;
                }
                try {
                    int flags = 64;
                    packageInfo = BackupManagerService.this.mPackageManager.getPackageInfo(packageName, flags);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.e(BackupManagerService.TAG, "Invalid package restoring data", e);
                    EventLog.writeEvent(2832, packageName, "Package missing on device");
                    this.executeNextState(RestoreState.RUNNING_QUEUE);
                    return;
                }
                if (packageInfo.applicationInfo.backupAgentName == null || "".equals(packageInfo.applicationInfo.backupAgentName)) {
                    Slog.i(BackupManagerService.TAG, "Data exists for package " + packageName + " but app has no agent; skipping");
                    EventLog.writeEvent(2832, packageName, "Package has no agent");
                    this.executeNextState(RestoreState.RUNNING_QUEUE);
                    return;
                }
                if (metaInfo.versionCode > packageInfo.versionCode) {
                    if ((packageInfo.applicationInfo.flags & 0x20000) == 0) {
                        String message = "Version " + metaInfo.versionCode + " > installed version " + packageInfo.versionCode;
                        Slog.w(BackupManagerService.TAG, "Package " + packageName + ": " + message);
                        EventLog.writeEvent(2832, packageName, message);
                        this.executeNextState(RestoreState.RUNNING_QUEUE);
                        return;
                    }
                    Slog.v(BackupManagerService.TAG, "Version " + metaInfo.versionCode + " > installed " + packageInfo.versionCode + " but restoreAnyVersion");
                }
                if (!BackupManagerService.this.signaturesMatch(metaInfo.signatures, packageInfo)) {
                    Slog.w(BackupManagerService.TAG, "Signature mismatch restoring " + packageName);
                    EventLog.writeEvent(2832, packageName, "Signature mismatch");
                    this.executeNextState(RestoreState.RUNNING_QUEUE);
                    return;
                }
                Slog.v(BackupManagerService.TAG, "Package " + packageName + " restore version [" + metaInfo.versionCode + "] is compatible with installed version [" + packageInfo.versionCode + "]");
                IBackupAgent agent = BackupManagerService.this.bindToAgentSynchronous(packageInfo.applicationInfo, 0);
                if (agent == null) {
                    Slog.w(BackupManagerService.TAG, "Can't find backup agent for " + packageName);
                    EventLog.writeEvent(2832, packageName, "Restore agent missing");
                    this.executeNextState(RestoreState.RUNNING_QUEUE);
                    return;
                }
                try {
                    this.initiateOneRestore(packageInfo, metaInfo.versionCode, agent, this.mNeedFullBackup);
                    ++this.mCount;
                }
                catch (Exception e) {
                    Slog.e(BackupManagerService.TAG, "Error when attempting restore: " + e.toString());
                    this.agentErrorCleanup();
                    this.executeNextState(RestoreState.RUNNING_QUEUE);
                }
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Unable to fetch restore data from transport");
                this.mStatus = 1;
                this.executeNextState(RestoreState.FINAL);
            }
        }

        void finalizeRestore() {
            try {
                this.mTransport.finishRestore();
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Error finishing restore", e);
            }
            if (this.mObserver != null) {
                try {
                    this.mObserver.restoreFinished(this.mStatus);
                }
                catch (RemoteException e) {
                    Slog.d(BackupManagerService.TAG, "Restore observer died at restoreFinished");
                }
            }
            if (this.mTargetPackage == null && this.mPmAgent != null) {
                BackupManagerService.this.mAncestralPackages = this.mPmAgent.getRestoredPackages();
                BackupManagerService.this.mAncestralToken = this.mToken;
                BackupManagerService.this.writeRestoreTokens();
            }
            if (this.mPmToken > 0) {
                try {
                    BackupManagerService.this.mPackageManagerBinder.finishPackageInstall(this.mPmToken);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            BackupManagerService.this.mBackupHandler.removeMessages(8);
            BackupManagerService.this.mBackupHandler.sendEmptyMessageDelayed(8, 60000L);
            Slog.i(BackupManagerService.TAG, "Restore complete.");
            BackupManagerService.this.mWakelock.release();
        }

        void initiateOneRestore(PackageInfo app, int appVersionCode, IBackupAgent agent, boolean needFullBackup) {
            this.mCurrentPackage = app;
            String packageName = app.packageName;
            Slog.d(BackupManagerService.TAG, "initiateOneRestore packageName=" + packageName);
            this.mBackupDataName = new File(BackupManagerService.this.mDataDir, packageName + ".restore");
            this.mNewStateName = new File(this.mStateDir, packageName + ".new");
            this.mSavedStateName = new File(this.mStateDir, packageName);
            int token = BackupManagerService.this.generateToken();
            try {
                this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x3C000000);
                if (!SELinux.restorecon(this.mBackupDataName)) {
                    Slog.e(BackupManagerService.TAG, "SElinux restorecon failed for " + this.mBackupDataName);
                }
                if (this.mTransport.getRestoreData(this.mBackupData) != 0) {
                    Slog.e(BackupManagerService.TAG, "Error getting restore data for " + packageName);
                    EventLog.writeEvent(2831, new Object[0]);
                    this.mBackupData.close();
                    this.mBackupDataName.delete();
                    this.executeNextState(RestoreState.FINAL);
                    return;
                }
                this.mBackupData.close();
                this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
                this.mNewState = ParcelFileDescriptor.open(this.mNewStateName, 0x3C000000);
                BackupManagerService.this.prepareOperationTimeout(token, 60000L, this);
                agent.doRestore(this.mBackupData, appVersionCode, this.mNewState, token, BackupManagerService.this.mBackupManagerBinder);
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Unable to call app for restore: " + packageName, e);
                EventLog.writeEvent(2832, packageName, e.toString());
                this.agentErrorCleanup();
                this.executeNextState(RestoreState.RUNNING_QUEUE);
            }
        }

        void agentErrorCleanup() {
            BackupManagerService.this.clearApplicationDataSynchronous(this.mCurrentPackage.packageName);
            this.agentCleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void agentCleanup() {
            this.mBackupDataName.delete();
            try {
                if (this.mBackupData != null) {
                    this.mBackupData.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.mNewState != null) {
                    this.mNewState.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.mNewState = null;
            this.mBackupData = null;
            this.mNewStateName.delete();
            if (this.mCurrentPackage.applicationInfo != null) {
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(this.mCurrentPackage.applicationInfo);
                    if (this.mTargetPackage == null && (this.mCurrentPackage.applicationInfo.flags & 0x10000) != 0) {
                        Slog.d(BackupManagerService.TAG, "Restore complete, killing host process of " + this.mCurrentPackage.applicationInfo.processName);
                        BackupManagerService.this.mActivityManager.killApplicationProcess(this.mCurrentPackage.applicationInfo.processName, this.mCurrentPackage.applicationInfo.uid);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            BackupManagerService.this.mBackupHandler.removeMessages(7, this);
            Object object = BackupManagerService.this.mCurrentOpLock;
            synchronized (object) {
                BackupManagerService.this.mCurrentOperations.clear();
            }
        }

        public void operationComplete() {
            int size = (int)this.mBackupDataName.length();
            EventLog.writeEvent(2833, this.mCurrentPackage.packageName, size);
            this.agentCleanup();
            this.executeNextState(RestoreState.RUNNING_QUEUE);
        }

        public void handleTimeout() {
            Slog.e(BackupManagerService.TAG, "Timeout restoring application " + this.mCurrentPackage.packageName);
            EventLog.writeEvent(2832, this.mCurrentPackage.packageName, "restore timeout");
            this.agentErrorCleanup();
            this.executeNextState(RestoreState.RUNNING_QUEUE);
        }

        void executeNextState(RestoreState nextState) {
            this.mCurrentState = nextState;
            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(20, this);
            BackupManagerService.this.mBackupHandler.sendMessage(msg);
        }

        class RestoreRequest {
            public PackageInfo app;
            public int storedAppVersion;

            RestoreRequest(PackageInfo _app, int _version) {
                this.app = _app;
                this.storedAppVersion = _version;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RestoreState {
        INITIAL,
        DOWNLOAD_DATA,
        PM_METADATA,
        RUNNING_QUEUE,
        FINAL;

    }

    class PerformFullRestoreTask
    extends ObbServiceClient
    implements Runnable {
        ParcelFileDescriptor mInputFile;
        String mCurrentPassword;
        String mDecryptPassword;
        IFullBackupRestoreObserver mObserver;
        AtomicBoolean mLatchObject;
        IBackupAgent mAgent;
        String mAgentPackage;
        ApplicationInfo mTargetApp;
        FullBackupObbConnection mObbConnection;
        ParcelFileDescriptor[] mPipes;
        long mBytes;
        final HashMap<String, RestorePolicy> mPackagePolicies;
        final HashMap<String, String> mPackageInstallers;
        final HashMap<String, Signature[]> mManifestSignatures;
        final HashSet<String> mClearedPackages;
        final RestoreInstallObserver mInstallObserver;
        final RestoreDeleteObserver mDeleteObserver;

        PerformFullRestoreTask(ParcelFileDescriptor fd, String curPassword, String decryptPassword, IFullBackupRestoreObserver observer, AtomicBoolean latch) {
            this.mObbConnection = null;
            this.mPipes = null;
            this.mPackagePolicies = new HashMap();
            this.mPackageInstallers = new HashMap();
            this.mManifestSignatures = new HashMap();
            this.mClearedPackages = new HashSet();
            this.mInstallObserver = new RestoreInstallObserver();
            this.mDeleteObserver = new RestoreDeleteObserver();
            this.mInputFile = fd;
            this.mCurrentPassword = curPassword;
            this.mDecryptPassword = decryptPassword;
            this.mObserver = observer;
            this.mLatchObject = latch;
            this.mAgent = null;
            this.mAgentPackage = null;
            this.mTargetApp = null;
            this.mObbConnection = new FullBackupObbConnection();
            this.mClearedPackages.add("android");
            this.mClearedPackages.add("com.android.providers.settings");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block51: {
                block42: {
                    block50: {
                        block41: {
                            block49: {
                                block40: {
                                    Slog.i("BackupManagerService", "--- Performing full-dataset restore ---");
                                    this.mObbConnection.establish();
                                    this.sendStartRestore();
                                    if (Environment.getExternalStorageState().equals("mounted")) {
                                        this.mPackagePolicies.put("com.android.sharedstoragebackup", RestorePolicy.ACCEPT);
                                    }
                                    rawInStream = null;
                                    rawDataIn = null;
                                    try {
                                        try {
                                            block47: {
                                                block44: {
                                                    block45: {
                                                        block46: {
                                                            if (BackupManagerService.this.hasBackupPassword() && !BackupManagerService.this.passwordMatchesSaved(this.mCurrentPassword, 10000)) {
                                                                Slog.w("BackupManagerService", "Backup password mismatch; aborting");
                                                                var13_3 = null;
                                                                this.tearDownPipes();
                                                                this.tearDownAgent(this.mTargetApp);
                                                                break block40;
                                                            }
                                                            this.mBytes = 0L;
                                                            buffer = new byte[32768];
                                                            rawInStream = new FileInputStream(this.mInputFile.getFileDescriptor());
                                                            rawDataIn = new DataInputStream(rawInStream);
                                                            compressed = false;
                                                            preCompressStream /* !! */  = rawInStream;
                                                            okay = false;
                                                            headerLen = "ANDROID BACKUP\n".length();
                                                            streamHeader = new byte[headerLen];
                                                            rawDataIn.readFully(streamHeader);
                                                            magicBytes = "ANDROID BACKUP\n".getBytes("UTF-8");
                                                            if (!Arrays.equals(magicBytes, streamHeader)) break block44;
                                                            s = this.readHeaderLine(rawInStream);
                                                            if (Integer.parseInt(s) != 1) break block45;
                                                            s = this.readHeaderLine(rawInStream);
                                                            compressed = Integer.parseInt(s) != 0;
                                                            s = this.readHeaderLine(rawInStream);
                                                            if (!s.equals("none")) break block46;
                                                            okay = true;
                                                            break block47;
                                                        }
                                                        if (this.mDecryptPassword != null && this.mDecryptPassword.length() > 0) {
                                                            preCompressStream /* !! */  = this.decodeAesHeaderAndInitialize(s, rawInStream);
                                                            if (preCompressStream /* !! */  != null) {
                                                                okay = true;
                                                            }
                                                            break block47;
                                                        } else {
                                                            Slog.w("BackupManagerService", "Archive is encrypted but no password given");
                                                        }
                                                        break block47;
                                                    }
                                                    Slog.w("BackupManagerService", "Wrong header version: " + s);
                                                    break block47;
                                                }
                                                Slog.w("BackupManagerService", "Didn't read the right header magic");
                                            }
                                            if (!okay) {
                                                Slog.w("BackupManagerService", "Invalid restore data; aborting.");
                                                break block41;
                                            }
                                            v0 /* !! */  = in /* !! */  = compressed != false ? new InflaterInputStream(preCompressStream /* !! */ ) : preCompressStream /* !! */ ;
                                            while (didRestore = this.restoreOneFile(in /* !! */ , buffer)) {
                                            }
                                            break block42;
                                        }
                                        catch (IOException e) {
                                            Slog.e("BackupManagerService", "Unable to read restore input");
                                            var13_6 = null;
                                            this.tearDownPipes();
                                            this.tearDownAgent(this.mTargetApp);
                                            try {
                                                if (rawDataIn != null) {
                                                    rawDataIn.close();
                                                }
                                                if (rawInStream != null) {
                                                    rawInStream.close();
                                                }
                                                this.mInputFile.close();
                                            }
                                            catch (IOException e) {
                                                Slog.w("BackupManagerService", "Close of restore data pipe threw", e);
                                            }
                                            var14_11 = BackupManagerService.this.mCurrentOpLock;
                                            synchronized (var14_11) {
                                                BackupManagerService.this.mCurrentOperations.clear();
                                            }
                                            var14_11 = this.mLatchObject;
                                            synchronized (var14_11) {
                                                this.mLatchObject.set(true);
                                                this.mLatchObject.notifyAll();
                                            }
                                            this.mObbConnection.tearDown();
                                            this.sendEndRestore();
                                            Slog.d("BackupManagerService", "Full restore pass complete.");
                                            BackupManagerService.this.mWakelock.release();
                                            return;
                                        }
                                    }
                                    catch (Throwable var12_24) {
                                        block48: {
                                            var13_7 = null;
                                            this.tearDownPipes();
                                            this.tearDownAgent(this.mTargetApp);
                                            ** try [egrp 2[TRYBLOCK] [8 : 408->434)] { 
lbl103:
                                            // 1 sources

                                            if (rawDataIn != null) {
                                                rawDataIn.close();
                                            }
                                            if (rawInStream != null) {
                                                rawInStream.close();
                                            }
                                            this.mInputFile.close();
                                            break block48;
lbl109:
                                            // 1 sources

                                            catch (IOException e) {
                                                Slog.w("BackupManagerService", "Close of restore data pipe threw", e);
                                            }
                                        }
                                        var14_12 = BackupManagerService.this.mCurrentOpLock;
                                        synchronized (var14_12) {
                                            BackupManagerService.this.mCurrentOperations.clear();
                                        }
                                        var14_12 = this.mLatchObject;
                                        synchronized (var14_12) {
                                            this.mLatchObject.set(true);
                                            this.mLatchObject.notifyAll();
                                        }
                                        this.mObbConnection.tearDown();
                                        this.sendEndRestore();
                                        Slog.d("BackupManagerService", "Full restore pass complete.");
                                        BackupManagerService.this.mWakelock.release();
                                        throw var12_24;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [8 : 408->434)] { 
lbl128:
                                // 1 sources

                                if (rawDataIn != null) {
                                    rawDataIn.close();
                                }
                                if (rawInStream != null) {
                                    rawInStream.close();
                                }
                                this.mInputFile.close();
                                break block49;
lbl134:
                                // 1 sources

                                catch (IOException e) {
                                    Slog.w("BackupManagerService", "Close of restore data pipe threw", e);
                                }
                            }
                            var14_8 = BackupManagerService.this.mCurrentOpLock;
                            synchronized (var14_8) {
                                BackupManagerService.this.mCurrentOperations.clear();
                            }
                            var14_8 = this.mLatchObject;
                            synchronized (var14_8) {
                                this.mLatchObject.set(true);
                                this.mLatchObject.notifyAll();
                            }
                            this.mObbConnection.tearDown();
                            this.sendEndRestore();
                            Slog.d("BackupManagerService", "Full restore pass complete.");
                            BackupManagerService.this.mWakelock.release();
                            return;
                        }
                        var13_4 = null;
                        this.tearDownPipes();
                        this.tearDownAgent(this.mTargetApp);
                        ** try [egrp 2[TRYBLOCK] [8 : 408->434)] { 
lbl156:
                        // 1 sources

                        if (rawDataIn != null) {
                            rawDataIn.close();
                        }
                        if (rawInStream != null) {
                            rawInStream.close();
                        }
                        this.mInputFile.close();
                        break block50;
lbl162:
                        // 1 sources

                        catch (IOException e) {
                            Slog.w("BackupManagerService", "Close of restore data pipe threw", e);
                        }
                    }
                    var14_9 = BackupManagerService.this.mCurrentOpLock;
                    synchronized (var14_9) {
                        BackupManagerService.this.mCurrentOperations.clear();
                    }
                    var14_9 = this.mLatchObject;
                    synchronized (var14_9) {
                        this.mLatchObject.set(true);
                        this.mLatchObject.notifyAll();
                    }
                    this.mObbConnection.tearDown();
                    this.sendEndRestore();
                    Slog.d("BackupManagerService", "Full restore pass complete.");
                    BackupManagerService.this.mWakelock.release();
                    return;
                }
                var13_5 = null;
                this.tearDownPipes();
                this.tearDownAgent(this.mTargetApp);
                ** try [egrp 2[TRYBLOCK] [8 : 408->434)] { 
lbl184:
                // 1 sources

                if (rawDataIn != null) {
                    rawDataIn.close();
                }
                if (rawInStream != null) {
                    rawInStream.close();
                }
                this.mInputFile.close();
                break block51;
lbl190:
                // 1 sources

                catch (IOException e) {
                    Slog.w("BackupManagerService", "Close of restore data pipe threw", e);
                }
            }
            var14_10 = BackupManagerService.this.mCurrentOpLock;
            synchronized (var14_10) {
                BackupManagerService.this.mCurrentOperations.clear();
            }
            var14_10 = this.mLatchObject;
            synchronized (var14_10) {
                this.mLatchObject.set(true);
                this.mLatchObject.notifyAll();
            }
            this.mObbConnection.tearDown();
            this.sendEndRestore();
            Slog.d("BackupManagerService", "Full restore pass complete.");
            BackupManagerService.this.mWakelock.release();
        }

        String readHeaderLine(InputStream in) throws IOException {
            int c;
            StringBuilder buffer = new StringBuilder(80);
            while ((c = in.read()) >= 0 && c != 10) {
                buffer.append((char)c);
            }
            return buffer.toString();
        }

        InputStream decodeAesHeaderAndInitialize(String encryptionName, InputStream rawInStream) {
            CipherInputStream result = null;
            try {
                if (encryptionName.equals(BackupManagerService.ENCRYPTION_ALGORITHM_NAME)) {
                    String userSaltHex = this.readHeaderLine(rawInStream);
                    byte[] userSalt = BackupManagerService.this.hexToByteArray(userSaltHex);
                    String ckSaltHex = this.readHeaderLine(rawInStream);
                    byte[] ckSalt = BackupManagerService.this.hexToByteArray(ckSaltHex);
                    int rounds = Integer.parseInt(this.readHeaderLine(rawInStream));
                    String userIvHex = this.readHeaderLine(rawInStream);
                    String masterKeyBlobHex = this.readHeaderLine(rawInStream);
                    Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    SecretKey userKey = BackupManagerService.this.buildPasswordKey(this.mDecryptPassword, userSalt, rounds);
                    byte[] IV = BackupManagerService.this.hexToByteArray(userIvHex);
                    IvParameterSpec ivSpec = new IvParameterSpec(IV);
                    c.init(2, (Key)new SecretKeySpec(userKey.getEncoded(), "AES"), ivSpec);
                    byte[] mkCipher = BackupManagerService.this.hexToByteArray(masterKeyBlobHex);
                    byte[] mkBlob = c.doFinal(mkCipher);
                    int offset = 0;
                    byte len = mkBlob[offset++];
                    IV = Arrays.copyOfRange(mkBlob, offset, offset + len);
                    offset += len;
                    len = mkBlob[offset++];
                    byte[] mk = Arrays.copyOfRange(mkBlob, offset, offset + len);
                    offset += len;
                    len = mkBlob[offset++];
                    byte[] mkChecksum = Arrays.copyOfRange(mkBlob, offset, offset + len);
                    byte[] calculatedCk = BackupManagerService.this.makeKeyChecksum(mk, ckSalt, rounds);
                    if (Arrays.equals(calculatedCk, mkChecksum)) {
                        ivSpec = new IvParameterSpec(IV);
                        c.init(2, (Key)new SecretKeySpec(mk, "AES"), ivSpec);
                        result = new CipherInputStream(rawInStream, c);
                    } else {
                        Slog.w(BackupManagerService.TAG, "Incorrect password");
                    }
                } else {
                    Slog.w(BackupManagerService.TAG, "Unsupported encryption method: " + encryptionName);
                }
            }
            catch (InvalidAlgorithmParameterException e) {
                Slog.e(BackupManagerService.TAG, "Needed parameter spec unavailable!", e);
            }
            catch (BadPaddingException e) {
                Slog.w(BackupManagerService.TAG, "Incorrect password");
            }
            catch (IllegalBlockSizeException e) {
                Slog.w(BackupManagerService.TAG, "Invalid block size in master key");
            }
            catch (NoSuchAlgorithmException e) {
                Slog.e(BackupManagerService.TAG, "Needed decryption algorithm unavailable!");
            }
            catch (NoSuchPaddingException e) {
                Slog.e(BackupManagerService.TAG, "Needed padding mechanism unavailable!");
            }
            catch (InvalidKeyException e) {
                Slog.w(BackupManagerService.TAG, "Illegal password; aborting");
            }
            catch (NumberFormatException e) {
                Slog.w(BackupManagerService.TAG, "Can't parse restore data header");
            }
            catch (IOException e) {
                Slog.w(BackupManagerService.TAG, "Can't read input header");
            }
            return result;
        }

        boolean restoreOneFile(InputStream instream, byte[] buffer) {
            FileMetadata info;
            block40: {
                try {
                    long nRead;
                    info = this.readTarHeaders(instream);
                    if (info == null) break block40;
                    String pkg = info.packageName;
                    if (!pkg.equals(this.mAgentPackage)) {
                        if (!this.mPackagePolicies.containsKey(pkg)) {
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                        if (this.mAgent != null) {
                            Slog.d(BackupManagerService.TAG, "Saw new package; tearing down old one");
                            this.tearDownPipes();
                            this.tearDownAgent(this.mTargetApp);
                            this.mTargetApp = null;
                            this.mAgentPackage = null;
                        }
                    }
                    if (info.path.equals(BackupManagerService.BACKUP_MANIFEST_FILENAME)) {
                        this.mPackagePolicies.put(pkg, this.readAppManifest(info, instream));
                        this.mPackageInstallers.put(pkg, info.installerPackageName);
                        this.skipTarPadding(info.size, instream);
                        this.sendOnRestorePackage(pkg);
                        break block40;
                    }
                    boolean okay = true;
                    RestorePolicy policy = this.mPackagePolicies.get(pkg);
                    switch (policy) {
                        case IGNORE: {
                            okay = false;
                            break;
                        }
                        case ACCEPT_IF_APK: {
                            if (info.domain.equals("a")) {
                                Slog.d(BackupManagerService.TAG, "APK file; installing");
                                String installerName = this.mPackageInstallers.get(pkg);
                                okay = this.installApk(info, installerName, instream);
                                this.mPackagePolicies.put(pkg, okay ? RestorePolicy.ACCEPT : RestorePolicy.IGNORE);
                                this.skipTarPadding(info.size, instream);
                                return true;
                            }
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                            okay = false;
                            break;
                        }
                        case ACCEPT: {
                            if (!info.domain.equals("a")) break;
                            Slog.d(BackupManagerService.TAG, "apk present but ACCEPT");
                            okay = false;
                            break;
                        }
                        default: {
                            Slog.e(BackupManagerService.TAG, "Invalid policy from manifest");
                            okay = false;
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (okay && this.mAgent != null) {
                        Slog.i(BackupManagerService.TAG, "Reusing existing agent instance");
                    }
                    if (okay && this.mAgent == null) {
                        Slog.d(BackupManagerService.TAG, "Need to launch agent for " + pkg);
                        try {
                            this.mTargetApp = BackupManagerService.this.mPackageManager.getApplicationInfo(pkg, 0);
                            if (!this.mClearedPackages.contains(pkg)) {
                                if (this.mTargetApp.backupAgentName == null) {
                                    Slog.d(BackupManagerService.TAG, "Clearing app data preparatory to full restore");
                                    BackupManagerService.this.clearApplicationDataSynchronous(pkg);
                                } else {
                                    Slog.d(BackupManagerService.TAG, "backup agent (" + this.mTargetApp.backupAgentName + ") => no clear");
                                }
                                this.mClearedPackages.add(pkg);
                            } else {
                                Slog.d(BackupManagerService.TAG, "We've initialized this app already; no clear required");
                            }
                            this.setUpPipes();
                            this.mAgent = BackupManagerService.this.bindToAgentSynchronous(this.mTargetApp, 3);
                            this.mAgentPackage = pkg;
                        }
                        catch (IOException e) {
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            // empty catch block
                        }
                        if (this.mAgent == null) {
                            Slog.d(BackupManagerService.TAG, "Unable to create agent for " + pkg);
                            okay = false;
                            this.tearDownPipes();
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (okay && !pkg.equals(this.mAgentPackage)) {
                        Slog.e(BackupManagerService.TAG, "Restoring data for " + pkg + " but agent is for " + this.mAgentPackage);
                        okay = false;
                    }
                    if (okay) {
                        boolean agentSuccess = true;
                        long toCopy = info.size;
                        int token = BackupManagerService.this.generateToken();
                        try {
                            BackupManagerService.this.prepareOperationTimeout(token, 300000L, null);
                            if (info.domain.equals("obb")) {
                                Slog.d(BackupManagerService.TAG, "Restoring OBB file for " + pkg + " : " + info.path);
                                this.mObbConnection.restoreObbFile(pkg, this.mPipes[0], info.size, info.type, info.path, info.mode, info.mtime, token, BackupManagerService.this.mBackupManagerBinder);
                            } else {
                                Slog.d(BackupManagerService.TAG, "Invoking agent to restore file " + info.path);
                                if (this.mTargetApp.processName.equals("system")) {
                                    Slog.d(BackupManagerService.TAG, "system process agent - spinning a thread");
                                    RestoreFileRunnable runner = new RestoreFileRunnable(this.mAgent, info, this.mPipes[0], token);
                                    new Thread(runner).start();
                                } else {
                                    this.mAgent.doRestoreFile(this.mPipes[0], info.size, info.type, info.domain, info.path, info.mode, info.mtime, token, BackupManagerService.this.mBackupManagerBinder);
                                }
                            }
                        }
                        catch (IOException e) {
                            Slog.d(BackupManagerService.TAG, "Couldn't establish restore");
                            agentSuccess = false;
                            okay = false;
                        }
                        catch (RemoteException e) {
                            Slog.e(BackupManagerService.TAG, "Agent crashed during full restore");
                            agentSuccess = false;
                            okay = false;
                        }
                        if (okay) {
                            boolean pipeOkay = true;
                            FileOutputStream pipe = new FileOutputStream(this.mPipes[1].getFileDescriptor());
                            while (toCopy > 0L) {
                                int toRead = toCopy > (long)buffer.length ? buffer.length : (int)toCopy;
                                int nRead2 = instream.read(buffer, 0, toRead);
                                if (nRead2 >= 0) {
                                    this.mBytes += (long)nRead2;
                                }
                                if (nRead2 <= 0) break;
                                toCopy -= (long)nRead2;
                                if (!pipeOkay) continue;
                                try {
                                    pipe.write(buffer, 0, nRead2);
                                }
                                catch (IOException e) {
                                    Slog.e(BackupManagerService.TAG, "Failed to write to restore pipe", e);
                                    pipeOkay = false;
                                }
                            }
                            this.skipTarPadding(info.size, instream);
                            agentSuccess = BackupManagerService.this.waitUntilOperationComplete(token);
                        }
                        if (!agentSuccess) {
                            BackupManagerService.this.mBackupHandler.removeMessages(7);
                            this.tearDownPipes();
                            this.tearDownAgent(this.mTargetApp);
                            this.mAgent = null;
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (okay) break block40;
                    Slog.d(BackupManagerService.TAG, "[discarding file content]");
                    for (long bytesToConsume = info.size + 511L & 0xFFFFFFFFFFFFFE00L; bytesToConsume > 0L; bytesToConsume -= nRead) {
                        int toRead = bytesToConsume > (long)buffer.length ? buffer.length : (int)bytesToConsume;
                        nRead = instream.read(buffer, 0, toRead);
                        if (nRead >= 0L) {
                            this.mBytes += nRead;
                        }
                        if (nRead > 0L) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    Slog.w(BackupManagerService.TAG, "io exception on restore socket read", e);
                    info = null;
                }
            }
            return info != null;
        }

        void setUpPipes() throws IOException {
            this.mPipes = ParcelFileDescriptor.createPipe();
        }

        void tearDownPipes() {
            if (this.mPipes != null) {
                try {
                    this.mPipes[0].close();
                    this.mPipes[0] = null;
                    this.mPipes[1].close();
                    this.mPipes[1] = null;
                }
                catch (IOException e) {
                    Slog.w(BackupManagerService.TAG, "Couldn't close agent pipes", e);
                }
                this.mPipes = null;
            }
        }

        void tearDownAgent(ApplicationInfo app) {
            if (this.mAgent != null) {
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(app);
                    if (app.uid != 1000 && !app.packageName.equals("com.android.backupconfirm")) {
                        Slog.d(BackupManagerService.TAG, "Killing host process");
                        BackupManagerService.this.mActivityManager.killApplicationProcess(app.processName, app.uid);
                    } else {
                        Slog.d(BackupManagerService.TAG, "Not killing after full restore");
                    }
                }
                catch (RemoteException e) {
                    Slog.d(BackupManagerService.TAG, "Lost app trying to shut down");
                }
                this.mAgent = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean installApk(FileMetadata info, String installerPackage, InputStream instream) {
            boolean okay = true;
            Slog.d(BackupManagerService.TAG, "Installing from backup: " + info.packageName);
            File apkFile = new File(BackupManagerService.this.mDataDir, info.packageName);
            try {
                block16: {
                    try {
                        boolean uninstall;
                        block17: {
                            int didRead;
                            FileOutputStream apkStream = new FileOutputStream(apkFile);
                            byte[] buffer = new byte[32768];
                            for (long size = info.size; size > 0L; size -= (long)didRead) {
                                long toRead = (long)buffer.length < size ? (long)buffer.length : size;
                                didRead = instream.read(buffer, 0, (int)toRead);
                                if (didRead >= 0) {
                                    this.mBytes += (long)didRead;
                                }
                                apkStream.write(buffer, 0, didRead);
                            }
                            apkStream.close();
                            apkFile.setReadable(true, false);
                            Uri packageUri = Uri.fromFile(apkFile);
                            this.mInstallObserver.reset();
                            BackupManagerService.this.mPackageManager.installPackage(packageUri, this.mInstallObserver, 34, installerPackage);
                            this.mInstallObserver.waitForCompletion();
                            if (this.mInstallObserver.getResult() != 1) {
                                if (this.mPackagePolicies.get(info.packageName) != RestorePolicy.ACCEPT) {
                                    okay = false;
                                }
                                break block16;
                            }
                            uninstall = false;
                            if (!this.mInstallObserver.mPackageName.equals(info.packageName)) {
                                Slog.w(BackupManagerService.TAG, "Restore stream claimed to include apk for " + info.packageName + " but apk was really " + this.mInstallObserver.mPackageName);
                                okay = false;
                                uninstall = true;
                            } else {
                                try {
                                    PackageInfo pkg = BackupManagerService.this.mPackageManager.getPackageInfo(info.packageName, 64);
                                    if ((pkg.applicationInfo.flags & 0x8000) == 0) {
                                        Slog.w(BackupManagerService.TAG, "Restore stream contains apk of package " + info.packageName + " but it disallows backup/restore");
                                        okay = false;
                                        break block17;
                                    }
                                    Signature[] sigs = this.mManifestSignatures.get(info.packageName);
                                    if (BackupManagerService.this.signaturesMatch(sigs, pkg)) {
                                        if (pkg.applicationInfo.uid < 10000 && pkg.applicationInfo.backupAgentName == null) {
                                            Slog.w(BackupManagerService.TAG, "Installed app " + info.packageName + " has restricted uid and no agent");
                                            okay = false;
                                        }
                                        break block17;
                                    }
                                    Slog.w(BackupManagerService.TAG, "Installed app " + info.packageName + " signatures do not match restore manifest");
                                    okay = false;
                                    uninstall = true;
                                }
                                catch (PackageManager.NameNotFoundException e) {
                                    Slog.w(BackupManagerService.TAG, "Install of package " + info.packageName + " succeeded but now not found");
                                    okay = false;
                                }
                            }
                        }
                        if (uninstall) {
                            this.mDeleteObserver.reset();
                            BackupManagerService.this.mPackageManager.deletePackage(this.mInstallObserver.mPackageName, this.mDeleteObserver, 0);
                            this.mDeleteObserver.waitForCompletion();
                        }
                    }
                    catch (IOException e) {
                        Slog.e(BackupManagerService.TAG, "Unable to transcribe restored apk for install");
                        okay = false;
                        Object var15_18 = null;
                        apkFile.delete();
                        return okay;
                    }
                }
                Object var15_17 = null;
                apkFile.delete();
                return okay;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                apkFile.delete();
                throw throwable;
            }
        }

        void skipTarPadding(long size, InputStream instream) throws IOException {
            long partial = (size + 512L) % 512L;
            if (partial > 0L) {
                int needed = 512 - (int)partial;
                byte[] buffer = new byte[needed];
                if (this.readExactly(instream, buffer, 0, needed) == needed) {
                    this.mBytes += (long)needed;
                } else {
                    throw new IOException("Unexpected EOF in padding");
                }
            }
        }

        RestorePolicy readAppManifest(FileMetadata info, InputStream instream) throws IOException {
            RestorePolicy policy;
            block21: {
                if (info.size > 65536L) {
                    throw new IOException("Restore manifest too big; corrupt? size=" + info.size);
                }
                byte[] buffer = new byte[(int)info.size];
                if ((long)this.readExactly(instream, buffer, 0, (int)info.size) == info.size) {
                    this.mBytes += info.size;
                } else {
                    throw new IOException("Unexpected EOF in manifest");
                }
                policy = RestorePolicy.IGNORE;
                String[] str = new String[1];
                int offset = 0;
                try {
                    offset = this.extractLine(buffer, offset, str);
                    int version = Integer.parseInt(str[0]);
                    if (version == 1) {
                        offset = this.extractLine(buffer, offset, str);
                        String manifestPackage = str[0];
                        if (manifestPackage.equals(info.packageName)) {
                            offset = this.extractLine(buffer, offset, str);
                            version = Integer.parseInt(str[0]);
                            offset = this.extractLine(buffer, offset, str);
                            int platformVersion = Integer.parseInt(str[0]);
                            offset = this.extractLine(buffer, offset, str);
                            info.installerPackageName = str[0].length() > 0 ? str[0] : null;
                            offset = this.extractLine(buffer, offset, str);
                            boolean hasApk = str[0].equals("1");
                            offset = this.extractLine(buffer, offset, str);
                            int numSigs = Integer.parseInt(str[0]);
                            if (numSigs > 0) {
                                Signature[] sigs = new Signature[numSigs];
                                for (int i = 0; i < numSigs; ++i) {
                                    offset = this.extractLine(buffer, offset, str);
                                    sigs[i] = new Signature(str[0]);
                                }
                                this.mManifestSignatures.put(info.packageName, sigs);
                                try {
                                    PackageInfo pkgInfo = BackupManagerService.this.mPackageManager.getPackageInfo(info.packageName, 64);
                                    int flags = pkgInfo.applicationInfo.flags;
                                    if ((flags & 0x8000) != 0) {
                                        if (pkgInfo.applicationInfo.uid >= 10000 || pkgInfo.applicationInfo.backupAgentName != null) {
                                            if (BackupManagerService.this.signaturesMatch(sigs, pkgInfo)) {
                                                if (pkgInfo.versionCode >= version) {
                                                    Slog.i(BackupManagerService.TAG, "Sig + version match; taking data");
                                                    policy = RestorePolicy.ACCEPT;
                                                } else {
                                                    Slog.d(BackupManagerService.TAG, "Data version " + version + " is newer than installed version " + pkgInfo.versionCode + " - requiring apk");
                                                    policy = RestorePolicy.ACCEPT_IF_APK;
                                                }
                                            } else {
                                                Slog.w(BackupManagerService.TAG, "Restore manifest signatures do not match installed application for " + info.packageName);
                                            }
                                        } else {
                                            Slog.w(BackupManagerService.TAG, "Package " + info.packageName + " is system level with no agent");
                                        }
                                    } else {
                                        Slog.i(BackupManagerService.TAG, "Restore manifest from " + info.packageName + " but allowBackup=false");
                                    }
                                }
                                catch (PackageManager.NameNotFoundException e) {
                                    Slog.i(BackupManagerService.TAG, "Package " + info.packageName + " not installed; requiring apk in dataset");
                                    policy = RestorePolicy.ACCEPT_IF_APK;
                                }
                                if (policy == RestorePolicy.ACCEPT_IF_APK && !hasApk) {
                                    Slog.i(BackupManagerService.TAG, "Cannot restore package " + info.packageName + " without the matching .apk");
                                }
                                break block21;
                            }
                            Slog.i(BackupManagerService.TAG, "Missing signature on backed-up package " + info.packageName);
                            break block21;
                        }
                        Slog.i(BackupManagerService.TAG, "Expected package " + info.packageName + " but restore manifest claims " + manifestPackage);
                        break block21;
                    }
                    Slog.i(BackupManagerService.TAG, "Unknown restore manifest version " + version + " for package " + info.packageName);
                }
                catch (NumberFormatException e) {
                    Slog.w(BackupManagerService.TAG, "Corrupt restore manifest for package " + info.packageName);
                }
                catch (IllegalArgumentException e) {
                    Slog.w(BackupManagerService.TAG, e.getMessage());
                }
            }
            return policy;
        }

        int extractLine(byte[] buffer, int offset, String[] outStr) throws IOException {
            byte c;
            int pos;
            int end = buffer.length;
            if (offset >= end) {
                throw new IOException("Incomplete data");
            }
            for (pos = offset; pos < end && (c = buffer[pos]) != 10; ++pos) {
            }
            outStr[0] = new String(buffer, offset, pos - offset);
            return ++pos;
        }

        void dumpFileMetadata(FileMetadata info) {
            StringBuilder b = new StringBuilder(128);
            b.append(info.type == 2 ? (char)'d' : '-');
            b.append((info.mode & 0x100L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 0x80L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 0x40L) != 0L ? (char)'x' : '-');
            b.append((info.mode & 0x20L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 0x10L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 8L) != 0L ? (char)'x' : '-');
            b.append((info.mode & 4L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 2L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 1L) != 0L ? (char)'x' : '-');
            b.append(String.format(" %9d ", info.size));
            Date stamp = new Date(info.mtime);
            b.append(new SimpleDateFormat("MMM dd HH:mm:ss ").format(stamp));
            b.append(info.packageName);
            b.append(" :: ");
            b.append(info.domain);
            b.append(" :: ");
            b.append(info.path);
            Slog.i(BackupManagerService.TAG, b.toString());
        }

        FileMetadata readTarHeaders(InputStream instream) throws IOException {
            byte[] block = new byte[512];
            FileMetadata info = null;
            boolean gotHeader = this.readTarHeader(instream, block);
            if (gotHeader) {
                try {
                    byte typeChar;
                    info = new FileMetadata();
                    info.size = this.extractRadix(block, 124, 12, 8);
                    info.mtime = this.extractRadix(block, 136, 12, 8);
                    info.mode = this.extractRadix(block, 100, 8, 8);
                    info.path = this.extractString(block, 345, 155);
                    String path = this.extractString(block, 0, 100);
                    if (path.length() > 0) {
                        if (info.path.length() > 0) {
                            info.path = info.path + '/';
                        }
                        info.path = info.path + path;
                    }
                    if ((typeChar = block[156]) == 120) {
                        gotHeader = this.readPaxExtendedHeader(instream, info);
                        if (gotHeader) {
                            gotHeader = this.readTarHeader(instream, block);
                        }
                        if (!gotHeader) {
                            throw new IOException("Bad or missing pax header");
                        }
                        typeChar = block[156];
                    }
                    switch (typeChar) {
                        case 48: {
                            info.type = 1;
                            break;
                        }
                        case 53: {
                            info.type = 2;
                            if (info.size == 0L) break;
                            Slog.w(BackupManagerService.TAG, "Directory entry with nonzero size in header");
                            info.size = 0L;
                            break;
                        }
                        case 0: {
                            Slog.w(BackupManagerService.TAG, "Saw type=0 in tar header block, info=" + info);
                            return null;
                        }
                        default: {
                            Slog.e(BackupManagerService.TAG, "Unknown tar entity type: " + typeChar);
                            throw new IOException("Unknown entity type " + typeChar);
                        }
                    }
                    if ("shared/".regionMatches(0, info.path, 0, "shared/".length())) {
                        info.path = info.path.substring("shared/".length());
                        info.packageName = BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE;
                        info.domain = "shared";
                        Slog.i(BackupManagerService.TAG, "File in shared storage: " + info.path);
                    } else if ("apps/".regionMatches(0, info.path, 0, "apps/".length())) {
                        info.path = info.path.substring("apps/".length());
                        int slash = info.path.indexOf(47);
                        if (slash < 0) {
                            throw new IOException("Illegal semantic path in " + info.path);
                        }
                        info.packageName = info.path.substring(0, slash);
                        info.path = info.path.substring(slash + 1);
                        if (!info.path.equals(BackupManagerService.BACKUP_MANIFEST_FILENAME)) {
                            slash = info.path.indexOf(47);
                            if (slash < 0) {
                                throw new IOException("Illegal semantic path in non-manifest " + info.path);
                            }
                            info.domain = info.path.substring(0, slash);
                            info.path = info.path.substring(slash + 1);
                        }
                    }
                }
                catch (IOException e) {
                    Slog.e(BackupManagerService.TAG, "Parse error in header: " + e.getMessage());
                    this.HEXLOG(block);
                    throw e;
                }
            }
            return info;
        }

        private void HEXLOG(byte[] block) {
            int offset = 0;
            int todo = block.length;
            StringBuilder buf = new StringBuilder(64);
            while (todo > 0) {
                buf.append(String.format("%04x   ", offset));
                int numThisLine = todo > 16 ? 16 : todo;
                for (int i = 0; i < numThisLine; ++i) {
                    buf.append(String.format("%02x ", block[offset + i]));
                }
                Slog.i("hexdump", buf.toString());
                buf.setLength(0);
                todo -= numThisLine;
                offset += numThisLine;
            }
        }

        int readExactly(InputStream in, byte[] buffer, int offset, int size) throws IOException {
            int soFar;
            int nRead;
            if (size <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            for (soFar = 0; soFar < size && (nRead = in.read(buffer, offset + soFar, size - soFar)) > 0; soFar += nRead) {
            }
            return soFar;
        }

        boolean readTarHeader(InputStream instream, byte[] block) throws IOException {
            int got = this.readExactly(instream, block, 0, 512);
            if (got == 0) {
                return false;
            }
            if (got < 512) {
                throw new IOException("Unable to read full block header");
            }
            this.mBytes += 512L;
            return true;
        }

        boolean readPaxExtendedHeader(InputStream instream, FileMetadata info) throws IOException {
            int linelen;
            if (info.size > 32768L) {
                Slog.w(BackupManagerService.TAG, "Suspiciously large pax header size " + info.size + " - aborting");
                throw new IOException("Sanity failure: pax header size " + info.size);
            }
            int numBlocks = (int)(info.size + 511L >> 9);
            byte[] data = new byte[numBlocks * 512];
            if (this.readExactly(instream, data, 0, data.length) < data.length) {
                throw new IOException("Unable to read full pax header");
            }
            this.mBytes += (long)data.length;
            int contentSize = (int)info.size;
            int offset = 0;
            do {
                int value;
                int eol;
                for (eol = offset + 1; eol < contentSize && data[eol] != 32; ++eol) {
                }
                if (eol >= contentSize) {
                    throw new IOException("Invalid pax data");
                }
                linelen = (int)this.extractRadix(data, offset, eol - offset, 10);
                int key = eol + 1;
                eol = offset + linelen - 1;
                for (value = key + 1; data[value] != 61 && value <= eol; ++value) {
                }
                if (value > eol) {
                    throw new IOException("Invalid pax declaration");
                }
                String keyStr = new String(data, key, value - key, "UTF-8");
                String valStr = new String(data, value + 1, eol - value - 1, "UTF-8");
                if ("path".equals(keyStr)) {
                    info.path = valStr;
                    continue;
                }
                if ("size".equals(keyStr)) {
                    info.size = Long.parseLong(valStr);
                    continue;
                }
                Slog.i(BackupManagerService.TAG, "Unhandled pax key: " + key);
            } while ((offset += linelen) < contentSize);
            return true;
        }

        long extractRadix(byte[] data, int offset, int maxChars, int radix) throws IOException {
            byte b;
            long value = 0L;
            int end = offset + maxChars;
            for (int i = offset; i < end && (b = data[i]) != 0 && b != 32; ++i) {
                if (b < 48 || b > 48 + radix - 1) {
                    throw new IOException("Invalid number in header: '" + (char)b + "' for radix " + radix);
                }
                value = (long)radix * value + (long)(b - 48);
            }
            return value;
        }

        String extractString(byte[] data, int offset, int maxChars) throws IOException {
            int eos;
            int end = offset + maxChars;
            for (eos = offset; eos < end && data[eos] != 0; ++eos) {
            }
            return new String(data, offset, eos - offset, "US-ASCII");
        }

        void sendStartRestore() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onStartRestore();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full restore observer went away: startRestore");
                    this.mObserver = null;
                }
            }
        }

        void sendOnRestorePackage(String name) {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onRestorePackage(name);
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full restore observer went away: restorePackage");
                    this.mObserver = null;
                }
            }
        }

        void sendEndRestore() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onEndRestore();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full restore observer went away: endRestore");
                    this.mObserver = null;
                }
            }
        }

        class RestoreDeleteObserver
        extends IPackageDeleteObserver.Stub {
            final AtomicBoolean mDone = new AtomicBoolean();
            int mResult;

            RestoreDeleteObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mDone.set(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForCompletion() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    while (!this.mDone.get()) {
                        try {
                            this.mDone.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void packageDeleted(String packageName, int returnCode) throws RemoteException {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mResult = returnCode;
                    this.mDone.set(true);
                    this.mDone.notifyAll();
                }
            }
        }

        class RestoreInstallObserver
        extends IPackageInstallObserver.Stub {
            final AtomicBoolean mDone = new AtomicBoolean();
            String mPackageName;
            int mResult;

            RestoreInstallObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mDone.set(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForCompletion() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    while (!this.mDone.get()) {
                        try {
                            this.mDone.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            int getResult() {
                return this.mResult;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void packageInstalled(String packageName, int returnCode) throws RemoteException {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mResult = returnCode;
                    this.mPackageName = packageName;
                    this.mDone.set(true);
                    this.mDone.notifyAll();
                }
            }
        }

        class RestoreFileRunnable
        implements Runnable {
            IBackupAgent mAgent;
            FileMetadata mInfo;
            ParcelFileDescriptor mSocket;
            int mToken;

            RestoreFileRunnable(IBackupAgent agent, FileMetadata info, ParcelFileDescriptor socket, int token) throws IOException {
                this.mAgent = agent;
                this.mInfo = info;
                this.mToken = token;
                this.mSocket = ParcelFileDescriptor.dup(socket.getFileDescriptor());
            }

            public void run() {
                try {
                    this.mAgent.doRestoreFile(this.mSocket, this.mInfo.size, this.mInfo.type, this.mInfo.domain, this.mInfo.path, this.mInfo.mode, this.mInfo.mtime, this.mToken, BackupManagerService.this.mBackupManagerBinder);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RestorePolicy {
        IGNORE,
        ACCEPT,
        ACCEPT_IF_APK;

    }

    static class FileMetadata {
        String packageName;
        String installerPackageName;
        int type;
        String domain;
        String path;
        long mode;
        long mtime;
        long size;

        FileMetadata() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("FileMetadata{");
            sb.append(this.packageName);
            sb.append(',');
            sb.append(this.type);
            sb.append(',');
            sb.append(this.domain);
            sb.append(':');
            sb.append(this.path);
            sb.append(',');
            sb.append(this.size);
            sb.append('}');
            return sb.toString();
        }
    }

    class PerformFullBackupTask
    extends ObbServiceClient
    implements Runnable {
        ParcelFileDescriptor mOutputFile;
        DeflaterOutputStream mDeflater;
        IFullBackupRestoreObserver mObserver;
        boolean mIncludeApks;
        boolean mIncludeObbs;
        boolean mIncludeShared;
        boolean mAllApps;
        final boolean mIncludeSystem;
        String[] mPackages;
        String mCurrentPassword;
        String mEncryptPassword;
        AtomicBoolean mLatchObject;
        File mFilesDir;
        File mManifestFile;

        PerformFullBackupTask(ParcelFileDescriptor fd, IFullBackupRestoreObserver observer, boolean includeApks, boolean includeObbs, boolean includeShared, String curPassword, String encryptPassword, boolean doAllApps, boolean doSystem, String[] packages, AtomicBoolean latch) {
            this.mOutputFile = fd;
            this.mObserver = observer;
            this.mIncludeApks = includeApks;
            this.mIncludeObbs = includeObbs;
            this.mIncludeShared = includeShared;
            this.mAllApps = doAllApps;
            this.mIncludeSystem = doSystem;
            this.mPackages = packages;
            this.mCurrentPassword = curPassword;
            this.mEncryptPassword = encryptPassword == null || "".equals(encryptPassword) ? curPassword : encryptPassword;
            this.mLatchObject = latch;
            this.mFilesDir = new File("/data/system");
            this.mManifestFile = new File(this.mFilesDir, BackupManagerService.BACKUP_MANIFEST_FILENAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block62: {
                block57: {
                    block61: {
                        block55: {
                            Slog.i("BackupManagerService", "--- Performing full-dataset backup ---");
                            packagesToBackup = new ArrayList<E>();
                            obbConnection = new FullBackupObbConnection();
                            obbConnection.establish();
                            this.sendStartBackup();
                            if (this.mAllApps) {
                                packagesToBackup = BackupManagerService.access$600(BackupManagerService.this).getInstalledPackages(64);
                                if (!this.mIncludeSystem) {
                                    i = 0;
                                    while (i < packagesToBackup.size()) {
                                        pkg = (PackageInfo)packagesToBackup.get(i);
                                        if ((pkg.applicationInfo.flags & 1) != 0) {
                                            packagesToBackup.remove(i);
                                            continue;
                                        }
                                        ++i;
                                    }
                                }
                            }
                            if (this.mPackages != null) {
                                for (String pkgName : this.mPackages) {
                                    try {
                                        packagesToBackup.add(BackupManagerService.access$600(BackupManagerService.this).getPackageInfo(pkgName, 64));
                                    }
                                    catch (PackageManager.NameNotFoundException e) {
                                        Slog.w("BackupManagerService", "Unknown package " + pkgName + ", skipping");
                                    }
                                }
                            }
                            i = 0;
                            while (i < packagesToBackup.size()) {
                                pkg = (PackageInfo)packagesToBackup.get(i);
                                if ((pkg.applicationInfo.flags & 32768) == 0 || pkg.packageName.equals("com.android.sharedstoragebackup")) {
                                    packagesToBackup.remove(i);
                                    continue;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < packagesToBackup.size()) {
                                pkg = (PackageInfo)packagesToBackup.get(i);
                                if (pkg.applicationInfo.uid < 10000 && pkg.applicationInfo.backupAgentName == null) {
                                    packagesToBackup.remove(i);
                                    continue;
                                }
                                ++i;
                            }
                            ofstream = new FileOutputStream(this.mOutputFile.getFileDescriptor());
                            out = null;
                            pkg = null;
                            try {
                                try {
                                    encrypting = this.mEncryptPassword != null && this.mEncryptPassword.length() > 0;
                                    compressing = true;
                                    finalOutput /* !! */  = ofstream;
                                    if (BackupManagerService.this.hasBackupPassword() && !BackupManagerService.this.passwordMatchesSaved(this.mCurrentPassword, 10000)) {
                                        Slog.w("BackupManagerService", "Backup password mismatch; aborting");
                                        var14_20 = null;
                                        this.tearDown(pkg);
                                        break block55;
                                    }
                                    headerbuf = new StringBuilder(1024);
                                    headerbuf.append("ANDROID BACKUP\n");
                                    headerbuf.append(1);
                                    headerbuf.append(compressing != false ? "\n1\n" : "\n0\n");
                                    try {
                                        if (encrypting) {
                                            finalOutput /* !! */  = this.emitAesBackupHeader(headerbuf, finalOutput /* !! */ );
                                        } else {
                                            headerbuf.append("none\n");
                                        }
                                        header = headerbuf.toString().getBytes("UTF-8");
                                        ofstream.write(header);
                                        if (compressing) {
                                            deflater = new Deflater(9);
                                            finalOutput /* !! */  = new DeflaterOutputStream((OutputStream)finalOutput /* !! */ , deflater, true);
                                        }
                                        out = finalOutput /* !! */ ;
                                    }
                                    catch (Exception e) {
                                        Slog.e("BackupManagerService", "Unable to emit archive header", e);
                                        var14_21 = null;
                                        this.tearDown(pkg);
                                        try {
                                            if (out != null) {
                                                out.close();
                                            }
                                            this.mOutputFile.close();
                                        }
                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                        var15_27 = BackupManagerService.this.mCurrentOpLock;
                                        synchronized (var15_27) {
                                            BackupManagerService.this.mCurrentOperations.clear();
                                        }
                                        var15_27 = this.mLatchObject;
                                        synchronized (var15_27) {
                                            this.mLatchObject.set(true);
                                            this.mLatchObject.notifyAll();
                                        }
                                        this.sendEndBackup();
                                        obbConnection.tearDown();
                                        Slog.d("BackupManagerService", "Full backup pass complete.");
                                        BackupManagerService.this.mWakelock.release();
                                        return;
                                    }
                                    if (this.mIncludeShared) {
                                        try {
                                            pkg = BackupManagerService.access$600(BackupManagerService.this).getPackageInfo("com.android.sharedstoragebackup", 0);
                                            packagesToBackup.add(pkg);
                                        }
                                        catch (PackageManager.NameNotFoundException e) {
                                            Slog.e("BackupManagerService", "Unable to find shared-storage backup handler");
                                        }
                                    }
                                    N = packagesToBackup.size();
                                    for (i = 0; i < N; ++i) {
                                        pkg = (PackageInfo)packagesToBackup.get(i);
                                        this.backupOnePackage(pkg, out);
                                        if (!this.mIncludeObbs || (obbOkay = obbConnection.backupObbs(pkg, out))) continue;
                                        throw new RuntimeException("Failure writing OBB stack for " + pkg);
                                    }
                                    this.finalizeBackup(out);
                                    break block57;
                                }
                                catch (RemoteException e) {
                                    block58: {
                                        Slog.e("BackupManagerService", "App died during full backup");
                                        var14_23 = null;
                                        this.tearDown(pkg);
                                        ** try [egrp 5[TRYBLOCK] [15 : 779->799)] { 
lbl133:
                                        // 1 sources

                                        if (out != null) {
                                            out.close();
                                        }
                                        this.mOutputFile.close();
                                        break block58;
lbl137:
                                        // 1 sources

                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                    }
                                    var15_29 = BackupManagerService.this.mCurrentOpLock;
                                    synchronized (var15_29) {
                                        BackupManagerService.this.mCurrentOperations.clear();
                                    }
                                    var15_29 = this.mLatchObject;
                                    synchronized (var15_29) {
                                        this.mLatchObject.set(true);
                                        this.mLatchObject.notifyAll();
                                    }
                                    this.sendEndBackup();
                                    obbConnection.tearDown();
                                    Slog.d("BackupManagerService", "Full backup pass complete.");
                                    BackupManagerService.this.mWakelock.release();
                                    return;
                                }
                                catch (Exception e) {
                                    block59: {
                                        Slog.e("BackupManagerService", "Internal exception during full backup", e);
                                        var14_24 = null;
                                        this.tearDown(pkg);
                                        ** try [egrp 5[TRYBLOCK] [15 : 779->799)] { 
lbl160:
                                        // 1 sources

                                        if (out != null) {
                                            out.close();
                                        }
                                        this.mOutputFile.close();
                                        break block59;
lbl164:
                                        // 1 sources

                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                    }
                                    var15_30 = BackupManagerService.this.mCurrentOpLock;
                                    synchronized (var15_30) {
                                        BackupManagerService.this.mCurrentOperations.clear();
                                    }
                                    var15_30 = this.mLatchObject;
                                    synchronized (var15_30) {
                                        this.mLatchObject.set(true);
                                        this.mLatchObject.notifyAll();
                                    }
                                    this.sendEndBackup();
                                    obbConnection.tearDown();
                                    Slog.d("BackupManagerService", "Full backup pass complete.");
                                    BackupManagerService.this.mWakelock.release();
                                    return;
                                }
                            }
                            catch (Throwable var13_40) {
                                block60: {
                                    var14_25 = null;
                                    this.tearDown(pkg);
                                    ** try [egrp 5[TRYBLOCK] [15 : 779->799)] { 
lbl185:
                                    // 1 sources

                                    if (out != null) {
                                        out.close();
                                    }
                                    this.mOutputFile.close();
                                    break block60;
lbl189:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                }
                                var15_31 = BackupManagerService.this.mCurrentOpLock;
                                synchronized (var15_31) {
                                    BackupManagerService.this.mCurrentOperations.clear();
                                }
                                var15_31 = this.mLatchObject;
                                synchronized (var15_31) {
                                    this.mLatchObject.set(true);
                                    this.mLatchObject.notifyAll();
                                }
                                this.sendEndBackup();
                                obbConnection.tearDown();
                                Slog.d("BackupManagerService", "Full backup pass complete.");
                                BackupManagerService.this.mWakelock.release();
                                throw var13_40;
                            }
                        }
                        ** try [egrp 5[TRYBLOCK] [15 : 779->799)] { 
lbl207:
                        // 1 sources

                        if (out != null) {
                            out.close();
                        }
                        this.mOutputFile.close();
                        break block61;
lbl211:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    var15_26 = BackupManagerService.this.mCurrentOpLock;
                    synchronized (var15_26) {
                        BackupManagerService.this.mCurrentOperations.clear();
                    }
                    var15_26 = this.mLatchObject;
                    synchronized (var15_26) {
                        this.mLatchObject.set(true);
                        this.mLatchObject.notifyAll();
                    }
                    this.sendEndBackup();
                    obbConnection.tearDown();
                    Slog.d("BackupManagerService", "Full backup pass complete.");
                    BackupManagerService.this.mWakelock.release();
                    return;
                }
                var14_22 = null;
                this.tearDown(pkg);
                ** try [egrp 5[TRYBLOCK] [15 : 779->799)] { 
lbl231:
                // 1 sources

                if (out != null) {
                    out.close();
                }
                this.mOutputFile.close();
                break block62;
lbl235:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
            }
            var15_28 = BackupManagerService.this.mCurrentOpLock;
            synchronized (var15_28) {
                BackupManagerService.this.mCurrentOperations.clear();
            }
            var15_28 = this.mLatchObject;
            synchronized (var15_28) {
                this.mLatchObject.set(true);
                this.mLatchObject.notifyAll();
            }
            this.sendEndBackup();
            obbConnection.tearDown();
            Slog.d("BackupManagerService", "Full backup pass complete.");
            BackupManagerService.this.mWakelock.release();
        }

        private OutputStream emitAesBackupHeader(StringBuilder headerbuf, OutputStream ofstream) throws Exception {
            byte[] newUserSalt = BackupManagerService.this.randomBytes(512);
            SecretKey userKey = BackupManagerService.this.buildPasswordKey(this.mEncryptPassword, newUserSalt, 10000);
            byte[] masterPw = new byte[32];
            BackupManagerService.this.mRng.nextBytes(masterPw);
            byte[] checksumSalt = BackupManagerService.this.randomBytes(512);
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec masterKeySpec = new SecretKeySpec(masterPw, "AES");
            c.init(1, masterKeySpec);
            CipherOutputStream finalOutput = new CipherOutputStream(ofstream, c);
            headerbuf.append(BackupManagerService.ENCRYPTION_ALGORITHM_NAME);
            headerbuf.append('\n');
            headerbuf.append(BackupManagerService.this.byteArrayToHex(newUserSalt));
            headerbuf.append('\n');
            headerbuf.append(BackupManagerService.this.byteArrayToHex(checksumSalt));
            headerbuf.append('\n');
            headerbuf.append(10000);
            headerbuf.append('\n');
            Cipher mkC = Cipher.getInstance("AES/CBC/PKCS5Padding");
            mkC.init(1, userKey);
            byte[] IV = mkC.getIV();
            headerbuf.append(BackupManagerService.this.byteArrayToHex(IV));
            headerbuf.append('\n');
            IV = c.getIV();
            byte[] mk = masterKeySpec.getEncoded();
            byte[] checksum = BackupManagerService.this.makeKeyChecksum(masterKeySpec.getEncoded(), checksumSalt, 10000);
            ByteArrayOutputStream blob = new ByteArrayOutputStream(IV.length + mk.length + checksum.length + 3);
            DataOutputStream mkOut = new DataOutputStream(blob);
            mkOut.writeByte(IV.length);
            mkOut.write(IV);
            mkOut.writeByte(mk.length);
            mkOut.write(mk);
            mkOut.writeByte(checksum.length);
            mkOut.write(checksum);
            mkOut.flush();
            byte[] encryptedMk = mkC.doFinal(blob.toByteArray());
            headerbuf.append(BackupManagerService.this.byteArrayToHex(encryptedMk));
            headerbuf.append('\n');
            return finalOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void backupOnePackage(PackageInfo pkg, OutputStream out) throws RemoteException {
            block21: {
                block22: {
                    ParcelFileDescriptor[] pipes;
                    block20: {
                        Slog.d(BackupManagerService.TAG, "Binding to full backup agent : " + pkg.packageName);
                        IBackupAgent agent = BackupManagerService.this.bindToAgentSynchronous(pkg.applicationInfo, 1);
                        if (agent == null) break block22;
                        pipes = null;
                        pipes = ParcelFileDescriptor.createPipe();
                        ApplicationInfo app = pkg.applicationInfo;
                        boolean isSharedStorage = pkg.packageName.equals(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE);
                        boolean sendApk = this.mIncludeApks && !isSharedStorage && (app.flags & 0x20000000) == 0 && ((app.flags & 1) == 0 || (app.flags & 0x80) != 0);
                        this.sendOnBackupPackage(isSharedStorage ? "Shared storage" : pkg.packageName);
                        int token = BackupManagerService.this.generateToken();
                        FullBackupRunner runner = new FullBackupRunner(pkg, agent, pipes[1], token, sendApk, !isSharedStorage);
                        pipes[1].close();
                        pipes[1] = null;
                        Thread t = new Thread(runner);
                        t.start();
                        try {
                            BackupManagerService.this.routeSocketDataToOutput(pipes[0], out);
                        }
                        catch (IOException e) {
                            Slog.i(BackupManagerService.TAG, "Caught exception reading from agent", e);
                        }
                        if (!BackupManagerService.this.waitUntilOperationComplete(token)) {
                            Slog.e(BackupManagerService.TAG, "Full backup failed on package " + pkg.packageName);
                            break block20;
                        }
                        Slog.d(BackupManagerService.TAG, "Full package backup success: " + pkg.packageName);
                    }
                    Object var13_13 = null;
                    try {
                        out.flush();
                        if (pipes != null) {
                            if (pipes[0] != null) {
                                pipes[0].close();
                            }
                            if (pipes[1] != null) {
                                pipes[1].close();
                            }
                        }
                        break block21;
                    }
                    catch (IOException e2) {
                        Slog.w(BackupManagerService.TAG, "Error bringing down backup stack");
                    }
                    break block21;
                    {
                        catch (IOException e) {
                            Slog.e(BackupManagerService.TAG, "Error backing up " + pkg.packageName, e);
                            Object var13_14 = null;
                            try {
                                out.flush();
                                if (pipes != null) {
                                    if (pipes[0] != null) {
                                        pipes[0].close();
                                    }
                                    if (pipes[1] != null) {
                                        pipes[1].close();
                                    }
                                }
                                break block21;
                            }
                            catch (IOException e2) {
                                Slog.w(BackupManagerService.TAG, "Error bringing down backup stack");
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        try {
                            out.flush();
                            if (pipes != null) {
                                if (pipes[0] != null) {
                                    pipes[0].close();
                                }
                                if (pipes[1] != null) {
                                    pipes[1].close();
                                }
                            }
                        }
                        catch (IOException e2) {
                            Slog.w(BackupManagerService.TAG, "Error bringing down backup stack");
                        }
                        throw throwable;
                    }
                }
                Slog.w(BackupManagerService.TAG, "Unable to bind to full agent for " + pkg.packageName);
            }
            this.tearDown(pkg);
        }

        private void writeApkToBackup(PackageInfo pkg, BackupDataOutput output) {
            File[] obbFiles;
            String appSourceDir = pkg.applicationInfo.sourceDir;
            String apkDir = new File(appSourceDir).getParent();
            FullBackup.backupToTar(pkg.packageName, "a", null, apkDir, appSourceDir, output);
            Environment.UserEnvironment userEnv = new Environment.UserEnvironment(0);
            File obbDir = userEnv.buildExternalStorageAppObbDirs(pkg.packageName)[0];
            if (obbDir != null && (obbFiles = obbDir.listFiles()) != null) {
                String obbDirName = obbDir.getAbsolutePath();
                for (File obb : obbFiles) {
                    FullBackup.backupToTar(pkg.packageName, "obb", null, obbDirName, obb.getAbsolutePath(), output);
                }
            }
        }

        private void finalizeBackup(OutputStream out) {
            try {
                byte[] eof = new byte[1024];
                out.write(eof);
            }
            catch (IOException e) {
                Slog.w(BackupManagerService.TAG, "Error attempting to finalize backup stream");
            }
        }

        private void writeAppManifest(PackageInfo pkg, File manifestFile, boolean withApk) throws IOException {
            StringBuilder builder = new StringBuilder(4096);
            StringBuilderPrinter printer = new StringBuilderPrinter(builder);
            printer.println(Integer.toString(1));
            printer.println(pkg.packageName);
            printer.println(Integer.toString(pkg.versionCode));
            printer.println(Integer.toString(Build.VERSION.SDK_INT));
            String installerName = BackupManagerService.this.mPackageManager.getInstallerPackageName(pkg.packageName);
            printer.println(installerName != null ? installerName : "");
            printer.println(withApk ? "1" : "0");
            if (pkg.signatures == null) {
                printer.println("0");
            } else {
                printer.println(Integer.toString(pkg.signatures.length));
                for (Signature sig : pkg.signatures) {
                    printer.println(sig.toCharsString());
                }
            }
            FileOutputStream outstream = new FileOutputStream(manifestFile);
            outstream.write(builder.toString().getBytes());
            outstream.close();
        }

        private void tearDown(PackageInfo pkg) {
            ApplicationInfo app;
            if (pkg != null && (app = pkg.applicationInfo) != null) {
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(app);
                    if (app.uid != 1000 && app.uid != 1001) {
                        BackupManagerService.this.mActivityManager.killApplicationProcess(app.processName, app.uid);
                    }
                }
                catch (RemoteException e) {
                    Slog.d(BackupManagerService.TAG, "Lost app trying to shut down");
                }
            }
        }

        void sendStartBackup() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onStartBackup();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full backup observer went away: startBackup");
                    this.mObserver = null;
                }
            }
        }

        void sendOnBackupPackage(String name) {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onBackupPackage(name);
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full backup observer went away: backupPackage");
                    this.mObserver = null;
                }
            }
        }

        void sendEndBackup() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onEndBackup();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full backup observer went away: endBackup");
                    this.mObserver = null;
                }
            }
        }

        class FullBackupRunner
        implements Runnable {
            PackageInfo mPackage;
            IBackupAgent mAgent;
            ParcelFileDescriptor mPipe;
            int mToken;
            boolean mSendApk;
            boolean mWriteManifest;

            FullBackupRunner(PackageInfo pack, IBackupAgent agent, ParcelFileDescriptor pipe, int token, boolean sendApk, boolean writeManifest) throws IOException {
                this.mPackage = pack;
                this.mAgent = agent;
                this.mPipe = ParcelFileDescriptor.dup(pipe.getFileDescriptor());
                this.mToken = token;
                this.mSendApk = sendApk;
                this.mWriteManifest = writeManifest;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block12: {
                    BackupDataOutput output = new BackupDataOutput(this.mPipe.getFileDescriptor());
                    if (this.mWriteManifest) {
                        PerformFullBackupTask.this.writeAppManifest(this.mPackage, PerformFullBackupTask.this.mManifestFile, this.mSendApk);
                        FullBackup.backupToTar(this.mPackage.packageName, null, null, PerformFullBackupTask.this.mFilesDir.getAbsolutePath(), PerformFullBackupTask.this.mManifestFile.getAbsolutePath(), output);
                    }
                    if (this.mSendApk) {
                        PerformFullBackupTask.this.writeApkToBackup(this.mPackage, output);
                    }
                    Slog.d(BackupManagerService.TAG, "Calling doFullBackup() on " + this.mPackage.packageName);
                    BackupManagerService.this.prepareOperationTimeout(this.mToken, 300000L, null);
                    this.mAgent.doFullBackup(this.mPipe, this.mToken, BackupManagerService.this.mBackupManagerBinder);
                    Object var3_4 = null;
                    try {
                        this.mPipe.close();
                    }
                    catch (IOException e2) {}
                    break block12;
                    {
                        catch (IOException e) {
                            Slog.e(BackupManagerService.TAG, "Error running full backup for " + this.mPackage.packageName);
                            Object var3_5 = null;
                            try {
                                this.mPipe.close();
                            }
                            catch (IOException e2) {}
                            break block12;
                        }
                        catch (RemoteException e) {
                            Slog.e(BackupManagerService.TAG, "Remote agent vanished during full backup of " + this.mPackage.packageName);
                            Object var3_6 = null;
                            try {
                                this.mPipe.close();
                            }
                            catch (IOException e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        try {
                            this.mPipe.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    class FullBackupObbConnection
    implements ServiceConnection {
        volatile IObbBackupService mService = null;

        FullBackupObbConnection() {
        }

        public void establish() {
            Slog.i(BackupManagerService.TAG, "Initiating bind of OBB service on " + this);
            Intent obbIntent = new Intent().setComponent(new ComponentName(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE, "com.android.sharedstoragebackup.ObbBackupService"));
            BackupManagerService.this.mContext.bindService(obbIntent, this, 1);
        }

        public void tearDown() {
            BackupManagerService.this.mContext.unbindService(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public boolean backupObbs(PackageInfo pkg, OutputStream out) {
            boolean success;
            block17: {
                success = false;
                this.waitForConnection();
                ParcelFileDescriptor[] pipes = null;
                pipes = ParcelFileDescriptor.createPipe();
                int token = BackupManagerService.this.generateToken();
                BackupManagerService.this.prepareOperationTimeout(token, 300000L, null);
                this.mService.backupObbs(pkg.packageName, pipes[1], token, BackupManagerService.this.mBackupManagerBinder);
                BackupManagerService.this.routeSocketDataToOutput(pipes[0], out);
                success = BackupManagerService.this.waitUntilOperationComplete(token);
                Object var7_7 = null;
                try {
                    out.flush();
                    if (pipes != null) {
                        if (pipes[0] != null) {
                            pipes[0].close();
                        }
                        if (pipes[1] != null) {
                            pipes[1].close();
                        }
                    }
                    break block17;
                }
                catch (IOException e2) {
                    Slog.w(BackupManagerService.TAG, "I/O error closing down OBB backup", e2);
                }
                break block17;
                {
                    catch (Exception e) {
                        Slog.w(BackupManagerService.TAG, "Unable to back up OBBs for " + pkg, e);
                        Object var7_8 = null;
                        try {
                            out.flush();
                            if (pipes != null) {
                                if (pipes[0] != null) {
                                    pipes[0].close();
                                }
                                if (pipes[1] != null) {
                                    pipes[1].close();
                                }
                            }
                            break block17;
                        }
                        catch (IOException e2) {
                            Slog.w(BackupManagerService.TAG, "I/O error closing down OBB backup", e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        out.flush();
                        if (pipes != null) {
                            if (pipes[0] != null) {
                                pipes[0].close();
                            }
                            if (pipes[1] != null) {
                                pipes[1].close();
                            }
                        }
                    }
                    catch (IOException e2) {
                        Slog.w(BackupManagerService.TAG, "I/O error closing down OBB backup", e2);
                    }
                    throw throwable;
                }
            }
            return success;
        }

        public void restoreObbFile(String pkgName, ParcelFileDescriptor data, long fileSize, int type, String path, long mode, long mtime, int token, IBackupManager callbackBinder) {
            this.waitForConnection();
            try {
                this.mService.restoreObbFile(pkgName, data, fileSize, type, path, mode, mtime, token, callbackBinder);
            }
            catch (Exception e) {
                Slog.w(BackupManagerService.TAG, "Unable to restore OBBs for " + pkgName, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForConnection() {
            FullBackupObbConnection fullBackupObbConnection = this;
            synchronized (fullBackupObbConnection) {
                while (this.mService == null) {
                    Slog.i(BackupManagerService.TAG, "...waiting for OBB service binding...");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Slog.i(BackupManagerService.TAG, "Connected to OBB service; continuing");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            FullBackupObbConnection fullBackupObbConnection = this;
            synchronized (fullBackupObbConnection) {
                this.mService = IObbBackupService.Stub.asInterface(service);
                Slog.i(BackupManagerService.TAG, "OBB service connection " + this.mService + " connected on " + this);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            FullBackupObbConnection fullBackupObbConnection = this;
            synchronized (fullBackupObbConnection) {
                this.mService = null;
                Slog.i(BackupManagerService.TAG, "OBB service connection disconnected on " + this);
                this.notifyAll();
            }
        }
    }

    abstract class ObbServiceClient {
        public IObbBackupService mObbService;

        ObbServiceClient() {
        }

        public void setObbBinder(IObbBackupService binder) {
            this.mObbService = binder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PerformBackupTask
    implements BackupRestoreTask {
        private static final String TAG = "PerformBackupTask";
        IBackupTransport mTransport;
        ArrayList<BackupRequest> mQueue;
        ArrayList<BackupRequest> mOriginalQueue;
        File mStateDir;
        File mJournal;
        BackupState mCurrentState;
        PackageInfo mCurrentPackage;
        File mSavedStateName;
        File mBackupDataName;
        File mNewStateName;
        ParcelFileDescriptor mSavedState;
        ParcelFileDescriptor mBackupData;
        ParcelFileDescriptor mNewState;
        int mStatus;
        boolean mFinished;

        public PerformBackupTask(IBackupTransport transport, ArrayList<BackupRequest> queue, File journal) {
            this.mTransport = transport;
            this.mOriginalQueue = queue;
            this.mJournal = journal;
            try {
                this.mStateDir = new File(BackupManagerService.this.mBaseStateDir, transport.transportDirName());
            }
            catch (RemoteException e) {
                // empty catch block
            }
            this.mCurrentState = BackupState.INITIAL;
            this.mFinished = false;
            BackupManagerService.this.addBackupTrace("STATE => INITIAL");
        }

        @Override
        public void execute() {
            switch (this.mCurrentState) {
                case INITIAL: {
                    this.beginBackup();
                    break;
                }
                case RUNNING_QUEUE: {
                    this.invokeNextAgent();
                    break;
                }
                case FINAL: {
                    if (!this.mFinished) {
                        this.finalizeBackup();
                    } else {
                        Slog.e(TAG, "Duplicate finish");
                    }
                    this.mFinished = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginBackup() {
            BackupManagerService.this.clearBackupTrace();
            StringBuilder b = new StringBuilder(256);
            b.append("beginBackup: [");
            for (BackupRequest req : this.mOriginalQueue) {
                b.append(' ');
                b.append(req.packageName);
            }
            b.append(" ]");
            BackupManagerService.this.addBackupTrace(b.toString());
            this.mStatus = 0;
            if (this.mOriginalQueue.isEmpty()) {
                Slog.w(TAG, "Backup begun with an empty queue - nothing to do.");
                BackupManagerService.this.addBackupTrace("queue empty at begin");
                this.executeNextState(BackupState.FINAL);
                return;
            }
            this.mQueue = (ArrayList)this.mOriginalQueue.clone();
            Slog.v(TAG, "Beginning backup of " + this.mQueue.size() + " targets");
            File pmState = new File(this.mStateDir, BackupManagerService.PACKAGE_MANAGER_SENTINEL);
            try {
                String transportName = this.mTransport.transportDirName();
                EventLog.writeEvent(2821, transportName);
                if (this.mStatus == 0 && pmState.length() <= 0L) {
                    Slog.i(TAG, "Initializing (wiping) backup state and transport storage");
                    BackupManagerService.this.addBackupTrace("initializing transport " + transportName);
                    BackupManagerService.this.resetBackupState(this.mStateDir);
                    this.mStatus = this.mTransport.initializeDevice();
                    BackupManagerService.this.addBackupTrace("transport.initializeDevice() == " + this.mStatus);
                    if (this.mStatus == 0) {
                        EventLog.writeEvent(2827, new Object[0]);
                    } else {
                        EventLog.writeEvent(2822, "(initialize)");
                        Slog.e(TAG, "Transport error in initializeDevice()");
                    }
                }
                if (this.mStatus == 0) {
                    PackageManagerBackupAgent pmAgent = new PackageManagerBackupAgent(BackupManagerService.this.mPackageManager, BackupManagerService.this.allAgentPackages());
                    this.mStatus = this.invokeAgentForBackup(BackupManagerService.PACKAGE_MANAGER_SENTINEL, IBackupAgent.Stub.asInterface(pmAgent.onBind()), this.mTransport);
                    BackupManagerService.this.addBackupTrace("PMBA invoke: " + this.mStatus);
                }
                if (this.mStatus == 2) {
                    EventLog.writeEvent(2826, this.mTransport.transportDirName());
                }
            }
            catch (Exception e) {
                Slog.e(TAG, "Error in backup thread", e);
                BackupManagerService.this.addBackupTrace("Exception in backup thread: " + e);
                this.mStatus = 1;
            }
            finally {
                BackupManagerService.this.addBackupTrace("exiting prelim: " + this.mStatus);
                if (this.mStatus != 0) {
                    BackupManagerService.this.resetBackupState(this.mStateDir);
                    this.executeNextState(BackupState.FINAL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void invokeNextAgent() {
            BackupRequest request;
            block42: {
                block41: {
                    block38: {
                        BackupState nextState2;
                        block43: {
                            block39: {
                                block40: {
                                    this.mStatus = 0;
                                    BackupManagerService.this.addBackupTrace("invoke q=" + this.mQueue.size());
                                    if (this.mQueue.isEmpty()) {
                                        Slog.i(TAG, "queue now empty");
                                        this.executeNextState(BackupState.FINAL);
                                        return;
                                    }
                                    request = this.mQueue.get(0);
                                    this.mQueue.remove(0);
                                    Slog.d(TAG, "starting agent for backup of " + request);
                                    BackupManagerService.this.addBackupTrace("launch agent for " + request.packageName);
                                    try {
                                        try {
                                            this.mCurrentPackage = BackupManagerService.this.mPackageManager.getPackageInfo(request.packageName, 64);
                                            if (this.mCurrentPackage.applicationInfo.backupAgentName == null) {
                                                Slog.i(TAG, "Package " + request.packageName + " no longer supports backup; skipping");
                                                BackupManagerService.this.addBackupTrace("skipping - no agent, completion is noop");
                                                this.executeNextState(BackupState.RUNNING_QUEUE);
                                                Object var5_2 = null;
                                                BackupManagerService.this.mWakelock.setWorkSource(null);
                                                if (this.mStatus == 0) break block38;
                                                nextState2 = BackupState.RUNNING_QUEUE;
                                                if (this.mStatus != 3) break block39;
                                                break block40;
                                            }
                                            if ((this.mCurrentPackage.applicationInfo.flags & 0x200000) != 0) {
                                                BackupManagerService.this.addBackupTrace("skipping - stopped");
                                                this.executeNextState(BackupState.RUNNING_QUEUE);
                                                break block41;
                                            }
                                            IBackupAgent agent = null;
                                            try {
                                                BackupManagerService.this.mWakelock.setWorkSource(new WorkSource(this.mCurrentPackage.applicationInfo.uid));
                                                agent = BackupManagerService.this.bindToAgentSynchronous(this.mCurrentPackage.applicationInfo, 0);
                                                BackupManagerService.this.addBackupTrace("agent bound; a? = " + (agent != null));
                                                if (agent != null) {
                                                    this.mStatus = this.invokeAgentForBackup(request.packageName, agent, this.mTransport);
                                                    break block42;
                                                }
                                                this.mStatus = 3;
                                            }
                                            catch (SecurityException ex) {
                                                Slog.d(TAG, "error in bind/backup", ex);
                                                this.mStatus = 3;
                                                BackupManagerService.this.addBackupTrace("agent SE");
                                            }
                                            break block42;
                                        }
                                        catch (PackageManager.NameNotFoundException e) {
                                            Slog.d(TAG, "Package does not exist; skipping");
                                            BackupManagerService.this.addBackupTrace("no such package");
                                            this.mStatus = 4;
                                            Object var5_5 = null;
                                            BackupManagerService.this.mWakelock.setWorkSource(null);
                                            if (this.mStatus == 0) {
                                                BackupManagerService.this.addBackupTrace("expecting completion/timeout callback");
                                                return;
                                            }
                                            BackupState nextState2 = BackupState.RUNNING_QUEUE;
                                            if (this.mStatus == 3) {
                                                BackupManagerService.this.dataChangedImpl(request.packageName);
                                                this.mStatus = 0;
                                                if (this.mQueue.isEmpty()) {
                                                    nextState2 = BackupState.FINAL;
                                                }
                                            } else if (this.mStatus == 4) {
                                                this.mStatus = 0;
                                            } else {
                                                this.revertAndEndBackup();
                                                nextState2 = BackupState.FINAL;
                                            }
                                            this.executeNextState(nextState2);
                                            return;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_6 = null;
                                        BackupManagerService.this.mWakelock.setWorkSource(null);
                                        if (this.mStatus == 0) {
                                            BackupManagerService.this.addBackupTrace("expecting completion/timeout callback");
                                            throw throwable;
                                        }
                                        BackupState nextState2 = BackupState.RUNNING_QUEUE;
                                        if (this.mStatus == 3) {
                                            BackupManagerService.this.dataChangedImpl(request.packageName);
                                            this.mStatus = 0;
                                            if (this.mQueue.isEmpty()) {
                                                nextState2 = BackupState.FINAL;
                                            }
                                        } else if (this.mStatus == 4) {
                                            this.mStatus = 0;
                                        } else {
                                            this.revertAndEndBackup();
                                            nextState2 = BackupState.FINAL;
                                        }
                                        this.executeNextState(nextState2);
                                        throw throwable;
                                    }
                                }
                                BackupManagerService.this.dataChangedImpl(request.packageName);
                                this.mStatus = 0;
                                if (this.mQueue.isEmpty()) {
                                    nextState2 = BackupState.FINAL;
                                }
                                break block43;
                            }
                            if (this.mStatus == 4) {
                                this.mStatus = 0;
                            } else {
                                this.revertAndEndBackup();
                                nextState2 = BackupState.FINAL;
                            }
                        }
                        this.executeNextState(nextState2);
                        return;
                    }
                    BackupManagerService.this.addBackupTrace("expecting completion/timeout callback");
                    return;
                }
                Object var5_3 = null;
                BackupManagerService.this.mWakelock.setWorkSource(null);
                if (this.mStatus != 0) {
                    BackupState nextState2 = BackupState.RUNNING_QUEUE;
                    if (this.mStatus == 3) {
                        BackupManagerService.this.dataChangedImpl(request.packageName);
                        this.mStatus = 0;
                        if (this.mQueue.isEmpty()) {
                            nextState2 = BackupState.FINAL;
                        }
                    } else if (this.mStatus == 4) {
                        this.mStatus = 0;
                    } else {
                        this.revertAndEndBackup();
                        nextState2 = BackupState.FINAL;
                    }
                    this.executeNextState(nextState2);
                    return;
                }
                BackupManagerService.this.addBackupTrace("expecting completion/timeout callback");
                return;
            }
            Object var5_4 = null;
            BackupManagerService.this.mWakelock.setWorkSource(null);
            if (this.mStatus != 0) {
                BackupState nextState2 = BackupState.RUNNING_QUEUE;
                if (this.mStatus == 3) {
                    BackupManagerService.this.dataChangedImpl(request.packageName);
                    this.mStatus = 0;
                    if (this.mQueue.isEmpty()) {
                        nextState2 = BackupState.FINAL;
                    }
                } else if (this.mStatus == 4) {
                    this.mStatus = 0;
                } else {
                    this.revertAndEndBackup();
                    nextState2 = BackupState.FINAL;
                }
                this.executeNextState(nextState2);
                return;
            }
            BackupManagerService.this.addBackupTrace("expecting completion/timeout callback");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finalizeBackup() {
            BackupManagerService.this.addBackupTrace("finishing");
            if (this.mJournal != null && !this.mJournal.delete()) {
                Slog.e(TAG, "Unable to remove backup journal file " + this.mJournal);
            }
            if (BackupManagerService.this.mCurrentToken == 0L && this.mStatus == 0) {
                BackupManagerService.this.addBackupTrace("success; recording token");
                try {
                    BackupManagerService.this.mCurrentToken = this.mTransport.getCurrentRestoreSet();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                BackupManagerService.this.writeRestoreTokens();
            }
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                BackupManagerService.this.mBackupRunning = false;
                if (this.mStatus == 2) {
                    this.clearMetadata();
                    Slog.d(TAG, "Server requires init; rerunning");
                    BackupManagerService.this.addBackupTrace("init required; rerunning");
                    BackupManagerService.this.backupNow();
                }
            }
            BackupManagerService.this.clearBackupTrace();
            Slog.i(TAG, "Backup pass finished.");
            BackupManagerService.this.mWakelock.release();
        }

        void clearMetadata() {
            File pmState = new File(this.mStateDir, BackupManagerService.PACKAGE_MANAGER_SENTINEL);
            if (pmState.exists()) {
                pmState.delete();
            }
        }

        int invokeAgentForBackup(String packageName, IBackupAgent agent, IBackupTransport transport) {
            Slog.d(TAG, "invokeAgentForBackup on " + packageName);
            BackupManagerService.this.addBackupTrace("invoking " + packageName);
            this.mSavedStateName = new File(this.mStateDir, packageName);
            this.mBackupDataName = new File(BackupManagerService.this.mDataDir, packageName + ".data");
            this.mNewStateName = new File(this.mStateDir, packageName + ".new");
            this.mSavedState = null;
            this.mBackupData = null;
            this.mNewState = null;
            int token = BackupManagerService.this.generateToken();
            try {
                if (packageName.equals(BackupManagerService.PACKAGE_MANAGER_SENTINEL)) {
                    this.mCurrentPackage = new PackageInfo();
                    this.mCurrentPackage.packageName = packageName;
                }
                this.mSavedState = ParcelFileDescriptor.open(this.mSavedStateName, 0x18000000);
                this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x3C000000);
                if (!SELinux.restorecon(this.mBackupDataName)) {
                    Slog.e(TAG, "SELinux restorecon failed on " + this.mBackupDataName);
                }
                this.mNewState = ParcelFileDescriptor.open(this.mNewStateName, 0x3C000000);
                BackupManagerService.this.addBackupTrace("setting timeout");
                BackupManagerService.this.prepareOperationTimeout(token, 30000L, this);
                BackupManagerService.this.addBackupTrace("calling agent doBackup()");
                agent.doBackup(this.mSavedState, this.mBackupData, this.mNewState, token, BackupManagerService.this.mBackupManagerBinder);
            }
            catch (Exception e) {
                Slog.e(TAG, "Error invoking for backup on " + packageName);
                BackupManagerService.this.addBackupTrace("exception: " + e);
                EventLog.writeEvent(2823, packageName, e.toString());
                this.agentErrorCleanup();
                return 3;
            }
            BackupManagerService.this.addBackupTrace("invoke success");
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void operationComplete() {
            BackupState nextState;
            block19: {
                ParcelFileDescriptor backupData;
                block18: {
                    BackupManagerService.this.mBackupHandler.removeMessages(7);
                    this.clearAgentState();
                    BackupManagerService.this.addBackupTrace("operation complete");
                    backupData = null;
                    this.mStatus = 0;
                    int size = (int)this.mBackupDataName.length();
                    if (size > 0) {
                        if (this.mStatus == 0) {
                            backupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
                            BackupManagerService.this.addBackupTrace("sending data to transport");
                            this.mStatus = this.mTransport.performBackup(this.mCurrentPackage, backupData);
                        }
                        BackupManagerService.this.addBackupTrace("data delivered: " + this.mStatus);
                        if (this.mStatus == 0) {
                            BackupManagerService.this.addBackupTrace("finishing op on transport");
                            this.mStatus = this.mTransport.finishBackup();
                            BackupManagerService.this.addBackupTrace("finished: " + this.mStatus);
                        }
                    } else {
                        Slog.i(TAG, "no backup data written; not calling transport");
                        BackupManagerService.this.addBackupTrace("no data to send");
                    }
                    if (this.mStatus == 0) {
                        this.mBackupDataName.delete();
                        this.mNewStateName.renameTo(this.mSavedStateName);
                        EventLog.writeEvent(2824, this.mCurrentPackage.packageName, size);
                        BackupManagerService.this.logBackupComplete(this.mCurrentPackage.packageName);
                        break block18;
                    }
                    EventLog.writeEvent(2822, this.mCurrentPackage.packageName);
                }
                Object var4_5 = null;
                try {
                    if (backupData != null) {
                        backupData.close();
                    }
                    break block19;
                }
                catch (IOException e2) {}
                break block19;
                {
                    catch (Exception e) {
                        Slog.e(TAG, "Transport error backing up " + this.mCurrentPackage.packageName, e);
                        EventLog.writeEvent(2822, this.mCurrentPackage.packageName);
                        this.mStatus = 1;
                        Object var4_6 = null;
                        try {
                            if (backupData != null) {
                                backupData.close();
                            }
                            break block19;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    try {
                        if (backupData != null) {
                            backupData.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (this.mStatus != 0) {
                this.revertAndEndBackup();
                nextState = BackupState.FINAL;
            } else {
                nextState = this.mQueue.isEmpty() ? BackupState.FINAL : BackupState.RUNNING_QUEUE;
            }
            this.executeNextState(nextState);
        }

        @Override
        public void handleTimeout() {
            Slog.e(TAG, "Timeout backing up " + this.mCurrentPackage.packageName);
            EventLog.writeEvent(2823, this.mCurrentPackage.packageName, "timeout");
            BackupManagerService.this.addBackupTrace("timeout of " + this.mCurrentPackage.packageName);
            this.agentErrorCleanup();
            BackupManagerService.this.dataChangedImpl(this.mCurrentPackage.packageName);
        }

        void revertAndEndBackup() {
            BackupManagerService.this.addBackupTrace("transport error; reverting");
            for (BackupRequest request : this.mOriginalQueue) {
                BackupManagerService.this.dataChangedImpl(request.packageName);
            }
            this.restartBackupAlarm();
        }

        void agentErrorCleanup() {
            this.mBackupDataName.delete();
            this.mNewStateName.delete();
            this.clearAgentState();
            this.executeNextState(this.mQueue.isEmpty() ? BackupState.FINAL : BackupState.RUNNING_QUEUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearAgentState() {
            try {
                if (this.mSavedState != null) {
                    this.mSavedState.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.mBackupData != null) {
                    this.mBackupData.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.mNewState != null) {
                    this.mNewState.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.mNewState = null;
            this.mBackupData = null;
            this.mSavedState = null;
            Object e = BackupManagerService.this.mCurrentOpLock;
            synchronized (e) {
                BackupManagerService.this.mCurrentOperations.clear();
            }
            if (this.mCurrentPackage.applicationInfo != null) {
                BackupManagerService.this.addBackupTrace("unbinding " + this.mCurrentPackage.packageName);
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(this.mCurrentPackage.applicationInfo);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartBackupAlarm() {
            BackupManagerService.this.addBackupTrace("setting backup trigger");
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                try {
                    BackupManagerService.this.startBackupAlarmsLocked(this.mTransport.requestBackupTime());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        void executeNextState(BackupState nextState) {
            BackupManagerService.this.addBackupTrace("executeNextState => " + (Object)((Object)nextState));
            this.mCurrentState = nextState;
            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(20, this);
            BackupManagerService.this.mBackupHandler.sendMessage(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BackupState {
        INITIAL,
        RUNNING_QUEUE,
        FINAL;

    }

    static interface BackupRestoreTask {
        public void execute();

        public void operationComplete();

        public void handleTimeout();
    }

    class ClearDataObserver
    extends IPackageDataObserver.Stub {
        ClearDataObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRemoveCompleted(String packageName, boolean succeeded) {
            Object object = BackupManagerService.this.mClearDataLock;
            synchronized (object) {
                BackupManagerService.this.mClearingData = false;
                BackupManagerService.this.mClearDataLock.notifyAll();
            }
        }
    }

    class TransportConnection
    implements ServiceConnection {
        TransportConnection() {
        }

        public void onServiceConnected(ComponentName component, IBinder service) {
            Slog.v(BackupManagerService.TAG, "Connected to transport " + component);
            try {
                IBackupTransport transport = IBackupTransport.Stub.asInterface(service);
                BackupManagerService.this.registerTransport(transport.name(), component.flattenToShortString(), transport);
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Unable to register transport " + component);
            }
        }

        public void onServiceDisconnected(ComponentName component) {
            Slog.v(BackupManagerService.TAG, "Disconnected from transport " + component);
            BackupManagerService.this.registerTransport(null, component.flattenToShortString(), null);
        }
    }

    private class RunInitializeReceiver
    extends BroadcastReceiver {
        private RunInitializeReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (BackupManagerService.RUN_INITIALIZE_ACTION.equals(intent.getAction())) {
                Object object = BackupManagerService.this.mQueueLock;
                synchronized (object) {
                    Slog.v(BackupManagerService.TAG, "Running a device init");
                    BackupManagerService.this.mWakelock.acquire();
                    Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(5);
                    BackupManagerService.this.mBackupHandler.sendMessage(msg);
                }
            }
        }
    }

    private class RunBackupReceiver
    extends BroadcastReceiver {
        private RunBackupReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (BackupManagerService.RUN_BACKUP_ACTION.equals(intent.getAction())) {
                Object object = BackupManagerService.this.mQueueLock;
                synchronized (object) {
                    if (BackupManagerService.this.mPendingInits.size() > 0) {
                        Slog.v(BackupManagerService.TAG, "Init pending at scheduled backup");
                        try {
                            BackupManagerService.this.mAlarmManager.cancel(BackupManagerService.this.mRunInitIntent);
                            BackupManagerService.this.mRunInitIntent.send();
                        }
                        catch (PendingIntent.CanceledException ce) {
                            Slog.e(BackupManagerService.TAG, "Run init intent cancelled");
                        }
                    } else if (BackupManagerService.this.mEnabled && BackupManagerService.this.mProvisioned) {
                        if (!BackupManagerService.this.mBackupRunning) {
                            Slog.v(BackupManagerService.TAG, "Running a backup pass");
                            BackupManagerService.this.mBackupRunning = true;
                            BackupManagerService.this.mWakelock.acquire();
                            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(1);
                            BackupManagerService.this.mBackupHandler.sendMessage(msg);
                        } else {
                            Slog.i(BackupManagerService.TAG, "Backup time but one already running");
                        }
                    } else {
                        Slog.w(BackupManagerService.TAG, "Backup pass but e=" + BackupManagerService.this.mEnabled + " p=" + BackupManagerService.this.mProvisioned);
                    }
                }
            }
        }
    }

    private class BackupHandler
    extends Handler {
        public BackupHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BackupManagerService.this.mLastBackupPass = System.currentTimeMillis();
                    BackupManagerService.this.mNextBackupPass = BackupManagerService.this.mLastBackupPass + 3600000L;
                    IBackupTransport transport = BackupManagerService.this.getTransport(BackupManagerService.this.mCurrentTransport);
                    if (transport == null) {
                        Slog.v(BackupManagerService.TAG, "Backup requested but no transport available");
                        Object object = BackupManagerService.this.mQueueLock;
                        synchronized (object) {
                            BackupManagerService.this.mBackupRunning = false;
                        }
                        BackupManagerService.this.mWakelock.release();
                        break;
                    }
                    ArrayList<BackupRequest> queue = new ArrayList<BackupRequest>();
                    File oldJournal = BackupManagerService.this.mJournal;
                    Object object = BackupManagerService.this.mQueueLock;
                    synchronized (object) {
                        if (BackupManagerService.this.mPendingBackups.size() > 0) {
                            for (BackupRequest b : BackupManagerService.this.mPendingBackups.values()) {
                                queue.add(b);
                            }
                            Slog.v(BackupManagerService.TAG, "clearing pending backups");
                            BackupManagerService.this.mPendingBackups.clear();
                            BackupManagerService.this.mJournal = null;
                        }
                    }
                    if (queue.size() > 0) {
                        PerformBackupTask pbt = new PerformBackupTask(transport, queue, oldJournal);
                        Message pbtMessage = this.obtainMessage(20, pbt);
                        this.sendMessage(pbtMessage);
                        break;
                    }
                    Slog.v(BackupManagerService.TAG, "Backup requested but nothing pending");
                    object = BackupManagerService.this.mQueueLock;
                    synchronized (object) {
                        BackupManagerService.this.mBackupRunning = false;
                    }
                    BackupManagerService.this.mWakelock.release();
                    break;
                }
                case 20: {
                    try {
                        BackupRestoreTask task = (BackupRestoreTask)msg.obj;
                        task.execute();
                    }
                    catch (ClassCastException e) {
                        Slog.e(BackupManagerService.TAG, "Invalid backup task in flight, obj=" + msg.obj);
                    }
                    break;
                }
                case 21: {
                    try {
                        BackupRestoreTask task = (BackupRestoreTask)msg.obj;
                        task.operationComplete();
                    }
                    catch (ClassCastException e) {
                        Slog.e(BackupManagerService.TAG, "Invalid completion in flight, obj=" + msg.obj);
                    }
                    break;
                }
                case 2: {
                    FullBackupParams params = (FullBackupParams)msg.obj;
                    PerformFullBackupTask task = new PerformFullBackupTask(params.fd, params.observer, params.includeApks, params.includeObbs, params.includeShared, params.curPassword, params.encryptPassword, params.allApps, params.includeSystem, params.packages, params.latch);
                    new Thread(task).start();
                    break;
                }
                case 3: {
                    RestoreParams params = (RestoreParams)msg.obj;
                    Slog.d(BackupManagerService.TAG, "MSG_RUN_RESTORE observer=" + params.observer);
                    PerformRestoreTask task = new PerformRestoreTask(params.transport, params.observer, params.token, params.pkgInfo, params.pmToken, params.needFullBackup, params.filterSet);
                    Message restoreMsg = this.obtainMessage(20, task);
                    this.sendMessage(restoreMsg);
                    break;
                }
                case 10: {
                    FullRestoreParams params = (FullRestoreParams)msg.obj;
                    PerformFullRestoreTask task = new PerformFullRestoreTask(params.fd, params.curPassword, params.encryptPassword, params.observer, params.latch);
                    new Thread(task).start();
                    break;
                }
                case 4: {
                    ClearParams params = (ClearParams)msg.obj;
                    new PerformClearTask(params.transport, params.packageInfo).run();
                    break;
                }
                case 5: {
                    HashSet<String> queue;
                    Object task = BackupManagerService.this.mQueueLock;
                    synchronized (task) {
                        queue = new HashSet<String>(BackupManagerService.this.mPendingInits);
                        BackupManagerService.this.mPendingInits.clear();
                    }
                    new PerformInitializeTask(queue).run();
                    break;
                }
                case 6: {
                    RestoreSet[] sets = null;
                    RestoreGetSetsParams params = (RestoreGetSetsParams)msg.obj;
                    try {
                        sets = params.transport.getAvailableRestoreSets();
                        ActiveRestoreSession restoreMsg = params.session;
                        synchronized (restoreMsg) {
                            params.session.mRestoreSets = sets;
                        }
                        if (sets != null) break;
                        EventLog.writeEvent(2831, new Object[0]);
                        break;
                    }
                    catch (Exception e) {
                        Slog.e(BackupManagerService.TAG, "Error from transport getting set list");
                        break;
                    }
                    finally {
                        if (params.observer != null) {
                            try {
                                params.observer.restoreSetsAvailable(sets);
                            }
                            catch (RemoteException re) {
                                Slog.e(BackupManagerService.TAG, "Unable to report listing to observer");
                            }
                            catch (Exception e) {
                                Slog.e(BackupManagerService.TAG, "Restore observer threw", e);
                            }
                        }
                        this.removeMessages(8);
                        this.sendEmptyMessageDelayed(8, 60000L);
                        BackupManagerService.this.mWakelock.release();
                    }
                }
                case 7: {
                    BackupManagerService.this.handleTimeout(msg.arg1, msg.obj);
                    break;
                }
                case 8: {
                    Object object = BackupManagerService.this;
                    synchronized (object) {
                        if (BackupManagerService.this.mActiveRestoreSession != null) {
                            Slog.w(BackupManagerService.TAG, "Restore session timed out; aborting");
                            ActiveRestoreSession activeRestoreSession = BackupManagerService.this.mActiveRestoreSession;
                            activeRestoreSession.getClass();
                            this.post(activeRestoreSession.new ActiveRestoreSession.EndRestoreRunnable(BackupManagerService.this, BackupManagerService.this.mActiveRestoreSession));
                        }
                    }
                }
                case 9: {
                    Object object = BackupManagerService.this.mFullConfirmations;
                    synchronized (object) {
                        FullParams params = BackupManagerService.this.mFullConfirmations.get(msg.arg1);
                        if (params != null) {
                            Slog.i(BackupManagerService.TAG, "Full backup/restore timed out waiting for user confirmation");
                            BackupManagerService.this.signalFullBackupRestoreCompletion(params);
                            BackupManagerService.this.mFullConfirmations.delete(msg.arg1);
                            if (params.observer != null) {
                                try {
                                    params.observer.onTimeout();
                                }
                                catch (RemoteException e) {}
                            }
                        } else {
                            Slog.d(BackupManagerService.TAG, "couldn't find params for token " + msg.arg1);
                        }
                        break;
                    }
                }
            }
        }
    }

    class Operation {
        public int state;
        public BackupRestoreTask callback;

        Operation(int initialState, BackupRestoreTask callbackObj) {
            this.state = initialState;
            this.callback = callbackObj;
        }
    }

    class FullRestoreParams
    extends FullParams {
        FullRestoreParams(ParcelFileDescriptor input) {
            this.fd = input;
        }
    }

    class FullBackupParams
    extends FullParams {
        public boolean includeApks;
        public boolean includeObbs;
        public boolean includeShared;
        public boolean allApps;
        public boolean includeSystem;
        public String[] packages;

        FullBackupParams(ParcelFileDescriptor output, boolean saveApks, boolean saveObbs, boolean saveShared, boolean doAllApps, boolean doSystem, String[] pkgList) {
            this.fd = output;
            this.includeApks = saveApks;
            this.includeObbs = saveObbs;
            this.includeShared = saveShared;
            this.allApps = doAllApps;
            this.includeSystem = doSystem;
            this.packages = pkgList;
        }
    }

    class FullParams {
        public ParcelFileDescriptor fd;
        public final AtomicBoolean latch = new AtomicBoolean(false);
        public IFullBackupRestoreObserver observer;
        public String curPassword;
        public String encryptPassword;

        FullParams() {
        }
    }

    class ClearParams {
        public IBackupTransport transport;
        public PackageInfo packageInfo;

        ClearParams(IBackupTransport _transport, PackageInfo _info) {
            this.transport = _transport;
            this.packageInfo = _info;
        }
    }

    class RestoreParams {
        public IBackupTransport transport;
        public IRestoreObserver observer;
        public long token;
        public PackageInfo pkgInfo;
        public int pmToken;
        public boolean needFullBackup;
        public String[] filterSet;

        RestoreParams(IBackupTransport _transport, IRestoreObserver _obs, long _token, PackageInfo _pkg, int _pmToken, boolean _needFullBackup) {
            this.transport = _transport;
            this.observer = _obs;
            this.token = _token;
            this.pkgInfo = _pkg;
            this.pmToken = _pmToken;
            this.needFullBackup = _needFullBackup;
            this.filterSet = null;
        }

        RestoreParams(IBackupTransport _transport, IRestoreObserver _obs, long _token, boolean _needFullBackup) {
            this.transport = _transport;
            this.observer = _obs;
            this.token = _token;
            this.pkgInfo = null;
            this.pmToken = 0;
            this.needFullBackup = _needFullBackup;
            this.filterSet = null;
        }

        RestoreParams(IBackupTransport _transport, IRestoreObserver _obs, long _token, String[] _filterSet, boolean _needFullBackup) {
            this.transport = _transport;
            this.observer = _obs;
            this.token = _token;
            this.pkgInfo = null;
            this.pmToken = 0;
            this.needFullBackup = _needFullBackup;
            this.filterSet = _filterSet;
        }
    }

    class RestoreGetSetsParams {
        public IBackupTransport transport;
        public ActiveRestoreSession session;
        public IRestoreObserver observer;

        RestoreGetSetsParams(IBackupTransport _transport, ActiveRestoreSession _session, IRestoreObserver _observer) {
            this.transport = _transport;
            this.session = _session;
            this.observer = _observer;
        }
    }

    class ProvisionedObserver
    extends ContentObserver {
        public ProvisionedObserver(Handler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            boolean wasProvisioned = BackupManagerService.this.mProvisioned;
            boolean isProvisioned = BackupManagerService.this.deviceIsProvisioned();
            BackupManagerService.this.mProvisioned = wasProvisioned || isProvisioned;
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                if (BackupManagerService.this.mProvisioned && !wasProvisioned && BackupManagerService.this.mEnabled) {
                    BackupManagerService.this.startBackupAlarmsLocked(43200000L);
                }
            }
        }
    }

    class BackupRequest {
        public String packageName;

        BackupRequest(String pkgName) {
            this.packageName = pkgName;
        }

        public String toString() {
            return "BackupRequest{pkg=" + this.packageName + "}";
        }
    }
}

