/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothTetheringDataTracker;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.CaptivePortalTracker;
import android.net.ConnectivityManager;
import android.net.DummyDataStateTracker;
import android.net.EthernetDataTracker;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.MobileDataStateTracker;
import android.net.NetworkConfig;
import android.net.NetworkInfo;
import android.net.NetworkQuotaInfo;
import android.net.NetworkState;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.ProxyProperties;
import android.net.RouteInfo;
import android.net.SamplingDataTracker;
import android.net.Uri;
import android.net.wifi.WifiStateTracker;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.security.KeyStore;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.XmlUtils;
import com.android.server.EventLogTags;
import com.android.server.am.BatteryStatsService;
import com.android.server.connectivity.DataConnectionStats;
import com.android.server.connectivity.Nat464Xlat;
import com.android.server.connectivity.PacManager;
import com.android.server.connectivity.Tethering;
import com.android.server.connectivity.Vpn;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.LockdownVpnTracker;
import com.google.android.collect.Lists;
import com.google.android.collect.Sets;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectivityService
extends IConnectivityManager.Stub {
    private static final String TAG = "ConnectivityService";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean LOGD_RULES = false;
    private static final int RESTORE_DEFAULT_NETWORK_DELAY = 60000;
    private static final String NETWORK_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    private static final int DEFAULT_FAIL_FAST_TIME_MS = 60000;
    private static final String FAIL_FAST_TIME_MS = "persist.radio.fail_fast_time_ms";
    private static final String ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED = "android.net.ConnectivityService.action.PKT_CNT_SAMPLE_INTERVAL_ELAPSED";
    private static final int SAMPLE_INTERVAL_ELAPSED_REQUEST_CODE = 0;
    private PendingIntent mSampleIntervalElapsedIntent;
    private static final int DEFAULT_SAMPLING_INTERVAL_IN_SECONDS = 720;
    private static final int DEFAULT_START_SAMPLING_INTERVAL_IN_SECONDS = 60;
    AlarmManager mAlarmManager;
    private static final int MAX_HOSTROUTE_CYCLE_COUNT = 10;
    private Tethering mTethering;
    private KeyStore mKeyStore;
    @GuardedBy(value="mVpns")
    private final SparseArray<Vpn> mVpns = new SparseArray();
    private VpnCallback mVpnCallback = new VpnCallback();
    private boolean mLockdownEnabled;
    private LockdownVpnTracker mLockdownTracker;
    private Nat464Xlat mClat;
    private Object mRulesLock = new Object();
    private SparseIntArray mUidRules = new SparseIntArray();
    private HashSet<String> mMeteredIfaces = Sets.newHashSet();
    private NetworkStateTracker[] mNetTrackers;
    private CaptivePortalTracker mCaptivePortalTracker;
    private LinkProperties[] mCurrentLinkProperties;
    private List<Integer>[] mNetRequestersPids;
    private int[] mPriorityList;
    private Context mContext;
    private int mNetworkPreference;
    private int mActiveDefaultNetwork = -1;
    private int mDefaultInetCondition = 0;
    private int mDefaultInetConditionPublished = 0;
    private boolean mInetConditionChangeInFlight = false;
    private int mDefaultConnectionSequence = 0;
    private Object mDnsLock = new Object();
    private int mNumDnsEntries;
    private boolean mTestMode;
    private static ConnectivityService sServiceInstance;
    private INetworkManagementService mNetd;
    private INetworkPolicyManager mPolicyManager;
    private static final int ENABLED = 1;
    private static final int DISABLED = 0;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;
    private static final boolean TO_DEFAULT_TABLE = true;
    private static final boolean TO_SECONDARY_TABLE = false;
    private static final boolean EXEMPT = true;
    private static final boolean UNEXEMPT = false;
    private static final int EVENT_RESTORE_DEFAULT_NETWORK = 1;
    private static final int EVENT_CHANGE_MOBILE_DATA_ENABLED = 2;
    private static final int EVENT_SET_NETWORK_PREFERENCE = 3;
    private static final int EVENT_INET_CONDITION_CHANGE = 4;
    private static final int EVENT_INET_CONDITION_HOLD_END = 5;
    private static final int EVENT_SET_MOBILE_DATA = 7;
    private static final int EVENT_CLEAR_NET_TRANSITION_WAKELOCK = 8;
    private static final int EVENT_APPLY_GLOBAL_HTTP_PROXY = 9;
    private static final int EVENT_SET_DEPENDENCY_MET = 10;
    private static final int EVENT_SEND_STICKY_BROADCAST_INTENT = 11;
    private static final int EVENT_SET_POLICY_DATA_ENABLE = 12;
    private static final int EVENT_VPN_STATE_CHANGED = 13;
    private static final int EVENT_ENABLE_FAIL_FAST_MOBILE_DATA = 14;
    private static final int EVENT_SAMPLE_INTERVAL_ELAPSED = 15;
    private static final int EVENT_PROXY_HAS_CHANGED = 16;
    private InternalHandler mHandler;
    private NetworkStateTrackerHandler mTrackerHandler;
    private List<FeatureUser> mFeatureUsers;
    private boolean mSystemReady;
    private Intent mInitialBroadcast;
    private PowerManager.WakeLock mNetTransitionWakeLock;
    private String mNetTransitionWakeLockCausedBy = "";
    private int mNetTransitionWakeLockSerialNumber;
    private int mNetTransitionWakeLockTimeout;
    private InetAddress mDefaultDns;
    private final Object mRoutesLock = new Object();
    @GuardedBy(value="mRoutesLock")
    private Collection<RouteInfo> mAddedRoutes = new ArrayList<RouteInfo>();
    @GuardedBy(value="mRoutesLock")
    private Collection<LinkAddress> mExemptAddresses = new ArrayList<LinkAddress>();
    private static final int INET_CONDITION_LOG_MAX_SIZE = 15;
    private ArrayList mInetLog;
    private ProxyProperties mDefaultProxy = null;
    private Object mProxyLock = new Object();
    private boolean mDefaultProxyDisabled = false;
    private ProxyProperties mGlobalProxy = null;
    private PacManager mPacManager = null;
    private SettingsObserver mSettingsObserver;
    NetworkConfig[] mNetConfigs;
    int mNetworksDefined;
    RadioAttributes[] mRadioAttributes;
    List mProtectedNetworks;
    private DataConnectionStats mDataConnectionStats;
    private AtomicInteger mEnableFailFastMobileDataTag = new AtomicInteger(0);
    TelephonyManager mTelephonyManager;
    private INetworkManagementEventObserver mDataActivityObserver = new BaseNetworkObserver(){

        public void interfaceClassDataActivityChanged(String label, boolean active) {
            int deviceType = Integer.parseInt(label);
            ConnectivityService.this.sendDataActivityBroadcast(deviceType, active);
        }
    };
    private INetworkPolicyListener mPolicyListener = new INetworkPolicyListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUidRulesChanged(int uid, int uidRules) {
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                int oldRules = ConnectivityService.this.mUidRules.get(uid, 0);
                if (oldRules == uidRules) {
                    return;
                }
                ConnectivityService.this.mUidRules.put(uid, uidRules);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMeteredIfacesChanged(String[] meteredIfaces) {
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                ConnectivityService.this.mMeteredIfaces.clear();
                for (String iface : meteredIfaces) {
                    ConnectivityService.this.mMeteredIfaces.add(iface);
                }
            }
        }

        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            NetworkInfo info;
            NetworkStateTracker tracker;
            int networkType = ConnectivityService.this.mActiveDefaultNetwork;
            if (ConnectivityManager.isNetworkTypeValid(networkType) && (tracker = ConnectivityService.this.mNetTrackers[networkType]) != null && (info = tracker.getNetworkInfo()) != null && info.isConnected()) {
                ConnectivityService.this.sendConnectedBroadcast(info);
            }
        }
    };
    private BroadcastReceiver mUserPresentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (ConnectivityService.this.updateLockdownVpn()) {
                ConnectivityService.this.mContext.unregisterReceiver(this);
            }
        }
    };
    private static final int CMP_RESULT_CODE_NO_CONNECTION = 0;
    private static final int CMP_RESULT_CODE_CONNECTABLE = 1;
    private static final int CMP_RESULT_CODE_NO_DNS = 2;
    private static final int CMP_RESULT_CODE_NO_TCP_CONNECTION = 3;
    private static final int CMP_RESULT_CODE_REDIRECTED = 4;
    private static final int CMP_RESULT_CODE_PROVISIONING_NETWORK = 5;
    private AtomicBoolean mIsCheckingMobileProvisioning = new AtomicBoolean(false);
    private static final String CONNECTED_TO_PROVISIONING_NETWORK_ACTION = "com.android.server.connectivityservice.CONNECTED_TO_PROVISIONING_NETWORK_ACTION";
    private BroadcastReceiver mProvisioningReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(ConnectivityService.CONNECTED_TO_PROVISIONING_NETWORK_ACTION)) {
                ConnectivityService.this.handleMobileProvisioningAction(intent.getStringExtra("EXTRA_URL"));
            }
        }
    };
    private static final String NOTIFICATION_ID = "CaptivePortal.Notification";
    private volatile boolean mIsNotificationVisible = false;
    private static final String PROVISIONING_URL_PATH = "/data/misc/radio/provisioning_urls.xml";
    private final File mProvisioningUrlFile = new File("/data/misc/radio/provisioning_urls.xml");
    private static final String TAG_PROVISIONING_URLS = "provisioningUrls";
    private static final String TAG_PROVISIONING_URL = "provisioningUrl";
    private static final String TAG_REDIRECTED_URL = "redirectedUrl";
    private static final String ATTR_MCC = "mcc";
    private static final String ATTR_MNC = "mnc";
    private static final int REDIRECTED_PROVISIONING = 1;
    private static final int PROVISIONING = 2;
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_STARTING".equals(action)) {
                ConnectivityService.this.onUserStart(userId);
            } else if ("android.intent.action.USER_STOPPING".equals(action)) {
                ConnectivityService.this.onUserStop(userId);
            }
        }
    };

    public ConnectivityService(Context context, INetworkManagementService netd, INetworkStatsService statsService, INetworkPolicyManager policyManager) {
        this(context, netd, statsService, policyManager, null);
    }

    public ConnectivityService(Context context, INetworkManagementService netManager, INetworkStatsService statsService, INetworkPolicyManager policyManager, NetworkFactory netFactory) {
        int[] protectedNetworks;
        String[] naStrings;
        String[] raStrings;
        String dns;
        String id2;
        ConnectivityService.log("ConnectivityService starting up");
        HandlerThread handlerThread = new HandlerThread("ConnectivityServiceThread");
        handlerThread.start();
        this.mHandler = new InternalHandler(handlerThread.getLooper());
        this.mTrackerHandler = new NetworkStateTrackerHandler(handlerThread.getLooper());
        if (netFactory == null) {
            netFactory = new DefaultNetworkFactory(context, this.mTrackerHandler);
        }
        if (TextUtils.isEmpty(SystemProperties.get("net.hostname")) && (id2 = Settings.Secure.getString(context.getContentResolver(), "android_id")) != null && id2.length() > 0) {
            String name = new String("android-").concat(id2);
            SystemProperties.set("net.hostname", name);
        }
        if ((dns = Settings.Global.getString(context.getContentResolver(), "default_dns_server")) == null || dns.length() == 0) {
            dns = context.getResources().getString(17039396);
        }
        try {
            this.mDefaultDns = NetworkUtils.numericToInetAddress(dns);
        }
        catch (IllegalArgumentException e) {
            ConnectivityService.loge("Error setting defaultDns using " + dns);
        }
        this.mContext = ConnectivityService.checkNotNull(context, "missing Context");
        this.mNetd = ConnectivityService.checkNotNull(netManager, "missing INetworkManagementService");
        this.mPolicyManager = ConnectivityService.checkNotNull(policyManager, "missing INetworkPolicyManager");
        this.mKeyStore = KeyStore.getInstance();
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        try {
            this.mPolicyManager.registerListener(this.mPolicyListener);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("unable to register INetworkPolicyListener" + e.toString());
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mNetTransitionWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetTransitionWakeLockTimeout = this.mContext.getResources().getInteger(17694733);
        this.mNetTrackers = new NetworkStateTracker[15];
        this.mCurrentLinkProperties = new LinkProperties[15];
        this.mRadioAttributes = new RadioAttributes[15];
        this.mNetConfigs = new NetworkConfig[15];
        for (String raString : raStrings = context.getResources().getStringArray(17235981)) {
            RadioAttributes r = new RadioAttributes(raString);
            if (r.mType > 14) {
                ConnectivityService.loge("Error in radioAttributes - ignoring attempt to define type " + r.mType);
                continue;
            }
            if (this.mRadioAttributes[r.mType] != null) {
                ConnectivityService.loge("Error in radioAttributes - ignoring attempt to redefine type " + r.mType);
                continue;
            }
            this.mRadioAttributes[r.mType] = r;
        }
        boolean wifiOnly = SystemProperties.getBoolean("ro.radio.noril", false);
        ConnectivityService.log("wifiOnly=" + wifiOnly);
        for (String naString : naStrings = context.getResources().getStringArray(17235979)) {
            try {
                NetworkConfig n = new NetworkConfig(naString);
                if (n.type > 14) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to define type " + n.type);
                    continue;
                }
                if (wifiOnly && ConnectivityManager.isNetworkTypeMobile(n.type)) {
                    ConnectivityService.log("networkAttributes - ignoring mobile as this dev is wifiOnly " + n.type);
                    continue;
                }
                if (this.mNetConfigs[n.type] != null) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to redefine type " + n.type);
                    continue;
                }
                if (this.mRadioAttributes[n.radio] == null) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to use undefined radio " + n.radio + " in network type " + n.type);
                    continue;
                }
                this.mNetConfigs[n.type] = n;
                ++this.mNetworksDefined;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.mProtectedNetworks = new ArrayList();
        for (int p : protectedNetworks = context.getResources().getIntArray(17235980)) {
            if (this.mNetConfigs[p] != null && !this.mProtectedNetworks.contains(p)) {
                this.mProtectedNetworks.add(p);
                continue;
            }
            ConnectivityService.loge("Ignoring protectedNetwork " + p);
        }
        this.mPriorityList = new int[this.mNetworksDefined];
        int insertionPoint = this.mNetworksDefined - 1;
        int currentLowest = 0;
        int nextLowest = 0;
        while (insertionPoint > -1) {
            for (NetworkConfig na : this.mNetConfigs) {
                if (na == null || na.priority < currentLowest) continue;
                if (na.priority > currentLowest) {
                    if (na.priority >= nextLowest && nextLowest != 0) continue;
                    nextLowest = na.priority;
                    continue;
                }
                this.mPriorityList[insertionPoint--] = na.type;
            }
            currentLowest = nextLowest;
            nextLowest = 0;
        }
        this.mNetworkPreference = this.getPersistedNetworkPreference();
        if (this.mNetworkPreference == -1) {
            for (int n : this.mPriorityList) {
                if (!this.mNetConfigs[n].isDefault() || !ConnectivityManager.isNetworkTypeValid(n)) continue;
                this.mNetworkPreference = n;
                break;
            }
            if (this.mNetworkPreference == -1) {
                throw new IllegalStateException("You should set at least one default Network in config.xml!");
            }
        }
        this.mNetRequestersPids = new ArrayList[15];
        for (int i : this.mPriorityList) {
            this.mNetRequestersPids[i] = new ArrayList<Integer>();
        }
        this.mFeatureUsers = new ArrayList<FeatureUser>();
        this.mTestMode = SystemProperties.get("cm.test.mode").equals("true") && SystemProperties.get("ro.build.type").equals("eng");
        for (int targetNetworkType : this.mPriorityList) {
            NetworkStateTracker tracker;
            NetworkConfig config = this.mNetConfigs[targetNetworkType];
            try {
                this.mNetTrackers[targetNetworkType] = tracker = netFactory.createTracker(targetNetworkType, config);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Problem creating " + ConnectivityManager.getNetworkTypeName(targetNetworkType) + " tracker: " + e);
                continue;
            }
            tracker.startMonitoring(context, this.mTrackerHandler);
            if (!config.isDefault()) continue;
            tracker.reconnect();
        }
        this.mTethering = new Tethering(this.mContext, this.mNetd, statsService, this, this.mHandler.getLooper());
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_STARTING");
        intentFilter.addAction("android.intent.action.USER_STOPPING");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        this.mClat = new Nat464Xlat(this.mContext, this.mNetd, this, this.mTrackerHandler);
        try {
            this.mNetd.registerObserver(this.mTethering);
            this.mNetd.registerObserver(this.mDataActivityObserver);
            this.mNetd.registerObserver(this.mClat);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("Error registering observer :" + e);
        }
        this.mInetLog = new ArrayList();
        this.mSettingsObserver = new SettingsObserver(this.mHandler, 9);
        this.mSettingsObserver.observe(this.mContext);
        this.mDataConnectionStats = new DataConnectionStats(this.mContext);
        this.mDataConnectionStats.startMonitoring();
        Intent intent = new Intent(ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED, null);
        this.mSampleIntervalElapsedIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.setAlarm(60000, this.mSampleIntervalElapsedIntent);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals(ConnectivityService.ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED)) {
                    ConnectivityService.this.mHandler.sendMessage(ConnectivityService.this.mHandler.obtainMessage(15));
                }
            }
        }, new IntentFilter(filter));
        this.mPacManager = new PacManager(this.mContext, this.mHandler, 16);
        filter = new IntentFilter();
        filter.addAction(CONNECTED_TO_PROVISIONING_NETWORK_ACTION);
        this.mContext.registerReceiver(this.mProvisioningReceiver, filter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NetworkStateTracker makeWimaxStateTracker(Context context, Handler trackerHandler) {
        Class<?> wimaxStateTrackerClass = null;
        Class<?> wimaxServiceClass = null;
        NetworkStateTracker wimaxStateTracker = null;
        boolean isWimaxEnabled = context.getResources().getBoolean(17891400);
        if (isWimaxEnabled) {
            try {
                String wimaxJarLocation = context.getResources().getString(17039409);
                String wimaxLibLocation = context.getResources().getString(17039410);
                String wimaxManagerClassName = context.getResources().getString(17039411);
                String wimaxServiceClassName = context.getResources().getString(17039412);
                String wimaxStateTrackerClassName = context.getResources().getString(17039413);
                ConnectivityService.log("wimaxJarLocation: " + wimaxJarLocation);
                DexClassLoader wimaxClassLoader = new DexClassLoader(wimaxJarLocation, new ContextWrapper(context).getCacheDir().getAbsolutePath(), wimaxLibLocation, ClassLoader.getSystemClassLoader());
                try {
                    Class<?> wimaxManagerClass = wimaxClassLoader.loadClass(wimaxManagerClassName);
                    wimaxStateTrackerClass = wimaxClassLoader.loadClass(wimaxStateTrackerClassName);
                    wimaxServiceClass = wimaxClassLoader.loadClass(wimaxServiceClassName);
                }
                catch (ClassNotFoundException ex) {
                    ConnectivityService.loge("Exception finding Wimax classes: " + ex.toString());
                    return null;
                }
            }
            catch (Resources.NotFoundException ex) {
                ConnectivityService.loge("Wimax Resources does not exist!!! ");
                return null;
            }
            try {
                ConnectivityService.log("Starting Wimax Service... ");
                Constructor<?> wmxStTrkrConst = wimaxStateTrackerClass.getConstructor(Context.class, Handler.class);
                wimaxStateTracker = (NetworkStateTracker)wmxStTrkrConst.newInstance(context, trackerHandler);
                Constructor<?> wmxSrvConst = wimaxServiceClass.getDeclaredConstructor(Context.class, wimaxStateTrackerClass);
                wmxSrvConst.setAccessible(true);
                IBinder svcInvoker = (IBinder)wmxSrvConst.newInstance(context, wimaxStateTracker);
                wmxSrvConst.setAccessible(false);
                ServiceManager.addService("WiMax", svcInvoker);
                return wimaxStateTracker;
            }
            catch (Exception ex) {
                ConnectivityService.loge("Exception creating Wimax classes: " + ex.toString());
                return null;
            }
        }
        ConnectivityService.loge("Wimax is not enabled or not added to the network attributes!!! ");
        return null;
    }

    @Override
    public void setNetworkPreference(int preference) {
        this.enforceChangePermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, preference, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNetworkPreference() {
        int preference;
        this.enforceAccessPermission();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            preference = this.mNetworkPreference;
        }
        return preference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetNetworkPreference(int preference) {
        if (ConnectivityManager.isNetworkTypeValid(preference) && this.mNetConfigs[preference] != null && this.mNetConfigs[preference].isDefault() && this.mNetworkPreference != preference) {
            ContentResolver cr = this.mContext.getContentResolver();
            Settings.Global.putInt(cr, "network_preference", preference);
            ConnectivityService connectivityService = this;
            synchronized (connectivityService) {
                this.mNetworkPreference = preference;
            }
            this.enforcePreference();
        }
    }

    private int getConnectivityChangeDelay() {
        ContentResolver cr = this.mContext.getContentResolver();
        int defaultDelay = SystemProperties.getInt("conn.connectivity_change_delay", 3000);
        return Settings.Global.getInt(cr, "connectivity_change_delay", defaultDelay);
    }

    private int getPersistedNetworkPreference() {
        ContentResolver cr = this.mContext.getContentResolver();
        int networkPrefSetting = Settings.Global.getInt(cr, "network_preference", -1);
        return networkPrefSetting;
    }

    private void enforcePreference() {
        if (this.mNetTrackers[this.mNetworkPreference].getNetworkInfo().isConnected()) {
            return;
        }
        if (!this.mNetTrackers[this.mNetworkPreference].isAvailable()) {
            return;
        }
        for (int t = 0; t <= 14; ++t) {
            if (t == this.mNetworkPreference || this.mNetTrackers[t] == null || !this.mNetTrackers[t].getNetworkInfo().isConnected()) continue;
            ConnectivityService.log("tearing down " + this.mNetTrackers[t].getNetworkInfo() + " in enforcePreference");
            this.teardown(this.mNetTrackers[t]);
        }
    }

    private boolean teardown(NetworkStateTracker netTracker) {
        if (netTracker.teardown()) {
            netTracker.setTeardownRequested(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNetworkBlocked(NetworkStateTracker tracker, int uid) {
        int uidRules;
        boolean networkCostly;
        String iface = tracker.getLinkProperties().getInterfaceName();
        Object object = this.mRulesLock;
        synchronized (object) {
            networkCostly = this.mMeteredIfaces.contains(iface);
            uidRules = this.mUidRules.get(uid, 0);
        }
        return networkCostly && (uidRules & 1) != 0;
    }

    private NetworkInfo getFilteredNetworkInfo(NetworkStateTracker tracker, int uid) {
        NetworkInfo info = tracker.getNetworkInfo();
        if (this.isNetworkBlocked(tracker, uid)) {
            info = new NetworkInfo(info);
            info.setDetailedState(NetworkInfo.DetailedState.BLOCKED, null, null);
        }
        if (this.mLockdownTracker != null) {
            info = this.mLockdownTracker.augmentNetworkInfo(info);
        }
        return info;
    }

    @Override
    public NetworkInfo getActiveNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        return this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
    }

    private NetworkInfo getProvisioningNetworkInfo() {
        this.enforceAccessPermission();
        NetworkInfo provNi = null;
        for (NetworkInfo ni : this.getAllNetworkInfo()) {
            if (!ni.isConnectedToProvisioningNetwork()) continue;
            provNi = ni;
            break;
        }
        ConnectivityService.log("getProvisioningNetworkInfo: X provNi=" + provNi);
        return provNi;
    }

    @Override
    public NetworkInfo getProvisioningOrActiveNetworkInfo() {
        this.enforceAccessPermission();
        NetworkInfo provNi = this.getProvisioningNetworkInfo();
        if (provNi == null) {
            int uid = Binder.getCallingUid();
            provNi = this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
        }
        ConnectivityService.log("getProvisioningOrActiveNetworkInfo: X provNi=" + provNi);
        return provNi;
    }

    public NetworkInfo getActiveNetworkInfoUnfiltered() {
        NetworkStateTracker tracker;
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(this.mActiveDefaultNetwork) && (tracker = this.mNetTrackers[this.mActiveDefaultNetwork]) != null) {
            return tracker.getNetworkInfo();
        }
        return null;
    }

    @Override
    public NetworkInfo getActiveNetworkInfoForUid(int uid) {
        this.enforceConnectivityInternalPermission();
        return this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
    }

    @Override
    public NetworkInfo getNetworkInfo(int networkType) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        return this.getNetworkInfo(networkType, uid);
    }

    private NetworkInfo getNetworkInfo(int networkType, int uid) {
        NetworkStateTracker tracker;
        NetworkInfo info = null;
        if (ConnectivityManager.isNetworkTypeValid(networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            info = this.getFilteredNetworkInfo(tracker, uid);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkInfo[] getAllNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        ArrayList<NetworkInfo> result = Lists.newArrayList();
        Object object = this.mRulesLock;
        synchronized (object) {
            for (NetworkStateTracker tracker : this.mNetTrackers) {
                if (tracker == null) continue;
                result.add(this.getFilteredNetworkInfo(tracker, uid));
            }
        }
        return result.toArray(new NetworkInfo[result.size()]);
    }

    @Override
    public boolean isNetworkSupported(int networkType) {
        this.enforceAccessPermission();
        return ConnectivityManager.isNetworkTypeValid(networkType) && this.mNetTrackers[networkType] != null;
    }

    @Override
    public LinkProperties getActiveLinkProperties() {
        return this.getLinkProperties(this.mActiveDefaultNetwork);
    }

    @Override
    public LinkProperties getLinkProperties(int networkType) {
        NetworkStateTracker tracker;
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            return tracker.getLinkProperties();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkState[] getAllNetworkState() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        ArrayList<NetworkState> result = Lists.newArrayList();
        Object object = this.mRulesLock;
        synchronized (object) {
            for (NetworkStateTracker tracker : this.mNetTrackers) {
                if (tracker == null) continue;
                NetworkInfo info = this.getFilteredNetworkInfo(tracker, uid);
                result.add(new NetworkState(info, tracker.getLinkProperties(), tracker.getLinkCapabilities()));
            }
        }
        return result.toArray(new NetworkState[result.size()]);
    }

    private NetworkState getNetworkStateUnchecked(int networkType) {
        NetworkStateTracker tracker;
        if (ConnectivityManager.isNetworkTypeValid(networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            return new NetworkState(tracker.getNetworkInfo(), tracker.getLinkProperties(), tracker.getLinkCapabilities());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        NetworkQuotaInfo networkQuotaInfo;
        long token;
        block8: {
            NetworkQuotaInfo networkQuotaInfo2;
            block7: {
                this.enforceAccessPermission();
                token = Binder.clearCallingIdentity();
                try {
                    block6: {
                        NetworkState state = this.getNetworkStateUnchecked(this.mActiveDefaultNetwork);
                        if (state != null) {
                            try {
                                networkQuotaInfo2 = this.mPolicyManager.getNetworkQuotaInfo(state);
                            }
                            catch (RemoteException e) {
                                // empty catch block
                                break block6;
                            }
                            Object var6_6 = null;
                            break block7;
                        }
                    }
                    networkQuotaInfo = null;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(token);
            return networkQuotaInfo2;
        }
        Object var6_7 = null;
        Binder.restoreCallingIdentity(token);
        return networkQuotaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActiveNetworkMetered() {
        boolean bl;
        this.enforceAccessPermission();
        long token = Binder.clearCallingIdentity();
        try {
            bl = this.isNetworkMeteredUnchecked(this.mActiveDefaultNetwork);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
        return bl;
    }

    private boolean isNetworkMeteredUnchecked(int networkType) {
        NetworkState state = this.getNetworkStateUnchecked(networkType);
        if (state != null) {
            try {
                return this.mPolicyManager.isNetworkMetered(state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean setRadios(boolean turnOn) {
        boolean result = true;
        this.enforceChangePermission();
        for (NetworkStateTracker t : this.mNetTrackers) {
            if (t == null) continue;
            result = t.setRadio(turnOn) && result;
        }
        return result;
    }

    @Override
    public boolean setRadio(int netType, boolean turnOn) {
        this.enforceChangePermission();
        if (!ConnectivityManager.isNetworkTypeValid(netType)) {
            return false;
        }
        NetworkStateTracker tracker = this.mNetTrackers[netType];
        return tracker != null && tracker.setRadio(turnOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int startUsingNetworkFeature(int networkType, String feature, IBinder binder) {
        int n;
        long startTime = 0L;
        startTime = SystemClock.elapsedRealtime();
        this.enforceChangePermission();
        try {
            if (!ConnectivityManager.isNetworkTypeValid(networkType) || this.mNetConfigs[networkType] == null) {
                int n2 = 3;
                Object var23_7 = null;
                long execTime = SystemClock.elapsedRealtime() - startTime;
                if (execTime <= 250L) return n2;
                ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                return n2;
            }
            FeatureUser f = new FeatureUser(networkType, feature, binder);
            int usedNetworkType = this.convertFeatureToNetworkType(networkType, feature);
            if (this.mLockdownEnabled) {
                int n3 = 2;
                Object var23_8 = null;
                long execTime = SystemClock.elapsedRealtime() - startTime;
                if (execTime <= 250L) return n3;
                ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                return n3;
            }
            if (this.mProtectedNetworks.contains(usedNetworkType)) {
                this.enforceConnectivityInternalPermission();
            }
            boolean networkMetered = this.isNetworkMeteredUnchecked(usedNetworkType);
            Object object = this.mRulesLock;
            // MONITORENTER : object
            int uidRules = this.mUidRules.get(Binder.getCallingUid(), 0);
            // MONITOREXIT : object
            if (networkMetered && (uidRules & 1) != 0) {
                int n4 = 3;
                Object var23_9 = null;
                long execTime = SystemClock.elapsedRealtime() - startTime;
                if (execTime <= 250L) return n4;
                ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                return n4;
            }
            NetworkStateTracker network = this.mNetTrackers[usedNetworkType];
            if (network != null) {
                Integer currentPid = new Integer(ConnectivityService.getCallingPid());
                if (usedNetworkType != networkType) {
                    NetworkInfo ni = network.getNetworkInfo();
                    if (!ni.isAvailable()) {
                        if (!TextUtils.equals(feature, "enableDUNAlways")) {
                            ConnectivityService.log("special network not available ni=" + ni.getTypeName());
                            int n5 = 2;
                            Object var23_10 = null;
                            long execTime = SystemClock.elapsedRealtime() - startTime;
                            if (execTime <= 250L) return n5;
                            ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                            return n5;
                        }
                        ConnectivityService.log("special network not available, but try anyway ni=" + ni.getTypeName());
                    }
                    int restoreTimer = this.getRestoreDefaultNetworkDelay(usedNetworkType);
                    ConnectivityService connectivityService = this;
                    // MONITORENTER : connectivityService
                    boolean addToList = true;
                    if (restoreTimer < 0) {
                        for (FeatureUser u : this.mFeatureUsers) {
                            if (!u.isSameUser(f)) continue;
                            addToList = false;
                            break;
                        }
                    }
                    if (addToList) {
                        this.mFeatureUsers.add(f);
                    }
                    if (!this.mNetRequestersPids[usedNetworkType].contains(currentPid)) {
                        this.mNetRequestersPids[usedNetworkType].add(currentPid);
                    }
                    // MONITOREXIT : connectivityService
                    if (restoreTimer >= 0) {
                        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, f), restoreTimer);
                    }
                    if (ni.isConnectedOrConnecting() && !network.isTeardownRequested()) {
                        if (ni.isConnected()) {
                            long token = Binder.clearCallingIdentity();
                            try {
                                this.handleDnsConfigurationChange(usedNetworkType);
                                Object var20_51 = null;
                                Binder.restoreCallingIdentity(token);
                            }
                            catch (Throwable throwable) {
                                Object var20_52 = null;
                                Binder.restoreCallingIdentity(token);
                                throw throwable;
                            }
                            int n6 = 0;
                            Object var23_11 = null;
                            long execTime = SystemClock.elapsedRealtime() - startTime;
                            if (execTime <= 250L) return n6;
                            ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                            return n6;
                        }
                        int n7 = 1;
                        Object var23_12 = null;
                        long execTime = SystemClock.elapsedRealtime() - startTime;
                        if (execTime <= 250L) return n7;
                        ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                        return n7;
                    }
                    ConnectivityService.log("startUsingNetworkFeature reconnecting to " + networkType + ": " + feature);
                    if (network.reconnect()) {
                        ConnectivityService.log("startUsingNetworkFeature X: return APN_REQUEST_STARTED");
                        int n8 = 1;
                        Object var23_13 = null;
                        long execTime = SystemClock.elapsedRealtime() - startTime;
                        if (execTime <= 250L) return n8;
                        ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                        return n8;
                    }
                    ConnectivityService.log("startUsingNetworkFeature X: return APN_REQUEST_FAILED");
                    int n9 = 3;
                    Object var23_14 = null;
                    long execTime = SystemClock.elapsedRealtime() - startTime;
                    if (execTime <= 250L) return n9;
                    ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                    return n9;
                }
                ConnectivityService connectivityService = this;
                // MONITORENTER : connectivityService
                this.mFeatureUsers.add(f);
                if (!this.mNetRequestersPids[usedNetworkType].contains(currentPid)) {
                    this.mNetRequestersPids[usedNetworkType].add(currentPid);
                }
                // MONITOREXIT : connectivityService
                ConnectivityService.log("startUsingNetworkFeature X: return -1 unsupported feature.");
                int n10 = -1;
                Object var23_15 = null;
                long execTime = SystemClock.elapsedRealtime() - startTime;
                if (execTime <= 250L) return n10;
                ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
                return n10;
            }
            ConnectivityService.log("startUsingNetworkFeature X: return APN_TYPE_NOT_AVAILABLE");
            n = 2;
            Object var23_16 = null;
        }
        catch (Throwable throwable) {
            Object var23_17 = null;
            long execTime = SystemClock.elapsedRealtime() - startTime;
            if (execTime <= 250L) throw throwable;
            ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
            throw throwable;
        }
        long execTime = SystemClock.elapsedRealtime() - startTime;
        if (execTime <= 250L) return n;
        ConnectivityService.loge("startUsingNetworkFeature took too long: " + execTime + "ms");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopUsingNetworkFeature(int networkType, String feature) {
        this.enforceChangePermission();
        int pid = ConnectivityService.getCallingPid();
        int uid = ConnectivityService.getCallingUid();
        FeatureUser u = null;
        boolean found = false;
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            for (FeatureUser x : this.mFeatureUsers) {
                if (!x.isSameUser(pid, uid, networkType, feature)) continue;
                u = x;
                found = true;
                break;
            }
        }
        if (found && u != null) {
            return this.stopUsingNetworkFeature(u, true);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopUsingNetworkFeature(FeatureUser u, boolean ignoreDups) {
        int networkType = u.mNetworkType;
        String feature = u.mFeature;
        int pid = u.mPid;
        int uid = u.mUid;
        NetworkStateTracker tracker = null;
        boolean callTeardown = false;
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            ConnectivityService.log("stopUsingNetworkFeature: net " + networkType + ": " + feature + ", net is invalid");
            return -1;
        }
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            int usedNetworkType;
            if (!this.mFeatureUsers.contains(u)) {
                return 1;
            }
            u.unlinkDeathRecipient();
            this.mFeatureUsers.remove(this.mFeatureUsers.indexOf(u));
            if (!ignoreDups) {
                for (FeatureUser x : this.mFeatureUsers) {
                    if (!x.isSameUser(u)) continue;
                    return 1;
                }
            }
            if ((tracker = this.mNetTrackers[usedNetworkType = this.convertFeatureToNetworkType(networkType, feature)]) == null) {
                ConnectivityService.log("stopUsingNetworkFeature: net " + networkType + ": " + feature + " no known tracker for used net type " + usedNetworkType);
                return -1;
            }
            if (usedNetworkType != networkType) {
                Integer currentPid = new Integer(pid);
                this.mNetRequestersPids[usedNetworkType].remove(currentPid);
                long token = Binder.clearCallingIdentity();
                try {
                    this.reassessPidDns(pid, true);
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                this.flushVmDnsCache();
                if (this.mNetRequestersPids[usedNetworkType].size() != 0) {
                    return 1;
                }
                callTeardown = true;
            } else {
                ConnectivityService.log("stopUsingNetworkFeature: net " + networkType + ": " + feature + " not a known feature - dropping");
            }
        }
        if (callTeardown) {
            ConnectivityService.log("stopUsingNetworkFeature: teardown net " + networkType + ": " + feature);
            tracker.teardown();
            return 1;
        }
        return -1;
    }

    @Override
    public boolean requestRouteToHost(int networkType, int hostAddress) {
        InetAddress inetAddress = NetworkUtils.intToInetAddress(hostAddress);
        if (inetAddress == null) {
            return false;
        }
        return this.requestRouteToHostAddress(networkType, inetAddress.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress) {
        boolean bl;
        this.enforceChangePermission();
        if (this.mProtectedNetworks.contains(networkType)) {
            this.enforceConnectivityInternalPermission();
        }
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            ConnectivityService.log("requestRouteToHostAddress on invalid network: " + networkType);
            return false;
        }
        NetworkStateTracker tracker = this.mNetTrackers[networkType];
        NetworkInfo.DetailedState netState = NetworkInfo.DetailedState.DISCONNECTED;
        if (tracker != null) {
            netState = tracker.getNetworkInfo().getDetailedState();
        }
        if (netState != NetworkInfo.DetailedState.CONNECTED && netState != NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK || tracker.isTeardownRequested()) {
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            InetAddress addr = InetAddress.getByAddress(hostAddress);
            LinkProperties lp = tracker.getLinkProperties();
            boolean ok = this.addRouteToAddress(lp, addr, true);
            ConnectivityService.log("requestRouteToHostAddress ok=" + ok);
            bl = ok;
            Object var12_11 = null;
        }
        catch (UnknownHostException e) {
            try {
                ConnectivityService.log("requestRouteToHostAddress got " + e.toString());
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            {
            }
        }
        Binder.restoreCallingIdentity(token);
        return bl;
        ConnectivityService.log("requestRouteToHostAddress X bottom return false");
        return false;
    }

    private boolean addRoute(LinkProperties p, RouteInfo r, boolean toDefaultTable, boolean exempt) {
        return this.modifyRoute(p, r, 0, true, toDefaultTable, exempt);
    }

    private boolean removeRoute(LinkProperties p, RouteInfo r, boolean toDefaultTable) {
        return this.modifyRoute(p, r, 0, false, toDefaultTable, false);
    }

    private boolean addRouteToAddress(LinkProperties lp, InetAddress addr, boolean exempt) {
        return this.modifyRouteToAddress(lp, addr, true, true, exempt);
    }

    private boolean removeRouteToAddress(LinkProperties lp, InetAddress addr) {
        return this.modifyRouteToAddress(lp, addr, false, true, false);
    }

    private boolean modifyRouteToAddress(LinkProperties lp, InetAddress addr, boolean doAdd, boolean toDefaultTable, boolean exempt) {
        RouteInfo bestRoute = RouteInfo.selectBestRoute(lp.getAllRoutes(), addr);
        if (bestRoute == null) {
            bestRoute = RouteInfo.makeHostRoute(addr, lp.getInterfaceName());
        } else {
            String iface = bestRoute.getInterface();
            bestRoute = bestRoute.getGateway().equals(addr) ? RouteInfo.makeHostRoute(addr, iface) : RouteInfo.makeHostRoute(addr, bestRoute.getGateway(), iface);
        }
        return this.modifyRoute(lp, bestRoute, 0, doAdd, toDefaultTable, exempt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifyRoute(LinkProperties lp, RouteInfo r, int cycleCount, boolean doAdd, boolean toDefaultTable, boolean exempt) {
        Object bestRoute;
        if (lp == null || r == null) {
            ConnectivityService.log("modifyRoute got unexpected null: " + lp + ", " + r);
            return false;
        }
        if (cycleCount > 10) {
            ConnectivityService.loge("Error modifying route - too much recursion");
            return false;
        }
        String ifaceName = r.getInterface();
        if (ifaceName == null) {
            ConnectivityService.loge("Error modifying route - no interface name");
            return false;
        }
        if (r.hasGateway() && (bestRoute = RouteInfo.selectBestRoute(lp.getAllRoutes(), r.getGateway())) != null) {
            bestRoute = ((RouteInfo)bestRoute).getGateway().equals(r.getGateway()) ? RouteInfo.makeHostRoute(r.getGateway(), ifaceName) : RouteInfo.makeHostRoute(r.getGateway(), ((RouteInfo)bestRoute).getGateway(), ifaceName);
            this.modifyRoute(lp, (RouteInfo)bestRoute, cycleCount + 1, doAdd, toDefaultTable, exempt);
        }
        if (doAdd) {
            try {
                if (toDefaultTable) {
                    bestRoute = this.mRoutesLock;
                    synchronized (bestRoute) {
                        LinkAddress dest;
                        this.mAddedRoutes.add(r);
                        this.mNetd.addRoute(ifaceName, r);
                        if (exempt && !this.mExemptAddresses.contains(dest = r.getDestination())) {
                            this.mNetd.setHostExemption(dest);
                            this.mExemptAddresses.add(dest);
                        }
                    }
                }
                this.mNetd.addSecondaryRoute(ifaceName, r);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception trying to add a route: " + e);
                return false;
            }
        } else {
            if (toDefaultTable) {
                Object e = this.mRoutesLock;
                synchronized (e) {
                    this.mAddedRoutes.remove(r);
                    if (!this.mAddedRoutes.contains(r)) {
                        try {
                            this.mNetd.removeRoute(ifaceName, r);
                            LinkAddress dest = r.getDestination();
                            if (this.mExemptAddresses.contains(dest)) {
                                this.mNetd.clearHostExemption(dest);
                                this.mExemptAddresses.remove(dest);
                            }
                        }
                        catch (Exception e2) {
                            return false;
                        }
                    }
                }
            }
            try {
                this.mNetd.removeSecondaryRoute(ifaceName, r);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getMobileDataEnabled() {
        this.enforceAccessPermission();
        boolean retVal = Settings.Global.getInt(this.mContext.getContentResolver(), "mobile_data", 1) == 1;
        return retVal;
    }

    @Override
    public void setDataDependency(int networkType, boolean met) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10, met ? 1 : 0, networkType));
    }

    private void handleSetDependencyMet(int networkType, boolean met) {
        if (this.mNetTrackers[networkType] != null) {
            ConnectivityService.log("handleSetDependencyMet(" + networkType + ", " + met + ")");
            this.mNetTrackers[networkType].setDependencyMet(met);
        }
    }

    @Override
    public void setMobileDataEnabled(boolean enabled) {
        this.enforceChangePermission();
        ConnectivityService.log("setMobileDataEnabled(" + enabled + ")");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, enabled ? 1 : 0, 0));
    }

    private void handleSetMobileData(boolean enabled) {
        if (this.mNetTrackers[0] != null) {
            this.mNetTrackers[0].setUserDataEnable(enabled);
        }
        if (this.mNetTrackers[6] != null) {
            this.mNetTrackers[6].setUserDataEnable(enabled);
        }
    }

    @Override
    public void setPolicyDataEnable(int networkType, boolean enabled) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(12, networkType, enabled ? 1 : 0));
    }

    private void handleSetPolicyDataEnable(int networkType, boolean enabled) {
        NetworkStateTracker tracker;
        if (ConnectivityManager.isNetworkTypeValid(networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            tracker.setPolicyDataEnable(enabled);
        }
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
    }

    private void enforceTetherChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
    }

    private void enforceTetherAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceConnectivityInternalPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
    }

    private void enforceMarkNetworkSocketPermission() {
        if (Binder.getCallingUid() == 1013) {
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MARK_NETWORK_SOCKET", TAG);
    }

    private void handleDisconnect(NetworkInfo info) {
        String oldIface;
        int prevNetType = info.getType();
        this.mNetTrackers[prevNetType].setTeardownRequested(false);
        this.removeDataActivityTracking(prevNetType);
        if (!this.mNetConfigs[prevNetType].isDefault()) {
            List<Integer> pids = this.mNetRequestersPids[prevNetType];
            for (Integer pid : pids) {
                this.reassessPidDns(pid, false);
            }
        }
        Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
        intent.putExtra("networkInfo", new NetworkInfo(info));
        intent.putExtra("networkType", info.getType());
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        if (this.mNetConfigs[prevNetType].isDefault()) {
            this.tryFailover(prevNetType);
            if (this.mActiveDefaultNetwork != -1) {
                NetworkInfo switchTo = this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo();
                intent.putExtra("otherNetwork", switchTo);
            } else {
                this.mDefaultInetConditionPublished = 0;
                intent.putExtra("noConnectivity", true);
            }
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        boolean doReset = true;
        LinkProperties linkProperties = this.mNetTrackers[prevNetType].getLinkProperties();
        if (linkProperties != null && !TextUtils.isEmpty(oldIface = linkProperties.getInterfaceName())) {
            for (NetworkStateTracker networkStateTracker : this.mNetTrackers) {
                LinkProperties l;
                NetworkInfo networkInfo;
                if (networkStateTracker == null || !(networkInfo = networkStateTracker.getNetworkInfo()).isConnected() || networkInfo.getType() == prevNetType || (l = networkStateTracker.getLinkProperties()) == null || !oldIface.equals(l.getInterfaceName())) continue;
                doReset = false;
                break;
            }
        }
        this.handleConnectivityChange(prevNetType, doReset);
        Intent immediateIntent = new Intent(intent);
        immediateIntent.setAction("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendStickyBroadcast(immediateIntent);
        this.sendStickyBroadcastDelayed(intent, this.getConnectivityChangeDelay());
        if (this.mActiveDefaultNetwork != -1) {
            this.sendConnectedBroadcastDelayed(this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo(), this.getConnectivityChangeDelay());
        }
    }

    private void tryFailover(int prevNetType) {
        if (this.mNetConfigs[prevNetType].isDefault()) {
            if (this.mActiveDefaultNetwork == prevNetType) {
                ConnectivityService.log("tryFailover: set mActiveDefaultNetwork=-1, prevNetType=" + prevNetType);
                this.mActiveDefaultNetwork = -1;
            }
            for (int checkType = 0; checkType <= 14; ++checkType) {
                if (checkType == prevNetType || this.mNetConfigs[checkType] == null || !this.mNetConfigs[checkType].isDefault() || this.mNetTrackers[checkType] == null) continue;
                NetworkStateTracker checkTracker = this.mNetTrackers[checkType];
                NetworkInfo checkInfo = checkTracker.getNetworkInfo();
                if (!checkInfo.isConnectedOrConnecting() || checkTracker.isTeardownRequested()) {
                    checkInfo.setFailover(true);
                    checkTracker.reconnect();
                }
                ConnectivityService.log("Attempting to switch to " + checkInfo.getTypeName());
            }
        }
    }

    public void sendConnectedBroadcast(NetworkInfo info) {
        this.enforceConnectivityInternalPermission();
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE");
    }

    private void sendConnectedBroadcastDelayed(NetworkInfo info, int delayMs) {
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendGeneralBroadcastDelayed(info, "android.net.conn.CONNECTIVITY_CHANGE", delayMs);
    }

    private void sendInetConditionBroadcast(NetworkInfo info) {
        this.sendGeneralBroadcast(info, "android.net.conn.INET_CONDITION_ACTION");
    }

    private Intent makeGeneralIntent(NetworkInfo info, String bcastType) {
        if (this.mLockdownTracker != null) {
            info = this.mLockdownTracker.augmentNetworkInfo(info);
        }
        Intent intent = new Intent(bcastType);
        intent.putExtra("networkInfo", new NetworkInfo(info));
        intent.putExtra("networkType", info.getType());
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        return intent;
    }

    private void sendGeneralBroadcast(NetworkInfo info, String bcastType) {
        this.sendStickyBroadcast(this.makeGeneralIntent(info, bcastType));
    }

    private void sendGeneralBroadcastDelayed(NetworkInfo info, String bcastType, int delayMs) {
        this.sendStickyBroadcastDelayed(this.makeGeneralIntent(info, bcastType), delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDataActivityBroadcast(int deviceType, boolean active) {
        Intent intent = new Intent("android.net.conn.DATA_ACTIVITY_CHANGE");
        intent.putExtra("deviceType", deviceType);
        intent.putExtra("isActive", active);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, "android.permission.RECEIVE_DATA_ACTIVITY_CHANGE", null, null, 0, null, null);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    private void handleConnectionFailure(NetworkInfo info) {
        this.mNetTrackers[info.getType()].setTeardownRequested(false);
        String reason = info.getReason();
        String extraInfo = info.getExtraInfo();
        String reasonText = reason == null ? "." : " (" + reason + ").";
        ConnectivityService.loge("Attempt to connect to " + info.getTypeName() + " failed" + reasonText);
        Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
        intent.putExtra("networkInfo", new NetworkInfo(info));
        intent.putExtra("networkType", info.getType());
        if (this.getActiveNetworkInfo() == null) {
            intent.putExtra("noConnectivity", true);
        }
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        if (extraInfo != null) {
            intent.putExtra("extraInfo", extraInfo);
        }
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (this.mNetConfigs[info.getType()].isDefault()) {
            this.tryFailover(info.getType());
            if (this.mActiveDefaultNetwork != -1) {
                NetworkInfo switchTo = this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo();
                intent.putExtra("otherNetwork", switchTo);
            } else {
                this.mDefaultInetConditionPublished = 0;
                intent.putExtra("noConnectivity", true);
            }
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        Intent immediateIntent = new Intent(intent);
        immediateIntent.setAction("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendStickyBroadcast(immediateIntent);
        this.sendStickyBroadcast(intent);
        if (this.mActiveDefaultNetwork != -1) {
            this.sendConnectedBroadcast(this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcast(Intent intent) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mSystemReady) {
                this.mInitialBroadcast = new Intent(intent);
            }
            intent.addFlags(0x4000000);
            long ident = Binder.clearCallingIdentity();
            try {
                this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void sendStickyBroadcastDelayed(Intent intent, int delayMs) {
        if (delayMs <= 0) {
            this.sendStickyBroadcast(intent);
        } else {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(11, intent), delayMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        this.mCaptivePortalTracker = CaptivePortalTracker.makeCaptivePortalTracker(this.mContext, this);
        this.loadGlobalProxy();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            this.mSystemReady = true;
            if (this.mInitialBroadcast != null) {
                this.mContext.sendStickyBroadcastAsUser(this.mInitialBroadcast, UserHandle.ALL);
                this.mInitialBroadcast = null;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(9));
        if (!this.updateLockdownVpn()) {
            IntentFilter filter = new IntentFilter("android.intent.action.USER_PRESENT");
            this.mContext.registerReceiver(this.mUserPresentReceiver, filter);
        }
    }

    private boolean isNewNetTypePreferredOverCurrentNetType(int type) {
        return (type == this.mNetworkPreference || this.mNetConfigs[this.mActiveDefaultNetwork].priority <= this.mNetConfigs[type].priority) && this.mNetworkPreference != this.mActiveDefaultNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnect(NetworkInfo info) {
        int newNetType = info.getType();
        this.setupDataActivityTracking(newNetType);
        boolean isFailover = info.isFailover();
        NetworkStateTracker thisNet = this.mNetTrackers[newNetType];
        String thisIface = thisNet.getLinkProperties().getInterfaceName();
        if (this.mNetConfigs[newNetType].isDefault()) {
            Object otherNet;
            if (this.mActiveDefaultNetwork != -1 && this.mActiveDefaultNetwork != newNetType) {
                if (this.isNewNetTypePreferredOverCurrentNetType(newNetType)) {
                    otherNet = this.mNetTrackers[this.mActiveDefaultNetwork];
                    ConnectivityService.log("Policy requires " + otherNet.getNetworkInfo().getTypeName() + " teardown");
                    if (!this.teardown((NetworkStateTracker)otherNet)) {
                        ConnectivityService.loge("Network declined teardown request");
                        this.teardown(thisNet);
                        return;
                    }
                } else {
                    this.teardown(thisNet);
                    return;
                }
            }
            otherNet = this;
            synchronized (otherNet) {
                if (this.mNetTransitionWakeLock.isHeld()) {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(8, this.mNetTransitionWakeLockSerialNumber, 0), 1000L);
                }
            }
            this.mActiveDefaultNetwork = newNetType;
            this.mDefaultInetConditionPublished = 0;
            ++this.mDefaultConnectionSequence;
            this.mInetConditionChangeInFlight = false;
        }
        thisNet.setTeardownRequested(false);
        this.updateNetworkSettings(thisNet);
        this.updateMtuSizeSettings(thisNet);
        this.handleConnectivityChange(newNetType, false);
        this.sendConnectedBroadcastDelayed(info, this.getConnectivityChangeDelay());
        if (thisIface != null) {
            try {
                BatteryStatsService.getService().noteNetworkInterfaceType(thisIface, newNetType);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    private void handleCaptivePortalTrackerCheck(NetworkInfo info) {
        ConnectivityService.log("Captive portal check " + info);
        int type = info.getType();
        NetworkStateTracker thisNet = this.mNetTrackers[type];
        if (this.mNetConfigs[type].isDefault() && this.mActiveDefaultNetwork != -1 && this.mActiveDefaultNetwork != type) {
            if (this.isNewNetTypePreferredOverCurrentNetType(type)) {
                ConnectivityService.log("Captive check on " + info.getTypeName());
                this.mCaptivePortalTracker.detectCaptivePortal(new NetworkInfo(info));
                return;
            }
            ConnectivityService.log("Tear down low priority net " + info.getTypeName());
            this.teardown(thisNet);
            return;
        }
        ConnectivityService.log("handleCaptivePortalTrackerCheck: call captivePortalCheckComplete ni=" + info);
        thisNet.captivePortalCheckComplete();
    }

    @Override
    public void captivePortalCheckComplete(NetworkInfo info) {
        this.enforceConnectivityInternalPermission();
        ConnectivityService.log("captivePortalCheckComplete: ni=" + info);
        this.mNetTrackers[info.getType()].captivePortalCheckComplete();
    }

    @Override
    public void captivePortalCheckCompleted(NetworkInfo info, boolean isCaptivePortal) {
        this.enforceConnectivityInternalPermission();
        ConnectivityService.log("captivePortalCheckCompleted: ni=" + info + " captive=" + isCaptivePortal);
        this.mNetTrackers[info.getType()].captivePortalCheckCompleted(isCaptivePortal);
    }

    private void setupDataActivityTracking(int type) {
        int timeout;
        NetworkStateTracker thisNet = this.mNetTrackers[type];
        String iface = thisNet.getLinkProperties().getInterfaceName();
        if (ConnectivityManager.isNetworkTypeMobile(type)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_mobile", 0);
            type = 0;
        } else {
            timeout = 1 == type ? Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_wifi", 0) : 0;
        }
        if (timeout > 0 && iface != null) {
            try {
                this.mNetd.addIdleTimer(iface, timeout, Integer.toString(type));
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    private void removeDataActivityTracking(int type) {
        NetworkStateTracker net = this.mNetTrackers[type];
        String iface = net.getLinkProperties().getInterfaceName();
        if (iface != null && (ConnectivityManager.isNetworkTypeMobile(type) || 1 == type)) {
            try {
                this.mNetd.removeIdleTimer(iface);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectivityChange(int netType, boolean doReset) {
        NetworkStateTracker tracker;
        int resetMask = doReset ? 3 : 0;
        boolean exempt = ConnectivityManager.isNetworkTypeExempt(netType);
        this.handleDnsConfigurationChange(netType);
        LinkProperties curLp = this.mCurrentLinkProperties[netType];
        LinkProperties newLp = null;
        if (this.mNetTrackers[netType].getNetworkInfo().isConnected()) {
            newLp = this.mNetTrackers[netType].getLinkProperties();
            if (curLp != null) {
                if (curLp.isIdenticalInterfaceName(newLp)) {
                    LinkProperties.CompareResult<LinkAddress> car = curLp.compareAddresses(newLp);
                    if (car.removed.size() != 0 || car.added.size() != 0) {
                        for (LinkAddress linkAddr : car.removed) {
                            if (linkAddr.getAddress() instanceof Inet4Address) {
                                resetMask |= 1;
                            }
                            if (!(linkAddr.getAddress() instanceof Inet6Address)) continue;
                            resetMask |= 2;
                        }
                        ConnectivityService.log("handleConnectivityChange: addresses changed linkProperty[" + netType + "]:" + " resetMask=" + resetMask + "\n   car=" + car);
                    } else {
                        ConnectivityService.log("handleConnectivityChange: address are the same reset per doReset linkProperty[" + netType + "]:" + " resetMask=" + resetMask);
                    }
                } else {
                    resetMask = 3;
                    ConnectivityService.log("handleConnectivityChange: interface not not equivalent reset both linkProperty[" + netType + "]:" + " resetMask=" + resetMask);
                }
            }
            if (this.mNetConfigs[netType].isDefault()) {
                this.handleApplyDefaultProxy(newLp.getHttpProxy());
            }
        }
        this.mCurrentLinkProperties[netType] = newLp;
        boolean resetDns = this.updateRoutes(newLp, curLp, this.mNetConfigs[netType].isDefault(), exempt);
        if ((resetMask != 0 || resetDns) && curLp != null) {
            for (String iface : curLp.getAllInterfaceNames()) {
                if (!TextUtils.isEmpty(iface)) {
                    if (resetMask != 0) {
                        ConnectivityService.log("resetConnections(" + iface + ", " + resetMask + ")");
                        NetworkUtils.resetConnections(iface, resetMask);
                        if ((resetMask & 1) != 0) {
                            SparseArray<Vpn> sparseArray = this.mVpns;
                            synchronized (sparseArray) {
                                for (int i = 0; i < this.mVpns.size(); ++i) {
                                    this.mVpns.valueAt(i).interfaceStatusChanged(iface, false);
                                }
                            }
                        }
                    }
                    if (!resetDns) continue;
                    this.flushVmDnsCache();
                    try {
                        this.mNetd.flushInterfaceDnsCache(iface);
                    }
                    catch (Exception e) {
                        ConnectivityService.loge("Exception resetting dns cache: " + e);
                    }
                    continue;
                }
                ConnectivityService.loge("Can't reset connection for type " + netType);
            }
        }
        if (this.mClat.requiresClat(netType, tracker = this.mNetTrackers[netType])) {
            if (Nat464Xlat.isRunningClat(curLp) && !Nat464Xlat.isRunningClat(newLp)) {
                this.mClat.stopClat();
            }
            if (this.mNetTrackers[netType].getNetworkInfo().isConnected()) {
                this.mClat.startClat(tracker);
            } else {
                this.mClat.stopClat();
            }
        }
        if (TextUtils.equals(this.mNetTrackers[netType].getNetworkInfo().getReason(), "linkPropertiesChanged") && this.isTetheringSupported()) {
            this.mTethering.handleTetherIfaceChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRoutes(LinkProperties newLp, LinkProperties curLp, boolean isLinkDefault, boolean exempt) {
        Object routesToAdd = null;
        LinkProperties.CompareResult<Object> dnsDiff = new LinkProperties.CompareResult();
        LinkProperties.CompareResult<Object> routeDiff = new LinkProperties.CompareResult();
        if (curLp != null) {
            routeDiff = curLp.compareAllRoutes(newLp);
            dnsDiff = curLp.compareDnses(newLp);
        } else if (newLp != null) {
            routeDiff.added = newLp.getAllRoutes();
            dnsDiff.added = newLp.getDnses();
        }
        boolean routesChanged = routeDiff.removed.size() != 0 || routeDiff.added.size() != 0;
        for (RouteInfo r : routeDiff.removed) {
            if (isLinkDefault || !r.isDefaultRoute()) {
                this.removeRoute(curLp, r, true);
            }
            if (isLinkDefault) continue;
            this.removeRoute(curLp, r, false);
        }
        if (!isLinkDefault) {
            if (routesChanged) {
                if (curLp != null) {
                    for (InetAddress oldDns : curLp.getDnses()) {
                        this.removeRouteToAddress(curLp, oldDns);
                    }
                }
                if (newLp != null) {
                    for (InetAddress newDns : newLp.getDnses()) {
                        this.addRouteToAddress(newLp, newDns, exempt);
                    }
                }
            } else {
                for (InetAddress oldDns : dnsDiff.removed) {
                    this.removeRouteToAddress(curLp, oldDns);
                }
                for (InetAddress newDns : dnsDiff.added) {
                    this.addRouteToAddress(newLp, newDns, exempt);
                }
            }
        }
        for (RouteInfo r : routeDiff.added) {
            if (isLinkDefault || !r.isDefaultRoute()) {
                this.addRoute(newLp, r, true, exempt);
                continue;
            }
            this.addRoute(newLp, r, false, false);
            String ifaceName = newLp.getInterfaceName();
            Object object = this.mRoutesLock;
            synchronized (object) {
                if (!TextUtils.isEmpty(ifaceName) && !this.mAddedRoutes.contains(r)) {
                    try {
                        this.mNetd.removeRoute(ifaceName, r);
                    }
                    catch (Exception e) {
                        ConnectivityService.loge("Exception trying to remove a route: " + e);
                    }
                }
            }
        }
        return routesChanged;
    }

    private void updateMtuSizeSettings(NetworkStateTracker nt) {
        String iface = nt.getLinkProperties().getInterfaceName();
        int mtu = nt.getLinkProperties().getMtu();
        if (mtu < 68 || mtu > 10000) {
            ConnectivityService.loge("Unexpected mtu value: " + nt);
            return;
        }
        try {
            this.mNetd.setMtu(iface, mtu);
        }
        catch (Exception e) {
            Slog.e(TAG, "exception in setMtu()" + e);
        }
    }

    private void updateNetworkSettings(NetworkStateTracker nt) {
        String bufferSizes;
        String key = nt.getTcpBufferSizesPropName();
        String string2 = bufferSizes = key == null ? null : SystemProperties.get(key);
        if (TextUtils.isEmpty(bufferSizes)) {
            key = "net.tcp.buffersize.default";
            bufferSizes = SystemProperties.get(key);
        }
        if (bufferSizes.length() != 0) {
            this.setBufferSize(bufferSizes);
        }
    }

    private void setBufferSize(String bufferSizes) {
        try {
            String[] values = bufferSizes.split(",");
            if (values.length == 6) {
                String prefix = "/sys/kernel/ipv4/tcp_";
                FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_min", values[0]);
                FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_def", values[1]);
                FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_max", values[2]);
                FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_min", values[3]);
                FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_def", values[4]);
                FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_max", values[5]);
            } else {
                ConnectivityService.loge("Invalid buffersize string: " + bufferSizes);
            }
        }
        catch (IOException e) {
            ConnectivityService.loge("Can't set tcp buffer sizes:" + e);
        }
    }

    private void reassessPidDns(int pid, boolean doBump) {
        Integer myPid = new Integer(pid);
        for (int i : this.mPriorityList) {
            LinkProperties p;
            NetworkStateTracker nt;
            if (this.mNetConfigs[i].isDefault() || !(nt = this.mNetTrackers[i]).getNetworkInfo().isConnected() || nt.isTeardownRequested() || (p = nt.getLinkProperties()) == null || !this.mNetRequestersPids[i].contains(myPid)) continue;
            try {
                this.mNetd.setDnsInterfaceForPid(p.getInterfaceName(), pid);
            }
            catch (Exception e) {
                Slog.e(TAG, "exception reasseses pid dns: " + e);
            }
            return;
        }
        try {
            this.mNetd.clearDnsInterfaceForPid(pid);
        }
        catch (Exception e) {
            Slog.e(TAG, "exception clear interface from pid: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushVmDnsCache() {
        Intent intent = new Intent("android.intent.action.CLEAR_DNS_CACHE");
        intent.addFlags(0x20000000);
        intent.addFlags(0x4000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    private void updateDnsLocked(String network, String iface, Collection<InetAddress> dnses, String domains, boolean defaultDns) {
        int last = 0;
        if (dnses.size() == 0 && this.mDefaultDns != null) {
            dnses = new ArrayList<InetAddress>();
            dnses.add(this.mDefaultDns);
            ConnectivityService.loge("no dns provided for " + network + " - using " + this.mDefaultDns.getHostAddress());
        }
        try {
            this.mNetd.setDnsServersForInterface(iface, NetworkUtils.makeStrings(dnses), domains);
            if (defaultDns) {
                this.mNetd.setDefaultInterfaceForDns(iface);
            }
            for (InetAddress dns : dnses) {
                String key = "net.dns" + ++last;
                String value = dns.getHostAddress();
                SystemProperties.set(key, value);
            }
            for (int i = last + 1; i <= this.mNumDnsEntries; ++i) {
                String key = "net.dns" + i;
                SystemProperties.set(key, "");
            }
            this.mNumDnsEntries = last;
        }
        catch (Exception e) {
            ConnectivityService.loge("exception setting default dns interface: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDnsConfigurationChange(int netType) {
        NetworkStateTracker nt = this.mNetTrackers[netType];
        if (nt != null && nt.getNetworkInfo().isConnected() && !nt.isTeardownRequested()) {
            LinkProperties p = nt.getLinkProperties();
            if (p == null) {
                return;
            }
            Collection<InetAddress> dnses = p.getDnses();
            if (this.mNetConfigs[netType].isDefault()) {
                String network = nt.getNetworkInfo().getTypeName();
                Object object = this.mDnsLock;
                synchronized (object) {
                    this.updateDnsLocked(network, p.getInterfaceName(), dnses, p.getDomains(), true);
                }
            }
            try {
                this.mNetd.setDnsServersForInterface(p.getInterfaceName(), NetworkUtils.makeStrings(dnses), p.getDomains());
            }
            catch (Exception e) {
                ConnectivityService.loge("exception setting dns servers: " + e);
            }
            List<Integer> pids = this.mNetRequestersPids[netType];
            for (Integer pid : pids) {
                try {
                    this.mNetd.setDnsInterfaceForPid(p.getInterfaceName(), pid);
                }
                catch (Exception e) {
                    Slog.e(TAG, "exception setting interface for pid: " + e);
                }
            }
            this.flushVmDnsCache();
        }
    }

    private int getRestoreDefaultNetworkDelay(int networkType) {
        String restoreDefaultNetworkDelayStr = SystemProperties.get(NETWORK_RESTORE_DELAY_PROP_NAME);
        if (restoreDefaultNetworkDelayStr != null && restoreDefaultNetworkDelayStr.length() != 0) {
            try {
                return Integer.valueOf(restoreDefaultNetworkDelayStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int ret = 60000;
        if (networkType <= 14 && this.mNetConfigs[networkType] != null) {
            ret = this.mNetConfigs[networkType].restoreTime;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ConnectivityService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println();
        for (int i = 0; i < this.mNetTrackers.length; ++i) {
            NetworkStateTracker nst = this.mNetTrackers[i];
            if (nst == null) continue;
            pw.println("NetworkStateTracker for " + ConnectivityManager.getNetworkTypeName(i) + ":");
            pw.increaseIndent();
            if (nst.getNetworkInfo().isConnected()) {
                pw.println("Active network: " + nst.getNetworkInfo().getTypeName());
            }
            pw.println(nst.getNetworkInfo());
            pw.println(nst.getLinkProperties());
            pw.println(nst);
            pw.println();
            pw.decreaseIndent();
        }
        pw.println("Network Requester Pids:");
        pw.increaseIndent();
        for (int net : this.mPriorityList) {
            String pidString = net + ": ";
            for (Integer pid : this.mNetRequestersPids[net]) {
                pidString = pidString + pid.toString() + ", ";
            }
            pw.println(pidString);
        }
        pw.println();
        pw.decreaseIndent();
        pw.println("FeatureUsers:");
        pw.increaseIndent();
        for (FeatureUser requester : this.mFeatureUsers) {
            pw.println(((Object)requester).toString());
        }
        pw.println();
        pw.decreaseIndent();
        ConnectivityService i$ = this;
        synchronized (i$) {
            pw.println("NetworkTranstionWakeLock is currently " + (this.mNetTransitionWakeLock.isHeld() ? "" : "not ") + "held.");
            pw.println("It was last requested for " + this.mNetTransitionWakeLockCausedBy);
        }
        pw.println();
        this.mTethering.dump(fd, pw, args);
        if (this.mInetLog != null) {
            pw.println();
            pw.println("Inet condition reports:");
            pw.increaseIndent();
            for (int i = 0; i < this.mInetLog.size(); ++i) {
                pw.println(this.mInetLog.get(i));
            }
            pw.decreaseIndent();
        }
    }

    @Override
    public int tether(String iface) {
        this.enforceTetherChangePermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.tether(iface);
        }
        return 3;
    }

    @Override
    public int untether(String iface) {
        this.enforceTetherChangePermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.untether(iface);
        }
        return 3;
    }

    @Override
    public int getLastTetherError(String iface) {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getLastTetherError(iface);
        }
        return 3;
    }

    @Override
    public String[] getTetherableUsbRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableUsbRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableWifiRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableWifiRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableBluetoothRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableBluetoothRegexs();
        }
        return new String[0];
    }

    @Override
    public int setUsbTethering(boolean enable) {
        this.enforceTetherChangePermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.setUsbTethering(enable);
        }
        return 3;
    }

    @Override
    public String[] getTetherableIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetherableIfaces();
    }

    @Override
    public String[] getTetheredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetheredIfaces();
    }

    @Override
    public String[] getTetheringErroredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getErroredIfaces();
    }

    @Override
    public boolean isTetheringSupported() {
        this.enforceTetherAccessPermission();
        int defaultVal = SystemProperties.get("ro.tether.denied").equals("true") ? 0 : 1;
        boolean tetherEnabledInSettings = Settings.Global.getInt(this.mContext.getContentResolver(), "tether_supported", defaultVal) != 0;
        return tetherEnabledInSettings && (this.mTethering.getTetherableUsbRegexs().length != 0 || this.mTethering.getTetherableWifiRegexs().length != 0 || this.mTethering.getTetherableBluetoothRegexs().length != 0) && this.mTethering.getUpstreamIfaceTypes().length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworkTransitionWakelock(String forWhom) {
        this.enforceConnectivityInternalPermission();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
            ++this.mNetTransitionWakeLockSerialNumber;
            this.mNetTransitionWakeLock.acquire();
            this.mNetTransitionWakeLockCausedBy = forWhom;
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(8, this.mNetTransitionWakeLockSerialNumber, 0), this.mNetTransitionWakeLockTimeout);
    }

    @Override
    public void reportInetCondition(int networkType, int percentage) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR", TAG);
        int pid = ConnectivityService.getCallingPid();
        int uid = ConnectivityService.getCallingUid();
        String s = pid + "(" + uid + ") reports inet is " + (percentage > 50 ? "connected" : "disconnected") + " (" + percentage + ") on " + "network Type " + networkType + " at " + GregorianCalendar.getInstance().getTime();
        this.mInetLog.add(s);
        while (this.mInetLog.size() > 15) {
            this.mInetLog.remove(0);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, networkType, percentage));
    }

    private void handleInetConditionChange(int netType, int condition) {
        if (this.mActiveDefaultNetwork == -1) {
            ConnectivityService.log("handleInetConditionChange: no active default network - ignore");
            return;
        }
        if (this.mActiveDefaultNetwork != netType) {
            ConnectivityService.log("handleInetConditionChange: net=" + netType + " != default=" + this.mActiveDefaultNetwork + " - ignore");
            return;
        }
        this.mDefaultInetCondition = condition;
        if (!this.mInetConditionChangeInFlight) {
            int delay = this.mDefaultInetCondition > 50 ? Settings.Global.getInt(this.mContext.getContentResolver(), "inet_condition_debounce_up_delay", 500) : Settings.Global.getInt(this.mContext.getContentResolver(), "inet_condition_debounce_down_delay", 3000);
            this.mInetConditionChangeInFlight = true;
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(5, this.mActiveDefaultNetwork, this.mDefaultConnectionSequence), delay);
        }
    }

    private void handleInetConditionHoldEnd(int netType, int sequence) {
        ConnectivityService.log("handleInetConditionHoldEnd: net=" + netType + ", condition=" + this.mDefaultInetCondition + ", published condition=" + this.mDefaultInetConditionPublished);
        this.mInetConditionChangeInFlight = false;
        if (this.mActiveDefaultNetwork == -1) {
            ConnectivityService.log("handleInetConditionHoldEnd: no active default network - ignoring");
            return;
        }
        if (this.mDefaultConnectionSequence != sequence) {
            ConnectivityService.log("handleInetConditionHoldEnd: event hold for obsolete network - ignoring");
            return;
        }
        NetworkInfo networkInfo = this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo();
        if (!networkInfo.isConnected()) {
            ConnectivityService.log("handleInetConditionHoldEnd: default network not connected - ignoring");
            return;
        }
        this.mDefaultInetConditionPublished = this.mDefaultInetCondition;
        this.sendInetConditionBroadcast(networkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyProperties getProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            ProxyProperties ret = this.mGlobalProxy;
            if (ret == null && !this.mDefaultProxyDisabled) {
                ret = this.mDefaultProxy;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalProxy(ProxyProperties proxyProperties) {
        this.enforceConnectivityInternalPermission();
        Object object = this.mProxyLock;
        synchronized (object) {
            if (proxyProperties == this.mGlobalProxy) {
                return;
            }
            if (proxyProperties != null && proxyProperties.equals(this.mGlobalProxy)) {
                return;
            }
            if (this.mGlobalProxy != null && this.mGlobalProxy.equals(proxyProperties)) {
                return;
            }
            String host = "";
            int port = 0;
            String exclList = "";
            String pacFileUrl = "";
            if (!(proxyProperties == null || TextUtils.isEmpty(proxyProperties.getHost()) && TextUtils.isEmpty(proxyProperties.getPacFileUrl()))) {
                if (!proxyProperties.isValid()) {
                    ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                    return;
                }
                this.mGlobalProxy = new ProxyProperties(proxyProperties);
                host = this.mGlobalProxy.getHost();
                port = this.mGlobalProxy.getPort();
                exclList = this.mGlobalProxy.getExclusionList();
                if (proxyProperties.getPacFileUrl() != null) {
                    pacFileUrl = proxyProperties.getPacFileUrl();
                }
            } else {
                this.mGlobalProxy = null;
            }
            ContentResolver res = this.mContext.getContentResolver();
            long token = Binder.clearCallingIdentity();
            try {
                Settings.Global.putString(res, "global_http_proxy_host", host);
                Settings.Global.putInt(res, "global_http_proxy_port", port);
                Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclList);
                Settings.Global.putString(res, "global_proxy_pac_url", pacFileUrl);
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
        }
        if (this.mGlobalProxy == null) {
            proxyProperties = this.mDefaultProxy;
        }
        this.sendProxyBroadcast(proxyProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalProxy() {
        ContentResolver res = this.mContext.getContentResolver();
        String host = Settings.Global.getString(res, "global_http_proxy_host");
        int port = Settings.Global.getInt(res, "global_http_proxy_port", 0);
        String exclList = Settings.Global.getString(res, "global_http_proxy_exclusion_list");
        String pacFileUrl = Settings.Global.getString(res, "global_proxy_pac_url");
        if (!TextUtils.isEmpty(host) || !TextUtils.isEmpty(pacFileUrl)) {
            ProxyProperties proxyProperties = !TextUtils.isEmpty(pacFileUrl) ? new ProxyProperties(pacFileUrl) : new ProxyProperties(host, port, exclList);
            if (!proxyProperties.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                return;
            }
            Object object = this.mProxyLock;
            synchronized (object) {
                this.mGlobalProxy = proxyProperties;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyProperties getGlobalProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            return this.mGlobalProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyDefaultProxy(ProxyProperties proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && TextUtils.isEmpty(proxy.getPacFileUrl())) {
            proxy = null;
        }
        Object object = this.mProxyLock;
        synchronized (object) {
            if (this.mDefaultProxy != null && this.mDefaultProxy.equals(proxy)) {
                return;
            }
            if (this.mDefaultProxy == proxy) {
                return;
            }
            if (proxy != null && !proxy.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxy.toString());
                return;
            }
            this.mDefaultProxy = proxy;
            if (this.mGlobalProxy != null) {
                return;
            }
            if (!this.mDefaultProxyDisabled) {
                this.sendProxyBroadcast(proxy);
            }
        }
    }

    private void handleDeprecatedGlobalHttpProxy() {
        String proxy = Settings.Global.getString(this.mContext.getContentResolver(), "http_proxy");
        if (!TextUtils.isEmpty(proxy)) {
            String[] data = proxy.split(":");
            if (data.length == 0) {
                return;
            }
            String proxyHost = data[0];
            int proxyPort = 8080;
            if (data.length > 1) {
                try {
                    proxyPort = Integer.parseInt(data[1]);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            ProxyProperties p = new ProxyProperties(data[0], proxyPort, "");
            this.setGlobalProxy(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProxyBroadcast(ProxyProperties proxy) {
        if (proxy == null) {
            proxy = new ProxyProperties("", 0, "");
        }
        if (this.mPacManager.setCurrentProxyScriptUrl(proxy)) {
            return;
        }
        ConnectivityService.log("sending Proxy Broadcast for " + proxy);
        Intent intent = new Intent("android.intent.action.PROXY_CHANGE");
        intent.addFlags(0x24000000);
        intent.putExtra("proxy", proxy);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    private static void log(String s) {
        Slog.d(TAG, s);
    }

    private static void loge(String s) {
        Slog.e(TAG, s);
    }

    int convertFeatureToNetworkType(int networkType, String feature) {
        int usedNetworkType = networkType;
        if (networkType == 0) {
            if (TextUtils.equals(feature, "enableMMS")) {
                usedNetworkType = 2;
            } else if (TextUtils.equals(feature, "enableSUPL")) {
                usedNetworkType = 3;
            } else if (TextUtils.equals(feature, "enableDUN") || TextUtils.equals(feature, "enableDUNAlways")) {
                usedNetworkType = 4;
            } else if (TextUtils.equals(feature, "enableHIPRI")) {
                usedNetworkType = 5;
            } else if (TextUtils.equals(feature, "enableFOTA")) {
                usedNetworkType = 10;
            } else if (TextUtils.equals(feature, "enableIMS")) {
                usedNetworkType = 11;
            } else if (TextUtils.equals(feature, "enableCBS")) {
                usedNetworkType = 12;
            } else {
                Slog.e(TAG, "Can't match any mobile netTracker!");
            }
        } else if (networkType == 1) {
            if (TextUtils.equals(feature, "p2p")) {
                usedNetworkType = 13;
            } else {
                Slog.e(TAG, "Can't match any wifi netTracker!");
            }
        } else {
            Slog.e(TAG, "Unexpected network type");
        }
        return usedNetworkType;
    }

    private static <T> T checkNotNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean protectVpn(ParcelFileDescriptor socket) {
        block13: {
            block12: {
                this.throwIfLockdownEnabled();
                int type = this.mActiveDefaultNetwork;
                int user = UserHandle.getUserId(Binder.getCallingUid());
                if (!ConnectivityManager.isNetworkTypeValid(type) || this.mNetTrackers[type] == null) break block12;
                SparseArray<Vpn> sparseArray = this.mVpns;
                synchronized (sparseArray) {
                    this.mVpns.get(user).protect(socket, this.mNetTrackers[type].getLinkProperties().getInterfaceName());
                }
                boolean bl = true;
                Object var7_8 = null;
                try {
                    socket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bl;
            }
            Object var7_9 = null;
            try {
                socket.close();
            }
            catch (Exception e) {}
            break block13;
            {
                catch (Exception exception) {
                    Object var7_10 = null;
                    try {
                        socket.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    socket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareVpn(String oldPackage, String newPackage) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).prepare(oldPackage, newPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void markSocketAsUser(ParcelFileDescriptor socket, int uid) {
        this.enforceMarkNetworkSocketPermission();
        long token = Binder.clearCallingIdentity();
        try {
            try {
                int mark = this.mNetd.getMarkForUid(uid);
                if (mark == -1) {
                    mark = 0;
                }
                NetworkUtils.markSocket(socket.getFd(), mark);
            }
            catch (RemoteException e) {
                Object var7_7 = null;
                Binder.restoreCallingIdentity(token);
                return;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor establishVpn(VpnConfig config) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).establish(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLegacyVpn(VpnProfile profile) {
        this.throwIfLockdownEnabled();
        LinkProperties egress = this.getActiveLinkProperties();
        if (egress == null) {
            throw new IllegalStateException("Missing active network connection");
        }
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.mVpns.get(user).startLegacyVpn(profile, this.mKeyStore, egress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LegacyVpnInfo getLegacyVpnInfo() {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).getLegacyVpnInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VpnConfig getVpnConfig() {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).getVpnConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLockdownVpn() {
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Lockdown VPN only available to AID_SYSTEM");
            return false;
        }
        this.mLockdownEnabled = LockdownVpnTracker.isEnabled();
        if (this.mLockdownEnabled) {
            if (!this.mKeyStore.isUnlocked()) {
                Slog.w(TAG, "KeyStore locked; unable to create LockdownTracker");
                return false;
            }
            String profileName = new String(this.mKeyStore.get("LOCKDOWN_VPN"));
            VpnProfile profile = VpnProfile.decode(profileName, this.mKeyStore.get("VPN_" + profileName));
            int user = UserHandle.getUserId(Binder.getCallingUid());
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                this.setLockdownTracker(new LockdownVpnTracker(this.mContext, this.mNetd, this, this.mVpns.get(user), profile));
            }
        } else {
            this.setLockdownTracker(null);
        }
        return true;
    }

    private void setLockdownTracker(LockdownVpnTracker tracker) {
        LockdownVpnTracker existing = this.mLockdownTracker;
        this.mLockdownTracker = null;
        if (existing != null) {
            existing.shutdown();
        }
        try {
            if (tracker != null) {
                this.mNetd.setFirewallEnabled(true);
                this.mNetd.setFirewallInterfaceRule("lo", true);
                this.mLockdownTracker = tracker;
                this.mLockdownTracker.init();
            } else {
                this.mNetd.setFirewallEnabled(false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void throwIfLockdownEnabled() {
        if (this.mLockdownEnabled) {
            throw new IllegalStateException("Unavailable in lockdown mode");
        }
    }

    @Override
    public void supplyMessenger(int networkType, Messenger messenger) {
        this.enforceConnectivityInternalPermission();
        if (ConnectivityManager.isNetworkTypeValid(networkType) && this.mNetTrackers[networkType] != null) {
            this.mNetTrackers[networkType].supplyMessenger(messenger);
        }
    }

    @Override
    public int findConnectionTypeForIface(String iface) {
        this.enforceConnectivityInternalPermission();
        if (TextUtils.isEmpty(iface)) {
            return -1;
        }
        for (NetworkStateTracker tracker : this.mNetTrackers) {
            LinkProperties lp;
            if (tracker == null || (lp = tracker.getLinkProperties()) == null || !iface.equals(lp.getInterfaceName())) continue;
            return tracker.getNetworkInfo().getType();
        }
        return -1;
    }

    private void setEnableFailFastMobileData(int enabled) {
        int tag = enabled == 1 ? this.mEnableFailFastMobileDataTag.incrementAndGet() : this.mEnableFailFastMobileDataTag.get();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(14, tag, enabled));
    }

    private boolean isMobileDataStateTrackerReady() {
        MobileDataStateTracker mdst = (MobileDataStateTracker)this.mNetTrackers[5];
        return mdst != null && mdst.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkMobileProvisioning(int suggestedTimeOutMs) {
        long token;
        int timeOutMs;
        block6: {
            block5: {
                int n;
                timeOutMs = -1;
                ConnectivityService.log("checkMobileProvisioning: E suggestedTimeOutMs=" + suggestedTimeOutMs);
                this.enforceConnectivityInternalPermission();
                token = Binder.clearCallingIdentity();
                try {
                    timeOutMs = suggestedTimeOutMs;
                    if (suggestedTimeOutMs > 60000) {
                        timeOutMs = 60000;
                    }
                    if (this.isNetworkSupported(0) && this.isNetworkSupported(5)) break block5;
                    ConnectivityService.log("checkMobileProvisioning: X no mobile network");
                    n = timeOutMs;
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    Binder.restoreCallingIdentity(token);
                    ConnectivityService.log("checkMobileProvisioning: X");
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                ConnectivityService.log("checkMobileProvisioning: X");
                return n;
            }
            if (!this.mIsCheckingMobileProvisioning.getAndSet(true)) break block6;
            ConnectivityService.log("checkMobileProvisioning: X already checking ignore for the moment");
            int n = timeOutMs;
            Object var9_8 = null;
            Binder.restoreCallingIdentity(token);
            ConnectivityService.log("checkMobileProvisioning: X");
            return n;
        }
        this.setProvNotificationVisible(false, 5, null, null);
        CheckMp checkMp = new CheckMp(this.mContext, this);
        CheckMp.CallBack cb = new CheckMp.CallBack(){

            void onComplete(Integer result) {
                ConnectivityService.log("CheckMp.onComplete: result=" + result);
                NetworkInfo ni = ConnectivityService.this.mNetTrackers[5].getNetworkInfo();
                switch (result) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        ConnectivityService.log("CheckMp.onComplete: ignore, connected or no connection");
                        break;
                    }
                    case 4: {
                        ConnectivityService.log("CheckMp.onComplete: warm sim");
                        String url = ConnectivityService.this.getMobileProvisioningUrl();
                        if (TextUtils.isEmpty(url)) {
                            url = ConnectivityService.this.getMobileRedirectedProvisioningUrl();
                        }
                        if (!TextUtils.isEmpty(url)) {
                            ConnectivityService.log("CheckMp.onComplete: warm (redirected), url=" + url);
                            ConnectivityService.this.setProvNotificationVisible(true, 5, ni.getExtraInfo(), url);
                            break;
                        }
                        ConnectivityService.log("CheckMp.onComplete: warm (redirected), no url");
                        break;
                    }
                    case 5: {
                        String url = ConnectivityService.this.getMobileProvisioningUrl();
                        if (!TextUtils.isEmpty(url)) {
                            ConnectivityService.log("CheckMp.onComplete: warm (no dns/tcp), url=" + url);
                            ConnectivityService.this.setProvNotificationVisible(true, 5, ni.getExtraInfo(), url);
                            break;
                        }
                        ConnectivityService.log("CheckMp.onComplete: warm (no dns/tcp), no url");
                        break;
                    }
                    default: {
                        ConnectivityService.loge("CheckMp.onComplete: ignore unexpected result=" + result);
                    }
                }
                ConnectivityService.this.mIsCheckingMobileProvisioning.set(false);
            }
        };
        CheckMp.Params params = new CheckMp.Params(checkMp.getDefaultUrl(), timeOutMs, cb);
        ConnectivityService.log("checkMobileProvisioning: params=" + params);
        checkMp.execute(params);
        Object var9_9 = null;
        Binder.restoreCallingIdentity(token);
        ConnectivityService.log("checkMobileProvisioning: X");
        return timeOutMs;
    }

    private void handleMobileProvisioningAction(String url) {
        this.setProvNotificationVisible(false, 5, null, null);
        NetworkInfo ni = this.getProvisioningNetworkInfo();
        if (ni != null && ni.isConnectedToProvisioningNetwork()) {
            ConnectivityService.log("handleMobileProvisioningAction: on provisioning network");
            MobileDataStateTracker mdst = (MobileDataStateTracker)this.mNetTrackers[0];
            mdst.enableMobileProvisioning(url);
        } else {
            ConnectivityService.log("handleMobileProvisioningAction: on default network");
            Intent newIntent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", "android.intent.category.APP_BROWSER");
            newIntent.setData(Uri.parse(url));
            newIntent.setFlags(0x10400000);
            try {
                this.mContext.startActivity(newIntent);
            }
            catch (ActivityNotFoundException e) {
                ConnectivityService.loge("handleMobileProvisioningAction: startActivity failed" + e);
            }
        }
    }

    private void setProvNotificationVisible(boolean visible, int networkType, String extraInfo, String url) {
        ConnectivityService.log("setProvNotificationVisible: E visible=" + visible + " networkType=" + networkType + " extraInfo=" + extraInfo + " url=" + url);
        Resources r = Resources.getSystem();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (visible) {
            int icon;
            String details;
            String title;
            Notification notification = new Notification();
            switch (networkType) {
                case 1: {
                    title = r.getString(17040432, 0);
                    details = r.getString(17040434, extraInfo);
                    icon = 17302924;
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(url));
                    intent.setFlags(0x10400000);
                    notification.contentIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0);
                    break;
                }
                case 0: 
                case 5: {
                    title = r.getString(17040433, 0);
                    details = this.mTelephonyManager.getNetworkOperatorName();
                    icon = 17302920;
                    Intent intent = new Intent(CONNECTED_TO_PROVISIONING_NETWORK_ACTION);
                    intent.putExtra("EXTRA_URL", url);
                    intent.setFlags(0);
                    notification.contentIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
                    break;
                }
                default: {
                    title = r.getString(17040433, 0);
                    details = r.getString(17040434, extraInfo);
                    icon = 17302920;
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(url));
                    intent.setFlags(0x10400000);
                    notification.contentIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0);
                }
            }
            notification.when = 0L;
            notification.icon = icon;
            notification.flags = 16;
            notification.tickerText = title;
            notification.setLatestEventInfo(this.mContext, title, details, notification.contentIntent);
            try {
                notificationManager.notify(NOTIFICATION_ID, networkType, notification);
            }
            catch (NullPointerException npe) {
                ConnectivityService.loge("setNotificaitionVisible: visible notificationManager npe=" + npe);
                npe.printStackTrace();
            }
        } else {
            try {
                notificationManager.cancel(NOTIFICATION_ID, networkType);
            }
            catch (NullPointerException npe) {
                ConnectivityService.loge("setNotificaitionVisible: cancel notificationManager npe=" + npe);
                npe.printStackTrace();
            }
        }
        this.mIsNotificationVisible = visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getProvisioningUrlBaseFromFile(int type) {
        block23: {
            fileReader = null;
            parser = null;
            config = this.mContext.getResources().getConfiguration();
            switch (type) {
                case 2: {
                    tagType = "provisioningUrl";
                    break;
                }
                case 1: {
                    tagType = "redirectedUrl";
                    break;
                }
                default: {
                    throw new RuntimeException("getProvisioningUrlBaseFromFile: Unexpected parameter " + type);
                }
            }
            try {
                try {
                    fileReader = new FileReader(this.mProvisioningUrlFile);
                    parser = Xml.newPullParser();
                    parser.setInput(fileReader);
                    XmlUtils.beginDocument(parser, "provisioningUrls");
                    while (true) {
                        XmlUtils.nextElement(parser);
                        element = parser.getName();
                        if (element == null) {
                            element = null;
                            break block23;
                        }
                        if (!element.equals(tagType)) continue;
                        mcc = parser.getAttributeValue(null, "mcc");
                        try {
                            if (mcc == null || Integer.parseInt(mcc) != config.mcc || (mnc = parser.getAttributeValue(null, "mnc")) == null || Integer.parseInt(mnc) != config.mnc) continue;
                            parser.next();
                            if (parser.getEventType() != 4) continue;
                            var9_13 = parser.getText();
                        }
                        catch (NumberFormatException e) {
                            ConnectivityService.loge("NumberFormatException in getProvisioningUrlBaseFromFile: " + e);
                            continue;
                        }
                        break;
                    }
                    var11_14 = null;
                    if (fileReader == null) return var9_13;
                }
                catch (FileNotFoundException e) {
                    ConnectivityService.loge("Carrier Provisioning Urls file not found");
                    var11_16 = null;
                    if (fileReader == null) return null;
                    try {
                        fileReader.close();
                        return null;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                catch (XmlPullParserException e) {
                    ConnectivityService.loge("Xml parser exception reading Carrier Provisioning Urls file: " + e);
                    var11_17 = null;
                    if (fileReader == null) return null;
                    try {}
                    catch (IOException e) {
                        return null;
                    }
                    fileReader.close();
                    return null;
                }
                catch (IOException e) {
                    ConnectivityService.loge("I/O exception reading Carrier Provisioning Urls file: " + e);
                    var11_18 = null;
                    if (fileReader == null) return null;
                    try {}
                    catch (IOException e) {
                        return null;
                    }
                    fileReader.close();
                    return null;
                }
            }
            catch (Throwable var10_26) {
                var11_19 = null;
                if (fileReader == null) throw var10_26;
                ** try [egrp 3[TRYBLOCK] [13 : 372->379)] { 
lbl76:
                // 1 sources

                fileReader.close();
                throw var10_26;
lbl78:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var10_26;
            }
            try {}
            catch (IOException e) {
                // empty catch block
                return var9_13;
            }
            fileReader.close();
            return var9_13;
        }
        var11_15 = null;
        if (fileReader == null) return element;
        try {}
        catch (IOException e) {
            // empty catch block
            return element;
        }
        fileReader.close();
        return element;
    }

    @Override
    public String getMobileRedirectedProvisioningUrl() {
        this.enforceConnectivityInternalPermission();
        String url = this.getProvisioningUrlBaseFromFile(1);
        if (TextUtils.isEmpty(url)) {
            url = this.mContext.getResources().getString(17039399);
        }
        return url;
    }

    @Override
    public String getMobileProvisioningUrl() {
        this.enforceConnectivityInternalPermission();
        String url = this.getProvisioningUrlBaseFromFile(2);
        if (TextUtils.isEmpty(url)) {
            url = this.mContext.getResources().getString(17039398);
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioining_url from resource =" + url);
        } else {
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioning_url from File =" + url);
        }
        if (!TextUtils.isEmpty(url)) {
            String phoneNumber = this.mTelephonyManager.getLine1Number();
            if (TextUtils.isEmpty(phoneNumber)) {
                phoneNumber = "0000000000";
            }
            url = String.format(url, this.mTelephonyManager.getSimSerialNumber(), this.mTelephonyManager.getDeviceId(), phoneNumber);
        }
        return url;
    }

    @Override
    public void setProvisioningNotificationVisible(boolean visible, int networkType, String extraInfo, String url) {
        this.enforceConnectivityInternalPermission();
        this.setProvNotificationVisible(visible, networkType, extraInfo, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAirplaneMode(boolean enable) {
        this.enforceConnectivityInternalPermission();
        long ident = Binder.clearCallingIdentity();
        try {
            ContentResolver cr = this.mContext.getContentResolver();
            Settings.Global.putInt(cr, "airplane_mode_on", enable ? 1 : 0);
            Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
            intent.putExtra("state", enable);
            this.mContext.sendBroadcast(intent);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStart(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn != null) {
                ConnectivityService.loge("Starting user already has a VPN");
                return;
            }
            userVpn = new Vpn(this.mContext, this.mVpnCallback, this.mNetd, this, userId);
            this.mVpns.put(userId, userVpn);
            userVpn.startMonitoring(this.mContext, this.mTrackerHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStop(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn == null) {
                ConnectivityService.loge("Stopping user has no VPN");
                return;
            }
            this.mVpns.delete(userId);
        }
    }

    @Override
    public LinkQualityInfo getLinkQualityInfo(int networkType) {
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(networkType)) {
            return this.mNetTrackers[networkType].getLinkQualityInfo();
        }
        return null;
    }

    @Override
    public LinkQualityInfo getActiveLinkQualityInfo() {
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(this.mActiveDefaultNetwork)) {
            return this.mNetTrackers[this.mActiveDefaultNetwork].getLinkQualityInfo();
        }
        return null;
    }

    @Override
    public LinkQualityInfo[] getAllLinkQualityInfo() {
        this.enforceAccessPermission();
        ArrayList<LinkQualityInfo> result = Lists.newArrayList();
        for (NetworkStateTracker tracker : this.mNetTrackers) {
            LinkQualityInfo li;
            if (tracker == null || (li = tracker.getLinkQualityInfo()) == null) continue;
            result.add(li);
        }
        return result.toArray(new LinkQualityInfo[result.size()]);
    }

    private void handleNetworkSamplingTimeout() {
        String ifaceName;
        ConnectivityService.log("Sampling interval elapsed, updating statistics ..");
        HashMap<String, SamplingDataTracker.SamplingSnapshot> mapIfaceToSample = new HashMap<String, SamplingDataTracker.SamplingSnapshot>();
        for (NetworkStateTracker tracker : this.mNetTrackers) {
            if (tracker == null || (ifaceName = tracker.getNetworkInterfaceName()) == null) continue;
            mapIfaceToSample.put(ifaceName, null);
        }
        SamplingDataTracker.getSamplingSnapshots(mapIfaceToSample);
        for (NetworkStateTracker tracker : this.mNetTrackers) {
            SamplingDataTracker.SamplingSnapshot ss;
            if (tracker == null || (ss = (SamplingDataTracker.SamplingSnapshot)mapIfaceToSample.get(ifaceName = tracker.getNetworkInterfaceName())) == null) continue;
            tracker.stopSampling(ss);
            tracker.startSampling(ss);
        }
        ConnectivityService.log("Done.");
        int samplingIntervalInSeconds = Settings.Global.getInt(this.mContext.getContentResolver(), "connectivity_sampling_interval_in_seconds", 720);
        ConnectivityService.log("Setting timer for " + String.valueOf(samplingIntervalInSeconds) + "seconds");
        this.setAlarm(samplingIntervalInSeconds * 1000, this.mSampleIntervalElapsedIntent);
    }

    void setAlarm(int timeoutInMilliseconds, PendingIntent intent) {
        long wakeupTime = SystemClock.elapsedRealtime() + (long)timeoutInMilliseconds;
        this.mAlarmManager.set(2, wakeupTime, intent);
    }

    static /* synthetic */ boolean access$4800(ConnectivityService x0) {
        return x0.isMobileDataStateTrackerReady();
    }

    static /* synthetic */ void access$4900(ConnectivityService x0, int x1) {
        x0.setEnableFailFastMobileData(x1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CheckMp
    extends AsyncTask<Params, Void, Integer> {
        private static final String CHECKMP_TAG = "CheckMp";
        private static boolean mTestingFailures;
        private static final int MAX_LOOPS = 4;
        public static final int MAX_TIMEOUT_MS = 60000;
        private static final int SOCKET_TIMEOUT_MS = 5000;
        private static final int NET_ERROR_SLEEP_SEC = 3;
        private static final int NET_ROUTE_ESTABLISHMENT_SLEEP_SEC = 3;
        private static final int POLLING_SLEEP_SEC = 1;
        private Context mContext;
        private ConnectivityService mCs;
        private TelephonyManager mTm;
        private Params mParams;

        public CheckMp(Context context, ConnectivityService cs) {
            mTestingFailures = Build.IS_DEBUGGABLE ? SystemProperties.getInt("persist.checkmp.testfailures", 0) == 1 : false;
            this.mContext = context;
            this.mCs = cs;
            this.mTm = (TelephonyManager)this.mContext.getSystemService("phone");
        }

        public String getDefaultUrl() {
            String server = Settings.Global.getString(this.mContext.getContentResolver(), "captive_portal_server");
            if (server == null) {
                server = "clients3.google.com";
            }
            return "http://" + server + "/generate_204";
        }

        /*
         * Exception decompiling
         */
        private synchronized Integer isMobileOk(Params params) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected Integer doInBackground(Params ... params) {
            return this.isMobileOk(params[0]);
        }

        @Override
        protected void onPostExecute(Integer result) {
            CheckMp.log("onPostExecute: result=" + result);
            if (this.mParams != null && this.mParams.mCb != null) {
                this.mParams.mCb.onComplete(result);
            }
        }

        private String inetAddressesToString(InetAddress[] addresses) {
            StringBuffer sb = new StringBuffer();
            boolean firstTime = true;
            for (InetAddress addr : addresses) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(",");
                }
                sb.append(addr);
            }
            return sb.toString();
        }

        private void printNetworkInfo() {
            boolean hasIccCard = this.mTm.hasIccCard();
            int simState = this.mTm.getSimState();
            CheckMp.log("hasIccCard=" + hasIccCard + " simState=" + simState);
            NetworkInfo[] ni = this.mCs.getAllNetworkInfo();
            if (ni != null) {
                CheckMp.log("ni.length=" + ni.length);
                for (NetworkInfo netInfo : ni) {
                    CheckMp.log("netInfo=" + netInfo.toString());
                }
            } else {
                CheckMp.log("no network info ni=null");
            }
        }

        private static void sleep(int seconds) {
            try {
                Thread.sleep(seconds * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private static void log(String s) {
            Slog.d(ConnectivityService.TAG, "[CheckMp] " + s);
        }

        static abstract class CallBack {
            CallBack() {
            }

            abstract void onComplete(Integer var1);
        }

        static class CheckMpHostnameVerifier
        implements HostnameVerifier {
            Uri mOrgUri;

            CheckMpHostnameVerifier(Uri orgUri) {
                this.mOrgUri = orgUri;
            }

            public boolean verify(String hostname, SSLSession session) {
                String orgUriHost;
                HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
                boolean retVal = hv.verify(orgUriHost = this.mOrgUri.getHost(), session) || hv.verify(hostname, session);
                CheckMp.log("isMobileOk: hostnameVerify retVal=" + retVal + " hostname=" + hostname + " orgUriHost=" + orgUriHost);
                return retVal;
            }
        }

        static class Params {
            private String mUrl;
            private long mTimeOutMs;
            private CallBack mCb;

            Params(String url, long timeOutMs, CallBack cb) {
                this.mUrl = url;
                this.mTimeOutMs = timeOutMs;
                this.mCb = cb;
            }

            public String toString() {
                return "{ url=" + this.mUrl + " mTimeOutMs=" + this.mTimeOutMs + " mCb=" + this.mCb + "}";
            }

            static /* synthetic */ String access$4600(Params x0) {
                return x0.mUrl;
            }

            static /* synthetic */ long access$4700(Params x0) {
                return x0.mTimeOutMs;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VpnCallback {
        private VpnCallback() {
        }

        public void onStateChanged(NetworkInfo info) {
            ConnectivityService.this.mHandler.obtainMessage(13, info).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void override(String iface, List<String> dnsServers, List<String> searchDomains) {
            if (dnsServers == null) {
                this.restore();
                return;
            }
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            for (String address : dnsServers) {
                try {
                    addresses.add(InetAddress.parseNumericAddress(address));
                }
                catch (Exception e) {}
            }
            if (addresses.isEmpty()) {
                this.restore();
                return;
            }
            StringBuilder buffer = new StringBuilder();
            if (searchDomains != null) {
                for (String domain : searchDomains) {
                    buffer.append(domain).append(' ');
                }
            }
            String domains = buffer.toString().trim();
            Object object = ConnectivityService.this.mDnsLock;
            synchronized (object) {
                ConnectivityService.this.updateDnsLocked("VPN", iface, addresses, domains, false);
            }
            object = ConnectivityService.this.mProxyLock;
            synchronized (object) {
                ConnectivityService.this.mDefaultProxyDisabled = true;
                if (ConnectivityService.this.mGlobalProxy == null && ConnectivityService.this.mDefaultProxy != null) {
                    ConnectivityService.this.sendProxyBroadcast(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restore() {
            Object object = ConnectivityService.this.mProxyLock;
            synchronized (object) {
                ConnectivityService.this.mDefaultProxyDisabled = false;
                if (ConnectivityService.this.mGlobalProxy == null && ConnectivityService.this.mDefaultProxy != null) {
                    ConnectivityService.this.sendProxyBroadcast(ConnectivityService.this.mDefaultProxy);
                }
            }
        }

        public void protect(ParcelFileDescriptor socket) {
            try {
                int mark = ConnectivityService.this.mNetd.getMarkForProtect();
                NetworkUtils.markSocket(socket.getFd(), mark);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void setRoutes(String interfaze, List<RouteInfo> routes) {
            for (RouteInfo route : routes) {
                try {
                    ConnectivityService.this.mNetd.setMarkedForwardingRoute(interfaze, route);
                }
                catch (RemoteException e) {}
            }
        }

        public void setMarkedForwarding(String interfaze) {
            try {
                ConnectivityService.this.mNetd.setMarkedForwarding(interfaze);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void clearMarkedForwarding(String interfaze) {
            try {
                ConnectivityService.this.mNetd.clearMarkedForwarding(interfaze);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void addUserForwarding(String interfaze, int uid, boolean forwardDns) {
            int uidStart = uid * 100000;
            int uidEnd = uidStart + 100000 - 1;
            this.addUidForwarding(interfaze, uidStart, uidEnd, forwardDns);
        }

        public void clearUserForwarding(String interfaze, int uid, boolean forwardDns) {
            int uidStart = uid * 100000;
            int uidEnd = uidStart + 100000 - 1;
            this.clearUidForwarding(interfaze, uidStart, uidEnd, forwardDns);
        }

        public void addUidForwarding(String interfaze, int uidStart, int uidEnd, boolean forwardDns) {
            try {
                ConnectivityService.this.mNetd.setUidRangeRoute(interfaze, uidStart, uidEnd);
                if (forwardDns) {
                    ConnectivityService.this.mNetd.setDnsInterfaceForUidRange(interfaze, uidStart, uidEnd);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        public void clearUidForwarding(String interfaze, int uidStart, int uidEnd, boolean forwardDns) {
            try {
                ConnectivityService.this.mNetd.clearUidRangeRoute(interfaze, uidStart, uidEnd);
                if (forwardDns) {
                    ConnectivityService.this.mNetd.clearDnsInterfaceForUidRange(uidStart, uidEnd);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mWhat;
        private Handler mHandler;

        SettingsObserver(Handler handler, int what) {
            super(handler);
            this.mHandler = handler;
            this.mWhat = what;
        }

        void observe(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.Global.getUriFor("http_proxy"), false, this);
        }

        public void onChange(boolean selfChange) {
            this.mHandler.obtainMessage(this.mWhat).sendToTarget();
        }
    }

    private class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: {
                    String causedBy = null;
                    ConnectivityService connectivityService = ConnectivityService.this;
                    synchronized (connectivityService) {
                        if (msg.arg1 == ConnectivityService.this.mNetTransitionWakeLockSerialNumber && ConnectivityService.this.mNetTransitionWakeLock.isHeld()) {
                            ConnectivityService.this.mNetTransitionWakeLock.release();
                            causedBy = ConnectivityService.this.mNetTransitionWakeLockCausedBy;
                        }
                    }
                    if (causedBy == null) break;
                    ConnectivityService.log("NetTransition Wakelock for " + causedBy + " released by timeout");
                    break;
                }
                case 1: {
                    FeatureUser u = (FeatureUser)msg.obj;
                    u.expire();
                    break;
                }
                case 4: {
                    int netType = msg.arg1;
                    int condition = msg.arg2;
                    ConnectivityService.this.handleInetConditionChange(netType, condition);
                    break;
                }
                case 5: {
                    int netType = msg.arg1;
                    int sequence = msg.arg2;
                    ConnectivityService.this.handleInetConditionHoldEnd(netType, sequence);
                    break;
                }
                case 3: {
                    int preference = msg.arg1;
                    ConnectivityService.this.handleSetNetworkPreference(preference);
                    break;
                }
                case 7: {
                    boolean enabled = msg.arg1 == 1;
                    ConnectivityService.this.handleSetMobileData(enabled);
                    break;
                }
                case 9: {
                    ConnectivityService.this.handleDeprecatedGlobalHttpProxy();
                    break;
                }
                case 10: {
                    boolean met = msg.arg1 == 1;
                    ConnectivityService.this.handleSetDependencyMet(msg.arg2, met);
                    break;
                }
                case 11: {
                    Intent intent = (Intent)msg.obj;
                    ConnectivityService.this.sendStickyBroadcast(intent);
                    break;
                }
                case 12: {
                    int networkType = msg.arg1;
                    boolean enabled = msg.arg2 == 1;
                    ConnectivityService.this.handleSetPolicyDataEnable(networkType, enabled);
                    break;
                }
                case 13: {
                    if (ConnectivityService.this.mLockdownTracker == null) break;
                    ConnectivityService.this.mLockdownTracker.onVpnStateChanged((NetworkInfo)msg.obj);
                    break;
                }
                case 14: {
                    int tag = ConnectivityService.this.mEnableFailFastMobileDataTag.get();
                    if (msg.arg1 == tag) {
                        MobileDataStateTracker mobileDst = (MobileDataStateTracker)ConnectivityService.this.mNetTrackers[0];
                        if (mobileDst == null) break;
                        mobileDst.setEnableFailFastMobileData(msg.arg2);
                        break;
                    }
                    ConnectivityService.log("EVENT_ENABLE_FAIL_FAST_MOBILE_DATA: stale arg1:" + msg.arg1 + " != tag:" + tag);
                    break;
                }
                case 15: {
                    ConnectivityService.this.handleNetworkSamplingTimeout();
                    break;
                }
                case 16: {
                    ConnectivityService.this.handleApplyDefaultProxy((ProxyProperties)msg.obj);
                }
            }
        }
    }

    private class NetworkStateTrackerHandler
    extends Handler {
        public NetworkStateTrackerHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 458752: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    NetworkInfo.State state = info.getState();
                    if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.DISCONNECTED || state == NetworkInfo.State.SUSPENDED) {
                        ConnectivityService.log("ConnectivityChange for " + info.getTypeName() + ": " + (Object)((Object)state) + "/" + (Object)((Object)info.getDetailedState()));
                    }
                    if (ConnectivityManager.isNetworkTypeMobile(info.getType()) && 0 != Settings.Global.getInt(ConnectivityService.this.mContext.getContentResolver(), "device_provisioned", 0) && (state == NetworkInfo.State.CONNECTED && info.getType() == 0 || info.isConnectedToProvisioningNetwork())) {
                        ConnectivityService.log("ConnectivityChange checkMobileProvisioning for TYPE_MOBILE or ProvisioningNetwork");
                        ConnectivityService.this.checkMobileProvisioning(60000);
                    }
                    EventLogTags.writeConnectivityStateChanged(info.getType(), info.getSubtype(), info.getDetailedState().ordinal());
                    if (info.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
                        ConnectivityService.this.handleConnectionFailure(info);
                    } else if (info.getDetailedState() == NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK) {
                        ConnectivityService.this.handleCaptivePortalTrackerCheck(info);
                    } else if (info.isConnectedToProvisioningNetwork()) {
                        LinkProperties lp = ConnectivityService.this.getLinkProperties(info.getType());
                        ConnectivityService.log("EVENT_STATE_CHANGED: connected to provisioning network, lp=" + lp);
                        for (RouteInfo r : lp.getRoutes()) {
                            ConnectivityService.this.removeRoute(lp, r, true);
                        }
                    } else if (state == NetworkInfo.State.DISCONNECTED) {
                        ConnectivityService.this.handleDisconnect(info);
                    } else if (state == NetworkInfo.State.SUSPENDED) {
                        ConnectivityService.this.handleDisconnect(info);
                    } else if (state == NetworkInfo.State.CONNECTED) {
                        ConnectivityService.this.handleConnect(info);
                    }
                    if (ConnectivityService.this.mLockdownTracker == null) break;
                    ConnectivityService.this.mLockdownTracker.onNetworkInfoChanged(info);
                    break;
                }
                case 458753: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    ConnectivityService.this.handleConnectivityChange(info.getType(), false);
                    break;
                }
                case 458755: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    int type = info.getType();
                    ConnectivityService.this.updateNetworkSettings(ConnectivityService.this.mNetTrackers[type]);
                    break;
                }
            }
        }
    }

    private class FeatureUser
    implements IBinder.DeathRecipient {
        int mNetworkType;
        String mFeature;
        IBinder mBinder;
        int mPid;
        int mUid;
        long mCreateTime;

        FeatureUser(int type, String feature, IBinder binder) {
            this.mNetworkType = type;
            this.mFeature = feature;
            this.mBinder = binder;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.mCreateTime = System.currentTimeMillis();
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        void unlinkDeathRecipient() {
            this.mBinder.unlinkToDeath(this, 0);
        }

        public void binderDied() {
            ConnectivityService.log("ConnectivityService FeatureUser binderDied(" + this.mNetworkType + ", " + this.mFeature + ", " + this.mBinder + "), created " + (System.currentTimeMillis() - this.mCreateTime) + " mSec ago");
            ConnectivityService.this.stopUsingNetworkFeature(this, false);
        }

        public void expire() {
            ConnectivityService.this.stopUsingNetworkFeature(this, false);
        }

        public boolean isSameUser(FeatureUser u) {
            if (u == null) {
                return false;
            }
            return this.isSameUser(u.mPid, u.mUid, u.mNetworkType, u.mFeature);
        }

        public boolean isSameUser(int pid, int uid, int networkType, String feature) {
            return this.mPid == pid && this.mUid == uid && this.mNetworkType == networkType && TextUtils.equals(this.mFeature, feature);
        }

        public String toString() {
            return "FeatureUser(" + this.mNetworkType + "," + this.mFeature + "," + this.mPid + "," + this.mUid + "), created " + (System.currentTimeMillis() - this.mCreateTime) + " mSec ago";
        }
    }

    private static class DefaultNetworkFactory
    implements NetworkFactory {
        private final Context mContext;
        private final Handler mTrackerHandler;

        public DefaultNetworkFactory(Context context, Handler trackerHandler) {
            this.mContext = context;
            this.mTrackerHandler = trackerHandler;
        }

        public NetworkStateTracker createTracker(int targetNetworkType, NetworkConfig config) {
            switch (config.radio) {
                case 1: {
                    return new WifiStateTracker(targetNetworkType, config.name);
                }
                case 0: {
                    return new MobileDataStateTracker(targetNetworkType, config.name);
                }
                case 8: {
                    return new DummyDataStateTracker(targetNetworkType, config.name);
                }
                case 7: {
                    return BluetoothTetheringDataTracker.getInstance();
                }
                case 6: {
                    return ConnectivityService.makeWimaxStateTracker(this.mContext, this.mTrackerHandler);
                }
                case 9: {
                    return EthernetDataTracker.getInstance();
                }
            }
            throw new IllegalArgumentException("Trying to create a NetworkStateTracker for an unknown radio type: " + config.radio);
        }
    }

    public static interface NetworkFactory {
        public NetworkStateTracker createTracker(int var1, NetworkConfig var2);
    }

    private static class RadioAttributes {
        public int mSimultaneity;
        public int mType;

        public RadioAttributes(String init) {
            String[] fragments = init.split(",");
            this.mType = Integer.parseInt(fragments[0]);
            this.mSimultaneity = Integer.parseInt(fragments[1]);
        }
    }
}

