/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.server.RandomBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EntropyMixer
extends Binder {
    private static final String TAG = "EntropyMixer";
    private static final int ENTROPY_WHAT = 1;
    private static final int ENTROPY_WRITE_PERIOD = 10800000;
    private static final long START_TIME = System.currentTimeMillis();
    private static final long START_NANOTIME = System.nanoTime();
    private final String randomDevice;
    private final String hwRandomDevice;
    private final String entropyFile;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what != 1) {
                Slog.e(EntropyMixer.TAG, "Will not process invalid message");
                return;
            }
            EntropyMixer.this.addHwRandomEntropy();
            EntropyMixer.this.writeEntropy();
            EntropyMixer.this.scheduleEntropyWriter();
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            EntropyMixer.this.writeEntropy();
        }
    };

    public EntropyMixer(Context context) {
        this(context, EntropyMixer.getSystemDir() + "/entropy.dat", "/dev/urandom", "/dev/hw_random");
    }

    public EntropyMixer(Context context, String entropyFile, String randomDevice, String hwRandomDevice) {
        if (randomDevice == null) {
            throw new NullPointerException("randomDevice");
        }
        if (hwRandomDevice == null) {
            throw new NullPointerException("hwRandomDevice");
        }
        if (entropyFile == null) {
            throw new NullPointerException("entropyFile");
        }
        this.randomDevice = randomDevice;
        this.hwRandomDevice = hwRandomDevice;
        this.entropyFile = entropyFile;
        this.loadInitialEntropy();
        this.addDeviceSpecificEntropy();
        this.addHwRandomEntropy();
        this.writeEntropy();
        this.scheduleEntropyWriter();
        IntentFilter broadcastFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        broadcastFilter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        broadcastFilter.addAction("android.intent.action.REBOOT");
        context.registerReceiver(this.mBroadcastReceiver, broadcastFilter);
    }

    private void scheduleEntropyWriter() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 10800000L);
    }

    private void loadInitialEntropy() {
        try {
            RandomBlock.fromFile(this.entropyFile).toFile(this.randomDevice, false);
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "No existing entropy file -- first boot?");
        }
        catch (IOException e) {
            Slog.w(TAG, "Failure loading existing entropy file", e);
        }
    }

    private void writeEntropy() {
        try {
            Slog.i(TAG, "Writing entropy...");
            RandomBlock.fromFile(this.randomDevice).toFile(this.entropyFile, true);
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to write entropy", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceSpecificEntropy() {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileOutputStream(this.randomDevice));
                out.println("Copyright (C) 2009 The Android Open Source Project");
                out.println("All Your Randomness Are Belong To Us");
                out.println(START_TIME);
                out.println(START_NANOTIME);
                out.println(SystemProperties.get("ro.serialno"));
                out.println(SystemProperties.get("ro.bootmode"));
                out.println(SystemProperties.get("ro.baseband"));
                out.println(SystemProperties.get("ro.carrier"));
                out.println(SystemProperties.get("ro.bootloader"));
                out.println(SystemProperties.get("ro.hardware"));
                out.println(SystemProperties.get("ro.revision"));
                out.println(SystemProperties.get("ro.build.fingerprint"));
                out.println(new Object().hashCode());
                out.println(System.currentTimeMillis());
                out.println(System.nanoTime());
            }
            catch (IOException e) {
                Slog.w(TAG, "Unable to add device specific data to the entropy pool", e);
                Object var4_3 = null;
                if (out != null) {
                    out.close();
                }
            }
            Object var4_2 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private void addHwRandomEntropy() {
        try {
            RandomBlock.fromFile(this.hwRandomDevice).toFile(this.randomDevice, false);
            Slog.i(TAG, "Added HW RNG output to entropy pool");
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to add HW RNG output to entropy pool", e);
        }
    }

    private static String getSystemDir() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        systemDir.mkdirs();
        return systemDir.toString();
    }
}

