/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.net.INetworkManagementEventObserver;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.NetworkStats;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.wifi.WifiConfiguration;
import android.os.Binder;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import com.android.internal.app.IBatteryStats;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.util.Preconditions;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnector;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.NativeDaemonEvent;
import com.android.server.Watchdog;
import com.android.server.net.LockdownVpnTracker;
import com.google.android.collect.Maps;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkManagementService
extends INetworkManagementService.Stub
implements Watchdog.Monitor {
    private static final String TAG = "NetworkManagementService";
    private static final boolean DBG = false;
    private static final String NETD_TAG = "NetdConnector";
    private static final String NETD_SOCKET_NAME = "netd";
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String ALLOW = "allow";
    private static final String DENY = "deny";
    private static final String DEFAULT = "default";
    private static final String SECONDARY = "secondary";
    public static final String LIMIT_GLOBAL_ALERT = "globalAlert";
    private Context mContext;
    private NativeDaemonConnector mConnector;
    private final Handler mMainHandler = new Handler();
    private Thread mThread;
    private CountDownLatch mConnectedSignal = new CountDownLatch(1);
    private final RemoteCallbackList<INetworkManagementEventObserver> mObservers = new RemoteCallbackList();
    private final NetworkStatsFactory mStatsFactory = new NetworkStatsFactory();
    private Object mQuotaLock = new Object();
    private HashMap<String, Long> mActiveQuotas = Maps.newHashMap();
    private HashMap<String, Long> mActiveAlerts = Maps.newHashMap();
    private SparseBooleanArray mUidRejectOnQuota = new SparseBooleanArray();
    private Object mIdleTimerLock = new Object();
    private HashMap<String, IdleTimerParams> mActiveIdleTimers = Maps.newHashMap();
    private volatile boolean mBandwidthControlEnabled;
    private volatile boolean mFirewallEnabled;

    private NetworkManagementService(Context context, String socket) {
        this.mContext = context;
        if ("simulator".equals(SystemProperties.get("ro.product.device"))) {
            return;
        }
        this.mConnector = new NativeDaemonConnector(new NetdCallbackReceiver(), socket, 10, NETD_TAG, 160);
        this.mThread = new Thread(this.mConnector, NETD_TAG);
        Watchdog.getInstance().addMonitor(this);
    }

    static NetworkManagementService create(Context context, String socket) throws InterruptedException {
        NetworkManagementService service = new NetworkManagementService(context, socket);
        CountDownLatch connectedSignal = service.mConnectedSignal;
        service.mThread.start();
        connectedSignal.await();
        return service;
    }

    public static NetworkManagementService create(Context context) throws InterruptedException {
        return NetworkManagementService.create(context, NETD_SOCKET_NAME);
    }

    public void systemReady() {
        this.prepareNativeDaemon();
    }

    @Override
    public void registerObserver(INetworkManagementEventObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mObservers.register(observer);
    }

    @Override
    public void unregisterObserver(INetworkManagementEventObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mObservers.unregister(observer);
    }

    private void notifyInterfaceStatusChanged(String iface, boolean up) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).interfaceStatusChanged(iface, up);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    private void notifyInterfaceLinkStateChanged(String iface, boolean up) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).interfaceLinkStateChanged(iface, up);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    private void notifyInterfaceAdded(String iface) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).interfaceAdded(iface);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    private void notifyInterfaceRemoved(String iface) {
        this.mActiveAlerts.remove(iface);
        this.mActiveQuotas.remove(iface);
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).interfaceRemoved(iface);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    private void notifyLimitReached(String limitName, String iface) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).limitReached(limitName, iface);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    private void notifyInterfaceClassActivity(String label, boolean active) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).interfaceClassDataActivityChanged(label, active);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNativeDaemon() {
        this.mBandwidthControlEnabled = false;
        boolean hasKernelSupport = new File("/proc/net/xt_qtaguid/ctrl").exists();
        if (hasKernelSupport) {
            Slog.d(TAG, "enabling bandwidth control");
            try {
                this.mConnector.execute("bandwidth", "enable");
                this.mBandwidthControlEnabled = true;
            }
            catch (NativeDaemonConnectorException e) {
                Log.wtf(TAG, "problem enabling bandwidth controls", e);
            }
        } else {
            Slog.d(TAG, "not enabling bandwidth control");
        }
        SystemProperties.set("net.qtaguid_enabled", this.mBandwidthControlEnabled ? "1" : "0");
        if (this.mBandwidthControlEnabled) {
            try {
                IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")).noteNetworkStatsEnabled();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            int size = this.mActiveQuotas.size();
            if (size > 0) {
                Slog.d(TAG, "pushing " + size + " active quota rules");
                HashMap<String, Long> activeQuotas = this.mActiveQuotas;
                this.mActiveQuotas = Maps.newHashMap();
                for (Map.Entry<String, Long> entry : activeQuotas.entrySet()) {
                    this.setInterfaceQuota(entry.getKey(), entry.getValue());
                }
            }
            if ((size = this.mActiveAlerts.size()) > 0) {
                Slog.d(TAG, "pushing " + size + " active alert rules");
                HashMap<String, Long> activeAlerts = this.mActiveAlerts;
                this.mActiveAlerts = Maps.newHashMap();
                for (Map.Entry<String, Long> entry : activeAlerts.entrySet()) {
                    this.setInterfaceAlert(entry.getKey(), entry.getValue());
                }
            }
            if ((size = this.mUidRejectOnQuota.size()) > 0) {
                Slog.d(TAG, "pushing " + size + " active uid rules");
                SparseBooleanArray uidRejectOnQuota = this.mUidRejectOnQuota;
                this.mUidRejectOnQuota = new SparseBooleanArray();
                for (int i = 0; i < uidRejectOnQuota.size(); ++i) {
                    this.setUidNetworkRules(uidRejectOnQuota.keyAt(i), uidRejectOnQuota.valueAt(i));
                }
            }
        }
        this.setFirewallEnabled(this.mFirewallEnabled || LockdownVpnTracker.isEnabled());
    }

    private void notifyAddressUpdated(String iface, LinkAddress address) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).addressUpdated(iface, address);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    private void notifyAddressRemoved(String iface, LinkAddress address) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).addressRemoved(iface, address);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    private void notifyInterfaceDnsServerInfo(String iface, long lifetime, String[] addresses) {
        int length = this.mObservers.beginBroadcast();
        for (int i = 0; i < length; ++i) {
            try {
                this.mObservers.getBroadcastItem(i).interfaceDnsServerInfo(iface, lifetime, addresses);
                continue;
            }
            catch (RemoteException e) {
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.mObservers.finishBroadcast();
    }

    @Override
    public String[] listInterfaces() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("interface", "list"), 110);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public InterfaceConfiguration getInterfaceConfig(String iface) {
        InterfaceConfiguration cfg;
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("interface", "getcfg", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(213);
        StringTokenizer st = new StringTokenizer(event.getMessage());
        try {
            cfg = new InterfaceConfiguration();
            cfg.setHardwareAddress(st.nextToken(" "));
            InetAddress addr = null;
            int prefixLength = 0;
            try {
                addr = NetworkUtils.numericToInetAddress(st.nextToken());
            }
            catch (IllegalArgumentException iae) {
                Slog.e(TAG, "Failed to parse ipaddr", iae);
            }
            try {
                prefixLength = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                Slog.e(TAG, "Failed to parse prefixLength", nfe);
            }
            cfg.setLinkAddress(new LinkAddress(addr, prefixLength));
            while (st.hasMoreTokens()) {
                cfg.setFlag(st.nextToken());
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalStateException("Invalid response from daemon: " + event);
        }
        return cfg;
    }

    @Override
    public void setInterfaceConfig(String iface, InterfaceConfiguration cfg) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        LinkAddress linkAddr = cfg.getLinkAddress();
        if (linkAddr == null || linkAddr.getAddress() == null) {
            throw new IllegalStateException("Null LinkAddress given");
        }
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("interface", "setcfg", iface, linkAddr.getAddress().getHostAddress(), linkAddr.getNetworkPrefixLength());
        for (String flag : cfg.getFlags()) {
            cmd.appendArg(flag);
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setInterfaceDown(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
        ifcg.setInterfaceDown();
        this.setInterfaceConfig(iface, ifcg);
    }

    @Override
    public void setInterfaceUp(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
        ifcg.setInterfaceUp();
        this.setInterfaceConfig(iface, ifcg);
    }

    @Override
    public void setInterfaceIpv6PrivacyExtensions(String iface, boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "ipv6privacyextensions", iface, enable ? "enable" : "disable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearInterfaceAddresses(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "clearaddrs", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void enableIpv6(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "ipv6", iface, "enable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void disableIpv6(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "ipv6", iface, "disable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void addRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyRoute(interfaceName, ADD, route, DEFAULT);
    }

    @Override
    public void removeRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyRoute(interfaceName, REMOVE, route, DEFAULT);
    }

    @Override
    public void addSecondaryRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyRoute(interfaceName, ADD, route, SECONDARY);
    }

    @Override
    public void removeSecondaryRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyRoute(interfaceName, REMOVE, route, SECONDARY);
    }

    private void modifyRoute(String interfaceName, String action, RouteInfo route, String type) {
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("interface", "route", action, interfaceName, type);
        LinkAddress la = route.getDestination();
        cmd.appendArg(la.getAddress().getHostAddress());
        cmd.appendArg(la.getNetworkPrefixLength());
        if (route.getGateway() == null) {
            if (la.getAddress() instanceof Inet4Address) {
                cmd.appendArg("0.0.0.0");
            } else {
                cmd.appendArg("::0");
            }
        } else {
            cmd.appendArg(route.getGateway().getHostAddress());
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<String> readRouteList(String filename) {
        String s;
        FileInputStream fstream = null;
        ArrayList<String> list = new ArrayList<String>();
        fstream = new FileInputStream(filename);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((s = br.readLine()) != null && s.length() != 0) {
            list.add(s);
        }
        Object var8_8 = null;
        if (fstream == null) return list;
        try {
            fstream.close();
            return list;
        }
        catch (IOException ex2) {}
        return list;
        {
            catch (IOException ex) {
                Object var8_9 = null;
                if (fstream == null) return list;
                try {
                    fstream.close();
                    return list;
                }
                catch (IOException ex2) {}
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (fstream == null) throw throwable;
            try {
                fstream.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public RouteInfo[] getRoutes(String interfaceName) {
        InetAddress destAddr;
        String dest;
        String iface;
        String[] fields;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        for (String s : this.readRouteList("/proc/net/route")) {
            fields = s.split("\t");
            if (fields.length <= 7 || !interfaceName.equals(iface = fields[0])) continue;
            dest = fields[1];
            String gate = fields[2];
            String flags = fields[3];
            String mask = fields[7];
            try {
                destAddr = NetworkUtils.intToInetAddress((int)Long.parseLong(dest, 16));
                int prefixLength = NetworkUtils.netmaskIntToPrefixLength((int)Long.parseLong(mask, 16));
                LinkAddress linkAddress = new LinkAddress(destAddr, prefixLength);
                InetAddress gatewayAddr = NetworkUtils.intToInetAddress((int)Long.parseLong(gate, 16));
                RouteInfo route = new RouteInfo(linkAddress, gatewayAddr);
                routes.add(route);
            }
            catch (Exception e) {
                Log.e(TAG, "Error parsing route " + s + " : " + e);
            }
        }
        for (String s : this.readRouteList("/proc/net/ipv6_route")) {
            fields = s.split("\\s+");
            if (fields.length <= 9 || !interfaceName.equals(iface = fields[9].trim())) continue;
            dest = fields[0];
            String prefix = fields[1];
            String gate = fields[4];
            try {
                int prefixLength = Integer.parseInt(prefix, 16);
                destAddr = NetworkUtils.hexToInet6Address(dest);
                LinkAddress linkAddress = new LinkAddress(destAddr, prefixLength);
                InetAddress gateAddr = NetworkUtils.hexToInet6Address(gate);
                RouteInfo route = new RouteInfo(linkAddress, gateAddr);
                routes.add(route);
            }
            catch (Exception e) {
                Log.e(TAG, "Error parsing route " + s + " : " + e);
            }
        }
        return routes.toArray(new RouteInfo[routes.size()]);
    }

    @Override
    public void setMtu(String iface, int mtu) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            NativeDaemonEvent event = this.mConnector.execute("interface", "setmtu", iface, mtu);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void shutdown() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SHUTDOWN", TAG);
        Slog.d(TAG, "Shutting down");
    }

    @Override
    public boolean getIpForwardingEnabled() throws IllegalStateException {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("ipfwd", "status");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(211);
        return event.getMessage().endsWith("enabled");
    }

    @Override
    public void setIpForwardingEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("ipfwd", enable ? "enable" : "disable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void startTethering(String[] dhcpRange) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("tether", "start");
        for (String d : dhcpRange) {
            cmd.appendArg(d);
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void stopTethering() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("tether", "stop");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public boolean isTetheringStarted() {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("tether", "status");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(210);
        return event.getMessage().endsWith("started");
    }

    @Override
    public void tetherInterface(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("tether", "interface", ADD, iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void untetherInterface(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("tether", "interface", REMOVE, iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public String[] listTetheredInterfaces() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("tether", "interface", "list"), 111);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setDnsForwarders(String[] dns) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("tether", "dns", "set");
        for (String s : dns) {
            cmd.appendArg(NetworkUtils.numericToInetAddress(s).getHostAddress());
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public String[] getDnsForwarders() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("tether", "dns", "list"), 112);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    private void modifyNat(String action, String internalInterface, String externalInterface) throws SocketException {
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("nat", action, internalInterface, externalInterface);
        NetworkInterface internalNetworkInterface = NetworkInterface.getByName(internalInterface);
        if (internalNetworkInterface == null) {
            cmd.appendArg("0");
        } else {
            List<InterfaceAddress> interfaceAddresses = internalNetworkInterface.getInterfaceAddresses();
            cmd.appendArg(interfaceAddresses.size());
            for (InterfaceAddress ia : interfaceAddresses) {
                InetAddress addr = NetworkUtils.getNetworkPart(ia.getAddress(), ia.getNetworkPrefixLength());
                cmd.appendArg(addr.getHostAddress() + "/" + ia.getNetworkPrefixLength());
            }
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void enableNat(String internalInterface, String externalInterface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.modifyNat("enable", internalInterface, externalInterface);
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void disableNat(String internalInterface, String externalInterface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.modifyNat("disable", internalInterface, externalInterface);
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String[] listTtys() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("list_ttys", new Object[0]), 113);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void attachPppd(String tty, String localAddr, String remoteAddr, String dns1Addr, String dns2Addr) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("pppd", "attach", tty, NetworkUtils.numericToInetAddress(localAddr).getHostAddress(), NetworkUtils.numericToInetAddress(remoteAddr).getHostAddress(), NetworkUtils.numericToInetAddress(dns1Addr).getHostAddress(), NetworkUtils.numericToInetAddress(dns2Addr).getHostAddress());
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void detachPppd(String tty) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("pppd", "detach", tty);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void startAccessPoint(WifiConfiguration wifiConfig, String wlanIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.wifiFirmwareReload(wlanIface, "AP");
            if (wifiConfig == null) {
                this.mConnector.execute("softap", "set", wlanIface);
            } else {
                this.mConnector.execute("softap", "set", wlanIface, wifiConfig.SSID, "broadcast", "6", NetworkManagementService.getSecurityType(wifiConfig), new NativeDaemonConnector.SensitiveArg(wifiConfig.preSharedKey));
            }
            this.mConnector.execute("softap", "startap");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    private static String getSecurityType(WifiConfiguration wifiConfig) {
        switch (wifiConfig.getAuthType()) {
            case 1: {
                return "wpa-psk";
            }
            case 4: {
                return "wpa2-psk";
            }
        }
        return "open";
    }

    @Override
    public void wifiFirmwareReload(String wlanIface, String mode) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("softap", "fwreload", wlanIface, mode);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void stopAccessPoint(String wlanIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("softap", "stopap");
            this.wifiFirmwareReload(wlanIface, "STA");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setAccessPoint(WifiConfiguration wifiConfig, String wlanIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            if (wifiConfig == null) {
                this.mConnector.execute("softap", "set", wlanIface);
            } else {
                this.mConnector.execute("softap", "set", wlanIface, wifiConfig.SSID, "broadcast", "6", NetworkManagementService.getSecurityType(wifiConfig), new NativeDaemonConnector.SensitiveArg(wifiConfig.preSharedKey));
            }
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIdleTimer(String iface, int timeout, String label) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            IdleTimerParams params = this.mActiveIdleTimers.get(iface);
            if (params != null) {
                ++params.networkCount;
                return;
            }
            try {
                this.mConnector.execute("idletimer", ADD, iface, Integer.toString(timeout), label);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            this.mActiveIdleTimers.put(iface, new IdleTimerParams(timeout, label));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleTimer(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            IdleTimerParams params = this.mActiveIdleTimers.get(iface);
            if (params == null || --params.networkCount > 0) {
                return;
            }
            try {
                this.mConnector.execute("idletimer", REMOVE, iface, Integer.toString(params.timeout), params.label);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            this.mActiveIdleTimers.remove(iface);
        }
    }

    @Override
    public NetworkStats getNetworkStatsSummaryDev() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsSummaryDev();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsSummaryXt() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsSummaryXt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsDetail() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsDetail(-1);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterfaceQuota(String iface, long quotaBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveQuotas.containsKey(iface)) {
                throw new IllegalStateException("iface " + iface + " already has quota");
            }
            try {
                this.mConnector.execute("bandwidth", "setiquota", iface, quotaBytes);
                this.mActiveQuotas.put(iface, quotaBytes);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterfaceQuota(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveQuotas.containsKey(iface)) {
                return;
            }
            this.mActiveQuotas.remove(iface);
            this.mActiveAlerts.remove(iface);
            try {
                this.mConnector.execute("bandwidth", "removeiquota", iface);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterfaceAlert(String iface, long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        if (!this.mActiveQuotas.containsKey(iface)) {
            throw new IllegalStateException("setting alert requires existing quota on iface");
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveAlerts.containsKey(iface)) {
                throw new IllegalStateException("iface " + iface + " already has alert");
            }
            try {
                this.mConnector.execute("bandwidth", "setinterfacealert", iface, alertBytes);
                this.mActiveAlerts.put(iface, alertBytes);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterfaceAlert(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveAlerts.containsKey(iface)) {
                return;
            }
            try {
                this.mConnector.execute("bandwidth", "removeinterfacealert", iface);
                this.mActiveAlerts.remove(iface);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    @Override
    public void setGlobalAlert(long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        try {
            this.mConnector.execute("bandwidth", "setglobalalert", alertBytes);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidNetworkRules(int uid, boolean rejectOnQuotaInterfaces) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            boolean oldRejectOnQuota = this.mUidRejectOnQuota.get(uid, false);
            if (oldRejectOnQuota == rejectOnQuotaInterfaces) {
                return;
            }
            try {
                this.mConnector.execute("bandwidth", rejectOnQuotaInterfaces ? "addnaughtyapps" : "removenaughtyapps", uid);
                if (rejectOnQuotaInterfaces) {
                    this.mUidRejectOnQuota.put(uid, true);
                } else {
                    this.mUidRejectOnQuota.delete(uid);
                }
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    @Override
    public boolean isBandwidthControlEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        return this.mBandwidthControlEnabled;
    }

    @Override
    public NetworkStats getNetworkStatsUidDetail(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsDetail(uid);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsTethering() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 1);
        try {
            NativeDaemonEvent[] events;
            for (NativeDaemonEvent event : events = this.mConnector.executeForList("bandwidth", "gettetherstats")) {
                if (event.getCode() != 114) continue;
                StringTokenizer tok = new StringTokenizer(event.getMessage());
                try {
                    String ifaceIn = tok.nextToken();
                    String ifaceOut = tok.nextToken();
                    NetworkStats.Entry entry = new NetworkStats.Entry();
                    entry.iface = ifaceOut;
                    entry.uid = -5;
                    entry.set = 0;
                    entry.tag = 0;
                    entry.rxBytes = Long.parseLong(tok.nextToken());
                    entry.rxPackets = Long.parseLong(tok.nextToken());
                    entry.txBytes = Long.parseLong(tok.nextToken());
                    entry.txPackets = Long.parseLong(tok.nextToken());
                    stats.combineValues(entry);
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException("problem parsing tethering stats: " + event);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("problem parsing tethering stats: " + event);
                }
            }
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        return stats;
    }

    @Override
    public void setDefaultInterfaceForDns(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "setdefaultif", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setDnsServersForInterface(String iface, String[] servers, String domains) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("resolver", "setifdns", iface, domains == null ? "" : domains);
        for (String s : servers) {
            InetAddress a = NetworkUtils.numericToInetAddress(s);
            if (a.isAnyLocalAddress()) continue;
            cmd.appendArg(a.getHostAddress());
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setUidRangeRoute(String iface, int uid_start, int uid_end) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "fwmark", "uid", ADD, iface, uid_start, uid_end);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearUidRangeRoute(String iface, int uid_start, int uid_end) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "fwmark", "uid", REMOVE, iface, uid_start, uid_end);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setMarkedForwarding(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "fwmark", "rule", ADD, iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearMarkedForwarding(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "fwmark", "rule", REMOVE, iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public int getMarkForUid(int uid) {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("interface", "fwmark", "get", "mark", uid);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(225);
        return Integer.parseInt(event.getMessage());
    }

    @Override
    public int getMarkForProtect() {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("interface", "fwmark", "get", "protect");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(225);
        return Integer.parseInt(event.getMessage());
    }

    @Override
    public void setMarkedForwardingRoute(String iface, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            LinkAddress dest = route.getDestination();
            this.mConnector.execute("interface", "fwmark", "route", ADD, iface, dest.getAddress().getHostAddress(), dest.getNetworkPrefixLength());
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearMarkedForwardingRoute(String iface, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            LinkAddress dest = route.getDestination();
            this.mConnector.execute("interface", "fwmark", "route", REMOVE, iface, dest.getAddress().getHostAddress(), dest.getNetworkPrefixLength());
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setHostExemption(LinkAddress host) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "fwmark", "exempt", ADD, host);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearHostExemption(LinkAddress host) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "fwmark", "exempt", REMOVE, host);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setDnsInterfaceForUidRange(String iface, int uid_start, int uid_end) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "setifaceforuidrange", iface, uid_start, uid_end);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearDnsInterfaceForUidRange(int uid_start, int uid_end) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "clearifaceforuidrange", uid_start, uid_end);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearDnsInterfaceMaps() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "clearifacemapping");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void flushDefaultDnsCache() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "flushdefaultif");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void flushInterfaceDnsCache(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "flushif", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setFirewallEnabled(boolean enabled) {
        NetworkManagementService.enforceSystemUid();
        try {
            this.mConnector.execute("firewall", enabled ? "enable" : "disable");
            this.mFirewallEnabled = enabled;
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public boolean isFirewallEnabled() {
        NetworkManagementService.enforceSystemUid();
        return this.mFirewallEnabled;
    }

    @Override
    public void setFirewallInterfaceRule(String iface, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        String rule = allow ? ALLOW : DENY;
        try {
            this.mConnector.execute("firewall", "set_interface_rule", iface, rule);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setFirewallEgressSourceRule(String addr, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        String rule = allow ? ALLOW : DENY;
        try {
            this.mConnector.execute("firewall", "set_egress_source_rule", addr, rule);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setFirewallEgressDestRule(String addr, int port, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        String rule = allow ? ALLOW : DENY;
        try {
            this.mConnector.execute("firewall", "set_egress_dest_rule", addr, port, rule);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setFirewallUidRule(int uid, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        String rule = allow ? ALLOW : DENY;
        try {
            this.mConnector.execute("firewall", "set_uid_rule", uid, rule);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    private static void enforceSystemUid() {
        int uid = Binder.getCallingUid();
        if (uid != 1000) {
            throw new SecurityException("Only available to AID_SYSTEM");
        }
    }

    @Override
    public void setDnsInterfaceForPid(String iface, int pid) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "setifaceforpid", iface, pid);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating with native deamon to set interface for pid" + iface, e);
        }
    }

    @Override
    public void clearDnsInterfaceForPid(int pid) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("resolver", "clearifaceforpid", pid);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating with native deamon to clear interface for pid " + pid, e);
        }
    }

    @Override
    public void startClatd(String interfaceName) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("clatd", "start", interfaceName);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void stopClatd() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("clatd", "stop");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public boolean isClatdStarted() {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("clatd", "status");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(223);
        return event.getMessage().endsWith("started");
    }

    @Override
    public void monitor() {
        if (this.mConnector != null) {
            this.mConnector.monitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        pw.println("NetworkManagementService NativeDaemonConnector Log:");
        this.mConnector.dump(fd, pw, args);
        pw.println();
        pw.print("Bandwidth control enabled: ");
        pw.println(this.mBandwidthControlEnabled);
        Object object = this.mQuotaLock;
        synchronized (object) {
            pw.print("Active quota ifaces: ");
            pw.println(this.mActiveQuotas.toString());
            pw.print("Active alert ifaces: ");
            pw.println(this.mActiveAlerts.toString());
        }
        object = this.mUidRejectOnQuota;
        synchronized (object) {
            pw.print("UID reject on quota ifaces: [");
            int size = this.mUidRejectOnQuota.size();
            for (int i = 0; i < size; ++i) {
                pw.print(this.mUidRejectOnQuota.keyAt(i));
                if (i >= size - 1) continue;
                pw.print(",");
            }
            pw.println("]");
        }
        pw.print("Firewall enabled: ");
        pw.println(this.mFirewallEnabled);
    }

    private class NetdCallbackReceiver
    implements INativeDaemonConnectorCallbacks {
        private NetdCallbackReceiver() {
        }

        public void onDaemonConnected() {
            if (NetworkManagementService.this.mConnectedSignal != null) {
                NetworkManagementService.this.mConnectedSignal.countDown();
                NetworkManagementService.this.mConnectedSignal = null;
            } else {
                NetworkManagementService.this.mMainHandler.post(new Runnable(){

                    public void run() {
                        NetworkManagementService.this.prepareNativeDaemon();
                    }
                });
            }
        }

        public boolean onEvent(int code, String raw2, String[] cooked) {
            String errorMessage = String.format("Invalid event from daemon (%s)", raw2);
            switch (code) {
                case 600: {
                    if (cooked.length < 4 || !cooked[1].equals("Iface")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    if (cooked[2].equals("added")) {
                        NetworkManagementService.this.notifyInterfaceAdded(cooked[3]);
                        return true;
                    }
                    if (cooked[2].equals("removed")) {
                        NetworkManagementService.this.notifyInterfaceRemoved(cooked[3]);
                        return true;
                    }
                    if (cooked[2].equals("changed") && cooked.length == 5) {
                        NetworkManagementService.this.notifyInterfaceStatusChanged(cooked[3], cooked[4].equals("up"));
                        return true;
                    }
                    if (cooked[2].equals("linkstate") && cooked.length == 5) {
                        NetworkManagementService.this.notifyInterfaceLinkStateChanged(cooked[3], cooked[4].equals("up"));
                        return true;
                    }
                    throw new IllegalStateException(errorMessage);
                }
                case 601: {
                    if (cooked.length < 5 || !cooked[1].equals("limit")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    if (cooked[2].equals("alert")) {
                        NetworkManagementService.this.notifyLimitReached(cooked[3], cooked[4]);
                        return true;
                    }
                    throw new IllegalStateException(errorMessage);
                }
                case 613: {
                    if (cooked.length < 4 || !cooked[1].equals("IfaceClass")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    boolean isActive = cooked[2].equals("active");
                    NetworkManagementService.this.notifyInterfaceClassActivity(cooked[3], isActive);
                    return true;
                }
                case 614: {
                    LinkAddress address;
                    if (cooked.length < 7 || !cooked[1].equals("Address")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    String iface = cooked[4];
                    try {
                        int flags = Integer.parseInt(cooked[5]);
                        int scope = Integer.parseInt(cooked[6]);
                        address = new LinkAddress(cooked[3], flags, scope);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException(errorMessage, e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException(errorMessage, e);
                    }
                    if (cooked[2].equals("updated")) {
                        NetworkManagementService.this.notifyAddressUpdated(iface, address);
                    } else {
                        NetworkManagementService.this.notifyAddressRemoved(iface, address);
                    }
                    return true;
                }
                case 615: {
                    if (cooked.length == 6 && cooked[1].equals("DnsInfo") && cooked[2].equals("servers")) {
                        long lifetime;
                        try {
                            lifetime = Long.parseLong(cooked[4]);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalStateException(errorMessage);
                        }
                        String[] servers = cooked[5].split(",");
                        NetworkManagementService.this.notifyInterfaceDnsServerInfo(cooked[3], lifetime, servers);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static class IdleTimerParams {
        public final int timeout;
        public final String label;
        public int networkCount;

        IdleTimerParams(int timeout, String label) {
            this.timeout = timeout;
            this.label = label;
            this.networkCount = 1;
        }
    }

    class NetdResponseCode {
        public static final int InterfaceListResult = 110;
        public static final int TetherInterfaceListResult = 111;
        public static final int TetherDnsFwdTgtListResult = 112;
        public static final int TtyListResult = 113;
        public static final int TetheringStatsListResult = 114;
        public static final int TetherStatusResult = 210;
        public static final int IpFwdStatusResult = 211;
        public static final int InterfaceGetCfgResult = 213;
        public static final int SoftapStatusResult = 214;
        public static final int InterfaceRxCounterResult = 216;
        public static final int InterfaceTxCounterResult = 217;
        public static final int QuotaCounterResult = 220;
        public static final int TetheringStatsResult = 221;
        public static final int DnsProxyQueryResult = 222;
        public static final int ClatdStatusResult = 223;
        public static final int GetMarkResult = 225;
        public static final int InterfaceChange = 600;
        public static final int BandwidthControl = 601;
        public static final int InterfaceClassActivity = 613;
        public static final int InterfaceAddressChange = 614;
        public static final int InterfaceDnsServerInfo = 615;

        NetdResponseCode() {
        }
    }
}

