/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppGlobals;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.content.PackageMonitor;
import java.util.List;

public class RecognitionManagerService
extends Binder {
    static final String TAG = "RecognitionManagerService";
    private final Context mContext;
    private final MyPackageMonitor mMonitor;
    private final IPackageManager mIPm;
    private static final boolean DEBUG = false;
    BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int userHandle;
            String action = intent.getAction();
            if ("android.intent.action.BOOT_COMPLETED".equals(action) && (userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1)) > 0) {
                RecognitionManagerService.this.initForUser(userHandle);
            }
        }
    };

    RecognitionManagerService(Context context) {
        this.mContext = context;
        this.mMonitor = new MyPackageMonitor();
        this.mMonitor.register(context, null, UserHandle.ALL, true);
        this.mIPm = AppGlobals.getPackageManager();
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, new IntentFilter("android.intent.action.BOOT_COMPLETED"), null, null);
    }

    public void systemReady() {
        this.initForUser(0);
    }

    private void initForUser(int userHandle) {
        ComponentName comp = this.getCurRecognizer(userHandle);
        ServiceInfo info = null;
        if (comp != null) {
            try {
                info = this.mIPm.getServiceInfo(comp, 0, userHandle);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (info == null && (comp = this.findAvailRecognizer(null, userHandle)) != null) {
            this.setCurRecognizer(comp, userHandle);
        }
    }

    ComponentName findAvailRecognizer(String prefPackage, int userHandle) {
        List<ResolveInfo> available = this.mContext.getPackageManager().queryIntentServicesAsUser(new Intent("android.speech.RecognitionService"), 0, userHandle);
        int numAvailable = available.size();
        if (numAvailable == 0) {
            Slog.w(TAG, "no available voice recognition services found for user " + userHandle);
            return null;
        }
        if (prefPackage != null) {
            for (int i = 0; i < numAvailable; ++i) {
                ServiceInfo serviceInfo = available.get((int)i).serviceInfo;
                if (!prefPackage.equals(serviceInfo.packageName)) continue;
                return new ComponentName(serviceInfo.packageName, serviceInfo.name);
            }
        }
        if (numAvailable > 1) {
            Slog.w(TAG, "more than one voice recognition service found, picking first");
        }
        ServiceInfo serviceInfo = available.get((int)0).serviceInfo;
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }

    ComponentName getCurRecognizer(int userHandle) {
        String curRecognizer = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "voice_recognition_service", userHandle);
        if (TextUtils.isEmpty(curRecognizer)) {
            return null;
        }
        return ComponentName.unflattenFromString(curRecognizer);
    }

    void setCurRecognizer(ComponentName comp, int userHandle) {
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "voice_recognition_service", comp != null ? comp.flattenToShortString() : "", userHandle);
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        public void onSomePackagesChanged() {
            int userHandle = this.getChangingUserId();
            ComponentName comp = RecognitionManagerService.this.getCurRecognizer(userHandle);
            if (comp == null) {
                if (this.anyPackagesAppearing() && (comp = RecognitionManagerService.this.findAvailRecognizer(null, userHandle)) != null) {
                    RecognitionManagerService.this.setCurRecognizer(comp, userHandle);
                }
                return;
            }
            int change = this.isPackageDisappearing(comp.getPackageName());
            if (change == 3 || change == 2) {
                RecognitionManagerService.this.setCurRecognizer(RecognitionManagerService.this.findAvailRecognizer(null, userHandle), userHandle);
            } else if (this.isPackageModified(comp.getPackageName())) {
                RecognitionManagerService.this.setCurRecognizer(RecognitionManagerService.this.findAvailRecognizer(comp.getPackageName(), userHandle), userHandle);
            }
        }
    }
}

