/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.os.PowerManager;
import android.util.Pools;
import android.view.Choreographer;
import android.view.InputEvent;
import android.view.InputFilter;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityEvent;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.EventStreamTransformation;
import com.android.server.accessibility.ScreenMagnifier;
import com.android.server.accessibility.TouchExplorer;

class AccessibilityInputFilter
extends InputFilter
implements EventStreamTransformation {
    private static final String TAG = AccessibilityInputFilter.class.getSimpleName();
    private static final boolean DEBUG = false;
    static final int FLAG_FEATURE_SCREEN_MAGNIFIER = 1;
    static final int FLAG_FEATURE_TOUCH_EXPLORATION = 2;
    static final int FLAG_FEATURE_FILTER_KEY_EVENTS = 4;
    private final Runnable mProcessBatchedEventsRunnable = new Runnable(){

        public void run() {
            long frameTimeNanos = AccessibilityInputFilter.this.mChoreographer.getFrameTimeNanos();
            AccessibilityInputFilter.this.processBatchedEvents(frameTimeNanos);
            if (AccessibilityInputFilter.this.mEventQueue != null) {
                AccessibilityInputFilter.this.scheduleProcessBatchedEvents();
            }
        }
    };
    private final Context mContext;
    private final PowerManager mPm;
    private final AccessibilityManagerService mAms;
    private final Choreographer mChoreographer;
    private int mCurrentTouchDeviceId;
    private boolean mInstalled;
    private int mEnabledFeatures;
    private TouchExplorer mTouchExplorer;
    private ScreenMagnifier mScreenMagnifier;
    private EventStreamTransformation mEventHandler;
    private MotionEventHolder mEventQueue;
    private boolean mMotionEventSequenceStarted;
    private boolean mHoverEventSequenceStarted;
    private boolean mKeyEventSequenceStarted;
    private boolean mFilterKeyEvents;

    AccessibilityInputFilter(Context context, AccessibilityManagerService service) {
        super(context.getMainLooper());
        this.mContext = context;
        this.mAms = service;
        this.mPm = (PowerManager)context.getSystemService("power");
        this.mChoreographer = Choreographer.getInstance();
    }

    public void onInstalled() {
        this.mInstalled = true;
        this.disableFeatures();
        this.enableFeatures();
        super.onInstalled();
    }

    public void onUninstalled() {
        this.mInstalled = false;
        this.disableFeatures();
        super.onUninstalled();
    }

    public void onInputEvent(InputEvent event, int policyFlags) {
        if (event instanceof MotionEvent && event.isFromSource(4098)) {
            MotionEvent motionEvent = (MotionEvent)event;
            this.onMotionEvent(motionEvent, policyFlags);
        } else if (event instanceof KeyEvent && event.isFromSource(257)) {
            KeyEvent keyEvent = (KeyEvent)event;
            this.onKeyEvent(keyEvent, policyFlags);
        } else {
            super.onInputEvent(event, policyFlags);
        }
    }

    private void onMotionEvent(MotionEvent event, int policyFlags) {
        if (this.mEventHandler == null) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if ((policyFlags & 0x40000000) == 0) {
            this.mMotionEventSequenceStarted = false;
            this.mHoverEventSequenceStarted = false;
            this.mEventHandler.clear();
            super.onInputEvent(event, policyFlags);
            return;
        }
        int deviceId = event.getDeviceId();
        if (this.mCurrentTouchDeviceId != deviceId) {
            this.mCurrentTouchDeviceId = deviceId;
            this.mMotionEventSequenceStarted = false;
            this.mHoverEventSequenceStarted = false;
            this.mEventHandler.clear();
        }
        if (this.mCurrentTouchDeviceId < 0) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (event.getActionMasked() == 8) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (event.isTouchEvent()) {
            if (!this.mMotionEventSequenceStarted) {
                if (event.getActionMasked() != 0) {
                    return;
                }
                this.mMotionEventSequenceStarted = true;
            }
        } else if (!this.mHoverEventSequenceStarted) {
            if (event.getActionMasked() != 9) {
                return;
            }
            this.mHoverEventSequenceStarted = true;
        }
        this.batchMotionEvent(event, policyFlags);
    }

    private void onKeyEvent(KeyEvent event, int policyFlags) {
        if (!this.mFilterKeyEvents) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if ((policyFlags & 0x40000000) == 0) {
            this.mKeyEventSequenceStarted = false;
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (!this.mKeyEventSequenceStarted) {
            if (event.getAction() != 0) {
                return;
            }
            this.mKeyEventSequenceStarted = true;
        }
        this.mAms.notifyKeyEvent(event, policyFlags);
    }

    private void scheduleProcessBatchedEvents() {
        this.mChoreographer.postCallback(0, this.mProcessBatchedEventsRunnable, null);
    }

    private void batchMotionEvent(MotionEvent event, int policyFlags) {
        if (this.mEventQueue == null) {
            this.mEventQueue = MotionEventHolder.obtain(event, policyFlags);
            this.scheduleProcessBatchedEvents();
            return;
        }
        if (this.mEventQueue.event.addBatch(event)) {
            return;
        }
        MotionEventHolder holder = MotionEventHolder.obtain(event, policyFlags);
        holder.next = this.mEventQueue;
        this.mEventQueue.previous = holder;
        this.mEventQueue = holder;
    }

    private void processBatchedEvents(long frameNanos) {
        MotionEventHolder current = this.mEventQueue;
        while (current.next != null) {
            current = current.next;
        }
        while (true) {
            if (current == null) {
                this.mEventQueue = null;
                break;
            }
            if (current.event.getEventTimeNano() >= frameNanos) {
                current.next = null;
                break;
            }
            this.handleMotionEvent(current.event, current.policyFlags);
            MotionEventHolder prior = current;
            current = current.previous;
            prior.recycle();
        }
    }

    private void handleMotionEvent(MotionEvent event, int policyFlags) {
        if (this.mEventHandler != null) {
            this.mPm.userActivity(event.getEventTime(), false);
            MotionEvent transformedEvent = MotionEvent.obtain(event);
            this.mEventHandler.onMotionEvent(transformedEvent, event, policyFlags);
            transformedEvent.recycle();
        }
    }

    public void onMotionEvent(MotionEvent transformedEvent, MotionEvent rawEvent, int policyFlags) {
        this.sendInputEvent(transformedEvent, policyFlags);
    }

    public void onAccessibilityEvent(AccessibilityEvent event) {
    }

    public void setNext(EventStreamTransformation sink) {
    }

    public void clear() {
    }

    void setEnabledFeatures(int enabledFeatures) {
        if (this.mEnabledFeatures == enabledFeatures) {
            return;
        }
        if (this.mInstalled) {
            this.disableFeatures();
        }
        this.mEnabledFeatures = enabledFeatures;
        if (this.mInstalled) {
            this.enableFeatures();
        }
    }

    void notifyAccessibilityEvent(AccessibilityEvent event) {
        if (this.mEventHandler != null) {
            this.mEventHandler.onAccessibilityEvent(event);
        }
    }

    private void enableFeatures() {
        this.mMotionEventSequenceStarted = false;
        this.mHoverEventSequenceStarted = false;
        if ((this.mEnabledFeatures & 1) != 0) {
            this.mScreenMagnifier = new ScreenMagnifier(this.mContext, 0, this.mAms);
            this.mEventHandler = this.mScreenMagnifier;
            this.mEventHandler.setNext(this);
        }
        if ((this.mEnabledFeatures & 2) != 0) {
            this.mTouchExplorer = new TouchExplorer(this.mContext, this.mAms);
            this.mTouchExplorer.setNext(this);
            if (this.mEventHandler != null) {
                this.mEventHandler.setNext(this.mTouchExplorer);
            } else {
                this.mEventHandler = this.mTouchExplorer;
            }
        }
        if ((this.mEnabledFeatures & 4) != 0) {
            this.mFilterKeyEvents = true;
        }
    }

    void disableFeatures() {
        if (this.mTouchExplorer != null) {
            this.mTouchExplorer.clear();
            this.mTouchExplorer.onDestroy();
            this.mTouchExplorer = null;
        }
        if (this.mScreenMagnifier != null) {
            this.mScreenMagnifier.clear();
            this.mScreenMagnifier.onDestroy();
            this.mScreenMagnifier = null;
        }
        this.mEventHandler = null;
        this.mKeyEventSequenceStarted = false;
        this.mMotionEventSequenceStarted = false;
        this.mHoverEventSequenceStarted = false;
        this.mFilterKeyEvents = false;
    }

    public void onDestroy() {
    }

    private static class MotionEventHolder {
        private static final int MAX_POOL_SIZE = 32;
        private static final Pools.SimplePool<MotionEventHolder> sPool = new Pools.SimplePool(32);
        public int policyFlags;
        public MotionEvent event;
        public MotionEventHolder next;
        public MotionEventHolder previous;

        private MotionEventHolder() {
        }

        public static MotionEventHolder obtain(MotionEvent event, int policyFlags) {
            MotionEventHolder holder = sPool.acquire();
            if (holder == null) {
                holder = new MotionEventHolder();
            }
            holder.event = MotionEvent.obtain(event);
            holder.policyFlags = policyFlags;
            return holder;
        }

        public void recycle() {
            this.event.recycle();
            this.event = null;
            this.policyFlags = 0;
            this.next = null;
            this.previous = null;
            sPool.release(this);
        }
    }
}

