/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ApplicationErrorReport;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ProcessRecord;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.net.InetSocketAddress;
import java.net.InetUnixAddress;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructTimeval;

final class NativeCrashListener
extends Thread {
    static final String TAG = "NativeCrashListener";
    static final boolean DEBUG = false;
    static final boolean MORE_DEBUG = false;
    static final String DEBUGGERD_SOCKET_PATH = "/data/system/ndebugsocket";
    static final long SOCKET_TIMEOUT_MILLIS = 2000L;
    final ActivityManagerService mAm = ActivityManagerService.self();

    NativeCrashListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        ackSignal = new byte[1];
        socketFile = new File("/data/system/ndebugsocket");
        if (socketFile.exists()) {
            socketFile.delete();
        }
        try {
            serverFd = Libcore.os.socket(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0);
            sockAddr = new InetUnixAddress("/data/system/ndebugsocket");
            Libcore.os.bind(serverFd, sockAddr, 0);
            Libcore.os.listen(serverFd, 1);
            while (true) lbl-1000:
            // 6 sources

            {
                block17: {
                    peer = new InetSocketAddress();
                    peerFd = null;
                    peerFd = Libcore.os.accept(serverFd, peer);
                    if (peerFd == null) break block17;
                    credentials = Libcore.os.getsockoptUcred(peerFd, OsConstants.SOL_SOCKET, OsConstants.SO_PEERCRED);
                    if (credentials.uid != 0) break block17;
                    this.consumeNativeCrashData(peerFd);
                }
                var8_9 = null;
                if (peerFd == null) continue;
                try {
                    Libcore.os.write(peerFd, ackSignal, 0, 1);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Libcore.os.close(peerFd);
                }
                catch (ErrnoException e) {}
                continue;
                {
                    catch (Exception e) {
                        Slog.w("NativeCrashListener", "Error handling connection", e);
                        var8_9 = null;
                        if (peerFd == null) continue;
                        try {
                            Libcore.os.write(peerFd, ackSignal, 0, 1);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Libcore.os.close(peerFd);
                        }
                        catch (ErrnoException e) {}
                        continue;
                    }
                }
                catch (Throwable var7_11) {
                    var8_9 = null;
                    if (peerFd != null) {
                        try {
                            Libcore.os.write(peerFd, ackSignal, 0, 1);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Libcore.os.close(peerFd);
                        }
                        catch (ErrnoException e) {
                            // empty catch block
                        }
                    }
                    throw var7_11;
                }
                break;
            }
        }
        catch (Exception e) {
            Slog.e("NativeCrashListener", "Unable to init native debug socket!", e);
            return;
        }
        {
            ** while (true)
        }
    }

    static int unpackInt(byte[] buf, int offset) {
        int b0 = buf[offset] & 0xFF;
        int b1 = buf[offset + 1] & 0xFF;
        int b2 = buf[offset + 2] & 0xFF;
        int b3 = buf[offset + 3] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    static int readExactly(FileDescriptor fd, byte[] buffer, int offset, int numBytes) throws ErrnoException {
        int totalRead = 0;
        while (numBytes > 0) {
            int n = Libcore.os.read(fd, buffer, offset + totalRead, numBytes);
            if (n <= 0) {
                return -1;
            }
            numBytes -= n;
            totalRead += n;
        }
        return totalRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consumeNativeCrashData(FileDescriptor fd) {
        block14: {
            byte[] buf = new byte[4096];
            ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
            try {
                StructTimeval timeout = StructTimeval.fromMillis(2000L);
                Libcore.os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, timeout);
                Libcore.os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, timeout);
                int headerBytes = NativeCrashListener.readExactly(fd, buf, 0, 8);
                if (headerBytes != 8) {
                    Slog.e(TAG, "Unable to read from debuggerd");
                    return;
                }
                int pid = NativeCrashListener.unpackInt(buf, 0);
                int signal = NativeCrashListener.unpackInt(buf, 4);
                if (pid > 0) {
                    ProcessRecord pr;
                    SparseArray<ProcessRecord> sparseArray = this.mAm.mPidsSelfLocked;
                    synchronized (sparseArray) {
                        pr = this.mAm.mPidsSelfLocked.get(pid);
                    }
                    if (pr != null) {
                        int bytes;
                        if (pr.persistent) {
                            return;
                        }
                        do {
                            if ((bytes = Libcore.os.read(fd, buf, 0, buf.length)) <= 0) continue;
                            if (buf[bytes - 1] == 0) {
                                os.write(buf, 0, bytes - 1);
                                break;
                            }
                            os.write(buf, 0, bytes);
                        } while (bytes > 0);
                        ActivityManagerService activityManagerService = this.mAm;
                        synchronized (activityManagerService) {
                            pr.crashing = true;
                            pr.forceCrashReport = true;
                        }
                        String reportString = new String(os.toByteArray(), "UTF-8");
                        new NativeCrashReporter(pr, signal, reportString).start();
                        break block14;
                    }
                    Slog.w(TAG, "Couldn't find ProcessRecord for pid " + pid);
                    break block14;
                }
                Slog.e(TAG, "Bogus pid!");
            }
            catch (Exception e) {
                Slog.e(TAG, "Exception dealing with report", e);
            }
        }
    }

    class NativeCrashReporter
    extends Thread {
        ProcessRecord mApp;
        int mSignal;
        String mCrashReport;

        NativeCrashReporter(ProcessRecord app, int signal, String report) {
            super("NativeCrashReport");
            this.mApp = app;
            this.mSignal = signal;
            this.mCrashReport = report;
        }

        public void run() {
            try {
                ApplicationErrorReport.CrashInfo ci = new ApplicationErrorReport.CrashInfo();
                ci.exceptionClassName = "Native crash";
                ci.exceptionMessage = Libcore.os.strsignal(this.mSignal);
                ci.throwFileName = "unknown";
                ci.throwClassName = "unknown";
                ci.throwMethodName = "unknown";
                ci.stackTrace = this.mCrashReport;
                NativeCrashListener.this.mAm.handleApplicationCrashInner("native_crash", this.mApp, this.mApp.processName, ci);
            }
            catch (Exception e) {
                Slog.e(NativeCrashListener.TAG, "Unable to report native crash", e);
            }
        }
    }
}

