/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.accounts.Account;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncRequest;
import android.content.SyncStatusInfo;
import android.database.IContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.server.content.SyncManager;
import com.android.server.content.SyncStorageEngine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentService
extends IContentService.Stub {
    private static final String TAG = "ContentService";
    private Context mContext;
    private boolean mFactoryTest;
    private final ObserverNode mRootNode = new ObserverNode("");
    private SyncManager mSyncManager = null;
    private final Object mSyncManagerLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncManager getSyncManager() {
        if (SystemProperties.getBoolean("config.disable_network", false)) {
            return null;
        }
        Object object = this.mSyncManagerLock;
        synchronized (object) {
            try {
                if (this.mSyncManager == null) {
                    this.mSyncManager = new SyncManager(this.mContext, this.mFactoryTest);
                }
            }
            catch (SQLiteException e) {
                Log.e(TAG, "Can't create SyncManager", e);
            }
            return this.mSyncManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "caller doesn't have the DUMP permission");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            if (this.mSyncManager == null) {
                pw.println("No SyncManager created!  (Disk full?)");
            } else {
                this.mSyncManager.dump(fd, pw);
            }
            pw.println();
            pw.println("Observer tree:");
            ObserverNode observerNode = this.mRootNode;
            synchronized (observerNode) {
                int i;
                int[] counts = new int[2];
                final SparseIntArray pidCounts = new SparseIntArray();
                this.mRootNode.dumpLocked(fd, pw, args, "", "  ", counts, pidCounts);
                pw.println();
                ArrayList<Integer> sorted = new ArrayList<Integer>();
                for (i = 0; i < pidCounts.size(); ++i) {
                    sorted.add(pidCounts.keyAt(i));
                }
                Collections.sort(sorted, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer lhs, Integer rhs) {
                        int rc;
                        int lc = pidCounts.get(lhs);
                        if (lc < (rc = pidCounts.get(rhs))) {
                            return 1;
                        }
                        if (lc > rc) {
                            return -1;
                        }
                        return 0;
                    }
                });
                for (i = 0; i < sorted.size(); ++i) {
                    int pid = (Integer)sorted.get(i);
                    pw.print("  pid ");
                    pw.print(pid);
                    pw.print(": ");
                    pw.print(pidCounts.get(pid));
                    pw.println(" observers");
                }
                pw.println();
                pw.print(" Total number of nodes: ");
                pw.println(counts[0]);
                pw.print(" Total number of observers: ");
                pw.println(counts[1]);
            }
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Content Service Crash", e);
            }
            throw e;
        }
    }

    ContentService(Context context, boolean factoryTest) {
        this.mContext = context;
        this.mFactoryTest = factoryTest;
    }

    public void systemReady() {
        this.getSyncManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContentObserver(Uri uri, boolean notifyForDescendants, IContentObserver observer, int userHandle) {
        if (observer == null || uri == null) {
            throw new IllegalArgumentException("You must pass a valid uri and observer");
        }
        int callingUser = UserHandle.getCallingUserId();
        if (callingUser != userHandle) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "no permission to observe other users' provider view");
        }
        if (userHandle < 0) {
            if (userHandle == -2) {
                userHandle = ActivityManager.getCurrentUser();
            } else if (userHandle != -1) {
                throw new InvalidParameterException("Bad user handle for registerContentObserver: " + userHandle);
            }
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.addObserverLocked(uri, observer, notifyForDescendants, this.mRootNode, Binder.getCallingUid(), Binder.getCallingPid(), userHandle);
        }
    }

    public void registerContentObserver(Uri uri, boolean notifyForDescendants, IContentObserver observer) {
        this.registerContentObserver(uri, notifyForDescendants, observer, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterContentObserver(IContentObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("You must pass a valid observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.removeObserverLocked(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChange(Uri uri, IContentObserver observer, boolean observerWantsSelfNotifications, boolean syncToNetwork, int userHandle) {
        int callingUserHandle;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "Notifying update of " + uri + " for user " + userHandle + " from observer " + observer + ", syncToNetwork " + syncToNetwork);
        }
        if (userHandle != (callingUserHandle = UserHandle.getCallingUserId())) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "no permission to notify other users");
        }
        if (userHandle < 0) {
            if (userHandle == -2) {
                userHandle = ActivityManager.getCurrentUser();
            } else if (userHandle != -1) {
                throw new InvalidParameterException("Bad user handle for notifyChange: " + userHandle);
            }
        }
        int uid = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager;
            ArrayList<ObserverCall> calls = new ArrayList<ObserverCall>();
            ObserverNode observerNode = this.mRootNode;
            synchronized (observerNode) {
                this.mRootNode.collectObserversLocked(uri, 0, observer, observerWantsSelfNotifications, userHandle, calls);
            }
            int numCalls = calls.size();
            for (int i = 0; i < numCalls; ++i) {
                ObserverCall oc = calls.get(i);
                try {
                    oc.mObserver.onChange(oc.mSelfChange, uri);
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Notified " + oc.mObserver + " of " + "update at " + uri);
                    continue;
                }
                catch (RemoteException ex) {
                    ObserverNode observerNode2 = this.mRootNode;
                    synchronized (observerNode2) {
                        Log.w(TAG, "Found dead observer, removing");
                        IBinder binder = oc.mObserver.asBinder();
                        ArrayList list = oc.mNode.mObservers;
                        int numList = list.size();
                        for (int j = 0; j < numList; ++j) {
                            ObserverNode.ObserverEntry oe = (ObserverNode.ObserverEntry)list.get(j);
                            if (oe.observer.asBinder() != binder) continue;
                            list.remove(j);
                            --j;
                            --numList;
                        }
                        continue;
                    }
                }
            }
            if (syncToNetwork && (syncManager = this.getSyncManager()) != null) {
                syncManager.scheduleLocalSync(null, callingUserHandle, uid, uri.getAuthority());
            }
            Object var23_24 = null;
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    public void notifyChange(Uri uri, IContentObserver observer, boolean observerWantsSelfNotifications, boolean syncToNetwork) {
        this.notifyChange(uri, observer, observerWantsSelfNotifications, syncToNetwork, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSync(Account account, String authority, Bundle extras) {
        ContentResolver.validateSyncExtrasBundle(extras);
        int userId = UserHandle.getCallingUserId();
        int uId = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.scheduleSync(account, userId, uId, authority, extras, 0L, 0L, false);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(SyncRequest request) {
        Bundle extras = request.getBundle();
        long flextime = request.getSyncFlexTime();
        long runAtTime = request.getSyncRunTime();
        int userId = UserHandle.getCallingUserId();
        int uId = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                if (request.hasAuthority()) {
                    Account account = request.getAccount();
                    String provider = request.getProvider();
                    if (request.isPeriodic()) {
                        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
                        if (runAtTime < 60L) {
                            Slog.w(TAG, "Requested poll frequency of " + runAtTime + " seconds being rounded up to 60 seconds.");
                            runAtTime = 60L;
                        }
                        PeriodicSync syncToAdd = new PeriodicSync(account, provider, extras, runAtTime, flextime);
                        this.getSyncManager().getSyncStorageEngine().addPeriodicSync(syncToAdd, userId);
                    } else {
                        long beforeRuntimeMillis = flextime * 1000L;
                        long runtimeMillis = runAtTime * 1000L;
                        syncManager.scheduleSync(account, userId, uId, provider, extras, beforeRuntimeMillis, runtimeMillis, false);
                    }
                } else {
                    Log.w(TAG, "Unrecognised sync parameters, doing nothing.");
                }
            }
            Object var19_14 = null;
        }
        catch (Throwable throwable) {
            Object var19_15 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSync(Account account, String authority) {
        if (authority != null && authority.length() == 0) {
            throw new IllegalArgumentException("Authority must be non-empty");
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.clearScheduledSyncOperations(account, userId, authority);
                syncManager.cancelActiveSync(account, userId, authority);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncAdapterType[] getSyncAdapterTypes() {
        SyncAdapterType[] syncAdapterTypeArray;
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            syncAdapterTypeArray = syncManager.getSyncAdapterTypes(userId);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
        return syncAdapterTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSyncAutomatically(Account account, String providerName) {
        long identityToken;
        block3: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            int userId = UserHandle.getCallingUserId();
            identityToken = ContentService.clearCallingIdentity();
            try {
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block3;
                bl = syncManager.getSyncStorageEngine().getSyncAutomatically(account, userId, providerName);
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ContentService.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(identityToken);
            return bl;
        }
        Object var9_8 = null;
        ContentService.restoreCallingIdentity(identityToken);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncAutomatically(Account account, String providerName, boolean sync) {
        if (TextUtils.isEmpty(providerName)) {
            throw new IllegalArgumentException("Authority must be non-empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setSyncAutomatically(account, userId, providerName, sync);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        if (account == null) {
            throw new IllegalArgumentException("Account must not be null");
        }
        if (TextUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("Authority must not be empty.");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        if (pollFrequency < 60L) {
            Slog.w(TAG, "Requested poll frequency of " + pollFrequency + " seconds being rounded up to 60 seconds.");
            pollFrequency = 60L;
        }
        long identityToken = ContentService.clearCallingIdentity();
        try {
            PeriodicSync syncToAdd = new PeriodicSync(account, authority, extras, pollFrequency, SyncStorageEngine.calculateDefaultFlexTime(pollFrequency));
            this.getSyncManager().getSyncStorageEngine().addPeriodicSync(syncToAdd, userId);
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePeriodicSync(Account account, String authority, Bundle extras) {
        if (account == null) {
            throw new IllegalArgumentException("Account must not be null");
        }
        if (TextUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("Authority must not be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            PeriodicSync syncToRemove = new PeriodicSync(account, authority, extras, 0L, 0L);
            this.getSyncManager().getSyncStorageEngine().removePeriodicSync(syncToRemove, userId);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    public void removeSync(SyncRequest request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeriodicSync> getPeriodicSyncs(Account account, String providerName) {
        List<PeriodicSync> list;
        if (account == null) {
            throw new IllegalArgumentException("Account must not be null");
        }
        if (TextUtils.isEmpty(providerName)) {
            throw new IllegalArgumentException("Authority must not be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            list = this.getSyncManager().getSyncStorageEngine().getPeriodicSyncs(account, userId, providerName);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIsSyncable(Account account, String providerName) {
        long identityToken;
        block3: {
            int n;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            int userId = UserHandle.getCallingUserId();
            identityToken = ContentService.clearCallingIdentity();
            try {
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block3;
                n = syncManager.getIsSyncable(account, userId, providerName);
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ContentService.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(identityToken);
            return n;
        }
        Object var9_8 = null;
        ContentService.restoreCallingIdentity(identityToken);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsSyncable(Account account, String providerName, int syncable) {
        if (TextUtils.isEmpty(providerName)) {
            throw new IllegalArgumentException("Authority must not be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setIsSyncable(account, userId, providerName, syncable);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMasterSyncAutomatically() {
        long identityToken;
        block3: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            int userId = UserHandle.getCallingUserId();
            identityToken = ContentService.clearCallingIdentity();
            try {
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block3;
                bl = syncManager.getSyncStorageEngine().getMasterSyncAutomatically(userId);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ContentService.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(identityToken);
            return bl;
        }
        Object var7_6 = null;
        ContentService.restoreCallingIdentity(identityToken);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterSyncAutomatically(boolean flag) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setMasterSyncAutomatically(flag, userId);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSyncActive(Account account, String authority) {
        long identityToken;
        block3: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            int userId = UserHandle.getCallingUserId();
            identityToken = ContentService.clearCallingIdentity();
            try {
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block3;
                bl = syncManager.getSyncStorageEngine().isSyncActive(account, userId, authority);
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ContentService.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(identityToken);
            return bl;
        }
        Object var9_8 = null;
        ContentService.restoreCallingIdentity(identityToken);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SyncInfo> getCurrentSyncs() {
        List<SyncInfo> list;
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            list = this.getSyncManager().getSyncStorageEngine().getCurrentSyncsCopy(userId);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncStatusInfo getSyncStatus(Account account, String authority) {
        long identityToken;
        block4: {
            SyncStatusInfo syncStatusInfo;
            if (TextUtils.isEmpty(authority)) {
                throw new IllegalArgumentException("Authority must not be empty");
            }
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            int userId = UserHandle.getCallingUserId();
            identityToken = ContentService.clearCallingIdentity();
            try {
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block4;
                syncStatusInfo = syncManager.getSyncStorageEngine().getStatusByAccountAndAuthority(account, userId, authority);
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ContentService.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(identityToken);
            return syncStatusInfo;
        }
        Object var9_8 = null;
        ContentService.restoreCallingIdentity(identityToken);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSyncPending(Account account, String authority) {
        long identityToken;
        block3: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            int userId = UserHandle.getCallingUserId();
            identityToken = ContentService.clearCallingIdentity();
            try {
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block3;
                bl = syncManager.getSyncStorageEngine().isSyncPending(account, userId, authority);
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ContentService.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(identityToken);
            return bl;
        }
        Object var9_8 = null;
        ContentService.restoreCallingIdentity(identityToken);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusChangeListener(int mask, ISyncStatusObserver callback) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && callback != null) {
                syncManager.getSyncStorageEngine().addStatusChangeListener(mask, callback);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatusChangeListener(ISyncStatusObserver callback) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && callback != null) {
                syncManager.getSyncStorageEngine().removeStatusChangeListener(callback);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ContentService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(identityToken);
    }

    public static ContentService main(Context context, boolean factoryTest) {
        ContentService service = new ContentService(context, factoryTest);
        ServiceManager.addService("content", service);
        return service;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObserverNode {
        public static final int INSERT_TYPE = 0;
        public static final int UPDATE_TYPE = 1;
        public static final int DELETE_TYPE = 2;
        private String mName;
        private ArrayList<ObserverNode> mChildren = new ArrayList();
        private ArrayList<ObserverEntry> mObservers = new ArrayList();

        public ObserverNode(String name) {
            this.mName = name;
        }

        public void dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args, String name, String prefix, int[] counts, SparseIntArray pidCounts) {
            int i;
            String innerName = null;
            if (this.mObservers.size() > 0) {
                innerName = "".equals(name) ? this.mName : name + "/" + this.mName;
                for (i = 0; i < this.mObservers.size(); ++i) {
                    counts[1] = counts[1] + 1;
                    this.mObservers.get(i).dumpLocked(fd, pw, args, innerName, prefix, pidCounts);
                }
            }
            if (this.mChildren.size() > 0) {
                if (innerName == null) {
                    innerName = "".equals(name) ? this.mName : name + "/" + this.mName;
                }
                for (i = 0; i < this.mChildren.size(); ++i) {
                    counts[0] = counts[0] + 1;
                    this.mChildren.get(i).dumpLocked(fd, pw, args, innerName, prefix, counts, pidCounts);
                }
            }
        }

        private String getUriSegment(Uri uri, int index) {
            if (uri != null) {
                if (index == 0) {
                    return uri.getAuthority();
                }
                return uri.getPathSegments().get(index - 1);
            }
            return null;
        }

        private int countUriSegments(Uri uri) {
            if (uri == null) {
                return 0;
            }
            return uri.getPathSegments().size() + 1;
        }

        public void addObserverLocked(Uri uri, IContentObserver observer, boolean notifyForDescendants, Object observersLock, int uid, int pid, int userHandle) {
            this.addObserverLocked(uri, 0, observer, notifyForDescendants, observersLock, uid, pid, userHandle);
        }

        private void addObserverLocked(Uri uri, int index, IContentObserver observer, boolean notifyForDescendants, Object observersLock, int uid, int pid, int userHandle) {
            if (index == this.countUriSegments(uri)) {
                this.mObservers.add(new ObserverEntry(observer, notifyForDescendants, observersLock, uid, pid, userHandle));
                return;
            }
            String segment = this.getUriSegment(uri, index);
            if (segment == null) {
                throw new IllegalArgumentException("Invalid Uri (" + uri + ") used for observer");
            }
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (!node.mName.equals(segment)) continue;
                node.addObserverLocked(uri, index + 1, observer, notifyForDescendants, observersLock, uid, pid, userHandle);
                return;
            }
            ObserverNode node = new ObserverNode(segment);
            this.mChildren.add(node);
            node.addObserverLocked(uri, index + 1, observer, notifyForDescendants, observersLock, uid, pid, userHandle);
        }

        public boolean removeObserverLocked(IContentObserver observer) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                boolean empty = this.mChildren.get(i).removeObserverLocked(observer);
                if (!empty) continue;
                this.mChildren.remove(i);
                --i;
                --size;
            }
            IBinder observerBinder = observer.asBinder();
            size = this.mObservers.size();
            for (int i = 0; i < size; ++i) {
                ObserverEntry entry = this.mObservers.get(i);
                if (entry.observer.asBinder() != observerBinder) continue;
                this.mObservers.remove(i);
                observerBinder.unlinkToDeath(entry, 0);
                break;
            }
            return this.mChildren.size() == 0 && this.mObservers.size() == 0;
        }

        private void collectMyObserversLocked(boolean leaf, IContentObserver observer, boolean observerWantsSelfNotifications, int targetUserHandle, ArrayList<ObserverCall> calls) {
            int N = this.mObservers.size();
            IBinder observerBinder = observer == null ? null : observer.asBinder();
            for (int i = 0; i < N; ++i) {
                boolean selfChange;
                ObserverEntry entry = this.mObservers.get(i);
                boolean bl = selfChange = entry.observer.asBinder() == observerBinder;
                if (selfChange && !observerWantsSelfNotifications || targetUserHandle != -1 && entry.userHandle != -1 && targetUserHandle != entry.userHandle || !leaf && (leaf || !entry.notifyForDescendants)) continue;
                calls.add(new ObserverCall(this, entry.observer, selfChange));
            }
        }

        public void collectObserversLocked(Uri uri, int index, IContentObserver observer, boolean observerWantsSelfNotifications, int targetUserHandle, ArrayList<ObserverCall> calls) {
            String segment = null;
            int segmentCount = this.countUriSegments(uri);
            if (index >= segmentCount) {
                this.collectMyObserversLocked(true, observer, observerWantsSelfNotifications, targetUserHandle, calls);
            } else if (index < segmentCount) {
                segment = this.getUriSegment(uri, index);
                this.collectMyObserversLocked(false, observer, observerWantsSelfNotifications, targetUserHandle, calls);
            }
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (segment != null && !node.mName.equals(segment)) continue;
                node.collectObserversLocked(uri, index + 1, observer, observerWantsSelfNotifications, targetUserHandle, calls);
                if (segment != null) break;
            }
        }

        private class ObserverEntry
        implements IBinder.DeathRecipient {
            public final IContentObserver observer;
            public final int uid;
            public final int pid;
            public final boolean notifyForDescendants;
            private final int userHandle;
            private final Object observersLock;

            public ObserverEntry(IContentObserver o, boolean n, Object observersLock, int _uid, int _pid, int _userHandle) {
                this.observersLock = observersLock;
                this.observer = o;
                this.uid = _uid;
                this.pid = _pid;
                this.userHandle = _userHandle;
                this.notifyForDescendants = n;
                try {
                    this.observer.asBinder().linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.binderDied();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void binderDied() {
                Object object = this.observersLock;
                synchronized (object) {
                    ObserverNode.this.removeObserverLocked(this.observer);
                }
            }

            public void dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args, String name, String prefix, SparseIntArray pidCounts) {
                pidCounts.put(this.pid, pidCounts.get(this.pid) + 1);
                pw.print(prefix);
                pw.print(name);
                pw.print(": pid=");
                pw.print(this.pid);
                pw.print(" uid=");
                pw.print(this.uid);
                pw.print(" user=");
                pw.print(this.userHandle);
                pw.print(" target=");
                pw.println(Integer.toHexString(System.identityHashCode(this.observer != null ? this.observer.asBinder() : null)));
            }
        }
    }

    public static final class ObserverCall {
        final ObserverNode mNode;
        final IContentObserver mObserver;
        final boolean mSelfChange;

        ObserverCall(ObserverNode node, IContentObserver observer, boolean selfChange) {
            this.mNode = node;
            this.mObserver = observer;
            this.mSelfChange = selfChange;
        }
    }
}

