/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.Context;
import android.database.ContentObserver;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.IBinder;
import android.provider.Settings;
import android.util.Slog;
import android.view.Surface;
import android.view.SurfaceControl;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayManagerService;
import com.android.server.display.OverlayDisplayWindow;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class OverlayDisplayAdapter
extends DisplayAdapter {
    static final String TAG = "OverlayDisplayAdapter";
    static final boolean DEBUG = false;
    private static final int MIN_WIDTH = 100;
    private static final int MIN_HEIGHT = 100;
    private static final int MAX_WIDTH = 4096;
    private static final int MAX_HEIGHT = 4096;
    private static final Pattern SETTING_PATTERN = Pattern.compile("(\\d+)x(\\d+)/(\\d+)(,[a-z]+)*");
    private final Handler mUiHandler;
    private final ArrayList<OverlayDisplayHandle> mOverlays = new ArrayList();
    private String mCurrentOverlaySetting = "";

    public OverlayDisplayAdapter(DisplayManagerService.SyncRoot syncRoot, Context context, Handler handler, DisplayAdapter.Listener listener, Handler uiHandler) {
        super(syncRoot, context, handler, listener, TAG);
        this.mUiHandler = uiHandler;
    }

    public void dumpLocked(PrintWriter pw) {
        super.dumpLocked(pw);
        pw.println("mCurrentOverlaySetting=" + this.mCurrentOverlaySetting);
        pw.println("mOverlays: size=" + this.mOverlays.size());
        for (OverlayDisplayHandle overlay : this.mOverlays) {
            overlay.dumpLocked(pw);
        }
    }

    public void registerLocked() {
        super.registerLocked();
        this.getHandler().post(new Runnable(){

            public void run() {
                OverlayDisplayAdapter.this.getContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("overlay_display_devices"), true, new ContentObserver(OverlayDisplayAdapter.this.getHandler()){

                    public void onChange(boolean selfChange) {
                        OverlayDisplayAdapter.this.updateOverlayDisplayDevices();
                    }
                });
                OverlayDisplayAdapter.this.updateOverlayDisplayDevices();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOverlayDisplayDevices() {
        DisplayManagerService.SyncRoot syncRoot = this.getSyncRoot();
        synchronized (syncRoot) {
            this.updateOverlayDisplayDevicesLocked();
        }
    }

    private void updateOverlayDisplayDevicesLocked() {
        String value = Settings.Global.getString(this.getContext().getContentResolver(), "overlay_display_devices");
        if (value == null) {
            value = "";
        }
        if (value.equals(this.mCurrentOverlaySetting)) {
            return;
        }
        this.mCurrentOverlaySetting = value;
        if (!this.mOverlays.isEmpty()) {
            Slog.i(TAG, "Dismissing all overlay display devices.");
            for (OverlayDisplayHandle overlay : this.mOverlays) {
                overlay.dismissLocked();
            }
            this.mOverlays.clear();
        }
        int count = 0;
        for (String part : value.split(";")) {
            block10: {
                Matcher matcher = SETTING_PATTERN.matcher(part);
                if (matcher.matches()) {
                    if (count >= 4) {
                        Slog.w(TAG, "Too many overlay display devices specified: " + value);
                        break;
                    }
                    try {
                        int width = Integer.parseInt(matcher.group(1), 10);
                        int height = Integer.parseInt(matcher.group(2), 10);
                        int densityDpi = Integer.parseInt(matcher.group(3), 10);
                        String flagString = matcher.group(4);
                        if (width >= 100 && width <= 4096 && height >= 100 && height <= 4096 && densityDpi >= 120 && densityDpi <= 480) {
                            int number = ++count;
                            String name = this.getContext().getResources().getString(17040723, number);
                            int gravity = OverlayDisplayAdapter.chooseOverlayGravity(number);
                            boolean secure = flagString != null && flagString.contains(",secure");
                            Slog.i(TAG, "Showing overlay display device #" + number + ": name=" + name + ", width=" + width + ", height=" + height + ", densityDpi=" + densityDpi + ", secure=" + secure);
                            this.mOverlays.add(new OverlayDisplayHandle(name, width, height, densityDpi, gravity, secure));
                            continue;
                        }
                        break block10;
                    }
                    catch (NumberFormatException ex) {
                        break block10;
                    }
                }
                if (part.isEmpty()) continue;
            }
            Slog.w(TAG, "Malformed overlay display devices setting: " + value);
        }
    }

    private static int chooseOverlayGravity(int overlayNumber) {
        switch (overlayNumber) {
            case 1: {
                return 51;
            }
            case 2: {
                return 85;
            }
            case 3: {
                return 53;
            }
        }
        return 83;
    }

    private final class OverlayDisplayHandle
    implements OverlayDisplayWindow.Listener {
        private final String mName;
        private final int mWidth;
        private final int mHeight;
        private final int mDensityDpi;
        private final int mGravity;
        private final boolean mSecure;
        private OverlayDisplayWindow mWindow;
        private OverlayDisplayDevice mDevice;
        private final Runnable mShowRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OverlayDisplayWindow window = new OverlayDisplayWindow(OverlayDisplayAdapter.this.getContext(), OverlayDisplayHandle.this.mName, OverlayDisplayHandle.this.mWidth, OverlayDisplayHandle.this.mHeight, OverlayDisplayHandle.this.mDensityDpi, OverlayDisplayHandle.this.mGravity, OverlayDisplayHandle.this.mSecure, OverlayDisplayHandle.this);
                window.show();
                DisplayManagerService.SyncRoot syncRoot = OverlayDisplayAdapter.this.getSyncRoot();
                synchronized (syncRoot) {
                    OverlayDisplayHandle.this.mWindow = window;
                }
            }
        };
        private final Runnable mDismissRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OverlayDisplayWindow window;
                DisplayManagerService.SyncRoot syncRoot = OverlayDisplayAdapter.this.getSyncRoot();
                synchronized (syncRoot) {
                    window = OverlayDisplayHandle.this.mWindow;
                    OverlayDisplayHandle.this.mWindow = null;
                }
                if (window != null) {
                    window.dismiss();
                }
            }
        };

        public OverlayDisplayHandle(String name, int width, int height, int densityDpi, int gravity, boolean secure) {
            this.mName = name;
            this.mWidth = width;
            this.mHeight = height;
            this.mDensityDpi = densityDpi;
            this.mGravity = gravity;
            this.mSecure = secure;
            OverlayDisplayAdapter.this.mUiHandler.post(this.mShowRunnable);
        }

        public void dismissLocked() {
            OverlayDisplayAdapter.this.mUiHandler.removeCallbacks(this.mShowRunnable);
            OverlayDisplayAdapter.this.mUiHandler.post(this.mDismissRunnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowCreated(SurfaceTexture surfaceTexture, float refreshRate) {
            DisplayManagerService.SyncRoot syncRoot = OverlayDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                IBinder displayToken = SurfaceControl.createDisplay(this.mName, this.mSecure);
                this.mDevice = new OverlayDisplayDevice(displayToken, this.mName, this.mWidth, this.mHeight, refreshRate, this.mDensityDpi, this.mSecure, surfaceTexture);
                OverlayDisplayAdapter.this.sendDisplayDeviceEventLocked(this.mDevice, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowDestroyed() {
            DisplayManagerService.SyncRoot syncRoot = OverlayDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (this.mDevice != null) {
                    this.mDevice.destroyLocked();
                    OverlayDisplayAdapter.this.sendDisplayDeviceEventLocked(this.mDevice, 3);
                }
            }
        }

        public void dumpLocked(PrintWriter pw) {
            pw.println("  " + this.mName + ":");
            pw.println("    mWidth=" + this.mWidth);
            pw.println("    mHeight=" + this.mHeight);
            pw.println("    mDensityDpi=" + this.mDensityDpi);
            pw.println("    mGravity=" + this.mGravity);
            pw.println("    mSecure=" + this.mSecure);
            if (this.mWindow != null) {
                IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "    ");
                ipw.increaseIndent();
                DumpUtils.dumpAsync(OverlayDisplayAdapter.this.mUiHandler, this.mWindow, ipw, 200L);
            }
        }
    }

    private final class OverlayDisplayDevice
    extends DisplayDevice {
        private final String mName;
        private final int mWidth;
        private final int mHeight;
        private final float mRefreshRate;
        private final int mDensityDpi;
        private final boolean mSecure;
        private Surface mSurface;
        private SurfaceTexture mSurfaceTexture;
        private DisplayDeviceInfo mInfo;

        public OverlayDisplayDevice(IBinder displayToken, String name, int width, int height, float refreshRate, int densityDpi, boolean secure, SurfaceTexture surfaceTexture) {
            super(OverlayDisplayAdapter.this, displayToken);
            this.mName = name;
            this.mWidth = width;
            this.mHeight = height;
            this.mRefreshRate = refreshRate;
            this.mDensityDpi = densityDpi;
            this.mSecure = secure;
            this.mSurfaceTexture = surfaceTexture;
        }

        public void destroyLocked() {
            this.mSurfaceTexture = null;
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
            SurfaceControl.destroyDisplay(this.getDisplayTokenLocked());
        }

        public void performTraversalInTransactionLocked() {
            if (this.mSurfaceTexture != null) {
                if (this.mSurface == null) {
                    this.mSurface = new Surface(this.mSurfaceTexture);
                }
                this.setSurfaceInTransactionLocked(this.mSurface);
            }
        }

        public DisplayDeviceInfo getDisplayDeviceInfoLocked() {
            if (this.mInfo == null) {
                this.mInfo = new DisplayDeviceInfo();
                this.mInfo.name = this.mName;
                this.mInfo.width = this.mWidth;
                this.mInfo.height = this.mHeight;
                this.mInfo.refreshRate = this.mRefreshRate;
                this.mInfo.densityDpi = this.mDensityDpi;
                this.mInfo.xDpi = this.mDensityDpi;
                this.mInfo.yDpi = this.mDensityDpi;
                this.mInfo.flags = 64;
                if (this.mSecure) {
                    this.mInfo.flags |= 4;
                }
                this.mInfo.type = 4;
                this.mInfo.touch = 0;
            }
            return this.mInfo;
        }
    }
}

