/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.KeySet;
import android.content.pm.PackageParser;
import android.os.Binder;
import android.util.Base64;
import android.util.LongSparseArray;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeySetManager {
    static final String TAG = "KeySetManager";
    public static final long KEYSET_NOT_FOUND = -1L;
    private static final long PUBLIC_KEY_NOT_FOUND = -1L;
    private final Object mLockObject = new Object();
    private final LongSparseArray<KeySet> mKeySets = new LongSparseArray();
    private final LongSparseArray<PublicKey> mPublicKeys = new LongSparseArray();
    private final LongSparseArray<Set<Long>> mKeySetMapping = new LongSparseArray();
    private final Map<String, PackageSetting> mPackages;
    private static long lastIssuedKeySetId = 0L;
    private static long lastIssuedKeyId = 0L;

    public KeySetManager(Map<String, PackageSetting> packages) {
        this.mPackages = packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean packageIsSignedBy(String packageName, KeySet ks) {
        Object object = this.mLockObject;
        synchronized (object) {
            PackageSetting pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new NullPointerException("Invalid package name");
            }
            if (pkg.keySetData == null) {
                throw new NullPointerException("Package has no KeySet data");
            }
            long id2 = this.getIdByKeySetLocked(ks);
            return pkg.keySetData.packageIsSignedBy(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinedKeySetToPackage(String packageName, Set<PublicKey> keys, String alias) {
        if (packageName == null || keys == null || alias == null) {
            return;
        }
        Object object = this.mLockObject;
        synchronized (object) {
            KeySet ks = this.addKeySetLocked(keys);
            PackageSetting pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new NullPointerException("Unknown package");
            }
            long id2 = this.getIdByKeySetLocked(ks);
            pkg.keySetData.addDefinedKeySet(id2, alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSigningKeySetToPackage(String packageName, Set<PublicKey> signingKeys) {
        if (packageName == null || signingKeys == null) {
            return;
        }
        Object object = this.mLockObject;
        synchronized (object) {
            KeySet ks = this.addKeySetLocked(signingKeys);
            long id2 = this.getIdByKeySetLocked(ks);
            Set<Long> publicKeyIds = this.mKeySetMapping.get(id2);
            if (publicKeyIds == null) {
                throw new NullPointerException("Got invalid KeySet id");
            }
            PackageSetting pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new NullPointerException("No such package!");
            }
            pkg.keySetData.addSigningKeySet(id2);
            long[] arr$ = pkg.keySetData.getDefinedKeySets();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Long keySetID = arr$[i$];
                Set<Long> definedKeys = this.mKeySetMapping.get(keySetID);
                if (!publicKeyIds.contains(definedKeys)) continue;
                pkg.keySetData.addSigningKeySet(keySetID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIdByKeySet(KeySet ks) {
        Object object = this.mLockObject;
        synchronized (object) {
            return this.getIdByKeySetLocked(ks);
        }
    }

    private long getIdByKeySetLocked(KeySet ks) {
        for (int keySetIndex = 0; keySetIndex < this.mKeySets.size(); ++keySetIndex) {
            KeySet value = this.mKeySets.valueAt(keySetIndex);
            if (!ks.equals(value)) continue;
            return this.mKeySets.keyAt(keySetIndex);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeySet getKeySetById(long id2) {
        Object object = this.mLockObject;
        synchronized (object) {
            return this.mKeySets.get(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeySet getKeySetByAliasAndPackageName(String packageName, String alias) {
        Object object = this.mLockObject;
        synchronized (object) {
            PackageSetting p = this.mPackages.get(packageName);
            if (p == null) {
                throw new NullPointerException("Unknown package");
            }
            if (p.keySetData == null) {
                throw new IllegalArgumentException("Package has no keySet data");
            }
            long keySetId = p.keySetData.getAliases().get(alias);
            return this.mKeySets.get(keySetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KeySet> getSigningKeySetsByPackageName(String packageName) {
        Object object = this.mLockObject;
        synchronized (object) {
            HashSet<KeySet> signingKeySets = new HashSet<KeySet>();
            PackageSetting p = this.mPackages.get(packageName);
            if (p == null) {
                throw new NullPointerException("Unknown package");
            }
            if (p.keySetData == null) {
                throw new IllegalArgumentException("Package has no keySet data");
            }
            for (long l : p.keySetData.getSigningKeySets()) {
                signingKeySets.add(this.mKeySets.get(l));
            }
            return signingKeySets;
        }
    }

    private KeySet addKeySetLocked(Set<PublicKey> keys) {
        if (keys == null) {
            throw new NullPointerException("Provided keys cannot be null");
        }
        HashSet<Long> addedKeyIds = new HashSet<Long>(keys.size());
        for (PublicKey k : keys) {
            long id2 = this.addPublicKeyLocked(k);
            addedKeyIds.add(id2);
        }
        long existingKeySetId = this.getIdFromKeyIdsLocked(addedKeyIds);
        if (existingKeySetId != -1L) {
            return this.mKeySets.get(existingKeySetId);
        }
        KeySet ks = new KeySet(new Binder());
        long id3 = this.getFreeKeySetIDLocked();
        this.mKeySets.put(id3, ks);
        this.mKeySetMapping.put(id3, addedKeyIds);
        return ks;
    }

    private long addPublicKeyLocked(PublicKey key) {
        long existingKeyId = this.getIdForPublicKeyLocked(key);
        if (existingKeyId != -1L) {
            return existingKeyId;
        }
        long id2 = this.getFreePublicKeyIdLocked();
        this.mPublicKeys.put(id2, key);
        return id2;
    }

    private long getIdFromKeyIdsLocked(Set<Long> publicKeyIds) {
        for (int keyMapIndex = 0; keyMapIndex < this.mKeySetMapping.size(); ++keyMapIndex) {
            Set<Long> value = this.mKeySetMapping.valueAt(keyMapIndex);
            if (!((Object)value).equals(publicKeyIds)) continue;
            return this.mKeySetMapping.keyAt(keyMapIndex);
        }
        return -1L;
    }

    private long getIdForPublicKeyLocked(PublicKey k) {
        String encodedPublicKey = new String(k.getEncoded());
        for (int publicKeyIndex = 0; publicKeyIndex < this.mPublicKeys.size(); ++publicKeyIndex) {
            PublicKey value = this.mPublicKeys.valueAt(publicKeyIndex);
            String encodedExistingKey = new String(value.getEncoded());
            if (!encodedPublicKey.equals(encodedExistingKey)) continue;
            return this.mPublicKeys.keyAt(publicKeyIndex);
        }
        return -1L;
    }

    private long getFreeKeySetIDLocked() {
        return ++lastIssuedKeySetId;
    }

    private long getFreePublicKeyIdLocked() {
        return ++lastIssuedKeyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppKeySetData(String packageName) {
        Object object = this.mLockObject;
        synchronized (object) {
            Set<Long> deletableKeySets = this.getKnownKeySetsByPackageNameLocked(packageName);
            HashSet<Long> deletableKeys = new HashSet<Long>();
            Set<Long> knownKeys = null;
            for (Long ks : deletableKeySets) {
                knownKeys = this.mKeySetMapping.get(ks);
                if (knownKeys == null) continue;
                deletableKeys.addAll(knownKeys);
            }
            for (String pkgName : this.mPackages.keySet()) {
                if (pkgName.equals(packageName)) continue;
                Set<Long> knownKeySets = this.getKnownKeySetsByPackageNameLocked(pkgName);
                deletableKeySets.removeAll(knownKeySets);
                knownKeys = new HashSet<Long>();
                for (Long ks : knownKeySets) {
                    knownKeys = this.mKeySetMapping.get(ks);
                    if (knownKeys == null) continue;
                    deletableKeys.removeAll(knownKeys);
                }
            }
            for (Long ks : deletableKeySets) {
                this.mKeySets.delete(ks);
                this.mKeySetMapping.delete(ks);
            }
            for (Long keyId : deletableKeys) {
                this.mPublicKeys.delete(keyId);
            }
            for (String pkgName : this.mPackages.keySet()) {
                PackageSetting p = this.mPackages.get(pkgName);
                for (Long ks : deletableKeySets) {
                    p.keySetData.removeSigningKeySet(ks);
                    p.keySetData.removeDefinedKeySet(ks);
                }
            }
        }
    }

    private Set<Long> getKnownKeySetsByPackageNameLocked(String packageName) {
        PackageSetting p = this.mPackages.get(packageName);
        if (p == null) {
            throw new NullPointerException("Unknown package");
        }
        if (p.keySetData == null) {
            throw new IllegalArgumentException("Package has no keySet data");
        }
        HashSet<Long> knownKeySets = new HashSet<Long>();
        for (long ks : p.keySetData.getSigningKeySets()) {
            knownKeySets.add(ks);
        }
        for (long ks : p.keySetData.getDefinedKeySets()) {
            knownKeySets.add(ks);
        }
        return knownKeySets;
    }

    public String encodePublicKey(PublicKey k) throws IOException {
        return new String(Base64.encode(k.getEncoded(), 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        Object object = this.mLockObject;
        synchronized (object) {
            boolean printedHeader = false;
            for (Map.Entry<String, PackageSetting> e : this.mPackages.entrySet()) {
                String keySetPackage = e.getKey();
                if (packageName != null && !packageName.equals(keySetPackage)) continue;
                if (!printedHeader) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Key Set Manager:");
                    printedHeader = true;
                }
                PackageSetting pkg = e.getValue();
                pw.print("  [");
                pw.print(keySetPackage);
                pw.println("]");
                if (pkg.keySetData == null) continue;
                boolean printedLabel = false;
                for (Map.Entry<String, Long> entry : pkg.keySetData.getAliases().entrySet()) {
                    if (!printedLabel) {
                        pw.print("      KeySets Aliases: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(entry.getKey());
                    pw.print('=');
                    pw.print(Long.toString(entry.getValue()));
                }
                if (printedLabel) {
                    pw.println("");
                }
                printedLabel = false;
                for (long keySetId : pkg.keySetData.getDefinedKeySets()) {
                    if (!printedLabel) {
                        pw.print("      Defined KeySets: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(Long.toString(keySetId));
                }
                if (printedLabel) {
                    pw.println("");
                }
                printedLabel = false;
                for (long keySetId : pkg.keySetData.getSigningKeySets()) {
                    if (!printedLabel) {
                        pw.print("      Signing KeySets: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(Long.toString(keySetId));
                }
                if (!printedLabel) continue;
                pw.println("");
            }
        }
    }

    void writeKeySetManagerLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keyset-settings");
        this.writePublicKeysLPr(serializer);
        this.writeKeySetsLPr(serializer);
        serializer.startTag(null, "lastIssuedKeyId");
        serializer.attribute(null, "value", Long.toString(lastIssuedKeyId));
        serializer.endTag(null, "lastIssuedKeyId");
        serializer.startTag(null, "lastIssuedKeySetId");
        serializer.attribute(null, "value", Long.toString(lastIssuedKeySetId));
        serializer.endTag(null, "lastIssuedKeySetId");
        serializer.endTag(null, "keyset-settings");
    }

    void writePublicKeysLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keys");
        for (int pKeyIndex = 0; pKeyIndex < this.mPublicKeys.size(); ++pKeyIndex) {
            long id2 = this.mPublicKeys.keyAt(pKeyIndex);
            PublicKey key = this.mPublicKeys.valueAt(pKeyIndex);
            String encodedKey = this.encodePublicKey(key);
            serializer.startTag(null, "public-key");
            serializer.attribute(null, "identifier", Long.toString(id2));
            serializer.attribute(null, "value", encodedKey);
            serializer.endTag(null, "public-key");
        }
        serializer.endTag(null, "keys");
    }

    void writeKeySetsLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keysets");
        for (int keySetIndex = 0; keySetIndex < this.mKeySetMapping.size(); ++keySetIndex) {
            long id2 = this.mKeySetMapping.keyAt(keySetIndex);
            Set<Long> keys = this.mKeySetMapping.valueAt(keySetIndex);
            serializer.startTag(null, "keyset");
            serializer.attribute(null, "identifier", Long.toString(id2));
            for (long keyId : keys) {
                serializer.startTag(null, "key-id");
                serializer.attribute(null, "identifier", Long.toString(keyId));
                serializer.endTag(null, "key-id");
            }
            serializer.endTag(null, "keyset");
        }
        serializer.endTag(null, "keysets");
    }

    void readKeySetsLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        long currentKeySetId = 0L;
        while ((type = parser.next()) != 1) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("keys")) {
                this.readKeysLPw(parser);
                continue;
            }
            if (!tagName.equals("keysets")) continue;
            this.readKeySetListLPw(parser);
        }
    }

    void readKeysLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("public-key")) {
                this.readPublicKeyLPw(parser);
                continue;
            }
            if (tagName.equals("lastIssuedKeyId")) {
                lastIssuedKeyId = Long.parseLong(parser.getAttributeValue(null, "value"));
                continue;
            }
            if (!tagName.equals("lastIssuedKeySetId")) continue;
            lastIssuedKeySetId = Long.parseLong(parser.getAttributeValue(null, "value"));
        }
    }

    void readKeySetListLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        long currentKeySetId = 0L;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("keyset")) {
                currentKeySetId = this.readIdentifierLPw(parser);
                this.mKeySets.put(currentKeySetId, new KeySet(new Binder()));
                this.mKeySetMapping.put(currentKeySetId, new HashSet());
                continue;
            }
            if (!tagName.equals("key-id")) continue;
            long id2 = this.readIdentifierLPw(parser);
            this.mKeySetMapping.get(currentKeySetId).add(id2);
        }
    }

    long readIdentifierLPw(XmlPullParser parser) throws XmlPullParserException {
        return Long.parseLong(parser.getAttributeValue(null, "identifier"));
    }

    void readPublicKeyLPw(XmlPullParser parser) throws XmlPullParserException {
        String encodedID = parser.getAttributeValue(null, "identifier");
        long identifier = Long.parseLong(encodedID);
        String encodedPublicKey = parser.getAttributeValue(null, "value");
        PublicKey pub = PackageParser.parsePublicKey(encodedPublicKey);
        if (pub != null) {
            this.mPublicKeys.put(identifier, pub);
        }
    }
}

