/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import com.android.server.pm.GrantedPermissions;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSignatures;
import java.util.HashSet;

final class SharedUserSetting
extends GrantedPermissions {
    final String name;
    int userId;
    int uidFlags;
    final HashSet<PackageSetting> packages = new HashSet();
    final PackageSignatures signatures = new PackageSignatures();

    SharedUserSetting(String _name, int _pkgFlags) {
        super(_pkgFlags);
        this.uidFlags = _pkgFlags;
        this.name = _name;
    }

    public String toString() {
        return "SharedUserSetting{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "/" + this.userId + "}";
    }

    void removePackage(PackageSetting packageSetting) {
        if (this.packages.remove(packageSetting) && (this.pkgFlags & packageSetting.pkgFlags) != 0) {
            int aggregatedFlags = this.uidFlags;
            for (PackageSetting ps : this.packages) {
                aggregatedFlags |= ps.pkgFlags;
            }
            this.setFlags(aggregatedFlags);
        }
    }

    void addPackage(PackageSetting packageSetting) {
        if (this.packages.add(packageSetting)) {
            this.setFlags(this.pkgFlags | packageSetting.pkgFlags);
        }
    }
}

