/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.sip.ISipService;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipErrorCode;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.net.sip.SipSessionAdapter;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.telephony.Rlog;
import com.android.server.sip.SipSessionGroup;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import com.android.server.sip.SipWakeupTimer;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.sip.SipException;

public final class SipService
extends ISipService.Stub {
    static final String TAG = "SipService";
    static final boolean DBG = true;
    private static final int EXPIRY_TIME = 3600;
    private static final int SHORT_EXPIRY_TIME = 10;
    private static final int MIN_EXPIRY_TIME = 60;
    private static final int DEFAULT_KEEPALIVE_INTERVAL = 10;
    private static final int DEFAULT_MAX_KEEPALIVE_INTERVAL = 120;
    private Context mContext;
    private String mLocalIp;
    private int mNetworkType = -1;
    private SipWakeupTimer mTimer;
    private WifiManager.WifiLock mWifiLock;
    private boolean mSipOnWifiOnly;
    private SipKeepAliveProcessCallback mSipKeepAliveProcessCallback;
    private MyExecutor mExecutor = new MyExecutor();
    private Map<String, SipSessionGroupExt> mSipGroups = new HashMap<String, SipSessionGroupExt>();
    private Map<String, ISipSession> mPendingSessions = new HashMap<String, ISipSession>();
    private ConnectivityReceiver mConnectivityReceiver;
    private SipWakeLock mMyWakeLock;
    private int mKeepAliveInterval;
    private int mLastGoodKeepAliveInterval = 10;

    public static void start(Context context) {
        if (SipManager.isApiSupported(context)) {
            ServiceManager.addService("sip", new SipService(context));
            context.sendBroadcast(new Intent("android.net.sip.SIP_SERVICE_UP"));
            SipService.slog("start:");
        }
    }

    private SipService(Context context) {
        this.log("SipService: started!");
        this.mContext = context;
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.mWifiLock = ((WifiManager)context.getSystemService("wifi")).createWifiLock(1, TAG);
        this.mWifiLock.setReferenceCounted(false);
        this.mSipOnWifiOnly = SipManager.isSipWifiOnly(context);
        this.mMyWakeLock = new SipWakeLock((PowerManager)context.getSystemService("power"));
        this.mTimer = new SipWakeupTimer(context, this.mExecutor);
    }

    public synchronized SipProfile[] getListOfProfiles() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        boolean isCallerRadio = this.isCallerRadio();
        ArrayList<SipProfile> profiles = new ArrayList<SipProfile>();
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (!isCallerRadio && !this.isCallerCreator(group)) continue;
            profiles.add(group.getLocalProfile());
        }
        return profiles.toArray(new SipProfile[profiles.size()]);
    }

    public synchronized void open(SipProfile localProfile) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        try {
            this.createGroup(localProfile);
        }
        catch (SipException e) {
            this.loge("openToMakeCalls()", e);
        }
    }

    public synchronized void open3(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        if (incomingCallPendingIntent == null) {
            this.log("open3: incomingCallPendingIntent cannot be null; the profile is not opened");
            return;
        }
        this.log("open3: " + localProfile.getUriString() + ": " + incomingCallPendingIntent + ": " + listener);
        try {
            SipSessionGroupExt group = this.createGroup(localProfile, incomingCallPendingIntent, listener);
            if (localProfile.getAutoRegistration()) {
                group.openToReceiveCalls();
                this.updateWakeLocks();
            }
        }
        catch (SipException e) {
            this.loge("open3:", e);
        }
    }

    private boolean isCallerCreator(SipSessionGroupExt group) {
        SipProfile profile = group.getLocalProfile();
        return profile.getCallingUid() == Binder.getCallingUid();
    }

    private boolean isCallerCreatorOrRadio(SipSessionGroupExt group) {
        return this.isCallerRadio() || this.isCallerCreator(group);
    }

    private boolean isCallerRadio() {
        return Binder.getCallingUid() == 1001;
    }

    public synchronized void close(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return;
        }
        if (!this.isCallerCreatorOrRadio(group)) {
            this.log("only creator or radio can close this profile");
            return;
        }
        group = this.mSipGroups.remove(localProfileUri);
        this.notifyProfileRemoved(group.getLocalProfile());
        group.close();
        this.updateWakeLocks();
    }

    public synchronized boolean isOpened(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return false;
        }
        if (this.isCallerCreatorOrRadio(group)) {
            return true;
        }
        this.log("only creator or radio can query on the profile");
        return false;
    }

    public synchronized boolean isRegistered(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return false;
        }
        if (this.isCallerCreatorOrRadio(group)) {
            return group.isRegistered();
        }
        this.log("only creator or radio can query on the profile");
        return false;
    }

    public synchronized void setRegistrationListener(String localProfileUri, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return;
        }
        if (this.isCallerCreator(group)) {
            group.setListener(listener);
        } else {
            this.log("only creator can set listener on the profile");
        }
    }

    public synchronized ISipSession createSession(SipProfile localProfile, ISipSessionListener listener) {
        this.log("createSession: profile" + localProfile);
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        if (this.mNetworkType == -1) {
            this.log("createSession: mNetworkType==-1 ret=null");
            return null;
        }
        try {
            SipSessionGroupExt group = this.createGroup(localProfile);
            return group.createSession(listener);
        }
        catch (SipException e) {
            this.loge("createSession;", e);
            return null;
        }
    }

    public synchronized ISipSession getPendingSession(String callId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        if (callId == null) {
            return null;
        }
        return this.mPendingSessions.get(callId);
    }

    private String determineLocalIp() {
        try {
            DatagramSocket s = new DatagramSocket();
            s.connect(InetAddress.getByName("192.168.1.1"), 80);
            return s.getLocalAddress().getHostAddress();
        }
        catch (IOException e) {
            this.loge("determineLocalIp()", e);
            return null;
        }
    }

    private SipSessionGroupExt createGroup(SipProfile localProfile) throws SipException {
        String key = localProfile.getUriString();
        SipSessionGroupExt group = this.mSipGroups.get(key);
        if (group == null) {
            group = new SipSessionGroupExt(localProfile, null, null);
            this.mSipGroups.put(key, group);
            this.notifyProfileAdded(localProfile);
        } else if (!this.isCallerCreator(group)) {
            throw new SipException("only creator can access the profile");
        }
        return group;
    }

    private SipSessionGroupExt createGroup(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) throws SipException {
        String key = localProfile.getUriString();
        SipSessionGroupExt group = this.mSipGroups.get(key);
        if (group != null) {
            if (!this.isCallerCreator(group)) {
                throw new SipException("only creator can access the profile");
            }
            group.setIncomingCallPendingIntent(incomingCallPendingIntent);
            group.setListener(listener);
        } else {
            group = new SipSessionGroupExt(localProfile, incomingCallPendingIntent, listener);
            this.mSipGroups.put(key, group);
            this.notifyProfileAdded(localProfile);
        }
        return group;
    }

    private void notifyProfileAdded(SipProfile localProfile) {
        this.log("notify: profile added: " + localProfile);
        Intent intent = new Intent("com.android.phone.SIP_ADD_PHONE");
        intent.putExtra("android:localSipUri", localProfile.getUriString());
        this.mContext.sendBroadcast(intent);
        if (this.mSipGroups.size() == 1) {
            this.registerReceivers();
        }
    }

    private void notifyProfileRemoved(SipProfile localProfile) {
        this.log("notify: profile removed: " + localProfile);
        Intent intent = new Intent("com.android.phone.SIP_REMOVE_PHONE");
        intent.putExtra("android:localSipUri", localProfile.getUriString());
        this.mContext.sendBroadcast(intent);
        if (this.mSipGroups.size() == 0) {
            this.unregisterReceivers();
        }
    }

    private void stopPortMappingMeasurement() {
        if (this.mSipKeepAliveProcessCallback != null) {
            this.mSipKeepAliveProcessCallback.stop();
            this.mSipKeepAliveProcessCallback = null;
        }
    }

    private void startPortMappingLifetimeMeasurement(SipProfile localProfile) {
        this.startPortMappingLifetimeMeasurement(localProfile, 120);
    }

    private void startPortMappingLifetimeMeasurement(SipProfile localProfile, int maxInterval) {
        if (this.mSipKeepAliveProcessCallback == null && this.mKeepAliveInterval == -1 && this.isBehindNAT(this.mLocalIp)) {
            this.log("startPortMappingLifetimeMeasurement: profile=" + localProfile.getUriString());
            int minInterval = this.mLastGoodKeepAliveInterval;
            if (minInterval >= maxInterval) {
                this.mLastGoodKeepAliveInterval = 10;
                minInterval = 10;
                this.log("  reset min interval to " + minInterval);
            }
            this.mSipKeepAliveProcessCallback = new SipKeepAliveProcessCallback(localProfile, minInterval, maxInterval);
            this.mSipKeepAliveProcessCallback.start();
        }
    }

    private void restartPortMappingLifetimeMeasurement(SipProfile localProfile, int maxInterval) {
        this.stopPortMappingMeasurement();
        this.mKeepAliveInterval = -1;
        this.startPortMappingLifetimeMeasurement(localProfile, maxInterval);
    }

    private synchronized void addPendingSession(ISipSession session) {
        try {
            this.cleanUpPendingSessions();
            this.mPendingSessions.put(session.getCallId(), session);
            this.log("#pending sess=" + this.mPendingSessions.size());
        }
        catch (RemoteException e) {
            this.loge("addPendingSession()", e);
        }
    }

    private void cleanUpPendingSessions() throws RemoteException {
        Map.Entry[] entries;
        for (Map.Entry entry : entries = this.mPendingSessions.entrySet().toArray(new Map.Entry[this.mPendingSessions.size()])) {
            if (((ISipSession)entry.getValue()).getState() == 3) continue;
            this.mPendingSessions.remove(entry.getKey());
        }
    }

    private synchronized boolean callingSelf(SipSessionGroupExt ringingGroup, SipSessionGroup.SipSessionImpl ringingSession) {
        String callId = ringingSession.getCallId();
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (group == ringingGroup || !group.containsSession(callId)) continue;
            this.log("call self: " + ringingSession.getLocalProfile().getUriString() + " -> " + group.getLocalProfile().getUriString());
            return true;
        }
        return false;
    }

    private synchronized void onKeepAliveIntervalChanged() {
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            group.onKeepAliveIntervalChanged();
        }
    }

    private int getKeepAliveInterval() {
        return this.mKeepAliveInterval < 0 ? this.mLastGoodKeepAliveInterval : this.mKeepAliveInterval;
    }

    private boolean isBehindNAT(String address) {
        try {
            byte[] d = InetAddress.getByName(address).getAddress();
            if (d[0] == 10 || (0xFF & d[0]) == 172 && (0xF0 & d[1]) == 16 || (0xFF & d[0]) == 192 && (0xFF & d[1]) == 168) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            this.loge("isBehindAT()" + address, e);
        }
        return false;
    }

    private void registerReceivers() {
        this.mContext.registerReceiver(this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.log("registerReceivers:");
    }

    private void unregisterReceivers() {
        this.mContext.unregisterReceiver(this.mConnectivityReceiver);
        this.log("unregisterReceivers:");
        this.mWifiLock.release();
        this.mNetworkType = -1;
    }

    private void updateWakeLocks() {
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (!group.isOpenedToReceiveCalls()) continue;
            if (this.mNetworkType == 1 || this.mNetworkType == -1) {
                this.mWifiLock.acquire();
            } else {
                this.mWifiLock.release();
            }
            return;
        }
        this.mWifiLock.release();
        this.mMyWakeLock.reset();
    }

    private synchronized void onConnectivityChanged(NetworkInfo info) {
        int networkType;
        if (info == null || info.isConnected() || info.getType() != this.mNetworkType) {
            ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            info = cm.getActiveNetworkInfo();
        }
        int n = networkType = info != null && info.isConnected() ? info.getType() : -1;
        if (this.mSipOnWifiOnly && networkType != 1) {
            networkType = -1;
        }
        if (this.mNetworkType == networkType) {
            return;
        }
        this.log("onConnectivityChanged: " + this.mNetworkType + " -> " + networkType);
        try {
            if (this.mNetworkType != -1) {
                this.mLocalIp = null;
                this.stopPortMappingMeasurement();
                for (SipSessionGroupExt group : this.mSipGroups.values()) {
                    group.onConnectivityChanged(false);
                }
            }
            this.mNetworkType = networkType;
            if (this.mNetworkType != -1) {
                this.mLocalIp = this.determineLocalIp();
                this.mKeepAliveInterval = -1;
                this.mLastGoodKeepAliveInterval = 10;
                for (SipSessionGroupExt group : this.mSipGroups.values()) {
                    group.onConnectivityChanged(true);
                }
            }
            this.updateWakeLocks();
        }
        catch (SipException e) {
            this.loge("onConnectivityChanged()", e);
        }
    }

    private static Looper createLooper() {
        HandlerThread thread = new HandlerThread("SipService.Executor");
        thread.start();
        return thread.getLooper();
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private static void slog(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s, Throwable e) {
        Rlog.e(TAG, s, e);
    }

    private class MyExecutor
    extends Handler
    implements Executor {
        MyExecutor() {
            super(SipService.createLooper());
        }

        public void execute(Runnable task) {
            SipService.this.mMyWakeLock.acquire(task);
            Message.obtain(this, 0, task).sendToTarget();
        }

        public void handleMessage(Message msg) {
            if (msg.obj instanceof Runnable) {
                this.executeInternal((Runnable)msg.obj);
            } else {
                SipService.this.log("handleMessage: not Runnable ignore msg=" + msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeInternal(Runnable task) {
            try {
                task.run();
            }
            catch (Throwable t) {
                SipService.this.loge("run task: " + task, t);
            }
            finally {
                SipService.this.mMyWakeLock.release(task);
            }
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                final NetworkInfo info = (NetworkInfo)bundle.get("networkInfo");
                SipService.this.mExecutor.execute(new Runnable(){

                    public void run() {
                        SipService.this.onConnectivityChanged(info);
                    }
                });
            }
        }
    }

    private class SipAutoReg
    extends SipSessionAdapter
    implements Runnable,
    SipSessionGroup.KeepAliveProcessCallback {
        private String SAR_TAG;
        private static final boolean SAR_DBG = true;
        private static final int MIN_KEEPALIVE_SUCCESS_COUNT = 10;
        private SipSessionGroup.SipSessionImpl mSession;
        private SipSessionGroup.SipSessionImpl mKeepAliveSession;
        private SipSessionListenerProxy mProxy = new SipSessionListenerProxy();
        private int mBackoff = 1;
        private boolean mRegistered;
        private long mExpiryTime;
        private int mErrorCode;
        private String mErrorMessage;
        private boolean mRunning = false;
        private int mKeepAliveSuccessCount = 0;

        private SipAutoReg() {
        }

        public void start(SipSessionGroup group) {
            if (!this.mRunning) {
                this.mRunning = true;
                this.mBackoff = 1;
                this.mSession = (SipSessionGroup.SipSessionImpl)group.createSession(this);
                if (this.mSession == null) {
                    return;
                }
                SipService.this.mMyWakeLock.acquire(this.mSession);
                this.mSession.unregister();
                this.SAR_TAG = "SipAutoReg:" + this.mSession.getLocalProfile().getUriString();
                this.log("start: group=" + group);
            }
        }

        private void startKeepAliveProcess(int interval) {
            this.log("startKeepAliveProcess: interval=" + interval);
            if (this.mKeepAliveSession == null) {
                this.mKeepAliveSession = this.mSession.duplicate();
            } else {
                this.mKeepAliveSession.stopKeepAliveProcess();
            }
            try {
                this.mKeepAliveSession.startKeepAliveProcess(interval, this);
            }
            catch (SipException e) {
                this.loge("startKeepAliveProcess: interval=" + interval, e);
            }
        }

        private void stopKeepAliveProcess() {
            if (this.mKeepAliveSession != null) {
                this.mKeepAliveSession.stopKeepAliveProcess();
                this.mKeepAliveSession = null;
            }
            this.mKeepAliveSuccessCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(boolean portChanged) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (portChanged) {
                    int interval = SipService.this.getKeepAliveInterval();
                    if (this.mKeepAliveSuccessCount < 10) {
                        this.log("onResponse: keepalive doesn't work with interval " + interval + ", past success count=" + this.mKeepAliveSuccessCount);
                        if (interval > 10) {
                            SipService.this.restartPortMappingLifetimeMeasurement(this.mSession.getLocalProfile(), interval);
                            this.mKeepAliveSuccessCount = 0;
                        }
                    } else {
                        this.log("keep keepalive going with interval " + interval + ", past success count=" + this.mKeepAliveSuccessCount);
                        this.mKeepAliveSuccessCount /= 2;
                    }
                } else {
                    SipService.this.startPortMappingLifetimeMeasurement(this.mSession.getLocalProfile());
                    ++this.mKeepAliveSuccessCount;
                }
                if (!this.mRunning || !portChanged) {
                    return;
                }
                this.mKeepAliveSession = null;
                SipService.this.mMyWakeLock.acquire(this.mSession);
                this.mSession.register(3600);
            }
        }

        public void onError(int errorCode, String description) {
            this.loge("onError: errorCode=" + errorCode + " desc=" + description);
            this.onResponse(true);
        }

        public void stop() {
            if (!this.mRunning) {
                return;
            }
            this.mRunning = false;
            SipService.this.mMyWakeLock.release(this.mSession);
            if (this.mSession != null) {
                this.mSession.setListener(null);
                if (SipService.this.mNetworkType != -1 && this.mRegistered) {
                    this.mSession.unregister();
                }
            }
            SipService.this.mTimer.cancel(this);
            this.stopKeepAliveProcess();
            this.mRegistered = false;
            this.setListener(this.mProxy.getListener());
        }

        public void onKeepAliveIntervalChanged() {
            if (this.mKeepAliveSession != null) {
                int newInterval = SipService.this.getKeepAliveInterval();
                this.log("onKeepAliveIntervalChanged: interval=" + newInterval);
                this.mKeepAliveSuccessCount = 0;
                this.startKeepAliveProcess(newInterval);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setListener(ISipSessionListener listener) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                this.mProxy.setListener(listener);
                try {
                    int state;
                    int n = state = this.mSession == null ? 0 : this.mSession.getState();
                    if (state == 1 || state == 2) {
                        this.mProxy.onRegistering(this.mSession);
                    } else if (this.mRegistered) {
                        int duration = (int)(this.mExpiryTime - SystemClock.elapsedRealtime());
                        this.mProxy.onRegistrationDone(this.mSession, duration);
                    } else if (this.mErrorCode != 0) {
                        if (this.mErrorCode == -5) {
                            this.mProxy.onRegistrationTimeout(this.mSession);
                        } else {
                            this.mProxy.onRegistrationFailed(this.mSession, this.mErrorCode, this.mErrorMessage);
                        }
                    } else if (SipService.this.mNetworkType == -1) {
                        this.mProxy.onRegistrationFailed(this.mSession, -10, "no data connection");
                    } else if (!this.mRunning) {
                        this.mProxy.onRegistrationFailed(this.mSession, -4, "registration not running");
                    } else {
                        this.mProxy.onRegistrationFailed(this.mSession, -9, String.valueOf(state));
                    }
                }
                catch (Throwable t) {
                    this.loge("setListener: ", t);
                }
            }
        }

        public boolean isRegistered() {
            return this.mRegistered;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!this.mRunning) {
                    return;
                }
                this.mErrorCode = 0;
                this.mErrorMessage = null;
                this.log("run: registering");
                if (SipService.this.mNetworkType != -1) {
                    SipService.this.mMyWakeLock.acquire(this.mSession);
                    this.mSession.register(3600);
                }
            }
        }

        private void restart(int duration) {
            this.log("restart: duration=" + duration + "s later.");
            SipService.this.mTimer.cancel(this);
            SipService.this.mTimer.set(duration * 1000, this);
        }

        private int backoffDuration() {
            int duration = 10 * this.mBackoff;
            if (duration > 3600) {
                duration = 3600;
            } else {
                this.mBackoff *= 2;
            }
            return duration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistering(ISipSession session) {
            this.log("onRegistering: " + session);
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mRegistered = false;
                this.mProxy.onRegistering(session);
            }
        }

        private boolean notCurrentSession(ISipSession session) {
            if (session != this.mSession) {
                ((SipSessionGroup.SipSessionImpl)session).setListener(null);
                SipService.this.mMyWakeLock.release(session);
                return true;
            }
            return !this.mRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationDone(ISipSession session, int duration) {
            this.log("onRegistrationDone: " + session);
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mProxy.onRegistrationDone(session, duration);
                if (duration > 0) {
                    this.mExpiryTime = SystemClock.elapsedRealtime() + (long)(duration * 1000);
                    if (!this.mRegistered) {
                        this.mRegistered = true;
                        if ((duration -= 60) < 60) {
                            duration = 60;
                        }
                        this.restart(duration);
                        SipProfile localProfile = this.mSession.getLocalProfile();
                        if (this.mKeepAliveSession == null && (SipService.this.isBehindNAT(SipService.this.mLocalIp) || localProfile.getSendKeepAlive())) {
                            this.startKeepAliveProcess(SipService.this.getKeepAliveInterval());
                        }
                    }
                    SipService.this.mMyWakeLock.release(session);
                } else {
                    this.mRegistered = false;
                    this.mExpiryTime = -1L;
                    this.log("Refresh registration immediately");
                    this.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationFailed(ISipSession session, int errorCode, String message) {
            this.log("onRegistrationFailed: " + session + ": " + SipErrorCode.toString(errorCode) + ": " + message);
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                switch (errorCode) {
                    case -12: 
                    case -8: {
                        this.log("   pause auto-registration");
                        this.stop();
                        break;
                    }
                    default: {
                        this.restartLater();
                    }
                }
                this.mErrorCode = errorCode;
                this.mErrorMessage = message;
                this.mProxy.onRegistrationFailed(session, errorCode, message);
                SipService.this.mMyWakeLock.release(session);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationTimeout(ISipSession session) {
            this.log("onRegistrationTimeout: " + session);
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mErrorCode = -5;
                this.mProxy.onRegistrationTimeout(session);
                this.restartLater();
                SipService.this.mMyWakeLock.release(session);
            }
        }

        private void restartLater() {
            this.loge("restartLater");
            this.mRegistered = false;
            this.restart(this.backoffDuration());
        }

        private void log(String s) {
            Rlog.d(this.SAR_TAG, s);
        }

        private void loge(String s) {
            Rlog.e(this.SAR_TAG, s);
        }

        private void loge(String s, Throwable e) {
            Rlog.e(this.SAR_TAG, s, e);
        }
    }

    private class SipKeepAliveProcessCallback
    implements Runnable,
    SipSessionGroup.KeepAliveProcessCallback {
        private static final String SKAI_TAG = "SipKeepAliveProcessCallback";
        private static final boolean SKAI_DBG = true;
        private static final int MIN_INTERVAL = 5;
        private static final int PASS_THRESHOLD = 10;
        private static final int NAT_MEASUREMENT_RETRY_INTERVAL = 120;
        private SipProfile mLocalProfile;
        private SipSessionGroupExt mGroup;
        private SipSessionGroup.SipSessionImpl mSession;
        private int mMinInterval;
        private int mMaxInterval;
        private int mInterval;
        private int mPassCount;

        public SipKeepAliveProcessCallback(SipProfile localProfile, int minInterval, int maxInterval) {
            this.mMaxInterval = maxInterval;
            this.mMinInterval = minInterval;
            this.mLocalProfile = localProfile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.mSession != null) {
                    return;
                }
                this.mInterval = (this.mMaxInterval + this.mMinInterval) / 2;
                this.mPassCount = 0;
                if (this.mInterval < 10 || this.checkTermination()) {
                    this.log("start: measurement aborted; interval=[" + this.mMinInterval + "," + this.mMaxInterval + "]");
                    return;
                }
                try {
                    this.log("start: interval=" + this.mInterval);
                    this.mGroup = new SipSessionGroupExt(this.mLocalProfile, null, null);
                    this.mGroup.setWakeupTimer(new SipWakeupTimer(SipService.this.mContext, SipService.this.mExecutor));
                    this.mSession = (SipSessionGroup.SipSessionImpl)this.mGroup.createSession(null);
                    this.mSession.startKeepAliveProcess(this.mInterval, this);
                }
                catch (Throwable t) {
                    this.onError(-4, t.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.mSession != null) {
                    this.mSession.stopKeepAliveProcess();
                    this.mSession = null;
                }
                if (this.mGroup != null) {
                    this.mGroup.close();
                    this.mGroup = null;
                }
                SipService.this.mTimer.cancel(this);
                this.log("stop");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restart() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.mSession == null) {
                    return;
                }
                this.log("restart: interval=" + this.mInterval);
                try {
                    this.mSession.stopKeepAliveProcess();
                    this.mPassCount = 0;
                    this.mSession.startKeepAliveProcess(this.mInterval, this);
                }
                catch (SipException e) {
                    this.loge("restart", e);
                }
            }
        }

        private boolean checkTermination() {
            return this.mMaxInterval - this.mMinInterval < 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(boolean portChanged) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!portChanged) {
                    if (++this.mPassCount != 10) {
                        return;
                    }
                    if (SipService.this.mKeepAliveInterval > 0) {
                        SipService.this.mLastGoodKeepAliveInterval = SipService.this.mKeepAliveInterval;
                    }
                    this.mMinInterval = this.mInterval;
                    SipService.this.mKeepAliveInterval = this.mMinInterval;
                    this.log("onResponse: portChanged=" + portChanged + " mKeepAliveInterval=" + SipService.this.mKeepAliveInterval);
                    SipService.this.onKeepAliveIntervalChanged();
                } else {
                    this.mMaxInterval = this.mInterval;
                }
                if (this.checkTermination()) {
                    this.stop();
                    SipService.this.mKeepAliveInterval = this.mMinInterval;
                    this.log("onResponse: checkTermination mKeepAliveInterval=" + SipService.this.mKeepAliveInterval);
                } else {
                    this.mInterval = (this.mMaxInterval + this.mMinInterval) / 2;
                    this.log("onResponse: mKeepAliveInterval=" + SipService.this.mKeepAliveInterval + ", new mInterval=" + this.mInterval);
                    this.restart();
                }
            }
        }

        public void onError(int errorCode, String description) {
            this.loge("onError: errorCode=" + errorCode + " desc=" + description);
            this.restartLater();
        }

        public void run() {
            SipService.this.mTimer.cancel(this);
            this.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restartLater() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                int interval = 120;
                SipService.this.mTimer.cancel(this);
                SipService.this.mTimer.set(interval * 1000, this);
            }
        }

        private void log(String s) {
            Rlog.d(SKAI_TAG, s);
        }

        private void loge(String s) {
            Rlog.d(SKAI_TAG, s);
        }

        private void loge(String s, Throwable t) {
            Rlog.d(SKAI_TAG, s, t);
        }
    }

    private class SipSessionGroupExt
    extends SipSessionAdapter {
        private static final String SSGE_TAG = "SipSessionGroupExt";
        private static final boolean SSGE_DBG = true;
        private SipSessionGroup mSipGroup;
        private PendingIntent mIncomingCallPendingIntent;
        private boolean mOpenedToReceiveCalls;
        private SipAutoReg mAutoRegistration;

        public SipSessionGroupExt(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) throws SipException {
            this.mAutoRegistration = new SipAutoReg();
            this.log("SipSessionGroupExt: profile=" + localProfile);
            this.mSipGroup = new SipSessionGroup(this.duplicate(localProfile), localProfile.getPassword(), SipService.this.mTimer, SipService.this.mMyWakeLock);
            this.mIncomingCallPendingIntent = incomingCallPendingIntent;
            this.mAutoRegistration.setListener(listener);
        }

        public SipProfile getLocalProfile() {
            return this.mSipGroup.getLocalProfile();
        }

        public boolean containsSession(String callId) {
            return this.mSipGroup.containsSession(callId);
        }

        public void onKeepAliveIntervalChanged() {
            this.mAutoRegistration.onKeepAliveIntervalChanged();
        }

        void setWakeupTimer(SipWakeupTimer timer) {
            this.mSipGroup.setWakeupTimer(timer);
        }

        private SipProfile duplicate(SipProfile p) {
            try {
                return new SipProfile.Builder(p).setPassword("*").build();
            }
            catch (Exception e) {
                this.loge("duplicate()", e);
                throw new RuntimeException("duplicate profile", e);
            }
        }

        public void setListener(ISipSessionListener listener) {
            this.mAutoRegistration.setListener(listener);
        }

        public void setIncomingCallPendingIntent(PendingIntent pIntent) {
            this.mIncomingCallPendingIntent = pIntent;
        }

        public void openToReceiveCalls() throws SipException {
            this.mOpenedToReceiveCalls = true;
            if (SipService.this.mNetworkType != -1) {
                this.mSipGroup.openToReceiveCalls(this);
                this.mAutoRegistration.start(this.mSipGroup);
            }
            this.log("openToReceiveCalls: " + this.getUri() + ": " + this.mIncomingCallPendingIntent);
        }

        public void onConnectivityChanged(boolean connected) throws SipException {
            this.log("onConnectivityChanged: connected=" + connected + " uri=" + this.getUri() + ": " + this.mIncomingCallPendingIntent);
            this.mSipGroup.onConnectivityChanged();
            if (connected) {
                this.mSipGroup.reset();
                if (this.mOpenedToReceiveCalls) {
                    this.openToReceiveCalls();
                }
            } else {
                this.mSipGroup.close();
                this.mAutoRegistration.stop();
            }
        }

        public void close() {
            this.mOpenedToReceiveCalls = false;
            this.mSipGroup.close();
            this.mAutoRegistration.stop();
            this.log("close: " + this.getUri() + ": " + this.mIncomingCallPendingIntent);
        }

        public ISipSession createSession(ISipSessionListener listener) {
            this.log("createSession");
            return this.mSipGroup.createSession(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRinging(ISipSession s, SipProfile caller, String sessionDescription) {
            SipSessionGroup.SipSessionImpl session = (SipSessionGroup.SipSessionImpl)s;
            SipService sipService = SipService.this;
            synchronized (sipService) {
                try {
                    if (!this.isRegistered() || SipService.this.callingSelf(this, session)) {
                        this.log("onRinging: end notReg or self");
                        session.endCall();
                        return;
                    }
                    SipService.this.addPendingSession(session);
                    Intent intent = SipManager.createIncomingCallBroadcast(session.getCallId(), sessionDescription);
                    this.log("onRinging: uri=" + this.getUri() + ": " + caller.getUri() + ": " + session.getCallId() + " " + this.mIncomingCallPendingIntent);
                    this.mIncomingCallPendingIntent.send(SipService.this.mContext, 101, intent);
                }
                catch (PendingIntent.CanceledException e) {
                    this.loge("onRinging: pendingIntent is canceled, drop incoming call", e);
                    session.endCall();
                }
            }
        }

        public void onError(ISipSession session, int errorCode, String message) {
            this.log("onError: errorCode=" + errorCode + " desc=" + SipErrorCode.toString(errorCode) + ": " + message);
        }

        public boolean isOpenedToReceiveCalls() {
            return this.mOpenedToReceiveCalls;
        }

        public boolean isRegistered() {
            return this.mAutoRegistration.isRegistered();
        }

        private String getUri() {
            return this.mSipGroup.getLocalProfileUri();
        }

        private void log(String s) {
            Rlog.d(SSGE_TAG, s);
        }

        private void loge(String s, Throwable t) {
            Rlog.e(SSGE_TAG, s, t);
        }
    }
}

