/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.usb.UsbAccessory;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.Settings;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.FgThread;
import com.android.server.usb.UsbDebuggingManager;
import com.android.server.usb.UsbSettingsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;

public class UsbDeviceManager {
    private static final String TAG = UsbDeviceManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String USB_STATE_MATCH = "DEVPATH=/devices/virtual/android_usb/android0";
    private static final String ACCESSORY_START_MATCH = "DEVPATH=/devices/virtual/misc/usb_accessory";
    private static final String FUNCTIONS_PATH = "/sys/class/android_usb/android0/functions";
    private static final String STATE_PATH = "/sys/class/android_usb/android0/state";
    private static final String MASS_STORAGE_FILE_PATH = "/sys/class/android_usb/android0/f_mass_storage/lun/file";
    private static final String RNDIS_ETH_ADDR_PATH = "/sys/class/android_usb/android0/f_rndis/ethaddr";
    private static final String AUDIO_SOURCE_PCM_PATH = "/sys/class/android_usb/android0/f_audio_source/pcm";
    private static final int MSG_UPDATE_STATE = 0;
    private static final int MSG_ENABLE_ADB = 1;
    private static final int MSG_SET_CURRENT_FUNCTIONS = 2;
    private static final int MSG_SYSTEM_READY = 3;
    private static final int MSG_BOOT_COMPLETED = 4;
    private static final int MSG_USER_SWITCHED = 5;
    private static final int AUDIO_MODE_NONE = 0;
    private static final int AUDIO_MODE_SOURCE = 1;
    private static final int UPDATE_DELAY = 1000;
    private static final String BOOT_MODE_PROPERTY = "ro.bootmode";
    private UsbHandler mHandler;
    private boolean mBootCompleted;
    private final Object mLock = new Object();
    private final Context mContext;
    private final ContentResolver mContentResolver;
    @GuardedBy(value="mLock")
    private UsbSettingsManager mCurrentSettings;
    private NotificationManager mNotificationManager;
    private final boolean mHasUsbAccessory;
    private boolean mUseUsbNotification;
    private boolean mAdbEnabled;
    private boolean mAudioSourceEnabled;
    private Map<String, List<Pair<String, String>>> mOemModeMap;
    private String[] mAccessoryStrings;
    private UsbDebuggingManager mDebuggingManager;
    private final UEventObserver mUEventObserver = new UEventObserver(){

        public void onUEvent(UEventObserver.UEvent event) {
            String state = event.get("USB_STATE");
            String accessory = event.get("ACCESSORY");
            if (state != null) {
                UsbDeviceManager.this.mHandler.updateState(state);
            } else if ("START".equals(accessory)) {
                UsbDeviceManager.this.startAccessoryMode();
            }
        }
    };

    public UsbDeviceManager(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        PackageManager pm = this.mContext.getPackageManager();
        this.mHasUsbAccessory = pm.hasSystemFeature("android.hardware.usb.accessory");
        UsbDeviceManager.initRndisAddress();
        this.readOemUsbOverrideConfig();
        this.mHandler = new UsbHandler(FgThread.get().getLooper());
        if (this.nativeIsStartRequested()) {
            this.startAccessoryMode();
        }
        boolean secureAdbEnabled = SystemProperties.getBoolean("ro.adb.secure", false);
        boolean dataEncrypted = "1".equals(SystemProperties.get("vold.decrypt"));
        if (secureAdbEnabled && !dataEncrypted) {
            this.mDebuggingManager = new UsbDebuggingManager(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSettings(UsbSettingsManager settings) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentSettings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbSettingsManager getCurrentSettings() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentSettings;
        }
    }

    public void systemReady() {
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        boolean massStorageSupported = false;
        StorageManager storageManager = StorageManager.from(this.mContext);
        StorageVolume primary = storageManager.getPrimaryVolume();
        massStorageSupported = primary != null && primary.allowMassStorage();
        this.mUseUsbNotification = !massStorageSupported;
        Settings.Global.putInt(this.mContentResolver, "adb_enabled", this.mAdbEnabled ? 1 : 0);
        this.mHandler.sendEmptyMessage(3);
    }

    private void startAccessoryMode() {
        this.mAccessoryStrings = this.nativeGetAccessoryStrings();
        boolean enableAudio = this.nativeGetAudioMode() == 1;
        boolean enableAccessory = this.mAccessoryStrings != null && this.mAccessoryStrings[0] != null && this.mAccessoryStrings[1] != null;
        String functions = null;
        if (enableAccessory && enableAudio) {
            functions = "accessory,audio_source";
        } else if (enableAccessory) {
            functions = "accessory";
        } else if (enableAudio) {
            functions = "audio_source";
        }
        if (functions != null) {
            this.setCurrentFunctions(functions, false);
        }
    }

    private static void initRndisAddress() {
        int ETH_ALEN = 6;
        int[] address = new int[6];
        address[0] = 2;
        String serial = SystemProperties.get("ro.serialno", "1234567890ABCDEF");
        int serialLength = serial.length();
        for (int i = 0; i < serialLength; ++i) {
            int n = i % 5 + 1;
            address[n] = address[n] ^ serial.charAt(i);
        }
        String addrString = String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]);
        try {
            FileUtils.stringToFile(RNDIS_ETH_ADDR_PATH, addrString);
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to write to /sys/class/android_usb/android0/f_rndis/ethaddr");
        }
    }

    private static String addFunction(String functions, String function) {
        if ("none".equals(functions)) {
            return function;
        }
        if (!UsbDeviceManager.containsFunction(functions, function)) {
            if (functions.length() > 0) {
                functions = functions + ",";
            }
            functions = functions + function;
        }
        return functions;
    }

    private static String removeFunction(String functions, String function) {
        String[] split = functions.split(",");
        for (int i = 0; i < split.length; ++i) {
            if (!function.equals(split[i])) continue;
            split[i] = null;
        }
        if (split.length == 1 && split[0] == null) {
            return "none";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (s == null) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    private static boolean containsFunction(String functions, String function) {
        int index = functions.indexOf(function);
        if (index < 0) {
            return false;
        }
        if (index > 0 && functions.charAt(index - 1) != ',') {
            return false;
        }
        int charAfter = index + function.length();
        return charAfter >= functions.length() || functions.charAt(charAfter) == ',';
    }

    public UsbAccessory getCurrentAccessory() {
        return this.mHandler.getCurrentAccessory();
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        UsbAccessory currentAccessory = this.mHandler.getCurrentAccessory();
        if (currentAccessory == null) {
            throw new IllegalArgumentException("no accessory attached");
        }
        if (!currentAccessory.equals(accessory)) {
            String error = accessory.toString() + " does not match current accessory " + currentAccessory;
            throw new IllegalArgumentException(error);
        }
        this.getCurrentSettings().checkPermission(accessory);
        return this.nativeOpenAccessory();
    }

    public void setCurrentFunctions(String functions, boolean makeDefault) {
        this.mHandler.sendMessage(2, functions, makeDefault);
    }

    public void setMassStorageBackingFile(String path) {
        if (path == null) {
            path = "";
        }
        try {
            FileUtils.stringToFile(MASS_STORAGE_FILE_PATH, path);
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to write to /sys/class/android_usb/android0/f_mass_storage/lun/file");
        }
    }

    private void readOemUsbOverrideConfig() {
        String[] configList = this.mContext.getResources().getStringArray(17236007);
        if (configList != null) {
            for (String config : configList) {
                List<Pair<String, String>> overrideList;
                String[] items = config.split(":");
                if (items.length != 3) continue;
                if (this.mOemModeMap == null) {
                    this.mOemModeMap = new HashMap<String, List<Pair<String, String>>>();
                }
                if ((overrideList = this.mOemModeMap.get(items[0])) == null) {
                    overrideList = new LinkedList<Pair<String, String>>();
                    this.mOemModeMap.put(items[0], overrideList);
                }
                overrideList.add(new Pair<String, String>(items[1], items[2]));
            }
        }
    }

    private boolean needsOemUsbOverride() {
        if (this.mOemModeMap == null) {
            return false;
        }
        String bootMode = SystemProperties.get(BOOT_MODE_PROPERTY, "unknown");
        return this.mOemModeMap.get(bootMode) != null;
    }

    private String processOemUsbOverride(String usbFunctions) {
        if (usbFunctions == null || this.mOemModeMap == null) {
            return usbFunctions;
        }
        String bootMode = SystemProperties.get(BOOT_MODE_PROPERTY, "unknown");
        List<Pair<String, String>> overrides = this.mOemModeMap.get(bootMode);
        if (overrides != null) {
            for (Pair<String, String> pair : overrides) {
                if (!((String)pair.first).equals(usbFunctions)) continue;
                Slog.d(TAG, "OEM USB override: " + (String)pair.first + " ==> " + (String)pair.second);
                return (String)pair.second;
            }
        }
        return usbFunctions;
    }

    public void allowUsbDebugging(boolean alwaysAllow, String publicKey) {
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.allowUsbDebugging(alwaysAllow, publicKey);
        }
    }

    public void denyUsbDebugging() {
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.denyUsbDebugging();
        }
    }

    public void clearUsbDebuggingKeys() {
        if (this.mDebuggingManager == null) {
            throw new RuntimeException("Cannot clear Usb Debugging keys, UsbDebuggingManager not enabled");
        }
        this.mDebuggingManager.clearUsbDebuggingKeys();
    }

    public void dump(FileDescriptor fd, PrintWriter pw) {
        if (this.mHandler != null) {
            this.mHandler.dump(fd, pw);
        }
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.dump(fd, pw);
        }
    }

    private native String[] nativeGetAccessoryStrings();

    private native ParcelFileDescriptor nativeOpenAccessory();

    private native boolean nativeIsStartRequested();

    private native int nativeGetAudioMode();

    static /* synthetic */ String[] access$1402(UsbDeviceManager x0, String[] x1) {
        x0.mAccessoryStrings = x1;
        return x1;
    }

    private final class UsbHandler
    extends Handler {
        private boolean mConnected;
        private boolean mConfigured;
        private String mCurrentFunctions;
        private String mDefaultFunctions;
        private UsbAccessory mCurrentAccessory;
        private int mUsbNotificationId;
        private boolean mAdbNotificationShown;
        private int mCurrentUser;
        private final BroadcastReceiver mBootCompletedReceiver;
        private final BroadcastReceiver mUserSwitchedReceiver;

        public UsbHandler(Looper looper) {
            super(looper);
            this.mCurrentUser = -10000;
            this.mBootCompletedReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    UsbDeviceManager.this.mHandler.sendEmptyMessage(4);
                }
            };
            this.mUserSwitchedReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                    UsbDeviceManager.this.mHandler.obtainMessage(5, userId, 0).sendToTarget();
                }
            };
            try {
                this.mDefaultFunctions = SystemProperties.get("persist.sys.usb.config", "adb");
                this.mDefaultFunctions = UsbDeviceManager.this.processOemUsbOverride(this.mDefaultFunctions);
                String config = SystemProperties.get("sys.usb.config", "none");
                if (!config.equals(this.mDefaultFunctions)) {
                    Slog.w(TAG, "resetting config to persistent property: " + this.mDefaultFunctions);
                    SystemProperties.set("sys.usb.config", this.mDefaultFunctions);
                }
                this.mCurrentFunctions = this.mDefaultFunctions;
                String state = FileUtils.readTextFile(new File(UsbDeviceManager.STATE_PATH), 0, null).trim();
                this.updateState(state);
                UsbDeviceManager.this.mAdbEnabled = UsbDeviceManager.containsFunction(this.mCurrentFunctions, "adb");
                String value = SystemProperties.get("persist.service.adb.enable", "");
                if (value.length() > 0) {
                    char enable = value.charAt(0);
                    if (enable == '1') {
                        this.setAdbEnabled(true);
                    } else if (enable == '0') {
                        this.setAdbEnabled(false);
                    }
                    SystemProperties.set("persist.service.adb.enable", "");
                }
                UsbDeviceManager.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("adb_enabled"), false, new AdbSettingsObserver());
                UsbDeviceManager.this.mUEventObserver.startObserving(UsbDeviceManager.USB_STATE_MATCH);
                UsbDeviceManager.this.mUEventObserver.startObserving(UsbDeviceManager.ACCESSORY_START_MATCH);
                UsbDeviceManager.this.mContext.registerReceiver(this.mBootCompletedReceiver, new IntentFilter("android.intent.action.BOOT_COMPLETED"));
                UsbDeviceManager.this.mContext.registerReceiver(this.mUserSwitchedReceiver, new IntentFilter("android.intent.action.USER_SWITCHED"));
            }
            catch (Exception e) {
                Slog.e(TAG, "Error initializing UsbHandler", e);
            }
        }

        public void sendMessage(int what, boolean arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.arg1 = arg ? 1 : 0;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.obj = arg;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg0, boolean arg1) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.obj = arg0;
            m.arg1 = arg1 ? 1 : 0;
            this.sendMessage(m);
        }

        public void updateState(String state) {
            int configured;
            int connected;
            if ("DISCONNECTED".equals(state)) {
                connected = 0;
                configured = 0;
            } else if ("CONNECTED".equals(state)) {
                connected = 1;
                configured = 0;
            } else if ("CONFIGURED".equals(state)) {
                connected = 1;
                configured = 1;
            } else {
                Slog.e(TAG, "unknown state " + state);
                return;
            }
            this.removeMessages(0);
            Message msg = Message.obtain((Handler)this, 0);
            msg.arg1 = connected;
            msg.arg2 = configured;
            this.sendMessageDelayed(msg, connected == 0 ? 1000L : 0L);
        }

        private boolean waitForState(String state) {
            for (int i = 0; i < 20; ++i) {
                if (state.equals(SystemProperties.get("sys.usb.state"))) {
                    return true;
                }
                SystemClock.sleep(50L);
            }
            Slog.e(TAG, "waitForState(" + state + ") FAILED");
            return false;
        }

        private boolean setUsbConfig(String config) {
            SystemProperties.set("sys.usb.config", config);
            return this.waitForState(config);
        }

        private void setAdbEnabled(boolean enable) {
            if (enable != UsbDeviceManager.this.mAdbEnabled) {
                UsbDeviceManager.this.mAdbEnabled = enable;
                this.setEnabledFunctions(this.mDefaultFunctions, true);
                this.updateAdbNotification();
            }
            if (UsbDeviceManager.this.mDebuggingManager != null) {
                UsbDeviceManager.this.mDebuggingManager.setAdbEnabled(UsbDeviceManager.this.mAdbEnabled);
            }
        }

        private void setEnabledFunctions(String functions, boolean makeDefault) {
            if (functions != null && makeDefault && !UsbDeviceManager.this.needsOemUsbOverride()) {
                functions = UsbDeviceManager.this.mAdbEnabled ? UsbDeviceManager.addFunction(functions, "adb") : UsbDeviceManager.removeFunction(functions, "adb");
                if (!this.mDefaultFunctions.equals(functions)) {
                    if (!this.setUsbConfig("none")) {
                        Slog.e(TAG, "Failed to disable USB");
                        this.setUsbConfig(this.mCurrentFunctions);
                        return;
                    }
                    SystemProperties.set("persist.sys.usb.config", functions);
                    if (this.waitForState(functions)) {
                        this.mCurrentFunctions = functions;
                        this.mDefaultFunctions = functions;
                    } else {
                        Slog.e(TAG, "Failed to switch persistent USB config to " + functions);
                        SystemProperties.set("persist.sys.usb.config", this.mDefaultFunctions);
                    }
                }
            } else {
                if (functions == null) {
                    functions = this.mDefaultFunctions;
                }
                functions = UsbDeviceManager.this.processOemUsbOverride(functions);
                functions = UsbDeviceManager.this.mAdbEnabled ? UsbDeviceManager.addFunction(functions, "adb") : UsbDeviceManager.removeFunction(functions, "adb");
                if (!this.mCurrentFunctions.equals(functions)) {
                    if (!this.setUsbConfig("none")) {
                        Slog.e(TAG, "Failed to disable USB");
                        this.setUsbConfig(this.mCurrentFunctions);
                        return;
                    }
                    if (this.setUsbConfig(functions)) {
                        this.mCurrentFunctions = functions;
                    } else {
                        Slog.e(TAG, "Failed to switch USB config to " + functions);
                        this.setUsbConfig(this.mCurrentFunctions);
                    }
                }
            }
        }

        private void updateCurrentAccessory() {
            if (!UsbDeviceManager.this.mHasUsbAccessory) {
                return;
            }
            if (this.mConfigured) {
                if (UsbDeviceManager.this.mAccessoryStrings != null) {
                    this.mCurrentAccessory = new UsbAccessory(UsbDeviceManager.this.mAccessoryStrings);
                    Slog.d(TAG, "entering USB accessory mode: " + this.mCurrentAccessory);
                    if (UsbDeviceManager.this.mBootCompleted) {
                        UsbDeviceManager.this.getCurrentSettings().accessoryAttached(this.mCurrentAccessory);
                    }
                } else {
                    Slog.e(TAG, "nativeGetAccessoryStrings failed");
                }
            } else if (!this.mConnected) {
                Slog.d(TAG, "exited USB accessory mode");
                this.setEnabledFunctions(this.mDefaultFunctions, false);
                if (this.mCurrentAccessory != null) {
                    if (UsbDeviceManager.this.mBootCompleted) {
                        UsbDeviceManager.this.getCurrentSettings().accessoryDetached(this.mCurrentAccessory);
                    }
                    this.mCurrentAccessory = null;
                    UsbDeviceManager.access$1402(UsbDeviceManager.this, null);
                }
            }
        }

        private void updateUsbState() {
            Intent intent = new Intent("android.hardware.usb.action.USB_STATE");
            intent.addFlags(0x20000000);
            intent.putExtra("connected", this.mConnected);
            intent.putExtra("configured", this.mConfigured);
            if (this.mCurrentFunctions != null) {
                String[] functions = this.mCurrentFunctions.split(",");
                for (int i = 0; i < functions.length; ++i) {
                    intent.putExtra(functions[i], true);
                }
            }
            UsbDeviceManager.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }

        private void updateAudioSourceFunction() {
            boolean enabled = UsbDeviceManager.containsFunction(this.mCurrentFunctions, "audio_source");
            if (enabled != UsbDeviceManager.this.mAudioSourceEnabled) {
                Intent intent = new Intent("android.intent.action.USB_AUDIO_ACCESSORY_PLUG");
                intent.addFlags(0x20000000);
                intent.addFlags(0x40000000);
                intent.putExtra("state", enabled ? 1 : 0);
                if (enabled) {
                    try {
                        Scanner scanner = new Scanner(new File(UsbDeviceManager.AUDIO_SOURCE_PCM_PATH));
                        int card = scanner.nextInt();
                        int device = scanner.nextInt();
                        intent.putExtra("card", card);
                        intent.putExtra("device", device);
                    }
                    catch (FileNotFoundException e) {
                        Slog.e(TAG, "could not open audio source PCM file", e);
                    }
                }
                UsbDeviceManager.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
                UsbDeviceManager.this.mAudioSourceEnabled = enabled;
            }
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mConnected = msg.arg1 == 1;
                    this.mConfigured = msg.arg2 == 1;
                    this.updateUsbNotification();
                    this.updateAdbNotification();
                    if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "accessory")) {
                        this.updateCurrentAccessory();
                    }
                    if (!this.mConnected) {
                        this.setEnabledFunctions(this.mDefaultFunctions, false);
                    }
                    if (!UsbDeviceManager.this.mBootCompleted) break;
                    this.updateUsbState();
                    this.updateAudioSourceFunction();
                    break;
                }
                case 1: {
                    this.setAdbEnabled(msg.arg1 == 1);
                    break;
                }
                case 2: {
                    String functions = (String)msg.obj;
                    boolean makeDefault = msg.arg1 == 1;
                    this.setEnabledFunctions(functions, makeDefault);
                    break;
                }
                case 3: {
                    this.updateUsbNotification();
                    this.updateAdbNotification();
                    this.updateUsbState();
                    this.updateAudioSourceFunction();
                    break;
                }
                case 4: {
                    UsbDeviceManager.this.mBootCompleted = true;
                    if (this.mCurrentAccessory != null) {
                        UsbDeviceManager.this.getCurrentSettings().accessoryAttached(this.mCurrentAccessory);
                    }
                    if (UsbDeviceManager.this.mDebuggingManager == null) break;
                    UsbDeviceManager.this.mDebuggingManager.setAdbEnabled(UsbDeviceManager.this.mAdbEnabled);
                    break;
                }
                case 5: {
                    boolean mtpActive;
                    boolean bl = mtpActive = UsbDeviceManager.containsFunction(this.mCurrentFunctions, "mtp") || UsbDeviceManager.containsFunction(this.mCurrentFunctions, "ptp");
                    if (mtpActive && this.mCurrentUser != -10000) {
                        Slog.v(TAG, "Current user switched; resetting USB host stack for MTP");
                        this.setUsbConfig("none");
                        this.setUsbConfig(this.mCurrentFunctions);
                    }
                    this.mCurrentUser = msg.arg1;
                    break;
                }
            }
        }

        public UsbAccessory getCurrentAccessory() {
            return this.mCurrentAccessory;
        }

        private void updateUsbNotification() {
            if (UsbDeviceManager.this.mNotificationManager == null || !UsbDeviceManager.this.mUseUsbNotification) {
                return;
            }
            int id2 = 0;
            Resources r = UsbDeviceManager.this.mContext.getResources();
            if (this.mConnected) {
                if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "mtp")) {
                    id2 = 17040497;
                } else if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "ptp")) {
                    id2 = 17040498;
                } else if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "mass_storage")) {
                    id2 = 17040499;
                } else if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "accessory")) {
                    id2 = 17040500;
                }
            }
            if (id2 != this.mUsbNotificationId) {
                if (this.mUsbNotificationId != 0) {
                    UsbDeviceManager.this.mNotificationManager.cancelAsUser(null, this.mUsbNotificationId, UserHandle.ALL);
                    this.mUsbNotificationId = 0;
                }
                if (id2 != 0) {
                    CharSequence message = r.getText(17040501);
                    CharSequence title = r.getText(id2);
                    Notification notification = new Notification();
                    notification.icon = 17302957;
                    notification.when = 0L;
                    notification.flags = 2;
                    notification.tickerText = title;
                    notification.defaults = 0;
                    notification.sound = null;
                    notification.vibrate = null;
                    notification.priority = -2;
                    Intent intent = Intent.makeRestartActivityTask(new ComponentName("com.android.settings", "com.android.settings.UsbSettings"));
                    PendingIntent pi = PendingIntent.getActivityAsUser(UsbDeviceManager.this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
                    notification.setLatestEventInfo(UsbDeviceManager.this.mContext, title, message, pi);
                    UsbDeviceManager.this.mNotificationManager.notifyAsUser(null, id2, notification, UserHandle.ALL);
                    this.mUsbNotificationId = id2;
                }
            }
        }

        private void updateAdbNotification() {
            if (UsbDeviceManager.this.mNotificationManager == null) {
                return;
            }
            int id2 = 17040505;
            if (UsbDeviceManager.this.mAdbEnabled && this.mConnected) {
                if ("0".equals(SystemProperties.get("persist.adb.notify"))) {
                    return;
                }
                if (!this.mAdbNotificationShown) {
                    Resources r = UsbDeviceManager.this.mContext.getResources();
                    CharSequence title = r.getText(17040505);
                    CharSequence message = r.getText(17040506);
                    Notification notification = new Notification();
                    notification.icon = 17302925;
                    notification.when = 0L;
                    notification.flags = 2;
                    notification.tickerText = title;
                    notification.defaults = 0;
                    notification.sound = null;
                    notification.vibrate = null;
                    notification.priority = -1;
                    Intent intent = Intent.makeRestartActivityTask(new ComponentName("com.android.settings", "com.android.settings.DevelopmentSettings"));
                    PendingIntent pi = PendingIntent.getActivityAsUser(UsbDeviceManager.this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
                    notification.setLatestEventInfo(UsbDeviceManager.this.mContext, title, message, pi);
                    this.mAdbNotificationShown = true;
                    UsbDeviceManager.this.mNotificationManager.notifyAsUser(null, 17040505, notification, UserHandle.ALL);
                }
            } else if (this.mAdbNotificationShown) {
                this.mAdbNotificationShown = false;
                UsbDeviceManager.this.mNotificationManager.cancelAsUser(null, 17040505, UserHandle.ALL);
            }
        }

        public void dump(FileDescriptor fd, PrintWriter pw) {
            pw.println("  USB Device State:");
            pw.println("    Current Functions: " + this.mCurrentFunctions);
            pw.println("    Default Functions: " + this.mDefaultFunctions);
            pw.println("    mConnected: " + this.mConnected);
            pw.println("    mConfigured: " + this.mConfigured);
            pw.println("    mCurrentAccessory: " + this.mCurrentAccessory);
            try {
                pw.println("    Kernel state: " + FileUtils.readTextFile(new File(UsbDeviceManager.STATE_PATH), 0, null).trim());
                pw.println("    Kernel function list: " + FileUtils.readTextFile(new File(UsbDeviceManager.FUNCTIONS_PATH), 0, null).trim());
                pw.println("    Mass storage backing file: " + FileUtils.readTextFile(new File(UsbDeviceManager.MASS_STORAGE_FILE_PATH), 0, null).trim());
            }
            catch (IOException e) {
                pw.println("IOException: " + e);
            }
        }
    }

    private class AdbSettingsObserver
    extends ContentObserver {
        public AdbSettingsObserver() {
            super(null);
        }

        public void onChange(boolean selfChange) {
            boolean enable = Settings.Global.getInt(UsbDeviceManager.this.mContentResolver, "adb_enabled", 0) > 0;
            UsbDeviceManager.this.mHandler.sendMessage(1, enable);
        }
    }
}

