/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wifi;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.TaskStackBuilder;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiStateMachine;
import android.os.Handler;
import android.os.UserHandle;
import android.provider.Settings;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WifiNotificationController {
    private static final int ICON_NETWORKS_AVAILABLE = 17302924;
    private final long NOTIFICATION_REPEAT_DELAY_MS;
    private boolean mNotificationEnabled;
    private NotificationEnabledSettingObserver mNotificationEnabledSettingObserver;
    private long mNotificationRepeatTime;
    private Notification mNotification;
    private boolean mNotificationShown;
    private static final int NUM_SCANS_BEFORE_ACTUALLY_SCANNING = 3;
    private int mNumScansSinceNetworkStateChange;
    private final Context mContext;
    private final WifiStateMachine mWifiStateMachine;
    private NetworkInfo mNetworkInfo;
    private volatile int mWifiState;

    WifiNotificationController(Context context, WifiStateMachine wsm) {
        this.mContext = context;
        this.mWifiStateMachine = wsm;
        this.mWifiState = 4;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.SCAN_RESULTS");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    WifiNotificationController.this.mWifiState = intent.getIntExtra("wifi_state", 4);
                    WifiNotificationController.this.resetNotification();
                } else if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                    WifiNotificationController.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    switch (WifiNotificationController.this.mNetworkInfo.getDetailedState()) {
                        case CONNECTED: 
                        case DISCONNECTED: 
                        case CAPTIVE_PORTAL_CHECK: {
                            WifiNotificationController.this.resetNotification();
                        }
                    }
                } else if (intent.getAction().equals("android.net.wifi.SCAN_RESULTS")) {
                    WifiNotificationController.this.checkAndSetNotification(WifiNotificationController.this.mNetworkInfo, WifiNotificationController.this.mWifiStateMachine.syncGetScanResultsList());
                }
            }
        }, filter);
        this.NOTIFICATION_REPEAT_DELAY_MS = (long)Settings.Global.getInt(context.getContentResolver(), "wifi_networks_available_repeat_delay", 900) * 1000L;
        this.mNotificationEnabledSettingObserver = new NotificationEnabledSettingObserver(new Handler());
        this.mNotificationEnabledSettingObserver.register();
    }

    private synchronized void checkAndSetNotification(NetworkInfo networkInfo, List<ScanResult> scanResults) {
        if (!this.mNotificationEnabled) {
            return;
        }
        if (networkInfo == null) {
            return;
        }
        if (this.mWifiState != 3) {
            return;
        }
        NetworkInfo.State state = networkInfo.getState();
        if ((state == NetworkInfo.State.DISCONNECTED || state == NetworkInfo.State.UNKNOWN) && scanResults != null) {
            int numOpenNetworks = 0;
            for (int i = scanResults.size() - 1; i >= 0; --i) {
                ScanResult scanResult = scanResults.get(i);
                if (scanResult.capabilities == null || !scanResult.capabilities.equals("[ESS]")) continue;
                ++numOpenNetworks;
            }
            if (numOpenNetworks > 0) {
                if (++this.mNumScansSinceNetworkStateChange >= 3) {
                    this.setNotificationVisible(true, numOpenNetworks, false, 0);
                }
                return;
            }
        }
        this.setNotificationVisible(false, 0, false, 0);
    }

    private synchronized void resetNotification() {
        this.mNotificationRepeatTime = 0L;
        this.mNumScansSinceNetworkStateChange = 0;
        this.setNotificationVisible(false, 0, false, 0);
    }

    private void setNotificationVisible(boolean visible, int numNetworks, boolean force, int delay) {
        if (!(visible || this.mNotificationShown || force)) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (visible) {
            if (System.currentTimeMillis() < this.mNotificationRepeatTime) {
                return;
            }
            if (this.mNotification == null) {
                this.mNotification = new Notification();
                this.mNotification.when = 0L;
                this.mNotification.icon = 17302924;
                this.mNotification.flags = 16;
                this.mNotification.contentIntent = TaskStackBuilder.create(this.mContext).addNextIntentWithParentStack(new Intent("android.net.wifi.PICK_WIFI_NETWORK")).getPendingIntent(0, 0, null, UserHandle.CURRENT);
            }
            CharSequence title = this.mContext.getResources().getQuantityText(18022421, numNetworks);
            CharSequence details = this.mContext.getResources().getQuantityText(18022422, numNetworks);
            this.mNotification.tickerText = title;
            this.mNotification.setLatestEventInfo(this.mContext, title, details, this.mNotification.contentIntent);
            this.mNotificationRepeatTime = System.currentTimeMillis() + this.NOTIFICATION_REPEAT_DELAY_MS;
            notificationManager.notifyAsUser(null, 17302924, this.mNotification, UserHandle.ALL);
        } else {
            notificationManager.cancelAsUser(null, 17302924, UserHandle.ALL);
        }
        this.mNotificationShown = visible;
    }

    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("mNotificationEnabled " + this.mNotificationEnabled);
        pw.println("mNotificationRepeatTime " + this.mNotificationRepeatTime);
        pw.println("mNotificationShown " + this.mNotificationShown);
        pw.println("mNumScansSinceNetworkStateChange " + this.mNumScansSinceNetworkStateChange);
    }

    private class NotificationEnabledSettingObserver
    extends ContentObserver {
        public NotificationEnabledSettingObserver(Handler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register() {
            ContentResolver cr = WifiNotificationController.this.mContext.getContentResolver();
            cr.registerContentObserver(Settings.Global.getUriFor("wifi_networks_available_notification_on"), true, this);
            WifiNotificationController wifiNotificationController = WifiNotificationController.this;
            synchronized (wifiNotificationController) {
                WifiNotificationController.this.mNotificationEnabled = this.getValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            WifiNotificationController wifiNotificationController = WifiNotificationController.this;
            synchronized (wifiNotificationController) {
                WifiNotificationController.this.mNotificationEnabled = this.getValue();
                WifiNotificationController.this.resetNotification();
            }
        }

        private boolean getValue() {
            return Settings.Global.getInt(WifiNotificationController.this.mContext.getContentResolver(), "wifi_networks_available_notification_on", 1) == 1;
        }
    }
}

