/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Message;
import android.os.RemoteException;
import android.view.IApplicationToken;
import android.view.View;
import com.android.server.input.InputApplicationHandle;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.StartingData;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;

class AppWindowToken
extends WindowToken {
    final IApplicationToken appToken;
    final WindowList allAppWindows = new WindowList();
    final AppWindowAnimator mAppAnimator;
    final WindowAnimator mAnimator;
    int groupId = -1;
    boolean appFullscreen;
    int requestedOrientation = -1;
    int configChanges;
    boolean showWhenLocked;
    long inputDispatchingTimeoutNanos;
    long lastTransactionSequence = Long.MIN_VALUE;
    int numInterestingWindows;
    int numDrawnWindows;
    boolean inPendingTransaction;
    boolean allDrawn;
    boolean deferClearAllDrawn;
    boolean willBeHidden;
    boolean hiddenRequested;
    boolean clientHidden;
    boolean reportedVisible;
    boolean reportedDrawn;
    boolean removed;
    StartingData startingData;
    WindowState startingWindow;
    View startingView;
    boolean startingDisplayed;
    boolean startingMoved;
    boolean firstWindowDrawn;
    final InputApplicationHandle mInputApplicationHandle;

    AppWindowToken(WindowManagerService _service, IApplicationToken _token) {
        super(_service, _token.asBinder(), 2, true);
        this.appWindowToken = this;
        this.appToken = _token;
        this.mInputApplicationHandle = new InputApplicationHandle(this);
        this.mAnimator = this.service.mAnimator;
        this.mAppAnimator = new AppWindowAnimator(this);
    }

    void sendAppVisibilityToClients() {
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            if (win == this.startingWindow && this.clientHidden) continue;
            try {
                win.mClient.dispatchAppVisibility(!this.clientHidden);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    void updateReportedVisibilityLocked() {
        Message m;
        boolean nowVisible;
        if (this.appToken == null) {
            return;
        }
        int numInteresting = 0;
        int numVisible = 0;
        int numDrawn = 0;
        boolean nowGone = true;
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            if (win == this.startingWindow || win.mAppFreezing || win.mViewVisibility != 0 || win.mAttrs.type == 3 || win.mDestroying) continue;
            ++numInteresting;
            if (win.isDrawnLw()) {
                ++numDrawn;
                if (!win.mWinAnimator.isAnimating()) {
                    ++numVisible;
                }
                nowGone = false;
                continue;
            }
            if (!win.mWinAnimator.isAnimating()) continue;
            nowGone = false;
        }
        boolean nowDrawn = numInteresting > 0 && numDrawn >= numInteresting;
        boolean bl = nowVisible = numInteresting > 0 && numVisible >= numInteresting;
        if (!nowGone) {
            if (!nowDrawn) {
                nowDrawn = this.reportedDrawn;
            }
            if (!nowVisible) {
                nowVisible = this.reportedVisible;
            }
        }
        if (nowDrawn != this.reportedDrawn) {
            if (nowDrawn) {
                m = this.service.mH.obtainMessage(9, this);
                this.service.mH.sendMessage(m);
            }
            this.reportedDrawn = nowDrawn;
        }
        if (nowVisible != this.reportedVisible) {
            this.reportedVisible = nowVisible;
            m = this.service.mH.obtainMessage(8, nowVisible ? 1 : 0, nowGone ? 1 : 0, this);
            this.service.mH.sendMessage(m);
        }
    }

    WindowState findMainWindow() {
        int j = this.windows.size();
        while (j > 0) {
            WindowState win = (WindowState)this.windows.get(--j);
            if (win.mAttrs.type != 1 && win.mAttrs.type != 3) continue;
            return win;
        }
        return null;
    }

    boolean isVisible() {
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            if (win.mAppFreezing || win.mViewVisibility != 0 && (!win.mWinAnimator.isAnimating() || this.service.mAppTransition.isTransitionSet()) || win.mDestroying || !win.isDrawnLw()) continue;
            return true;
        }
        return false;
    }

    void dump(PrintWriter pw, String prefix) {
        super.dump(pw, prefix);
        if (this.appToken != null) {
            pw.print(prefix);
            pw.println("app=true");
        }
        if (this.allAppWindows.size() > 0) {
            pw.print(prefix);
            pw.print("allAppWindows=");
            pw.println(this.allAppWindows);
        }
        pw.print(prefix);
        pw.print("groupId=");
        pw.print(this.groupId);
        pw.print(" appFullscreen=");
        pw.print(this.appFullscreen);
        pw.print(" requestedOrientation=");
        pw.println(this.requestedOrientation);
        pw.print(prefix);
        pw.print("hiddenRequested=");
        pw.print(this.hiddenRequested);
        pw.print(" clientHidden=");
        pw.print(this.clientHidden);
        pw.print(" willBeHidden=");
        pw.print(this.willBeHidden);
        pw.print(" reportedDrawn=");
        pw.print(this.reportedDrawn);
        pw.print(" reportedVisible=");
        pw.println(this.reportedVisible);
        if (this.paused) {
            pw.print(prefix);
            pw.print("paused=");
            pw.println(this.paused);
        }
        if (this.numInterestingWindows != 0 || this.numDrawnWindows != 0 || this.allDrawn || this.mAppAnimator.allDrawn) {
            pw.print(prefix);
            pw.print("numInterestingWindows=");
            pw.print(this.numInterestingWindows);
            pw.print(" numDrawnWindows=");
            pw.print(this.numDrawnWindows);
            pw.print(" inPendingTransaction=");
            pw.print(this.inPendingTransaction);
            pw.print(" allDrawn=");
            pw.print(this.allDrawn);
            pw.print(" (animator=");
            pw.print(this.mAppAnimator.allDrawn);
            pw.println(")");
        }
        if (this.inPendingTransaction) {
            pw.print(prefix);
            pw.print("inPendingTransaction=");
            pw.println(this.inPendingTransaction);
        }
        if (this.startingData != null || this.removed || this.firstWindowDrawn) {
            pw.print(prefix);
            pw.print("startingData=");
            pw.print(this.startingData);
            pw.print(" removed=");
            pw.print(this.removed);
            pw.print(" firstWindowDrawn=");
            pw.println(this.firstWindowDrawn);
        }
        if (this.startingWindow != null || this.startingView != null || this.startingDisplayed || this.startingMoved) {
            pw.print(prefix);
            pw.print("startingWindow=");
            pw.print(this.startingWindow);
            pw.print(" startingView=");
            pw.print(this.startingView);
            pw.print(" startingDisplayed=");
            pw.print(this.startingDisplayed);
            pw.print(" startingMoved");
            pw.println(this.startingMoved);
        }
    }

    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("AppWindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" token=");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName;
    }
}

