/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

public class StackBox {
    public static final int TASK_STACK_GOES_BEFORE = 0;
    public static final int TASK_STACK_GOES_AFTER = 1;
    public static final int TASK_STACK_TO_LEFT_OF = 2;
    public static final int TASK_STACK_TO_RIGHT_OF = 3;
    public static final int TASK_STACK_GOES_ABOVE = 4;
    public static final int TASK_STACK_GOES_BELOW = 5;
    public static final int TASK_STACK_GOES_OVER = 6;
    public static final int TASK_STACK_GOES_UNDER = 7;
    static int sCurrentBoxId = 0;
    final int mStackBoxId;
    final WindowManagerService mService;
    final DisplayContent mDisplayContent;
    StackBox mParent;
    StackBox mFirst;
    StackBox mSecond;
    TaskStack mStack;
    Rect mBounds = new Rect();
    boolean mVertical;
    float mWeight;
    boolean layoutNeeded;
    boolean mUnderStatusBar;
    Rect mTmpRect = new Rect();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StackBox(WindowManagerService service, DisplayContent displayContent, StackBox parent) {
        Class<StackBox> clazz = StackBox.class;
        synchronized (StackBox.class) {
            this.mStackBoxId = sCurrentBoxId++;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.mService = service;
            this.mDisplayContent = displayContent;
            this.mParent = parent;
            return;
        }
    }

    void makeDirty() {
        this.layoutNeeded = true;
        if (this.mParent != null) {
            this.mParent.makeDirty();
        }
    }

    boolean contains(int stackBoxId) {
        return this.mStackBoxId == stackBoxId || this.mStack == null && (this.mFirst.contains(stackBoxId) || this.mSecond.contains(stackBoxId));
    }

    int stackIdFromPoint(int x, int y) {
        if (!this.mBounds.contains(x, y)) {
            return -1;
        }
        if (this.mStack != null) {
            return this.mStack.mStackId;
        }
        int stackId = this.mFirst.stackIdFromPoint(x, y);
        if (stackId >= 0) {
            return stackId;
        }
        return this.mSecond.stackIdFromPoint(x, y);
    }

    boolean isFirstChild() {
        return this.mParent != null && this.mParent.mFirst == this;
    }

    Rect getStackBounds(int stackId) {
        if (this.mStack != null) {
            return this.mStack.mStackId == stackId ? new Rect(this.mBounds) : null;
        }
        Rect bounds = this.mFirst.getStackBounds(stackId);
        if (bounds != null) {
            return bounds;
        }
        return this.mSecond.getStackBounds(stackId);
    }

    TaskStack split(int stackId, int relativeStackBoxId, int position, float weight) {
        TaskStack secondStack;
        TaskStack firstStack;
        if (this.mStackBoxId != relativeStackBoxId) {
            if (this.mStack != null) {
                return null;
            }
            TaskStack stack = this.mFirst.split(stackId, relativeStackBoxId, position, weight);
            if (stack != null) {
                return stack;
            }
            return this.mSecond.split(stackId, relativeStackBoxId, position, weight);
        }
        TaskStack stack = new TaskStack(this.mService, stackId, this.mDisplayContent);
        if (position == 0) {
            position = 2;
        } else if (position == 1) {
            position = 3;
        }
        switch (position) {
            default: {
                this.mVertical = false;
                if (position == 2) {
                    this.mWeight = weight;
                    firstStack = stack;
                    secondStack = this.mStack;
                    break;
                }
                this.mWeight = 1.0f - weight;
                firstStack = this.mStack;
                secondStack = stack;
                break;
            }
            case 4: 
            case 5: {
                this.mVertical = true;
                if (position == 4) {
                    this.mWeight = weight;
                    firstStack = stack;
                    secondStack = this.mStack;
                    break;
                }
                this.mWeight = 1.0f - weight;
                firstStack = this.mStack;
                secondStack = stack;
            }
        }
        firstStack.mStackBox = this.mFirst = new StackBox(this.mService, this.mDisplayContent, this);
        this.mFirst.mStack = firstStack;
        secondStack.mStackBox = this.mSecond = new StackBox(this.mService, this.mDisplayContent, this);
        this.mSecond.mStack = secondStack;
        this.mStack = null;
        return stack;
    }

    int getStackId() {
        if (this.mStack != null) {
            return this.mStack.mStackId;
        }
        return this.mFirst.getStackId();
    }

    int remove() {
        StackBox grandparent;
        this.mDisplayContent.layoutNeeded = true;
        if (this.mParent == null) {
            this.mDisplayContent.removeStackBox(this);
            return 0;
        }
        StackBox sibling = this.isFirstChild() ? this.mParent.mSecond : this.mParent.mFirst;
        sibling.mParent = grandparent = this.mParent.mParent;
        if (grandparent == null) {
            this.mDisplayContent.removeStackBox(this.mParent);
            this.mDisplayContent.addStackBox(sibling, true);
        } else if (this.mParent.isFirstChild()) {
            grandparent.mFirst = sibling;
        } else {
            grandparent.mSecond = sibling;
        }
        return sibling.getStackId();
    }

    boolean resize(int stackBoxId, float weight) {
        if (this.mStackBoxId != stackBoxId) {
            return this.mStack == null && (this.mFirst.resize(stackBoxId, weight) || this.mSecond.resize(stackBoxId, weight));
        }
        if (this.mParent != null) {
            this.mParent.mWeight = this.isFirstChild() ? weight : 1.0f - weight;
        }
        return true;
    }

    boolean setStackBoxSizes(Rect bounds, boolean underStatusBar) {
        boolean change = false;
        if (this.mUnderStatusBar != underStatusBar) {
            change = true;
            this.mUnderStatusBar = underStatusBar;
        }
        if (this.mStack != null) {
            if (change |= !this.mBounds.equals(bounds)) {
                this.mBounds.set(bounds);
                this.mStack.setBounds(bounds, underStatusBar);
            }
        } else {
            this.mTmpRect.set(bounds);
            if (this.mVertical) {
                int height = bounds.height();
                int firstHeight = (int)((float)height * this.mWeight);
                this.mTmpRect.bottom = bounds.top + firstHeight;
                change |= this.mFirst.setStackBoxSizes(this.mTmpRect, underStatusBar);
                this.mTmpRect.top = this.mTmpRect.bottom;
                this.mTmpRect.bottom = bounds.top + height;
                change |= this.mSecond.setStackBoxSizes(this.mTmpRect, false);
            } else {
                int width = bounds.width();
                int firstWidth = (int)((float)width * this.mWeight);
                this.mTmpRect.right = bounds.left + firstWidth;
                change |= this.mFirst.setStackBoxSizes(this.mTmpRect, underStatusBar);
                this.mTmpRect.left = this.mTmpRect.right;
                this.mTmpRect.right = bounds.left + width;
                change |= this.mSecond.setStackBoxSizes(this.mTmpRect, underStatusBar);
            }
        }
        return change;
    }

    void resetAnimationBackgroundAnimator() {
        if (this.mStack != null) {
            this.mStack.resetAnimationBackgroundAnimator();
            return;
        }
        this.mFirst.resetAnimationBackgroundAnimator();
        this.mSecond.resetAnimationBackgroundAnimator();
    }

    boolean animateDimLayers() {
        if (this.mStack != null) {
            return this.mStack.animateDimLayers();
        }
        boolean result = this.mFirst.animateDimLayers();
        return result |= this.mSecond.animateDimLayers();
    }

    void resetDimming() {
        if (this.mStack != null) {
            this.mStack.resetDimmingTag();
            return;
        }
        this.mFirst.resetDimming();
        this.mSecond.resetDimming();
    }

    boolean isDimming() {
        if (this.mStack != null) {
            return this.mStack.isDimming();
        }
        boolean result = this.mFirst.isDimming();
        return result |= this.mSecond.isDimming();
    }

    void stopDimmingIfNeeded() {
        if (this.mStack != null) {
            this.mStack.stopDimmingIfNeeded();
            return;
        }
        this.mFirst.stopDimmingIfNeeded();
        this.mSecond.stopDimmingIfNeeded();
    }

    void switchUserStacks(int userId) {
        if (this.mStack != null) {
            this.mStack.switchUser(userId);
            return;
        }
        this.mFirst.switchUserStacks(userId);
        this.mSecond.switchUserStacks(userId);
    }

    void close() {
        if (this.mStack != null) {
            this.mStack.mDimLayer.mDimSurface.destroy();
            this.mStack.mAnimationBackgroundSurface.mDimSurface.destroy();
            return;
        }
        this.mFirst.close();
        this.mSecond.close();
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mParent=");
        pw.println(this.mParent);
        pw.print(prefix);
        pw.print("mBounds=");
        pw.print(this.mBounds.toShortString());
        pw.print(" mVertical=");
        pw.print(this.mVertical);
        pw.print(" layoutNeeded=");
        pw.println(this.layoutNeeded);
        if (this.mFirst != null) {
            pw.print(prefix);
            pw.print("mFirst=");
            pw.println(System.identityHashCode(this.mFirst));
            this.mFirst.dump(prefix + "  ", pw);
            pw.print(prefix);
            pw.print("mSecond=");
            pw.println(System.identityHashCode(this.mSecond));
            this.mSecond.dump(prefix + "  ", pw);
        } else {
            pw.print(prefix);
            pw.print("mStack=");
            pw.println(this.mStack);
            this.mStack.dump(prefix + "  ", pw);
        }
    }

    public String toString() {
        if (this.mStack != null) {
            return "Box{" + this.hashCode() + " stack=" + this.mStack.mStackId + "}";
        }
        return "Box{" + this.hashCode() + " parent=" + System.identityHashCode(this.mParent) + " first=" + System.identityHashCode(this.mFirst) + " second=" + System.identityHashCode(this.mSecond) + "}";
    }
}

