/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.util.EventLog;
import android.util.TypedValue;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.StackBox;
import com.android.server.wm.Task;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import java.io.PrintWriter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskStack {
    private static final int DEFAULT_DIM_DURATION = 200;
    final int mStackId;
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final ArrayList<Task> mTasks = new ArrayList();
    StackBox mStackBox;
    final DimLayer mDimLayer;
    WindowStateAnimator mDimWinAnimator;
    final DimLayer mAnimationBackgroundSurface;
    WindowStateAnimator mAnimationBackgroundAnimator;
    boolean mDimmingTag;

    TaskStack(WindowManagerService service, int stackId, DisplayContent displayContent) {
        this.mService = service;
        this.mStackId = stackId;
        this.mDisplayContent = displayContent;
        this.mDimLayer = new DimLayer(service, this);
        this.mAnimationBackgroundSurface = new DimLayer(service, this);
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    ArrayList<Task> getTasks() {
        return this.mTasks;
    }

    boolean isHomeStack() {
        return this.mStackId == 0;
    }

    boolean hasSibling() {
        return this.mStackBox.mParent != null;
    }

    boolean addTask(Task task, boolean toTop) {
        int stackNdx;
        this.mStackBox.makeDirty();
        if (!toTop) {
            stackNdx = 0;
        } else {
            stackNdx = this.mTasks.size();
            int currentUserId = this.mService.mCurrentUserId;
            if (task.mUserId != currentUserId) {
                while (--stackNdx >= 0 && currentUserId == this.mTasks.get((int)stackNdx).mUserId) {
                }
                ++stackNdx;
            }
        }
        this.mTasks.add(stackNdx, task);
        task.mStack = this;
        this.mDisplayContent.addTask(task, toTop);
        return this.mDisplayContent.moveHomeStackBox(this.mStackId == 0);
    }

    boolean moveTaskToTop(Task task) {
        this.mTasks.remove(task);
        return this.addTask(task, true);
    }

    boolean moveTaskToBottom(Task task) {
        this.mTasks.remove(task);
        return this.addTask(task, false);
    }

    void removeTask(Task task) {
        this.mStackBox.makeDirty();
        this.mTasks.remove(task);
        this.mDisplayContent.removeTask(task);
    }

    int remove() {
        this.mAnimationBackgroundSurface.destroySurface();
        this.mDimLayer.destroySurface();
        EventLog.writeEvent(31006, this.mStackId);
        return this.mStackBox.remove();
    }

    void resetAnimationBackgroundAnimator() {
        this.mAnimationBackgroundAnimator = null;
        this.mAnimationBackgroundSurface.hide();
    }

    private long getDimBehindFadeDuration(long duration) {
        TypedValue tv = new TypedValue();
        this.mService.mContext.getResources().getValue(0x1120000, tv, true);
        if (tv.type == 6) {
            duration = (long)tv.getFraction(duration, duration);
        } else if (tv.type >= 16 && tv.type <= 31) {
            duration = tv.data;
        }
        return duration;
    }

    boolean animateDimLayers() {
        float dimAmount;
        int dimLayer;
        if (this.mDimWinAnimator == null) {
            dimLayer = this.mDimLayer.getLayer();
            dimAmount = 0.0f;
        } else {
            dimLayer = this.mDimWinAnimator.mAnimLayer - 1;
            dimAmount = this.mDimWinAnimator.mWin.mAttrs.dimAmount;
        }
        float targetAlpha = this.mDimLayer.getTargetAlpha();
        if (targetAlpha != dimAmount) {
            if (this.mDimWinAnimator == null) {
                this.mDimLayer.hide(200L);
            } else {
                long duration;
                long l = duration = this.mDimWinAnimator.mAnimating && this.mDimWinAnimator.mAnimation != null ? this.mDimWinAnimator.mAnimation.computeDurationHint() : 200L;
                if (targetAlpha > dimAmount) {
                    duration = this.getDimBehindFadeDuration(duration);
                }
                this.mDimLayer.show(dimLayer, dimAmount, duration);
            }
        } else if (this.mDimLayer.getLayer() != dimLayer) {
            this.mDimLayer.setLayer(dimLayer);
        }
        if (this.mDimLayer.isAnimating()) {
            if (!this.mService.okToDisplay()) {
                this.mDimLayer.show();
            } else {
                return this.mDimLayer.stepAnimation();
            }
        }
        return false;
    }

    void resetDimmingTag() {
        this.mDimmingTag = false;
    }

    void setDimmingTag() {
        this.mDimmingTag = true;
    }

    boolean testDimmingTag() {
        return this.mDimmingTag;
    }

    boolean isDimming() {
        return this.mDimLayer.isDimming();
    }

    boolean isDimming(WindowStateAnimator winAnimator) {
        return this.mDimWinAnimator == winAnimator && this.mDimLayer.isDimming();
    }

    void startDimmingIfNeeded(WindowStateAnimator newWinAnimator) {
        WindowStateAnimator existingDimWinAnimator = this.mDimWinAnimator;
        if (newWinAnimator.mSurfaceShown && (existingDimWinAnimator == null || !existingDimWinAnimator.mSurfaceShown || existingDimWinAnimator.mAnimLayer < newWinAnimator.mAnimLayer)) {
            this.mDimWinAnimator = newWinAnimator;
        }
    }

    void stopDimmingIfNeeded() {
        if (!this.mDimmingTag && this.isDimming()) {
            this.mDimWinAnimator = null;
        }
    }

    void setAnimationBackground(WindowStateAnimator winAnimator, int color2) {
        int animLayer = winAnimator.mAnimLayer;
        if (this.mAnimationBackgroundAnimator == null || animLayer < this.mAnimationBackgroundAnimator.mAnimLayer) {
            this.mAnimationBackgroundAnimator = winAnimator;
            animLayer = this.mService.adjustAnimationBackground(winAnimator);
            this.mAnimationBackgroundSurface.show(animLayer - 1, (float)(color2 >> 24 & 0xFF) / 255.0f, 0L);
        }
    }

    void setBounds(Rect bounds, boolean underStatusBar) {
        this.mDimLayer.setBounds(bounds);
        this.mAnimationBackgroundSurface.setBounds(bounds);
        ArrayList<WindowState> resizingWindows = this.mService.mResizingWindows;
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList activities = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                WindowList windows = ((AppWindowToken)activities.get((int)activityNdx)).allAppWindows;
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (!resizingWindows.contains(win)) {
                        resizingWindows.add(win);
                    }
                    win.mUnderStatusBar = underStatusBar;
                }
            }
        }
    }

    void switchUser(int userId) {
        int top = this.mTasks.size();
        for (int taskNdx = 0; taskNdx < top; ++taskNdx) {
            Task task = this.mTasks.get(taskNdx);
            if (task.mUserId != userId) continue;
            this.mTasks.remove(taskNdx);
            this.mTasks.add(task);
            --top;
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mStackId=");
        pw.println(this.mStackId);
        for (int taskNdx = 0; taskNdx < this.mTasks.size(); ++taskNdx) {
            pw.print(prefix);
            pw.println(this.mTasks.get(taskNdx));
        }
        if (this.mAnimationBackgroundSurface.isDimming()) {
            pw.print(prefix);
            pw.println("mWindowAnimationBackgroundSurface:");
            this.mAnimationBackgroundSurface.printTo(prefix + "  ", pw);
        }
        if (this.mDimLayer.isDimming()) {
            pw.print(prefix);
            pw.println("mDimLayer:");
            this.mDimLayer.printTo(prefix, pw);
            pw.print(prefix);
            pw.print("mDimWinAnimator=");
            pw.println(this.mDimWinAnimator);
        }
    }

    public String toString() {
        return "{stackId=" + this.mStackId + " tasks=" + this.mTasks + "}";
    }
}

