/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import android.os.Environment;
import android.os.SystemClock;
import android.util.Log;
import android.util.Xml;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.GridLayout;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.TableLayout;
import com.android.uiautomator.core.AccessibilityNodeInfoHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import org.xmlpull.v1.XmlSerializer;

public class AccessibilityNodeInfoDumper {
    private static final String LOGTAG = AccessibilityNodeInfoDumper.class.getSimpleName();
    private static final String[] NAF_EXCLUDED_CLASSES = new String[]{GridView.class.getName(), GridLayout.class.getName(), ListView.class.getName(), TableLayout.class.getName()};

    public static void dumpWindowToFile(AccessibilityNodeInfo root, int rotation, int width, int height) {
        File baseDir = new File(Environment.getDataDirectory(), "local");
        if (!baseDir.exists()) {
            baseDir.mkdir();
            baseDir.setExecutable(true, false);
            baseDir.setWritable(true, false);
            baseDir.setReadable(true, false);
        }
        AccessibilityNodeInfoDumper.dumpWindowToFile(root, new File(new File(Environment.getDataDirectory(), "local"), "window_dump.xml"), rotation, width, height);
    }

    public static void dumpWindowToFile(AccessibilityNodeInfo root, File dumpFile, int rotation, int width, int height) {
        if (root == null) {
            return;
        }
        long startTime = SystemClock.uptimeMillis();
        try {
            FileWriter writer = new FileWriter(dumpFile);
            XmlSerializer serializer = Xml.newSerializer();
            StringWriter stringWriter = new StringWriter();
            serializer.setOutput(stringWriter);
            serializer.startDocument("UTF-8", true);
            serializer.startTag("", "hierarchy");
            serializer.attribute("", "rotation", Integer.toString(rotation));
            AccessibilityNodeInfoDumper.dumpNodeRec(root, serializer, 0, width, height);
            serializer.endTag("", "hierarchy");
            serializer.endDocument();
            writer.write(stringWriter.toString());
            writer.close();
        }
        catch (IOException e) {
            Log.e(LOGTAG, "failed to dump window to file", e);
        }
        long endTime = SystemClock.uptimeMillis();
        Log.w(LOGTAG, "Fetch time: " + (endTime - startTime) + "ms");
    }

    private static void dumpNodeRec(AccessibilityNodeInfo node, XmlSerializer serializer, int index, int width, int height) throws IOException {
        serializer.startTag("", "node");
        if (!AccessibilityNodeInfoDumper.nafExcludedClass(node) && !AccessibilityNodeInfoDumper.nafCheck(node)) {
            serializer.attribute("", "NAF", Boolean.toString(true));
        }
        serializer.attribute("", "index", Integer.toString(index));
        serializer.attribute("", "text", AccessibilityNodeInfoDumper.safeCharSeqToString(node.getText()));
        serializer.attribute("", "resource-id", AccessibilityNodeInfoDumper.safeCharSeqToString(node.getViewIdResourceName()));
        serializer.attribute("", "class", AccessibilityNodeInfoDumper.safeCharSeqToString(node.getClassName()));
        serializer.attribute("", "package", AccessibilityNodeInfoDumper.safeCharSeqToString(node.getPackageName()));
        serializer.attribute("", "content-desc", AccessibilityNodeInfoDumper.safeCharSeqToString(node.getContentDescription()));
        serializer.attribute("", "checkable", Boolean.toString(node.isCheckable()));
        serializer.attribute("", "checked", Boolean.toString(node.isChecked()));
        serializer.attribute("", "clickable", Boolean.toString(node.isClickable()));
        serializer.attribute("", "enabled", Boolean.toString(node.isEnabled()));
        serializer.attribute("", "focusable", Boolean.toString(node.isFocusable()));
        serializer.attribute("", "focused", Boolean.toString(node.isFocused()));
        serializer.attribute("", "scrollable", Boolean.toString(node.isScrollable()));
        serializer.attribute("", "long-clickable", Boolean.toString(node.isLongClickable()));
        serializer.attribute("", "password", Boolean.toString(node.isPassword()));
        serializer.attribute("", "selected", Boolean.toString(node.isSelected()));
        serializer.attribute("", "bounds", AccessibilityNodeInfoHelper.getVisibleBoundsInScreen(node, width, height).toShortString());
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            AccessibilityNodeInfo child = node.getChild(i);
            if (child != null) {
                if (child.isVisibleToUser()) {
                    AccessibilityNodeInfoDumper.dumpNodeRec(child, serializer, i, width, height);
                    child.recycle();
                    continue;
                }
                Log.i(LOGTAG, String.format("Skipping invisible child: %s", child.toString()));
                continue;
            }
            Log.i(LOGTAG, String.format("Null child %d/%d, parent: %s", i, count, node.toString()));
        }
        serializer.endTag("", "node");
    }

    private static boolean nafExcludedClass(AccessibilityNodeInfo node) {
        String className = AccessibilityNodeInfoDumper.safeCharSeqToString(node.getClassName());
        for (String excludedClassName : NAF_EXCLUDED_CLASSES) {
            if (!className.endsWith(excludedClassName)) continue;
            return true;
        }
        return false;
    }

    private static boolean nafCheck(AccessibilityNodeInfo node) {
        boolean isNaf;
        boolean bl = isNaf = node.isClickable() && node.isEnabled() && AccessibilityNodeInfoDumper.safeCharSeqToString(node.getContentDescription()).isEmpty() && AccessibilityNodeInfoDumper.safeCharSeqToString(node.getText()).isEmpty();
        if (!isNaf) {
            return true;
        }
        return AccessibilityNodeInfoDumper.childNafCheck(node);
    }

    private static boolean childNafCheck(AccessibilityNodeInfo node) {
        int childCount = node.getChildCount();
        for (int x = 0; x < childCount; ++x) {
            AccessibilityNodeInfo childNode = node.getChild(x);
            if (!AccessibilityNodeInfoDumper.safeCharSeqToString(childNode.getContentDescription()).isEmpty() || !AccessibilityNodeInfoDumper.safeCharSeqToString(childNode.getText()).isEmpty()) {
                return true;
            }
            if (!AccessibilityNodeInfoDumper.childNafCheck(childNode)) continue;
            return true;
        }
        return false;
    }

    private static String safeCharSeqToString(CharSequence cs) {
        if (cs == null) {
            return "";
        }
        return AccessibilityNodeInfoDumper.stripInvalidXMLChars(cs);
    }

    private static String stripInvalidXMLChars(CharSequence cs) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < cs.length(); ++i) {
            char ch = cs.charAt(i);
            if (ch >= '\u0001' && ch <= '\b' || ch >= '\u000b' && ch <= '\f' || ch >= '\u000e' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u0084' || ch >= '\u0086' && ch <= '\u009f' || ch >= '\ufdd0' && ch <= '\ufddf' || ch >= '\u1fffe' && ch <= '\u1ffff' || ch >= '\u2fffe' && ch <= '\u2ffff' || ch >= '\u3fffe' && ch <= '\u3ffff' || ch >= '\u4fffe' && ch <= '\u4ffff' || ch >= '\u5fffe' && ch <= '\u5ffff' || ch >= '\u6fffe' && ch <= '\u6ffff' || ch >= '\u7fffe' && ch <= '\u7ffff' || ch >= '\u8fffe' && ch <= '\u8ffff' || ch >= '\u9fffe' && ch <= '\u9ffff' || ch >= '\uafffe' && ch <= '\uaffff' || ch >= '\ubfffe' && ch <= '\ubffff' || ch >= '\ucfffe' && ch <= '\ucffff' || ch >= '\udfffe' && ch <= '\udffff' || ch >= '\uefffe' && ch <= '\ueffff' || ch >= '\uffffe' && ch <= '\ufffff' || ch >= '\u10fffe' && ch <= '\u10ffff') {
                ret.append(".");
                continue;
            }
            ret.append(ch);
        }
        return ret.toString();
    }
}

