/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import com.android.uiautomator.core.Tracer;
import com.android.uiautomator.core.UiObject;
import com.android.uiautomator.core.UiObjectNotFoundException;
import com.android.uiautomator.core.UiSelector;

public class UiCollection
extends UiObject {
    public UiCollection(UiSelector selector) {
        super(selector);
    }

    public UiObject getChildByDescription(UiSelector childPattern, String text) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, text);
        if (text != null) {
            int count = this.getChildCount(childPattern);
            for (int x = 0; x < count; ++x) {
                UiObject row = this.getChildByInstance(childPattern, x);
                String nodeDesc = row.getContentDescription();
                if (nodeDesc != null && nodeDesc.contains(text)) {
                    return row;
                }
                UiObject item = row.getChild(new UiSelector().descriptionContains(text));
                if (!item.exists()) continue;
                return row;
            }
        }
        throw new UiObjectNotFoundException("for description= \"" + text + "\"");
    }

    public UiObject getChildByInstance(UiSelector childPattern, int instance) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, instance);
        UiSelector patternSelector = UiSelector.patternBuilder(this.getSelector(), UiSelector.patternBuilder(childPattern).instance(instance));
        return new UiObject(patternSelector);
    }

    public UiObject getChildByText(UiSelector childPattern, String text) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, text);
        if (text != null) {
            int count = this.getChildCount(childPattern);
            for (int x = 0; x < count; ++x) {
                UiObject row = this.getChildByInstance(childPattern, x);
                String nodeText = row.getText();
                if (text.equals(nodeText)) {
                    return row;
                }
                UiObject item = row.getChild(new UiSelector().text(text));
                if (!item.exists()) continue;
                return row;
            }
        }
        throw new UiObjectNotFoundException("for text= \"" + text + "\"");
    }

    public int getChildCount(UiSelector childPattern) {
        Tracer.trace(childPattern);
        UiSelector patternSelector = UiSelector.patternBuilder(this.getSelector(), UiSelector.patternBuilder(childPattern));
        return this.getQueryController().getPatternCount(patternSelector);
    }
}

