/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import android.graphics.Rect;
import android.util.Log;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.uiautomator.core.Tracer;
import com.android.uiautomator.core.UiCollection;
import com.android.uiautomator.core.UiObject;
import com.android.uiautomator.core.UiObjectNotFoundException;
import com.android.uiautomator.core.UiSelector;

public class UiScrollable
extends UiCollection {
    private static final String LOG_TAG = UiScrollable.class.getSimpleName();
    private static final int SCROLL_STEPS = 55;
    private static final int FLING_STEPS = 5;
    private static final double DEFAULT_SWIPE_DEADZONE_PCT = 0.1;
    private static int mMaxSearchSwipes = 30;
    private boolean mIsVerticalList = true;
    private double mSwipeDeadZonePercentage = 0.1;

    public UiScrollable(UiSelector container) {
        super(container);
    }

    public UiScrollable setAsVerticalList() {
        Tracer.trace(new Object[0]);
        this.mIsVerticalList = true;
        return this;
    }

    public UiScrollable setAsHorizontalList() {
        Tracer.trace(new Object[0]);
        this.mIsVerticalList = false;
        return this;
    }

    protected boolean exists(UiSelector selector) {
        return this.getQueryController().findAccessibilityNodeInfo(selector) != null;
    }

    public UiObject getChildByDescription(UiSelector childPattern, String text) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, text);
        return this.getChildByDescription(childPattern, text, true);
    }

    public UiObject getChildByDescription(UiSelector childPattern, String text, boolean allowScrollSearch) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, text, allowScrollSearch);
        if (text != null) {
            if (allowScrollSearch) {
                this.scrollIntoView(new UiSelector().descriptionContains(text));
            }
            return super.getChildByDescription(childPattern, text);
        }
        throw new UiObjectNotFoundException("for description= \"" + text + "\"");
    }

    public UiObject getChildByInstance(UiSelector childPattern, int instance) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, instance);
        UiSelector patternSelector = UiSelector.patternBuilder(this.getSelector(), UiSelector.patternBuilder(childPattern).instance(instance));
        return new UiObject(patternSelector);
    }

    public UiObject getChildByText(UiSelector childPattern, String text) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, text);
        return this.getChildByText(childPattern, text, true);
    }

    public UiObject getChildByText(UiSelector childPattern, String text, boolean allowScrollSearch) throws UiObjectNotFoundException {
        Tracer.trace(childPattern, text, allowScrollSearch);
        if (text != null) {
            if (allowScrollSearch) {
                this.scrollIntoView(new UiSelector().text(text));
            }
            return super.getChildByText(childPattern, text);
        }
        throw new UiObjectNotFoundException("for text= \"" + text + "\"");
    }

    public boolean scrollDescriptionIntoView(String text) throws UiObjectNotFoundException {
        Tracer.trace(text);
        return this.scrollIntoView(new UiSelector().description(text));
    }

    public boolean scrollIntoView(UiObject obj) throws UiObjectNotFoundException {
        Tracer.trace(obj.getSelector());
        return this.scrollIntoView(obj.getSelector());
    }

    public boolean scrollIntoView(UiSelector selector) throws UiObjectNotFoundException {
        Tracer.trace(selector);
        UiSelector childSelector = this.getSelector().childSelector(selector);
        if (this.exists(childSelector)) {
            return true;
        }
        this.scrollToBeginning(mMaxSearchSwipes);
        if (this.exists(childSelector)) {
            return true;
        }
        for (int x = 0; x < mMaxSearchSwipes; ++x) {
            boolean scrolled = this.scrollForward();
            if (this.exists(childSelector)) {
                return true;
            }
            if (scrolled) continue;
            return false;
        }
        return false;
    }

    public boolean ensureFullyVisible(UiObject childObject) throws UiObjectNotFoundException {
        Rect actual = childObject.getBounds();
        Rect visible = childObject.getVisibleBounds();
        if (visible.width() * visible.height() == actual.width() * actual.height()) {
            return true;
        }
        boolean shouldSwipeForward = false;
        if (this.mIsVerticalList) {
            shouldSwipeForward = actual.top == visible.top;
        } else {
            boolean bl = shouldSwipeForward = actual.left == visible.left;
        }
        if (this.mIsVerticalList) {
            if (shouldSwipeForward) {
                return this.swipeUp(10);
            }
            return this.swipeDown(10);
        }
        if (shouldSwipeForward) {
            return this.swipeLeft(10);
        }
        return this.swipeRight(10);
    }

    public boolean scrollTextIntoView(String text) throws UiObjectNotFoundException {
        Tracer.trace(text);
        return this.scrollIntoView(new UiSelector().text(text));
    }

    public UiScrollable setMaxSearchSwipes(int swipes) {
        Tracer.trace(swipes);
        mMaxSearchSwipes = swipes;
        return this;
    }

    public int getMaxSearchSwipes() {
        Tracer.trace(new Object[0]);
        return mMaxSearchSwipes;
    }

    public boolean flingForward() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        return this.scrollForward(5);
    }

    public boolean scrollForward() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        return this.scrollForward(55);
    }

    public boolean scrollForward(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Log.d(LOG_TAG, "scrollForward() on selector = " + this.getSelector());
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(10000L);
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = new Rect();
        node.getBoundsInScreen(rect);
        int downX = 0;
        int downY = 0;
        int upX = 0;
        int upY = 0;
        if (this.mIsVerticalList) {
            int swipeAreaAdjust = (int)((double)rect.height() * this.getSwipeDeadZonePercentage());
            downX = rect.centerX();
            downY = rect.bottom - swipeAreaAdjust;
            upX = rect.centerX();
            upY = rect.top + swipeAreaAdjust;
        } else {
            int swipeAreaAdjust = (int)((double)rect.width() * this.getSwipeDeadZonePercentage());
            downX = rect.right - swipeAreaAdjust;
            downY = rect.centerY();
            upX = rect.left + swipeAreaAdjust;
            upY = rect.centerY();
        }
        return this.getInteractionController().scrollSwipe(downX, downY, upX, upY, steps);
    }

    public boolean flingBackward() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        return this.scrollBackward(5);
    }

    public boolean scrollBackward() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        return this.scrollBackward(55);
    }

    public boolean scrollBackward(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Log.d(LOG_TAG, "scrollBackward() on selector = " + this.getSelector());
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(10000L);
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = new Rect();
        node.getBoundsInScreen(rect);
        int downX = 0;
        int downY = 0;
        int upX = 0;
        int upY = 0;
        if (this.mIsVerticalList) {
            int swipeAreaAdjust = (int)((double)rect.height() * this.getSwipeDeadZonePercentage());
            Log.d(LOG_TAG, "scrollToBegining() using vertical scroll");
            downX = rect.centerX();
            downY = rect.top + swipeAreaAdjust;
            upX = rect.centerX();
            upY = rect.bottom - swipeAreaAdjust;
        } else {
            int swipeAreaAdjust = (int)((double)rect.width() * this.getSwipeDeadZonePercentage());
            Log.d(LOG_TAG, "scrollToBegining() using hotizontal scroll");
            downX = rect.left + swipeAreaAdjust;
            downY = rect.centerY();
            upX = rect.right - swipeAreaAdjust;
            upY = rect.centerY();
        }
        return this.getInteractionController().scrollSwipe(downX, downY, upX, upY, steps);
    }

    public boolean scrollToBeginning(int maxSwipes, int steps) throws UiObjectNotFoundException {
        Tracer.trace(maxSwipes, steps);
        Log.d(LOG_TAG, "scrollToBeginning() on selector = " + this.getSelector());
        for (int x = 0; x < maxSwipes && this.scrollBackward(steps); ++x) {
        }
        return true;
    }

    public boolean scrollToBeginning(int maxSwipes) throws UiObjectNotFoundException {
        Tracer.trace(maxSwipes);
        return this.scrollToBeginning(maxSwipes, 55);
    }

    public boolean flingToBeginning(int maxSwipes) throws UiObjectNotFoundException {
        Tracer.trace(maxSwipes);
        return this.scrollToBeginning(maxSwipes, 5);
    }

    public boolean scrollToEnd(int maxSwipes, int steps) throws UiObjectNotFoundException {
        Tracer.trace(maxSwipes, steps);
        for (int x = 0; x < maxSwipes && this.scrollForward(steps); ++x) {
        }
        return true;
    }

    public boolean scrollToEnd(int maxSwipes) throws UiObjectNotFoundException {
        Tracer.trace(maxSwipes);
        return this.scrollToEnd(maxSwipes, 55);
    }

    public boolean flingToEnd(int maxSwipes) throws UiObjectNotFoundException {
        Tracer.trace(maxSwipes);
        return this.scrollToEnd(maxSwipes, 5);
    }

    public double getSwipeDeadZonePercentage() {
        Tracer.trace(new Object[0]);
        return this.mSwipeDeadZonePercentage;
    }

    public UiScrollable setSwipeDeadZonePercentage(double swipeDeadZonePercentage) {
        Tracer.trace(swipeDeadZonePercentage);
        this.mSwipeDeadZonePercentage = swipeDeadZonePercentage;
        return this;
    }
}

