/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import android.util.SparseArray;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiSelector {
    static final int SELECTOR_NIL = 0;
    static final int SELECTOR_TEXT = 1;
    static final int SELECTOR_START_TEXT = 2;
    static final int SELECTOR_CONTAINS_TEXT = 3;
    static final int SELECTOR_CLASS = 4;
    static final int SELECTOR_DESCRIPTION = 5;
    static final int SELECTOR_START_DESCRIPTION = 6;
    static final int SELECTOR_CONTAINS_DESCRIPTION = 7;
    static final int SELECTOR_INDEX = 8;
    static final int SELECTOR_INSTANCE = 9;
    static final int SELECTOR_ENABLED = 10;
    static final int SELECTOR_FOCUSED = 11;
    static final int SELECTOR_FOCUSABLE = 12;
    static final int SELECTOR_SCROLLABLE = 13;
    static final int SELECTOR_CLICKABLE = 14;
    static final int SELECTOR_CHECKED = 15;
    static final int SELECTOR_SELECTED = 16;
    static final int SELECTOR_ID = 17;
    static final int SELECTOR_PACKAGE_NAME = 18;
    static final int SELECTOR_CHILD = 19;
    static final int SELECTOR_CONTAINER = 20;
    static final int SELECTOR_PATTERN = 21;
    static final int SELECTOR_PARENT = 22;
    static final int SELECTOR_COUNT = 23;
    static final int SELECTOR_LONG_CLICKABLE = 24;
    static final int SELECTOR_TEXT_REGEX = 25;
    static final int SELECTOR_CLASS_REGEX = 26;
    static final int SELECTOR_DESCRIPTION_REGEX = 27;
    static final int SELECTOR_PACKAGE_NAME_REGEX = 28;
    static final int SELECTOR_RESOURCE_ID = 29;
    static final int SELECTOR_CHECKABLE = 30;
    static final int SELECTOR_RESOURCE_ID_REGEX = 31;
    private SparseArray<Object> mSelectorAttributes = new SparseArray();

    public UiSelector() {
    }

    UiSelector(UiSelector selector) {
        this.mSelectorAttributes = selector.cloneSelector().mSelectorAttributes;
    }

    protected UiSelector cloneSelector() {
        UiSelector ret = new UiSelector();
        ret.mSelectorAttributes = this.mSelectorAttributes.clone();
        if (this.hasChildSelector()) {
            ret.mSelectorAttributes.put(19, new UiSelector(this.getChildSelector()));
        }
        if (this.hasParentSelector()) {
            ret.mSelectorAttributes.put(22, new UiSelector(this.getParentSelector()));
        }
        if (this.hasPatternSelector()) {
            ret.mSelectorAttributes.put(21, new UiSelector(this.getPatternSelector()));
        }
        return ret;
    }

    static UiSelector patternBuilder(UiSelector selector) {
        if (!selector.hasPatternSelector()) {
            return new UiSelector().patternSelector(selector);
        }
        return selector;
    }

    static UiSelector patternBuilder(UiSelector container, UiSelector pattern) {
        return new UiSelector(new UiSelector().containerSelector(container).patternSelector(pattern));
    }

    public UiSelector text(String text) {
        return this.buildSelector(1, text);
    }

    public UiSelector textMatches(String regex) {
        return this.buildSelector(25, Pattern.compile(regex));
    }

    public UiSelector textStartsWith(String text) {
        return this.buildSelector(2, text);
    }

    public UiSelector textContains(String text) {
        return this.buildSelector(3, text);
    }

    public UiSelector className(String className) {
        return this.buildSelector(4, className);
    }

    public UiSelector classNameMatches(String regex) {
        return this.buildSelector(26, Pattern.compile(regex));
    }

    public <T> UiSelector className(Class<T> type) {
        return this.buildSelector(4, type.getName());
    }

    public UiSelector description(String desc) {
        return this.buildSelector(5, desc);
    }

    public UiSelector descriptionMatches(String regex) {
        return this.buildSelector(27, Pattern.compile(regex));
    }

    public UiSelector descriptionStartsWith(String desc) {
        return this.buildSelector(6, desc);
    }

    public UiSelector descriptionContains(String desc) {
        return this.buildSelector(7, desc);
    }

    public UiSelector resourceId(String id2) {
        return this.buildSelector(29, id2);
    }

    public UiSelector resourceIdMatches(String regex) {
        return this.buildSelector(31, Pattern.compile(regex));
    }

    public UiSelector index(int index) {
        return this.buildSelector(8, index);
    }

    public UiSelector instance(int instance) {
        return this.buildSelector(9, instance);
    }

    public UiSelector enabled(boolean val) {
        return this.buildSelector(10, val);
    }

    public UiSelector focused(boolean val) {
        return this.buildSelector(11, val);
    }

    public UiSelector focusable(boolean val) {
        return this.buildSelector(12, val);
    }

    public UiSelector scrollable(boolean val) {
        return this.buildSelector(13, val);
    }

    public UiSelector selected(boolean val) {
        return this.buildSelector(16, val);
    }

    public UiSelector checked(boolean val) {
        return this.buildSelector(15, val);
    }

    public UiSelector clickable(boolean val) {
        return this.buildSelector(14, val);
    }

    public UiSelector checkable(boolean val) {
        return this.buildSelector(30, val);
    }

    public UiSelector longClickable(boolean val) {
        return this.buildSelector(24, val);
    }

    public UiSelector childSelector(UiSelector selector) {
        return this.buildSelector(19, selector);
    }

    private UiSelector patternSelector(UiSelector selector) {
        return this.buildSelector(21, selector);
    }

    private UiSelector containerSelector(UiSelector selector) {
        return this.buildSelector(20, selector);
    }

    public UiSelector fromParent(UiSelector selector) {
        return this.buildSelector(22, selector);
    }

    public UiSelector packageName(String name) {
        return this.buildSelector(18, name);
    }

    public UiSelector packageNameMatches(String regex) {
        return this.buildSelector(28, Pattern.compile(regex));
    }

    private UiSelector buildSelector(int selectorId, Object selectorValue) {
        UiSelector selector = new UiSelector(this);
        if (selectorId == 19 || selectorId == 22) {
            selector.getLastSubSelector().mSelectorAttributes.put(selectorId, selectorValue);
        } else {
            selector.mSelectorAttributes.put(selectorId, selectorValue);
        }
        return selector;
    }

    UiSelector getChildSelector() {
        UiSelector selector = this.mSelectorAttributes.get(19, null);
        if (selector != null) {
            return new UiSelector(selector);
        }
        return null;
    }

    UiSelector getPatternSelector() {
        UiSelector selector = this.mSelectorAttributes.get(21, null);
        if (selector != null) {
            return new UiSelector(selector);
        }
        return null;
    }

    UiSelector getContainerSelector() {
        UiSelector selector = this.mSelectorAttributes.get(20, null);
        if (selector != null) {
            return new UiSelector(selector);
        }
        return null;
    }

    UiSelector getParentSelector() {
        UiSelector selector = this.mSelectorAttributes.get(22, null);
        if (selector != null) {
            return new UiSelector(selector);
        }
        return null;
    }

    int getInstance() {
        return this.getInt(9);
    }

    String getString(int criterion) {
        return this.mSelectorAttributes.get(criterion, null);
    }

    boolean getBoolean(int criterion) {
        return (Boolean)this.mSelectorAttributes.get(criterion, false);
    }

    int getInt(int criterion) {
        return (Integer)this.mSelectorAttributes.get(criterion, 0);
    }

    Pattern getPattern(int criterion) {
        return this.mSelectorAttributes.get(criterion, null);
    }

    boolean isMatchFor(AccessibilityNodeInfo node, int index) {
        int size = this.mSelectorAttributes.size();
        block27: for (int x = 0; x < size; ++x) {
            CharSequence s = null;
            int criterion = this.mSelectorAttributes.keyAt(x);
            switch (criterion) {
                case 8: {
                    if (index == this.getInt(criterion)) continue block27;
                    return false;
                }
                case 15: {
                    if (node.isChecked() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 4: {
                    s = node.getClassName();
                    if (s != null && ((Object)s).toString().contentEquals(this.getString(criterion))) continue block27;
                    return false;
                }
                case 26: {
                    s = node.getClassName();
                    if (s != null && this.getPattern(criterion).matcher(s).matches()) continue block27;
                    return false;
                }
                case 14: {
                    if (node.isClickable() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 30: {
                    if (node.isCheckable() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 24: {
                    if (node.isLongClickable() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 7: {
                    s = node.getContentDescription();
                    if (s != null && ((Object)s).toString().toLowerCase().contains(this.getString(criterion).toLowerCase())) continue block27;
                    return false;
                }
                case 6: {
                    s = node.getContentDescription();
                    if (s != null && ((Object)s).toString().toLowerCase().startsWith(this.getString(criterion).toLowerCase())) continue block27;
                    return false;
                }
                case 5: {
                    s = node.getContentDescription();
                    if (s != null && ((Object)s).toString().contentEquals(this.getString(criterion))) continue block27;
                    return false;
                }
                case 27: {
                    s = node.getContentDescription();
                    if (s != null && this.getPattern(criterion).matcher(s).matches()) continue block27;
                    return false;
                }
                case 3: {
                    s = node.getText();
                    if (s != null && ((Object)s).toString().toLowerCase().contains(this.getString(criterion).toLowerCase())) continue block27;
                    return false;
                }
                case 2: {
                    s = node.getText();
                    if (s != null && ((Object)s).toString().toLowerCase().startsWith(this.getString(criterion).toLowerCase())) continue block27;
                    return false;
                }
                case 1: {
                    s = node.getText();
                    if (s != null && ((Object)s).toString().contentEquals(this.getString(criterion))) continue block27;
                    return false;
                }
                case 25: {
                    s = node.getText();
                    if (s != null && this.getPattern(criterion).matcher(s).matches()) continue block27;
                    return false;
                }
                case 10: {
                    if (node.isEnabled() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 12: {
                    if (node.isFocusable() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 11: {
                    if (node.isFocused() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 17: {
                    continue block27;
                }
                case 18: {
                    s = node.getPackageName();
                    if (s != null && ((Object)s).toString().contentEquals(this.getString(criterion))) continue block27;
                    return false;
                }
                case 28: {
                    s = node.getPackageName();
                    if (s != null && this.getPattern(criterion).matcher(s).matches()) continue block27;
                    return false;
                }
                case 13: {
                    if (node.isScrollable() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 16: {
                    if (node.isSelected() == this.getBoolean(criterion)) continue block27;
                    return false;
                }
                case 29: {
                    s = node.getViewIdResourceName();
                    if (s != null && ((Object)s).toString().contentEquals(this.getString(criterion))) continue block27;
                    return false;
                }
                case 31: {
                    s = node.getViewIdResourceName();
                    if (s != null && this.getPattern(criterion).matcher(s).matches()) continue block27;
                    return false;
                }
            }
        }
        return this.matchOrUpdateInstance();
    }

    private boolean matchOrUpdateInstance() {
        int currentSelectorCounter = 0;
        int currentSelectorInstance = 0;
        if (this.mSelectorAttributes.indexOfKey(9) >= 0) {
            currentSelectorInstance = (Integer)this.mSelectorAttributes.get(9);
        }
        if (this.mSelectorAttributes.indexOfKey(23) >= 0) {
            currentSelectorCounter = (Integer)this.mSelectorAttributes.get(23);
        }
        if (currentSelectorInstance == currentSelectorCounter) {
            return true;
        }
        if (currentSelectorInstance > currentSelectorCounter) {
            this.mSelectorAttributes.put(23, ++currentSelectorCounter);
        }
        return false;
    }

    boolean isLeaf() {
        return this.mSelectorAttributes.indexOfKey(19) < 0 && this.mSelectorAttributes.indexOfKey(22) < 0;
    }

    boolean hasChildSelector() {
        return this.mSelectorAttributes.indexOfKey(19) >= 0;
    }

    boolean hasPatternSelector() {
        return this.mSelectorAttributes.indexOfKey(21) >= 0;
    }

    boolean hasContainerSelector() {
        return this.mSelectorAttributes.indexOfKey(20) >= 0;
    }

    boolean hasParentSelector() {
        return this.mSelectorAttributes.indexOfKey(22) >= 0;
    }

    private UiSelector getLastSubSelector() {
        if (this.mSelectorAttributes.indexOfKey(19) >= 0) {
            UiSelector child = (UiSelector)this.mSelectorAttributes.get(19);
            if (child.getLastSubSelector() == null) {
                return child;
            }
            return child.getLastSubSelector();
        }
        if (this.mSelectorAttributes.indexOfKey(22) >= 0) {
            UiSelector parent = (UiSelector)this.mSelectorAttributes.get(22);
            if (parent.getLastSubSelector() == null) {
                return parent;
            }
            return parent.getLastSubSelector();
        }
        return this;
    }

    public String toString() {
        return this.dumpToString(true);
    }

    String dumpToString(boolean all) {
        StringBuilder builder = new StringBuilder();
        builder.append(UiSelector.class.getSimpleName() + "[");
        int criterionCount = this.mSelectorAttributes.size();
        block33: for (int i = 0; i < criterionCount; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            int criterion = this.mSelectorAttributes.keyAt(i);
            switch (criterion) {
                case 1: {
                    builder.append("TEXT=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 25: {
                    builder.append("TEXT_REGEX=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 2: {
                    builder.append("START_TEXT=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 3: {
                    builder.append("CONTAINS_TEXT=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 4: {
                    builder.append("CLASS=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 26: {
                    builder.append("CLASS_REGEX=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 5: {
                    builder.append("DESCRIPTION=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 27: {
                    builder.append("DESCRIPTION_REGEX=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 6: {
                    builder.append("START_DESCRIPTION=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 7: {
                    builder.append("CONTAINS_DESCRIPTION=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 8: {
                    builder.append("INDEX=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 9: {
                    builder.append("INSTANCE=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 10: {
                    builder.append("ENABLED=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 11: {
                    builder.append("FOCUSED=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 12: {
                    builder.append("FOCUSABLE=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 13: {
                    builder.append("SCROLLABLE=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 14: {
                    builder.append("CLICKABLE=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 30: {
                    builder.append("CHECKABLE=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 24: {
                    builder.append("LONG_CLICKABLE=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 15: {
                    builder.append("CHECKED=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 16: {
                    builder.append("SELECTED=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 17: {
                    builder.append("ID=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 19: {
                    if (all) {
                        builder.append("CHILD=").append(this.mSelectorAttributes.valueAt(i));
                        continue block33;
                    }
                    builder.append("CHILD[..]");
                    continue block33;
                }
                case 21: {
                    if (all) {
                        builder.append("PATTERN=").append(this.mSelectorAttributes.valueAt(i));
                        continue block33;
                    }
                    builder.append("PATTERN[..]");
                    continue block33;
                }
                case 20: {
                    if (all) {
                        builder.append("CONTAINER=").append(this.mSelectorAttributes.valueAt(i));
                        continue block33;
                    }
                    builder.append("CONTAINER[..]");
                    continue block33;
                }
                case 22: {
                    if (all) {
                        builder.append("PARENT=").append(this.mSelectorAttributes.valueAt(i));
                        continue block33;
                    }
                    builder.append("PARENT[..]");
                    continue block33;
                }
                case 23: {
                    builder.append("COUNT=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 18: {
                    builder.append("PACKAGE NAME=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 28: {
                    builder.append("PACKAGE_NAME_REGEX=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 29: {
                    builder.append("RESOURCE_ID=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                case 31: {
                    builder.append("RESOURCE_ID_REGEX=").append(this.mSelectorAttributes.valueAt(i));
                    continue block33;
                }
                default: {
                    builder.append("UNDEFINED=" + criterion + " ").append(this.mSelectorAttributes.valueAt(i));
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

