/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.testrunner;

import com.android.uiautomator.testrunner.UiAutomatorTestCase;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseCollector {
    private ClassLoader mClassLoader;
    private List<TestCase> mTestCases;
    private TestCaseFilter mFilter;

    public TestCaseCollector(ClassLoader classLoader, TestCaseFilter filter) {
        this.mClassLoader = classLoader;
        this.mTestCases = new ArrayList<TestCase>();
        this.mFilter = filter;
    }

    public void addTestClasses(List<String> classNames) throws ClassNotFoundException {
        for (String className : classNames) {
            this.addTestClass(className);
        }
    }

    public void addTestClass(String className) throws ClassNotFoundException {
        int hashPos = className.indexOf(35);
        String methodName = null;
        if (hashPos != -1) {
            methodName = className.substring(hashPos + 1);
            className = className.substring(0, hashPos);
        }
        this.addTestClass(className, methodName);
    }

    public void addTestClass(String className, String methodName) throws ClassNotFoundException {
        Class<?> clazz = this.mClassLoader.loadClass(className);
        if (methodName != null) {
            this.addSingleTestMethod(clazz, methodName);
        } else {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (!this.mFilter.accept(method)) continue;
                this.addSingleTestMethod(clazz, method.getName());
            }
        }
    }

    public List<TestCase> getTestCases() {
        return Collections.unmodifiableList(this.mTestCases);
    }

    protected void addSingleTestMethod(Class<?> clazz, String method) {
        if (!this.mFilter.accept(clazz)) {
            throw new RuntimeException("Test class must be derived from UiAutomatorTestCase");
        }
        try {
            TestCase testCase = (TestCase)clazz.newInstance();
            testCase.setName(method);
            this.mTestCases.add(testCase);
        }
        catch (InstantiationException e) {
            this.mTestCases.add(this.error(clazz, "InstantiationException: could not instantiate test class. Class: " + clazz.getName()));
        }
        catch (IllegalAccessException e) {
            this.mTestCases.add(this.error(clazz, "IllegalAccessException: could not instantiate test class. Class: " + clazz.getName()));
        }
    }

    private UiAutomatorTestCase error(Class<?> clazz, final String message) {
        UiAutomatorTestCase warning = new UiAutomatorTestCase(){

            protected void runTest() {
                1.fail(message);
            }
        };
        warning.setName(clazz.getName());
        return warning;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TestCaseFilter {
        public boolean accept(Method var1);

        public boolean accept(Class<?> var1);
    }
}

