/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.testrunner;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.view.IInputMethodManager;
import com.android.uiautomator.core.UiDevice;
import com.android.uiautomator.testrunner.IAutomationSupport;
import java.util.List;
import junit.framework.TestCase;

public class UiAutomatorTestCase
extends TestCase {
    private static final String DISABLE_IME = "disable_ime";
    private static final String DUMMY_IME_PACKAGE = "com.android.testing.dummyime";
    private UiDevice mUiDevice;
    private Bundle mParams;
    private IAutomationSupport mAutomationSupport;
    private boolean mShouldDisableIme = false;

    protected void setUp() throws Exception {
        super.setUp();
        this.mShouldDisableIme = "true".equals(this.mParams.getString(DISABLE_IME));
        if (this.mShouldDisableIme) {
            this.setDummyIme();
        }
    }

    protected void tearDown() throws Exception {
        if (this.mShouldDisableIme) {
            this.restoreActiveIme();
        }
        super.tearDown();
    }

    public UiDevice getUiDevice() {
        return this.mUiDevice;
    }

    public Bundle getParams() {
        return this.mParams;
    }

    public IAutomationSupport getAutomationSupport() {
        return this.mAutomationSupport;
    }

    void setUiDevice(UiDevice uiDevice) {
        this.mUiDevice = uiDevice;
    }

    void setParams(Bundle params) {
        this.mParams = params;
    }

    void setAutomationSupport(IAutomationSupport automationSupport) {
        this.mAutomationSupport = automationSupport;
    }

    public void sleep(long ms) {
        SystemClock.sleep(ms);
    }

    private void setDummyIme() throws RemoteException {
        IInputMethodManager im = IInputMethodManager.Stub.asInterface(ServiceManager.getService("input_method"));
        List<InputMethodInfo> infos = im.getInputMethodList();
        String id2 = null;
        for (InputMethodInfo info : infos) {
            if (!DUMMY_IME_PACKAGE.equals(info.getComponent().getPackageName())) continue;
            id2 = info.getId();
        }
        if (id2 == null) {
            throw new RuntimeException(String.format("Required testing fixture missing: IME package (%s)", DUMMY_IME_PACKAGE));
        }
        im.setInputMethod(null, id2);
    }

    private void restoreActiveIme() throws RemoteException {
    }
}

