/*
 * Decompiled with CFR 0.152.
 */
package com.android.webview.chromium;

import android.util.Log;
import android.webkit.WebSettings;
import org.chromium.android_webview.AwSettings;

public class ContentSettingsAdapter
extends WebSettings {
    private static final String TAG = ContentSettingsAdapter.class.getSimpleName();
    private AwSettings mAwSettings;

    public ContentSettingsAdapter(AwSettings awSettings) {
        this.mAwSettings = awSettings;
    }

    AwSettings getAwSettings() {
        return this.mAwSettings;
    }

    @Deprecated
    public void setNavDump(boolean enabled) {
    }

    @Deprecated
    public boolean getNavDump() {
        return false;
    }

    public void setSupportZoom(boolean support) {
        this.mAwSettings.setSupportZoom(support);
    }

    public boolean supportZoom() {
        return this.mAwSettings.supportZoom();
    }

    public void setBuiltInZoomControls(boolean enabled) {
        this.mAwSettings.setBuiltInZoomControls(enabled);
    }

    public boolean getBuiltInZoomControls() {
        return this.mAwSettings.getBuiltInZoomControls();
    }

    public void setDisplayZoomControls(boolean enabled) {
        this.mAwSettings.setDisplayZoomControls(enabled);
    }

    public boolean getDisplayZoomControls() {
        return this.mAwSettings.getDisplayZoomControls();
    }

    public void setAllowFileAccess(boolean allow) {
        this.mAwSettings.setAllowFileAccess(allow);
    }

    public boolean getAllowFileAccess() {
        return this.mAwSettings.getAllowFileAccess();
    }

    public void setAllowContentAccess(boolean allow) {
        this.mAwSettings.setAllowContentAccess(allow);
    }

    public boolean getAllowContentAccess() {
        return this.mAwSettings.getAllowContentAccess();
    }

    public void setLoadWithOverviewMode(boolean overview) {
        this.mAwSettings.setLoadWithOverviewMode(overview);
    }

    public boolean getLoadWithOverviewMode() {
        return this.mAwSettings.getLoadWithOverviewMode();
    }

    public void setEnableSmoothTransition(boolean enable) {
    }

    public boolean enableSmoothTransition() {
        return false;
    }

    public void setUseWebViewBackgroundForOverscrollBackground(boolean view) {
    }

    public boolean getUseWebViewBackgroundForOverscrollBackground() {
        return false;
    }

    public void setSaveFormData(boolean save) {
        this.mAwSettings.setSaveFormData(save);
    }

    public boolean getSaveFormData() {
        return this.mAwSettings.getSaveFormData();
    }

    public void setSavePassword(boolean save) {
    }

    public boolean getSavePassword() {
        return false;
    }

    public synchronized void setTextZoom(int textZoom) {
        this.mAwSettings.setTextZoom(textZoom);
    }

    public synchronized int getTextZoom() {
        return this.mAwSettings.getTextZoom();
    }

    public void setDefaultZoom(WebSettings.ZoomDensity zoom) {
        if (zoom != WebSettings.ZoomDensity.MEDIUM) {
            Log.w(TAG, "setDefaultZoom not supported, zoom=" + (Object)((Object)zoom));
        }
    }

    public WebSettings.ZoomDensity getDefaultZoom() {
        return WebSettings.ZoomDensity.MEDIUM;
    }

    public void setLightTouchEnabled(boolean enabled) {
    }

    public boolean getLightTouchEnabled() {
        return false;
    }

    public synchronized void setUserAgent(int ua) {
        if (ua == 0) {
            this.setUserAgentString(null);
        } else {
            Log.w(TAG, "setUserAgent not supported, ua=" + ua);
        }
    }

    public synchronized int getUserAgent() {
        return AwSettings.getDefaultUserAgent().equals(this.getUserAgentString()) ? 0 : -1;
    }

    public synchronized void setUseWideViewPort(boolean use) {
        this.mAwSettings.setUseWideViewPort(use);
    }

    public synchronized boolean getUseWideViewPort() {
        return this.mAwSettings.getUseWideViewPort();
    }

    public synchronized void setSupportMultipleWindows(boolean support) {
        this.mAwSettings.setSupportMultipleWindows(support);
    }

    public synchronized boolean supportMultipleWindows() {
        return this.mAwSettings.supportMultipleWindows();
    }

    public synchronized void setLayoutAlgorithm(WebSettings.LayoutAlgorithm l) {
        AwSettings.LayoutAlgorithm[] chromiumValues = new AwSettings.LayoutAlgorithm[]{AwSettings.LayoutAlgorithm.NORMAL, AwSettings.LayoutAlgorithm.SINGLE_COLUMN, AwSettings.LayoutAlgorithm.NARROW_COLUMNS, AwSettings.LayoutAlgorithm.TEXT_AUTOSIZING};
        this.mAwSettings.setLayoutAlgorithm(chromiumValues[l.ordinal()]);
    }

    public synchronized WebSettings.LayoutAlgorithm getLayoutAlgorithm() {
        WebSettings.LayoutAlgorithm[] webViewValues = new WebSettings.LayoutAlgorithm[]{WebSettings.LayoutAlgorithm.NORMAL, WebSettings.LayoutAlgorithm.SINGLE_COLUMN, WebSettings.LayoutAlgorithm.NARROW_COLUMNS, WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING};
        return webViewValues[this.mAwSettings.getLayoutAlgorithm().ordinal()];
    }

    public synchronized void setStandardFontFamily(String font) {
        this.mAwSettings.setStandardFontFamily(font);
    }

    public synchronized String getStandardFontFamily() {
        return this.mAwSettings.getStandardFontFamily();
    }

    public synchronized void setFixedFontFamily(String font) {
        this.mAwSettings.setFixedFontFamily(font);
    }

    public synchronized String getFixedFontFamily() {
        return this.mAwSettings.getFixedFontFamily();
    }

    public synchronized void setSansSerifFontFamily(String font) {
        this.mAwSettings.setSansSerifFontFamily(font);
    }

    public synchronized String getSansSerifFontFamily() {
        return this.mAwSettings.getSansSerifFontFamily();
    }

    public synchronized void setSerifFontFamily(String font) {
        this.mAwSettings.setSerifFontFamily(font);
    }

    public synchronized String getSerifFontFamily() {
        return this.mAwSettings.getSerifFontFamily();
    }

    public synchronized void setCursiveFontFamily(String font) {
        this.mAwSettings.setCursiveFontFamily(font);
    }

    public synchronized String getCursiveFontFamily() {
        return this.mAwSettings.getCursiveFontFamily();
    }

    public synchronized void setFantasyFontFamily(String font) {
        this.mAwSettings.setFantasyFontFamily(font);
    }

    public synchronized String getFantasyFontFamily() {
        return this.mAwSettings.getFantasyFontFamily();
    }

    public synchronized void setMinimumFontSize(int size) {
        this.mAwSettings.setMinimumFontSize(size);
    }

    public synchronized int getMinimumFontSize() {
        return this.mAwSettings.getMinimumFontSize();
    }

    public synchronized void setMinimumLogicalFontSize(int size) {
        this.mAwSettings.setMinimumLogicalFontSize(size);
    }

    public synchronized int getMinimumLogicalFontSize() {
        return this.mAwSettings.getMinimumLogicalFontSize();
    }

    public synchronized void setDefaultFontSize(int size) {
        this.mAwSettings.setDefaultFontSize(size);
    }

    public synchronized int getDefaultFontSize() {
        return this.mAwSettings.getDefaultFontSize();
    }

    public synchronized void setDefaultFixedFontSize(int size) {
        this.mAwSettings.setDefaultFixedFontSize(size);
    }

    public synchronized int getDefaultFixedFontSize() {
        return this.mAwSettings.getDefaultFixedFontSize();
    }

    public synchronized void setLoadsImagesAutomatically(boolean flag) {
        this.mAwSettings.setLoadsImagesAutomatically(flag);
    }

    public synchronized boolean getLoadsImagesAutomatically() {
        return this.mAwSettings.getLoadsImagesAutomatically();
    }

    public synchronized void setBlockNetworkImage(boolean flag) {
        this.mAwSettings.setImagesEnabled(!flag);
    }

    public synchronized boolean getBlockNetworkImage() {
        return !this.mAwSettings.getImagesEnabled();
    }

    public synchronized void setBlockNetworkLoads(boolean flag) {
        this.mAwSettings.setBlockNetworkLoads(flag);
    }

    public synchronized boolean getBlockNetworkLoads() {
        return this.mAwSettings.getBlockNetworkLoads();
    }

    public synchronized void setJavaScriptEnabled(boolean flag) {
        this.mAwSettings.setJavaScriptEnabled(flag);
    }

    public void setAllowUniversalAccessFromFileURLs(boolean flag) {
        this.mAwSettings.setAllowUniversalAccessFromFileURLs(flag);
    }

    public void setAllowFileAccessFromFileURLs(boolean flag) {
        this.mAwSettings.setAllowFileAccessFromFileURLs(flag);
    }

    public synchronized void setPluginsEnabled(boolean flag) {
        this.mAwSettings.setPluginsEnabled(flag);
    }

    public synchronized void setPluginState(WebSettings.PluginState state) {
        this.mAwSettings.setPluginState(state);
    }

    public synchronized void setDatabasePath(String databasePath) {
    }

    public synchronized void setGeolocationDatabasePath(String databasePath) {
    }

    public synchronized void setAppCacheEnabled(boolean flag) {
        this.mAwSettings.setAppCacheEnabled(flag);
    }

    public synchronized void setAppCachePath(String appCachePath) {
        this.mAwSettings.setAppCachePath(appCachePath);
    }

    public synchronized void setAppCacheMaxSize(long appCacheMaxSize) {
    }

    public synchronized void setDatabaseEnabled(boolean flag) {
        this.mAwSettings.setDatabaseEnabled(flag);
    }

    public synchronized void setDomStorageEnabled(boolean flag) {
        this.mAwSettings.setDomStorageEnabled(flag);
    }

    public synchronized boolean getDomStorageEnabled() {
        return this.mAwSettings.getDomStorageEnabled();
    }

    public synchronized String getDatabasePath() {
        return "";
    }

    public synchronized boolean getDatabaseEnabled() {
        return this.mAwSettings.getDatabaseEnabled();
    }

    public synchronized void setGeolocationEnabled(boolean flag) {
        this.mAwSettings.setGeolocationEnabled(flag);
    }

    public synchronized boolean getJavaScriptEnabled() {
        return this.mAwSettings.getJavaScriptEnabled();
    }

    public boolean getAllowUniversalAccessFromFileURLs() {
        return this.mAwSettings.getAllowUniversalAccessFromFileURLs();
    }

    public boolean getAllowFileAccessFromFileURLs() {
        return this.mAwSettings.getAllowFileAccessFromFileURLs();
    }

    public synchronized boolean getPluginsEnabled() {
        return this.mAwSettings.getPluginsEnabled();
    }

    public synchronized WebSettings.PluginState getPluginState() {
        return this.mAwSettings.getPluginState();
    }

    public synchronized void setJavaScriptCanOpenWindowsAutomatically(boolean flag) {
        this.mAwSettings.setJavaScriptCanOpenWindowsAutomatically(flag);
    }

    public synchronized boolean getJavaScriptCanOpenWindowsAutomatically() {
        return this.mAwSettings.getJavaScriptCanOpenWindowsAutomatically();
    }

    public synchronized void setDefaultTextEncodingName(String encoding) {
        this.mAwSettings.setDefaultTextEncodingName(encoding);
    }

    public synchronized String getDefaultTextEncodingName() {
        return this.mAwSettings.getDefaultTextEncodingName();
    }

    public synchronized void setUserAgentString(String ua) {
        this.mAwSettings.setUserAgentString(ua);
    }

    public synchronized String getUserAgentString() {
        return this.mAwSettings.getUserAgentString();
    }

    public void setNeedInitialFocus(boolean flag) {
        this.mAwSettings.setShouldFocusFirstNode(flag);
    }

    public synchronized void setRenderPriority(WebSettings.RenderPriority priority) {
    }

    public void setCacheMode(int mode) {
        this.mAwSettings.setCacheMode(mode);
    }

    public int getCacheMode() {
        return this.mAwSettings.getCacheMode();
    }

    public void setMediaPlaybackRequiresUserGesture(boolean require) {
        this.mAwSettings.setMediaPlaybackRequiresUserGesture(require);
    }

    public boolean getMediaPlaybackRequiresUserGesture() {
        return this.mAwSettings.getMediaPlaybackRequiresUserGesture();
    }
}

