/*
 * Decompiled with CFR 0.152.
 */
package com.android.webview.chromium;

import android.webkit.ValueCallback;
import android.webkit.WebStorage;
import java.util.HashMap;
import java.util.Map;
import org.chromium.android_webview.AwQuotaManagerBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WebStorageAdapter
extends WebStorage {
    private final AwQuotaManagerBridge mQuotaManagerBridge;

    WebStorageAdapter(AwQuotaManagerBridge quotaManagerBridge) {
        this.mQuotaManagerBridge = quotaManagerBridge;
    }

    @Override
    public void getOrigins(final ValueCallback<Map> callback) {
        this.mQuotaManagerBridge.getOrigins(new ValueCallback<AwQuotaManagerBridge.Origins>(){

            @Override
            public void onReceiveValue(AwQuotaManagerBridge.Origins origins) {
                HashMap<String, 1> originsMap = new HashMap<String, 1>();
                for (int i = 0; i < origins.mOrigins.length; ++i) {
                    WebStorage.Origin origin = new WebStorage.Origin(origins.mOrigins[i], origins.mQuotas[i], origins.mUsages[i]){};
                    originsMap.put(origins.mOrigins[i], origin);
                }
                callback.onReceiveValue(originsMap);
            }
        });
    }

    @Override
    public void getUsageForOrigin(String origin, ValueCallback<Long> callback) {
        this.mQuotaManagerBridge.getUsageForOrigin(origin, callback);
    }

    @Override
    public void getQuotaForOrigin(String origin, ValueCallback<Long> callback) {
        this.mQuotaManagerBridge.getQuotaForOrigin(origin, callback);
    }

    @Override
    public void setQuotaForOrigin(String origin, long quota) {
    }

    @Override
    public void deleteOrigin(String origin) {
        this.mQuotaManagerBridge.deleteOrigin(origin);
    }

    @Override
    public void deleteAllData() {
        this.mQuotaManagerBridge.deleteAllData();
    }
}

