/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;

abstract class AbstractHttpInputStream
extends InputStream {
    protected final InputStream in;
    protected final HttpEngine httpEngine;
    private final CacheRequest cacheRequest;
    private final OutputStream cacheBody;
    protected boolean closed;

    AbstractHttpInputStream(InputStream in, HttpEngine httpEngine, CacheRequest cacheRequest) throws IOException {
        OutputStream cacheBody;
        this.in = in;
        this.httpEngine = httpEngine;
        OutputStream outputStream = cacheBody = cacheRequest != null ? cacheRequest.getBody() : null;
        if (cacheBody == null) {
            cacheRequest = null;
        }
        this.cacheBody = cacheBody;
        this.cacheRequest = cacheRequest;
    }

    public final int read() throws IOException {
        return Util.readSingleByte(this);
    }

    protected final void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    protected final void cacheWrite(byte[] buffer, int offset, int count) throws IOException {
        if (this.cacheBody != null) {
            this.cacheBody.write(buffer, offset, count);
        }
    }

    protected final void endOfInput() throws IOException {
        if (this.cacheRequest != null) {
            this.cacheBody.close();
        }
        this.httpEngine.release(false);
    }

    protected final void unexpectedEndOfInput() {
        if (this.cacheRequest != null) {
            this.cacheRequest.abort();
        }
        this.httpEngine.release(true);
    }
}

