/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FindBugsSuppressWarnings(value={"DM_NUMBER_CTOR"})
public final class Integer
extends Number
implements Comparable<Integer> {
    private static final long serialVersionUID = 1360826667806852920L;
    private final int value;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final int MIN_VALUE = -2147483648;
    public static final int SIZE = 32;
    private static final byte[] NTZ_TABLE = new byte[]{32, 0, 1, 12, 2, 6, -1, 13, 3, -1, 7, -1, -1, -1, -1, 14, 10, 4, -1, -1, 8, -1, -1, 25, -1, -1, -1, -1, -1, 21, 27, 15, 31, 11, 5, -1, -1, -1, -1, -1, 9, -1, -1, 24, -1, -1, 20, 26, 30, -1, -1, -1, -1, 23, -1, 19, 29, -1, 22, 18, 28, 17, 16, -1};
    public static final Class<Integer> TYPE = int[].class.getComponentType();
    private static final Integer[] SMALL_VALUES = new Integer[256];

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String string2) throws NumberFormatException {
        this(Integer.parseInt(string2));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Integer object) {
        return Integer.compare(this.value, object.value);
    }

    public static int compare(int lhs, int rhs) {
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    private static NumberFormatException invalidInt(String s) {
        throw new NumberFormatException("Invalid int: \"" + s + "\"");
    }

    public static Integer decode(String string2) throws NumberFormatException {
        boolean negative;
        int length = string2.length();
        int i = 0;
        if (length == 0) {
            throw Integer.invalidInt(string2);
        }
        char firstDigit = string2.charAt(i);
        boolean bl = negative = firstDigit == '-';
        if (negative) {
            if (length == 1) {
                throw Integer.invalidInt(string2);
            }
            firstDigit = string2.charAt(++i);
        }
        int base = 10;
        if (firstDigit == '0') {
            if (++i == length) {
                return 0;
            }
            firstDigit = string2.charAt(i);
            if (firstDigit == 'x' || firstDigit == 'X') {
                if (++i == length) {
                    throw Integer.invalidInt(string2);
                }
                base = 16;
            } else {
                base = 8;
            }
        } else if (firstDigit == '#') {
            if (++i == length) {
                throw Integer.invalidInt(string2);
            }
            base = 16;
        }
        int result = Integer.parse(string2, i, base, negative);
        return result;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Integer && ((Integer)o).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public static Integer getInteger(String string2) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String prop = System.getProperty(string2);
        if (prop == null) {
            return null;
        }
        try {
            return Integer.decode(prop);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Integer getInteger(String string2, int defaultValue) {
        if (string2 == null || string2.length() == 0) {
            return defaultValue;
        }
        String prop = System.getProperty(string2);
        if (prop == null) {
            return defaultValue;
        }
        try {
            return Integer.decode(prop);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static Integer getInteger(String string2, Integer defaultValue) {
        if (string2 == null || string2.length() == 0) {
            return defaultValue;
        }
        String prop = System.getProperty(string2);
        if (prop == null) {
            return defaultValue;
        }
        try {
            return Integer.decode(prop);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static int parseInt(String string2) throws NumberFormatException {
        return Integer.parseInt(string2, 10);
    }

    public static int parseInt(String string2, int radix) throws NumberFormatException {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (string2 == null) {
            throw Integer.invalidInt(string2);
        }
        int length = string2.length();
        int i = 0;
        if (length == 0) {
            throw Integer.invalidInt(string2);
        }
        boolean bl = negative = string2.charAt(i) == '-';
        if (negative && ++i == length) {
            throw Integer.invalidInt(string2);
        }
        return Integer.parse(string2, i, radix, negative);
    }

    private static int parse(String string2, int offset, int radix, boolean negative) throws NumberFormatException {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int length = string2.length();
        while (offset < length) {
            int digit;
            if ((digit = Character.digit(string2.charAt(offset++), radix)) == -1) {
                throw Integer.invalidInt(string2);
            }
            if (max > result) {
                throw Integer.invalidInt(string2);
            }
            int next = result * radix - digit;
            if (next > result) {
                throw Integer.invalidInt(string2);
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw Integer.invalidInt(string2);
        }
        return result;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public static String toBinaryString(int i) {
        return IntegralToString.intToBinaryString(i);
    }

    public static String toHexString(int i) {
        return IntegralToString.intToHexString(i, false, 0);
    }

    public static String toOctalString(int i) {
        return IntegralToString.intToOctalString(i);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(int i) {
        return IntegralToString.intToString(i);
    }

    public static String toString(int i, int radix) {
        return IntegralToString.intToString(i, radix);
    }

    public static Integer valueOf(String string2) throws NumberFormatException {
        return Integer.parseInt(string2);
    }

    public static Integer valueOf(String string2, int radix) throws NumberFormatException {
        return Integer.parseInt(string2, radix);
    }

    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(int i) {
        if (i <= 0) {
            return ~i >> 26 & 0x20;
        }
        int n = 1;
        if (i >> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n - (i >>> 31);
    }

    public static int numberOfTrailingZeros(int i) {
        return NTZ_TABLE[(i & -i) * 72416175 >>> 26];
    }

    public static int bitCount(int i) {
        i -= i >> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >> 2 & 0x33333333);
        i = (i >> 4) + i & 0xF0F0F0F;
        i += i >> 8;
        i += i >> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static int reverseBytes(int i) {
        i = i >>> 8 & 0xFF00FF | (i & 0xFF00FF) << 8;
        return i >>> 16 | i << 16;
    }

    public static int reverse(int i) {
        i = i >>> 1 & 0x55555555 | (i & 0x55555555) << 1;
        i = i >>> 2 & 0x33333333 | (i & 0x33333333) << 2;
        i = i >>> 4 & 0xF0F0F0F | (i & 0xF0F0F0F) << 4;
        i = i >>> 8 & 0xFF00FF | (i & 0xFF00FF) << 8;
        return i >>> 16 | i << 16;
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    public static Integer valueOf(int i) {
        return i >= 128 || i < -128 ? new Integer(i) : SMALL_VALUES[i + 128];
    }

    static {
        for (int i = -128; i < 128; ++i) {
            Integer.SMALL_VALUES[i + 128] = new Integer(i);
        }
    }
}

