/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FinalizerReference<T>
extends Reference<T> {
    public static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Object LIST_LOCK = new Object();
    private static FinalizerReference<?> head = null;
    private FinalizerReference<?> prev;
    private FinalizerReference<?> next;
    private T zombie;

    public FinalizerReference(T r, ReferenceQueue<? super T> q) {
        super(r, q);
    }

    @Override
    public T get() {
        return this.zombie;
    }

    @Override
    public void clear() {
        this.zombie = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Object referent) {
        FinalizerReference<Object> reference = new FinalizerReference<Object>(referent, queue);
        Object object = LIST_LOCK;
        synchronized (object) {
            reference.prev = null;
            reference.next = head;
            if (head != null) {
                FinalizerReference.head.prev = reference;
            }
            head = reference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(FinalizerReference<?> reference) {
        Object object = LIST_LOCK;
        synchronized (object) {
            FinalizerReference<?> next = reference.next;
            FinalizerReference<?> prev = reference.prev;
            reference.next = null;
            reference.prev = null;
            if (prev != null) {
                prev.next = next;
            } else {
                head = next;
            }
            if (next != null) {
                next.prev = prev;
            }
        }
    }

    public static void finalizeAllEnqueued() throws InterruptedException {
        Sentinel sentinel = new Sentinel();
        FinalizerReference.enqueueSentinelReference(sentinel);
        sentinel.awaitFinalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueueSentinelReference(Sentinel sentinel) {
        Object object = LIST_LOCK;
        synchronized (object) {
            FinalizerReference<?> r = head;
            while (r != null) {
                if (r.referent == sentinel) {
                    FinalizerReference<?> sentinelReference = r;
                    sentinelReference.referent = null;
                    sentinelReference.zombie = sentinel;
                    sentinelReference.enqueueInternal();
                    return;
                }
                r = r.next;
            }
        }
        throw new AssertionError((Object)"newly-created live Sentinel not on list!");
    }

    private static class Sentinel {
        boolean finalized = false;

        private Sentinel() {
        }

        protected synchronized void finalize() throws Throwable {
            if (this.finalized) {
                throw new AssertionError();
            }
            this.finalized = true;
            this.notifyAll();
        }

        synchronized void awaitFinalization() throws InterruptedException {
            while (!this.finalized) {
                this.wait();
            }
        }
    }
}

