/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.ListOfTypes;
import libcore.reflect.Types;
import libcore.util.EmptyArray;
import org.apache.harmony.kernel.vm.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor<T>
extends AccessibleObject
implements GenericDeclaration,
Member {
    Class<T> declaringClass;
    Class<?>[] parameterTypes;
    Class<?>[] exceptionTypes;
    ListOfTypes genericExceptionTypes;
    ListOfTypes genericParameterTypes;
    TypeVariable<Constructor<T>>[] formalTypeParameters;
    private volatile boolean genericTypesAreInitialized = false;
    int slot;
    private int methodDexIndex;

    private synchronized void initGenericTypes() {
        if (!this.genericTypesAreInitialized) {
            String signatureAttribute = this.getSignatureAttribute();
            GenericSignatureParser parser = new GenericSignatureParser(this.declaringClass.getClassLoader());
            parser.parseForConstructor(this, signatureAttribute, this.exceptionTypes);
            this.formalTypeParameters = parser.formalTypeParameters;
            this.genericParameterTypes = parser.parameterTypes;
            this.genericExceptionTypes = parser.exceptionTypes;
            this.genericTypesAreInitialized = true;
        }
    }

    private Constructor() {
    }

    private Constructor(Class<T> declaringClass, Class<?>[] ptypes, Class<?>[] extypes, int slot, int methodDexIndex) {
        this.declaringClass = declaringClass;
        this.parameterTypes = ptypes;
        this.exceptionTypes = extypes;
        this.slot = slot;
        this.methodDexIndex = methodDexIndex;
    }

    public int getDexMethodIndex() {
        return this.methodDexIndex;
    }

    @Override
    String getSignatureAttribute() {
        Object[] annotation = Method.getSignatureAnnotation(this.declaringClass, this.slot);
        if (annotation == null) {
            return null;
        }
        return StringUtils.combineStrings(annotation);
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        this.initGenericTypes();
        return (TypeVariable[])this.formalTypeParameters.clone();
    }

    public String toGenericString() {
        StringBuilder sb = new StringBuilder(80);
        this.initGenericTypes();
        int modifier = this.getModifiers();
        if (modifier != 0) {
            sb.append(Modifier.toString(modifier & 0xFFFFFF7F)).append(' ');
        }
        if (this.formalTypeParameters != null && this.formalTypeParameters.length > 0) {
            sb.append('<');
            for (int i = 0; i < this.formalTypeParameters.length; ++i) {
                this.appendGenericType(sb, this.formalTypeParameters[i]);
                if (i >= this.formalTypeParameters.length - 1) continue;
                sb.append(",");
            }
            sb.append("> ");
        }
        this.appendTypeName(sb, this.getDeclaringClass());
        sb.append('(');
        this.appendArrayGenericType(sb, Types.getTypeArray(this.genericParameterTypes, false));
        sb.append(')');
        Type[] genericExceptionTypeArray = Types.getTypeArray(this.genericExceptionTypes, false);
        if (genericExceptionTypeArray.length > 0) {
            sb.append(" throws ");
            this.appendArrayGenericType(sb, genericExceptionTypeArray);
        }
        return sb.toString();
    }

    public Type[] getGenericParameterTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericParameterTypes, true);
    }

    public Type[] getGenericExceptionTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericExceptionTypes, true);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return Method.getDeclaredAnnotations(this.declaringClass, this.slot);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return Method.getAnnotation(this.declaringClass, this.slot, annotationType);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return Method.isAnnotationPresent(this.declaringClass, this.slot, annotationType);
    }

    public Annotation[][] getParameterAnnotations() {
        Annotation[][] parameterAnnotations = Method.getParameterAnnotations(this.declaringClass, this.slot);
        if (parameterAnnotations.length == 0) {
            return Method.noAnnotations(this.parameterTypes.length);
        }
        return parameterAnnotations;
    }

    public boolean isVarArgs() {
        int mods = Method.getMethodModifiers(this.declaringClass, this.slot);
        return (mods & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        int mods = Method.getMethodModifiers(this.declaringClass, this.slot);
        return (mods & 0x1000) != 0;
    }

    public boolean equals(Object object) {
        return object instanceof Constructor && this.toString().equals(object.toString());
    }

    public Class<T> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?>[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            return EmptyArray.CLASS;
        }
        return (Class[])this.exceptionTypes.clone();
    }

    @Override
    public int getModifiers() {
        return Method.getMethodModifiers(this.declaringClass, this.slot);
    }

    @Override
    public String getName() {
        return this.declaringClass.getName();
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    private String getSignature() {
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            result.append(this.getSignature(this.parameterTypes[i]));
        }
        result.append(")V");
        return result.toString();
    }

    public int hashCode() {
        return this.declaringClass.getName().hashCode();
    }

    public T newInstance(Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.constructNative(args, this.declaringClass, this.parameterTypes, this.slot, this.flag);
    }

    private native T constructNative(Object[] var1, Class<T> var2, Class<?>[] var3, int var4, boolean var5) throws InstantiationException, IllegalAccessException, InvocationTargetException;

    public String toString() {
        StringBuilder result = new StringBuilder(Modifier.toString(this.getModifiers()));
        if (result.length() != 0) {
            result.append(' ');
        }
        result.append(this.declaringClass.getName());
        result.append("(");
        result.append(this.toString(this.parameterTypes));
        result.append(")");
        if (this.exceptionTypes != null && this.exceptionTypes.length != 0) {
            result.append(" throws ");
            result.append(this.toString(this.exceptionTypes));
        }
        return result.toString();
    }
}

