/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteArrayBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyBufferException;

final class ByteBufferAsDoubleBuffer
extends DoubleBuffer {
    private final ByteBuffer byteBuffer;

    static DoubleBuffer asDoubleBuffer(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.order(byteBuffer.order());
        return new ByteBufferAsDoubleBuffer(slice);
    }

    private ByteBufferAsDoubleBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() / 8, byteBuffer.effectiveDirectAddress);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
    }

    public DoubleBuffer asReadOnlyBuffer() {
        ByteBufferAsDoubleBuffer buf = new ByteBufferAsDoubleBuffer(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        buf.byteBuffer.order = this.byteBuffer.order;
        return buf;
    }

    public DoubleBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit * 8);
        this.byteBuffer.position(this.position * 8);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public DoubleBuffer duplicate() {
        ByteBuffer bb = this.byteBuffer.duplicate().order(this.byteBuffer.order());
        ByteBufferAsDoubleBuffer buf = new ByteBufferAsDoubleBuffer(bb);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    public double get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getDouble(this.position++ * 8);
    }

    public double get(int index) {
        this.checkIndex(index);
        return this.byteBuffer.getDouble(index * 8);
    }

    public DoubleBuffer get(double[] dst, int dstOffset, int doubleCount) {
        this.byteBuffer.limit(this.limit * 8);
        this.byteBuffer.position(this.position * 8);
        if (this.byteBuffer instanceof DirectByteBuffer) {
            ((DirectByteBuffer)this.byteBuffer).get(dst, dstOffset, doubleCount);
        } else {
            ((ByteArrayBuffer)this.byteBuffer).get(dst, dstOffset, doubleCount);
        }
        this.position += doubleCount;
        return this;
    }

    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    double[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    boolean protectedHasArray() {
        return false;
    }

    public DoubleBuffer put(double c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putDouble(this.position++ * 8, c);
        return this;
    }

    public DoubleBuffer put(int index, double c) {
        this.checkIndex(index);
        this.byteBuffer.putDouble(index * 8, c);
        return this;
    }

    public DoubleBuffer put(double[] src, int srcOffset, int doubleCount) {
        this.byteBuffer.limit(this.limit * 8);
        this.byteBuffer.position(this.position * 8);
        if (this.byteBuffer instanceof DirectByteBuffer) {
            ((DirectByteBuffer)this.byteBuffer).put(src, srcOffset, doubleCount);
        } else {
            ((ByteArrayBuffer)this.byteBuffer).put(src, srcOffset, doubleCount);
        }
        this.position += doubleCount;
        return this;
    }

    public DoubleBuffer slice() {
        this.byteBuffer.limit(this.limit * 8);
        this.byteBuffer.position(this.position * 8);
        ByteBuffer bb = this.byteBuffer.slice().order(this.byteBuffer.order());
        ByteBufferAsDoubleBuffer result = new ByteBufferAsDoubleBuffer(bb);
        this.byteBuffer.clear();
        return result;
    }
}

