/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.harmony.security.fortress.Services;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Provider
extends Properties {
    private static final long serialVersionUID = -4298000515446427739L;
    private String name;
    private double version;
    private transient String versionString;
    private String info;
    private transient int providerNumber = -1;
    private transient LinkedHashMap<String, Service> serviceTable;
    private transient LinkedHashMap<String, Service> aliasTable;
    private transient LinkedHashMap<String, Service> propertyServiceTable;
    private transient LinkedHashMap<String, Service> propertyAliasTable;
    private transient LinkedHashMap<Object, Object> changedProperties;
    private transient Service returnedService;
    private transient String lastAlgorithm;
    private transient String lastServiceName;
    private transient Set<Service> lastServicesSet;
    private transient String lastType;
    private transient Service lastServicesByType;

    protected Provider(String name, double version, String info) {
        this.name = name;
        this.version = version;
        this.info = info;
        this.versionString = String.valueOf(version);
        this.putProviderInfo();
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public String toString() {
        return this.name + " version " + this.version;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.serviceTable != null) {
            this.serviceTable.clear();
        }
        if (this.propertyServiceTable != null) {
            this.propertyServiceTable.clear();
        }
        if (this.aliasTable != null) {
            this.aliasTable.clear();
        }
        if (this.propertyAliasTable != null) {
            this.propertyAliasTable.clear();
        }
        this.changedProperties = null;
        this.putProviderInfo();
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
        this.servicesChanged();
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        Properties tmp = new Properties();
        tmp.load(inStream);
        this.myPutAll(tmp);
    }

    @Override
    public synchronized void putAll(Map<?, ?> t) {
        this.myPutAll(t);
    }

    private void myPutAll(Map<?, ?> t) {
        if (this.changedProperties == null) {
            this.changedProperties = new LinkedHashMap();
        }
        for (Map.Entry<?, ?> entry : t.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String && ((String)key).startsWith("Provider.")) continue;
            Object value = entry.getValue();
            super.put(key, value);
            if (this.changedProperties.remove(key) == null) {
                this.removeFromPropertyServiceTable(key);
            }
            this.changedProperties.put(key, value);
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key instanceof String && ((String)key).startsWith("Provider.")) {
            return null;
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
        if (this.changedProperties != null && this.changedProperties.remove(key) == null) {
            this.removeFromPropertyServiceTable(key);
        }
        if (this.changedProperties == null) {
            this.changedProperties = new LinkedHashMap();
        }
        this.changedProperties.put(key, value);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        if (key instanceof String && ((String)key).startsWith("Provider.")) {
            return null;
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
        if (this.changedProperties != null && this.changedProperties.remove(key) == null) {
            this.removeFromPropertyServiceTable(key);
            if (this.changedProperties.size() == 0) {
                this.changedProperties = null;
            }
        }
        return super.remove(key);
    }

    boolean implementsAlg(String serv, String alg, String attribute, String val) {
        String servAlg = serv + "." + alg;
        String prop = this.getPropertyIgnoreCase(servAlg);
        if (prop == null && (alg = this.getPropertyIgnoreCase("Alg.Alias." + servAlg)) != null) {
            servAlg = serv + "." + alg;
            prop = this.getPropertyIgnoreCase(servAlg);
        }
        if (prop != null) {
            if (attribute == null) {
                return true;
            }
            return this.checkAttribute(servAlg, attribute, val);
        }
        return false;
    }

    private boolean checkAttribute(String servAlg, String attribute, String val) {
        String attributeValue = this.getPropertyIgnoreCase(servAlg + ' ' + attribute);
        return attributeValue != null && (attribute.equalsIgnoreCase("KeySize") ? Integer.parseInt(attributeValue) >= Integer.parseInt(val) : attributeValue.equalsIgnoreCase(val));
    }

    void setProviderNumber(int n) {
        this.providerNumber = n;
    }

    int getProviderNumber() {
        return this.providerNumber;
    }

    synchronized Service getService(String type) {
        this.updatePropertyServiceTable();
        if (this.lastServicesByType != null && type.equals(this.lastType)) {
            return this.lastServicesByType;
        }
        for (Service service : this.getServices()) {
            if (!type.equals(service.type)) continue;
            this.lastType = type;
            this.lastServicesByType = service;
            return service;
        }
        return null;
    }

    public synchronized Service getService(String type, String algorithm) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        if (type.equals(this.lastServiceName) && algorithm.equalsIgnoreCase(this.lastAlgorithm)) {
            return this.returnedService;
        }
        String key = Provider.key(type, algorithm);
        Service o = null;
        if (this.serviceTable != null) {
            o = this.serviceTable.get(key);
        }
        if (o == null && this.aliasTable != null) {
            o = this.aliasTable.get(key);
        }
        if (o == null) {
            this.updatePropertyServiceTable();
        }
        if (o == null && this.propertyServiceTable != null) {
            o = this.propertyServiceTable.get(key);
        }
        if (o == null && this.propertyAliasTable != null) {
            o = this.propertyAliasTable.get(key);
        }
        if (o != null) {
            this.lastServiceName = type;
            this.lastAlgorithm = algorithm;
            this.returnedService = o;
            return this.returnedService;
        }
        return null;
    }

    public synchronized Set<Service> getServices() {
        this.updatePropertyServiceTable();
        if (this.lastServicesSet != null) {
            return this.lastServicesSet;
        }
        this.lastServicesSet = this.serviceTable != null ? new LinkedHashSet(this.serviceTable.values()) : new LinkedHashSet<Service>();
        if (this.propertyServiceTable != null) {
            this.lastServicesSet.addAll(this.propertyServiceTable.values());
        }
        this.lastServicesSet = Collections.unmodifiableSet(this.lastServicesSet);
        return this.lastServicesSet;
    }

    protected synchronized void putService(Service s) {
        if (s == null) {
            throw new NullPointerException("s == null");
        }
        if ("Provider".equals(s.getType())) {
            return;
        }
        this.servicesChanged();
        if (this.serviceTable == null) {
            this.serviceTable = new LinkedHashMap(128);
        }
        this.serviceTable.put(Provider.key(s.type, s.algorithm), s);
        if (s.aliases != null) {
            if (this.aliasTable == null) {
                this.aliasTable = new LinkedHashMap(256);
            }
            for (String alias : s.getAliases()) {
                this.aliasTable.put(Provider.key(s.type, alias), s);
            }
        }
        this.serviceInfoToProperties(s);
    }

    protected synchronized void removeService(Service s) {
        if (s == null) {
            throw new NullPointerException("s == null");
        }
        this.servicesChanged();
        if (this.serviceTable != null) {
            this.serviceTable.remove(Provider.key(s.type, s.algorithm));
        }
        if (this.aliasTable != null && s.aliases != null) {
            for (String alias : s.getAliases()) {
                this.aliasTable.remove(Provider.key(s.type, alias));
            }
        }
        this.serviceInfoFromProperties(s);
    }

    private void serviceInfoToProperties(Service s) {
        super.put(s.type + "." + s.algorithm, s.className);
        if (s.aliases != null) {
            Iterator i = s.aliases.iterator();
            while (i.hasNext()) {
                super.put("Alg.Alias." + s.type + "." + (String)i.next(), s.algorithm);
            }
        }
        if (s.attributes != null) {
            for (Map.Entry entry : s.attributes.entrySet()) {
                super.put(s.type + "." + s.algorithm + " " + (String)entry.getKey(), entry.getValue());
            }
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
    }

    private void serviceInfoFromProperties(Service s) {
        super.remove(s.type + "." + s.algorithm);
        if (s.aliases != null) {
            Iterator i = s.aliases.iterator();
            while (i.hasNext()) {
                super.remove("Alg.Alias." + s.type + "." + (String)i.next());
            }
        }
        if (s.attributes != null) {
            for (Map.Entry entry : s.attributes.entrySet()) {
                super.remove(s.type + "." + s.algorithm + " " + (String)entry.getKey());
            }
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
    }

    private void removeFromPropertyServiceTable(Object key) {
        if (key == null || !(key instanceof String)) {
            return;
        }
        String k = (String)key;
        if (k.startsWith("Provider.")) {
            return;
        }
        String algorithm = null;
        String attribute = null;
        if (k.startsWith("Alg.Alias.")) {
            String service_alias = k.substring(10);
            int i = service_alias.indexOf(46);
            String serviceName = service_alias.substring(0, i);
            String aliasName = service_alias.substring(i + 1);
            if (this.propertyAliasTable != null) {
                this.propertyAliasTable.remove(Provider.key(serviceName, aliasName));
            }
            if (this.propertyServiceTable != null) {
                for (Service s : this.propertyServiceTable.values()) {
                    if (!s.aliases.contains(aliasName)) continue;
                    s.aliases.remove(aliasName);
                    return;
                }
            }
            return;
        }
        int j = k.indexOf(46);
        if (j == -1) {
            return;
        }
        int i = k.indexOf(32);
        if (i == -1) {
            Service ser;
            String serviceName = k.substring(0, j);
            algorithm = k.substring(j + 1);
            if (this.propertyServiceTable != null && (ser = (Service)this.propertyServiceTable.remove(Provider.key(serviceName, algorithm))) != null && this.propertyAliasTable != null && ser.aliases != null) {
                for (String alias : ser.aliases) {
                    this.propertyAliasTable.remove(Provider.key(serviceName, alias));
                }
            }
        } else {
            Service o;
            attribute = k.substring(i + 1);
            String serviceName = k.substring(0, j);
            algorithm = k.substring(j + 1, i);
            if (this.propertyServiceTable != null && (o = this.propertyServiceTable.get(Provider.key(serviceName, algorithm))) != null) {
                Service s = o;
                s.attributes.remove(attribute);
            }
        }
    }

    private void updatePropertyServiceTable() {
        if (this.changedProperties == null || this.changedProperties.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.changedProperties.entrySet()) {
            String className;
            Service s;
            Service o;
            String propertyServiceTableKey;
            String algorithm;
            String serviceName;
            int i;
            Object _key = entry.getKey();
            Object _value = entry.getValue();
            if (_key == null || _value == null || !(_key instanceof String) || !(_value instanceof String)) continue;
            String key = (String)_key;
            String value = (String)_value;
            if (key.startsWith("Provider")) continue;
            if (key.startsWith("Alg.Alias.")) {
                String service_alias = key.substring(10);
                i = service_alias.indexOf(46);
                serviceName = service_alias.substring(0, i);
                String aliasName = service_alias.substring(i + 1);
                algorithm = value;
                propertyServiceTableKey = Provider.key(serviceName, algorithm);
                o = null;
                if (this.propertyServiceTable == null) {
                    this.propertyServiceTable = new LinkedHashMap(128);
                } else {
                    o = this.propertyServiceTable.get(propertyServiceTableKey);
                }
                if (o != null) {
                    s = o;
                    s.addAlias(aliasName);
                    if (this.propertyAliasTable == null) {
                        this.propertyAliasTable = new LinkedHashMap(256);
                    }
                    this.propertyAliasTable.put(Provider.key(serviceName, aliasName), s);
                    continue;
                }
                className = (String)this.changedProperties.get(serviceName + "." + algorithm);
                if (className == null) continue;
                ArrayList<String> l = new ArrayList<String>();
                l.add(aliasName);
                s = new Service(this, serviceName, algorithm, className, l, new HashMap<String, String>());
                this.propertyServiceTable.put(propertyServiceTableKey, s);
                if (this.propertyAliasTable == null) {
                    this.propertyAliasTable = new LinkedHashMap(256);
                }
                this.propertyAliasTable.put(Provider.key(serviceName, aliasName), s);
                continue;
            }
            int j = key.indexOf(46);
            if (j == -1) continue;
            i = key.indexOf(32);
            if (i == -1) {
                serviceName = key.substring(0, j);
                algorithm = key.substring(j + 1);
                String propertyServiceTableKey2 = Provider.key(serviceName, algorithm);
                Service o2 = null;
                if (this.propertyServiceTable != null) {
                    o2 = this.propertyServiceTable.get(propertyServiceTableKey2);
                }
                if (o2 != null) {
                    s = o2;
                    s.className = value;
                    continue;
                }
                s = new Service(this, serviceName, algorithm, value, Collections.<String>emptyList(), Collections.<String, String>emptyMap());
                if (this.propertyServiceTable == null) {
                    this.propertyServiceTable = new LinkedHashMap(128);
                }
                this.propertyServiceTable.put(propertyServiceTableKey2, s);
                continue;
            }
            serviceName = key.substring(0, j);
            algorithm = key.substring(j + 1, i);
            String attribute = key.substring(i + 1);
            propertyServiceTableKey = Provider.key(serviceName, algorithm);
            o = null;
            if (this.propertyServiceTable != null) {
                o = this.propertyServiceTable.get(propertyServiceTableKey);
            }
            if (o != null) {
                s = o;
                s.putAttribute(attribute, value);
                continue;
            }
            className = (String)this.changedProperties.get(serviceName + "." + algorithm);
            if (className == null) continue;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put(attribute, value);
            s = new Service(this, serviceName, algorithm, className, new ArrayList<String>(), m);
            if (this.propertyServiceTable == null) {
                this.propertyServiceTable = new LinkedHashMap(128);
            }
            this.propertyServiceTable.put(propertyServiceTableKey, s);
        }
        this.servicesChanged();
        this.changedProperties = null;
    }

    private void servicesChanged() {
        this.lastServicesByType = null;
        this.lastServiceName = null;
        this.lastServicesSet = null;
    }

    private void putProviderInfo() {
        super.put("Provider.id name", this.name != null ? this.name : "null");
        super.put("Provider.id version", this.versionString);
        super.put("Provider.id info", this.info != null ? this.info : "null");
        super.put("Provider.id className", this.getClass().getName());
    }

    private String getPropertyIgnoreCase(String key) {
        String res = this.getProperty(key);
        if (res != null) {
            return res;
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            if (!key.equalsIgnoreCase(propertyName)) continue;
            return this.getProperty(propertyName);
        }
        return null;
    }

    private static String key(String type, String algorithm) {
        return type + '.' + algorithm.toUpperCase(Locale.US);
    }

    private void readObject(ObjectInputStream in) throws NotActiveException, IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.versionString = String.valueOf(this.version);
        this.providerNumber = -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Service {
        private static final String ATTR_SUPPORTED_KEY_CLASSES = "SupportedKeyClasses";
        private static final String ATTR_SUPPORTED_KEY_FORMATS = "SupportedKeyFormats";
        private static final HashMap<String, Boolean> supportsParameterTypes = new HashMap();
        private static final HashMap<String, Class<?>> constructorParameterClasses;
        private Provider provider;
        private String type;
        private String algorithm;
        private String className;
        private List<String> aliases;
        private Map<String, String> attributes;
        private Class<?> implementation;
        private String lastClassName;
        private volatile boolean supportedKeysInitialized;
        private Class<?>[] keyClasses;
        private String[] keyFormats;

        private static Class<?> loadClassOrThrow(String className) {
            try {
                return Provider.class.getClassLoader().loadClass(className);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        public Service(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes) {
            if (provider == null) {
                throw new NullPointerException("provider == null");
            }
            if (type == null) {
                throw new NullPointerException("type == null");
            }
            if (algorithm == null) {
                throw new NullPointerException("algorithm == null");
            }
            if (className == null) {
                throw new NullPointerException("className == null");
            }
            this.provider = provider;
            this.type = type;
            this.algorithm = algorithm;
            this.className = className;
            this.aliases = aliases != null && aliases.size() == 0 ? Collections.emptyList() : aliases;
            this.attributes = attributes != null && attributes.size() == 0 ? Collections.emptyMap() : attributes;
        }

        void addAlias(String alias) {
            if (this.aliases == null || this.aliases.size() == 0) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(alias);
        }

        void putAttribute(String name, String value) {
            if (this.attributes == null || this.attributes.size() == 0) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, value);
        }

        public final String getType() {
            return this.type;
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final Provider getProvider() {
            return this.provider;
        }

        public final String getClassName() {
            return this.className;
        }

        public final String getAttribute(String name) {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(name);
        }

        List<String> getAliases() {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>(0);
            }
            return this.aliases;
        }

        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            if (this.implementation == null || !this.className.equals(this.lastClassName)) {
                ClassLoader cl = this.provider.getClass().getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                try {
                    this.implementation = Class.forName(this.className, true, cl);
                    this.lastClassName = this.className;
                }
                catch (Exception e) {
                    throw new NoSuchAlgorithmException(this.type + " " + this.algorithm + " implementation not found: " + e);
                }
            }
            if (!constructorParameterClasses.containsKey(this.type)) {
                if (constructorParameter == null) {
                    return this.newInstanceNoParameter();
                }
                return this.newInstanceWithParameter(constructorParameter, constructorParameter.getClass());
            }
            if (constructorParameter == null) {
                return this.newInstanceNoParameter();
            }
            Class<?> expectedClass = constructorParameterClasses.get(this.type);
            if (expectedClass == null) {
                throw new IllegalArgumentException("Constructor parameter not supported for " + this.type);
            }
            if (!expectedClass.isAssignableFrom(constructorParameter.getClass())) {
                throw new IllegalArgumentException("Expecting constructor parameter of type " + expectedClass.getName() + " but was " + constructorParameter.getClass().getName());
            }
            return this.newInstanceWithParameter(constructorParameter, expectedClass);
        }

        private Object newInstanceWithParameter(Object constructorParameter, Class<?> parameterClass) throws NoSuchAlgorithmException {
            try {
                Class[] parameterTypes = new Class[]{parameterClass};
                Object[] initargs = new Object[]{constructorParameter};
                return this.implementation.getConstructor(parameterTypes).newInstance(initargs);
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException(this.type + " " + this.algorithm + " implementation not found", e);
            }
        }

        private Object newInstanceNoParameter() throws NoSuchAlgorithmException {
            try {
                return this.implementation.newInstance();
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException(this.type + " " + this.algorithm + " implementation not found", e);
            }
        }

        public boolean supportsParameter(Object parameter) {
            Boolean supportsParameter = supportsParameterTypes.get(this.type);
            if (supportsParameter == null) {
                return true;
            }
            if (!supportsParameter.booleanValue()) {
                throw new InvalidParameterException("Cannot use a parameter with " + this.type);
            }
            if (parameter != null && !(parameter instanceof Key)) {
                throw new InvalidParameterException("Parameter should be of type Key");
            }
            this.ensureSupportedKeysInitialized();
            if (this.keyClasses == null && this.keyFormats == null) {
                return true;
            }
            if (parameter == null) {
                return false;
            }
            Key keyParam = (Key)parameter;
            if (this.keyClasses != null && Service.isInArray(this.keyClasses, keyParam.getClass())) {
                return true;
            }
            return this.keyFormats != null && Service.isInArray(this.keyFormats, keyParam.getFormat());
        }

        private void ensureSupportedKeysInitialized() {
            String supportedFormatString;
            if (this.supportedKeysInitialized) {
                return;
            }
            String supportedClassesString = this.getAttribute(ATTR_SUPPORTED_KEY_CLASSES);
            if (supportedClassesString != null) {
                String[] keyClassNames = supportedClassesString.split("\\|");
                ArrayList supportedClassList = new ArrayList(keyClassNames.length);
                ClassLoader classLoader = this.getProvider().getClass().getClassLoader();
                for (String keyClassName : keyClassNames) {
                    try {
                        Class<?> keyClass = classLoader.loadClass(keyClassName);
                        if (!Key.class.isAssignableFrom(keyClass)) continue;
                        supportedClassList.add(keyClass);
                    }
                    catch (ClassNotFoundException ignored) {
                        // empty catch block
                    }
                }
                this.keyClasses = supportedClassList.toArray(new Class[supportedClassList.size()]);
            }
            if ((supportedFormatString = this.getAttribute(ATTR_SUPPORTED_KEY_FORMATS)) != null) {
                this.keyFormats = supportedFormatString.split("\\|");
            }
            this.supportedKeysInitialized = true;
        }

        private static <T> boolean isInArray(T[] itemList, T target) {
            if (target == null) {
                return false;
            }
            for (T item : itemList) {
                if (!target.equals(item)) continue;
                return true;
            }
            return false;
        }

        private static boolean isInArray(Class<?>[] itemList, Class<?> target) {
            if (target == null) {
                return false;
            }
            for (Class<?> item : itemList) {
                if (!item.isAssignableFrom(target)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String result = "Provider " + this.provider.getName() + " Service " + this.type + "." + this.algorithm + " " + this.className;
            if (this.aliases != null) {
                result = result + "\nAliases " + this.aliases.toString();
            }
            if (this.attributes != null) {
                result = result + "\nAttributes " + this.attributes.toString();
            }
            return result;
        }

        static {
            supportsParameterTypes.put("AlgorithmParameterGenerator", false);
            supportsParameterTypes.put("AlgorithmParameters", false);
            supportsParameterTypes.put("CertificateFactory", false);
            supportsParameterTypes.put("CertPathBuilder", false);
            supportsParameterTypes.put("CertPathValidator", false);
            supportsParameterTypes.put("CertStore", false);
            supportsParameterTypes.put("KeyFactory", false);
            supportsParameterTypes.put("KeyGenerator", false);
            supportsParameterTypes.put("KeyManagerFactory", false);
            supportsParameterTypes.put("KeyPairGenerator", false);
            supportsParameterTypes.put("KeyStore", false);
            supportsParameterTypes.put("MessageDigest", false);
            supportsParameterTypes.put("SecretKeyFactory", false);
            supportsParameterTypes.put("SecureRandom", false);
            supportsParameterTypes.put("SSLContext", false);
            supportsParameterTypes.put("TrustManagerFactory", false);
            supportsParameterTypes.put("Cipher", true);
            supportsParameterTypes.put("KeyAgreement", true);
            supportsParameterTypes.put("Mac", true);
            supportsParameterTypes.put("Signature", true);
            constructorParameterClasses = new HashMap();
            constructorParameterClasses.put("CertStore", Service.loadClassOrThrow("java.security.cert.CertStoreParameters"));
            constructorParameterClasses.put("AlgorithmParameterGenerator", null);
            constructorParameterClasses.put("AlgorithmParameters", null);
            constructorParameterClasses.put("CertificateFactory", null);
            constructorParameterClasses.put("CertPathBuilder", null);
            constructorParameterClasses.put("CertPathValidator", null);
            constructorParameterClasses.put("KeyFactory", null);
            constructorParameterClasses.put("KeyGenerator", null);
            constructorParameterClasses.put("KeyManagerFactory", null);
            constructorParameterClasses.put("KeyPairGenerator", null);
            constructorParameterClasses.put("KeyStore", null);
            constructorParameterClasses.put("MessageDigest", null);
            constructorParameterClasses.put("SecretKeyFactory", null);
            constructorParameterClasses.put("SecureRandom", null);
            constructorParameterClasses.put("SSLContext", null);
            constructorParameterClasses.put("TrustManagerFactory", null);
            constructorParameterClasses.put("Cipher", null);
            constructorParameterClasses.put("KeyAgreement", null);
            constructorParameterClasses.put("Mac", null);
            constructorParameterClasses.put("Signature", null);
        }
    }
}

