/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ComparableTimSort;
import java.util.Comparator;
import java.util.DualPivotQuicksort;
import java.util.List;
import java.util.RandomAccess;
import java.util.TimSort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private Arrays() {
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... array2) {
        return new ArrayList<T>(array2);
    }

    public static int binarySearch(byte[] array2, byte value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(byte[] array2, int startIndex, int endIndex, byte value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            byte midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(char[] array2, char value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(char[] array2, int startIndex, int endIndex, char value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            char midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(double[] array2, double value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(double[] array2, int startIndex, int endIndex, double value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            long valueBits;
            int mid = lo + hi >>> 1;
            double midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            if (midVal != 0.0 && midVal == value) {
                return mid;
            }
            long midValBits = Double.doubleToLongBits(midVal);
            if (midValBits < (valueBits = Double.doubleToLongBits(value))) {
                lo = mid + 1;
                continue;
            }
            if (midValBits > valueBits) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(float[] array2, float value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(float[] array2, int startIndex, int endIndex, float value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int valueBits;
            int mid = lo + hi >>> 1;
            float midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            if (midVal != 0.0f && midVal == value) {
                return mid;
            }
            int midValBits = Float.floatToIntBits(midVal);
            if (midValBits < (valueBits = Float.floatToIntBits(value))) {
                lo = mid + 1;
                continue;
            }
            if (midValBits > valueBits) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(int[] array2, int value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(int[] array2, int startIndex, int endIndex, int value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(long[] array2, long value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(long[] array2, int startIndex, int endIndex, long value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            long midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(Object[] array2, Object value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(Object[] array2, int startIndex, int endIndex, Object value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midValCmp = ((Comparable)array2[mid]).compareTo(value);
            if (midValCmp < 0) {
                lo = mid + 1;
                continue;
            }
            if (midValCmp > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static <T> int binarySearch(T[] array2, T value, Comparator<? super T> comparator) {
        return Arrays.binarySearch(array2, 0, array2.length, value, comparator);
    }

    public static <T> int binarySearch(T[] array2, int startIndex, int endIndex, T value, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Arrays.binarySearch(array2, startIndex, endIndex, value);
        }
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midValCmp = comparator.compare(array2[mid], value);
            if (midValCmp < 0) {
                lo = mid + 1;
                continue;
            }
            if (midValCmp > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(short[] array2, short value) {
        return Arrays.binarySearch(array2, 0, array2.length, value);
    }

    public static int binarySearch(short[] array2, int startIndex, int endIndex, short value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array2.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            short midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    private static void checkBinarySearchBounds(int startIndex, int endIndex, int length) {
        if (startIndex > endIndex) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || endIndex > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void fill(byte[] array2, byte value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(byte[] array2, int start, int end, byte value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(short[] array2, short value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(short[] array2, int start, int end, short value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(char[] array2, char value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(char[] array2, int start, int end, char value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(int[] array2, int value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(int[] array2, int start, int end, int value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(long[] array2, long value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(long[] array2, int start, int end, long value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(float[] array2, float value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(float[] array2, int start, int end, float value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(double[] array2, double value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(double[] array2, int start, int end, double value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(boolean[] array2, boolean value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(boolean[] array2, int start, int end, boolean value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(Object[] array2, Object value) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = value;
        }
    }

    public static void fill(Object[] array2, int start, int end, Object value) {
        Arrays.checkStartAndEnd(array2.length, start, end);
        for (int i = start; i < end; ++i) {
            array2[i] = value;
        }
    }

    public static int hashCode(boolean[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (boolean element : array2) {
            hashCode = 31 * hashCode + (element ? 1231 : 1237);
        }
        return hashCode;
    }

    public static int hashCode(int[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (int element : array2) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(short[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (short element : array2) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(char[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (char element : array2) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(byte[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (byte element : array2) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(long[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (long elementValue : array2) {
            hashCode = 31 * hashCode + (int)(elementValue ^ elementValue >>> 32);
        }
        return hashCode;
    }

    public static int hashCode(float[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (float element : array2) {
            hashCode = 31 * hashCode + Float.floatToIntBits(element);
        }
        return hashCode;
    }

    public static int hashCode(double[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (double element : array2) {
            long v = Double.doubleToLongBits(element);
            hashCode = 31 * hashCode + (int)(v ^ v >>> 32);
        }
        return hashCode;
    }

    public static int hashCode(Object[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object element : array2) {
            int elementHashCode = element == null ? 0 : element.hashCode();
            hashCode = 31 * hashCode + elementHashCode;
        }
        return hashCode;
    }

    public static int deepHashCode(Object[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object element : array2) {
            int elementHashCode = Arrays.deepHashCodeElement(element);
            hashCode = 31 * hashCode + elementHashCode;
        }
        return hashCode;
    }

    private static int deepHashCodeElement(Object element) {
        if (element == null) {
            return 0;
        }
        Class<?> cl = element.getClass().getComponentType();
        if (cl == null) {
            return element.hashCode();
        }
        if (element instanceof Object[]) {
            return Arrays.deepHashCode((Object[])element);
        }
        if (cl == Integer.TYPE) {
            return Arrays.hashCode((int[])element);
        }
        if (cl == Character.TYPE) {
            return Arrays.hashCode((char[])element);
        }
        if (cl == Boolean.TYPE) {
            return Arrays.hashCode((boolean[])element);
        }
        if (cl == Byte.TYPE) {
            return Arrays.hashCode((byte[])element);
        }
        if (cl == Long.TYPE) {
            return Arrays.hashCode((long[])element);
        }
        if (cl == Float.TYPE) {
            return Arrays.hashCode((float[])element);
        }
        if (cl == Double.TYPE) {
            return Arrays.hashCode((double[])element);
        }
        return Arrays.hashCode((short[])element);
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] array1, short[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] array1, char[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] array1, int[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] array1, long[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] array1, float[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Float.floatToIntBits(array1[i]) == Float.floatToIntBits(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] array1, double[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Double.doubleToLongBits(array1[i]) == Double.doubleToLongBits(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] array1, boolean[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Object e1 = array1[i];
            Object e2 = array2[i];
            if (e1 != null ? e1.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Object e1 = array1[i];
            Object e2 = array2[i];
            if (Arrays.deepEqualsElements(e1, e2)) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEqualsElements(Object e1, Object e2) {
        Class<?> cl2;
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        Class<?> cl1 = e1.getClass().getComponentType();
        if (cl1 != (cl2 = e2.getClass().getComponentType())) {
            return false;
        }
        if (cl1 == null) {
            return e1.equals(e2);
        }
        if (e1 instanceof Object[]) {
            return Arrays.deepEquals((Object[])e1, (Object[])e2);
        }
        if (cl1 == Integer.TYPE) {
            return Arrays.equals((int[])e1, (int[])e2);
        }
        if (cl1 == Character.TYPE) {
            return Arrays.equals((char[])e1, (char[])e2);
        }
        if (cl1 == Boolean.TYPE) {
            return Arrays.equals((boolean[])e1, (boolean[])e2);
        }
        if (cl1 == Byte.TYPE) {
            return Arrays.equals((byte[])e1, (byte[])e2);
        }
        if (cl1 == Long.TYPE) {
            return Arrays.equals((long[])e1, (long[])e2);
        }
        if (cl1 == Float.TYPE) {
            return Arrays.equals((float[])e1, (float[])e2);
        }
        if (cl1 == Double.TYPE) {
            return Arrays.equals((double[])e1, (double[])e2);
        }
        return Arrays.equals((short[])e1, (short[])e2);
    }

    public static void sort(byte[] array2) {
        DualPivotQuicksort.sort(array2);
    }

    public static void sort(byte[] array2, int start, int end) {
        DualPivotQuicksort.sort(array2, start, end);
    }

    public static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException(arrayLength, offset, count);
        }
    }

    public static void checkStartAndEnd(int len, int start, int end) {
        if (start < 0 || end > len) {
            throw new ArrayIndexOutOfBoundsException("start < 0 || end > len. start=" + start + ", end=" + end + ", len=" + len);
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end: " + start + " > " + end);
        }
    }

    public static void sort(char[] array2) {
        DualPivotQuicksort.sort(array2);
    }

    public static void sort(char[] array2, int start, int end) {
        DualPivotQuicksort.sort(array2, start, end);
    }

    public static void sort(double[] array2) {
        DualPivotQuicksort.sort(array2);
    }

    public static void sort(double[] array2, int start, int end) {
        DualPivotQuicksort.sort(array2, start, end);
    }

    public static void sort(float[] array2) {
        DualPivotQuicksort.sort(array2);
    }

    public static void sort(float[] array2, int start, int end) {
        DualPivotQuicksort.sort(array2, start, end);
    }

    public static void sort(int[] array2) {
        DualPivotQuicksort.sort(array2);
    }

    public static void sort(int[] array2, int start, int end) {
        DualPivotQuicksort.sort(array2, start, end);
    }

    public static void sort(long[] array2) {
        DualPivotQuicksort.sort(array2);
    }

    public static void sort(long[] array2, int start, int end) {
        DualPivotQuicksort.sort(array2, start, end);
    }

    public static void sort(short[] array2) {
        DualPivotQuicksort.sort(array2);
    }

    public static void sort(short[] array2, int start, int end) {
        DualPivotQuicksort.sort(array2, start, end);
    }

    public static void sort(Object[] array2) {
        ComparableTimSort.sort(array2);
    }

    public static void sort(Object[] array2, int start, int end) {
        ComparableTimSort.sort(array2, start, end);
    }

    public static <T> void sort(T[] array2, int start, int end, Comparator<? super T> comparator) {
        TimSort.sort(array2, start, end, comparator);
    }

    public static <T> void sort(T[] array2, Comparator<? super T> comparator) {
        TimSort.sort(array2, comparator);
    }

    public static String toString(boolean[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 7);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(byte[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 6);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(char[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 3);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(double[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 7);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(float[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 7);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(int[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 6);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(long[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 6);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(short[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 6);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(Object[] array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array2.length * 7);
        sb.append('[');
        sb.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            sb.append(", ");
            sb.append(array2[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String deepToString(Object[] array2) {
        if (array2 == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder(array2.length * 9);
        Arrays.deepToStringImpl(array2, new Object[]{array2}, buf);
        return buf.toString();
    }

    private static void deepToStringImpl(Object[] array2, Object[] origArrays, StringBuilder sb) {
        if (array2 == null) {
            sb.append("null");
            return;
        }
        sb.append('[');
        for (int i = 0; i < array2.length; ++i) {
            Object elem;
            if (i != 0) {
                sb.append(", ");
            }
            if ((elem = array2[i]) == null) {
                sb.append("null");
                continue;
            }
            Class<?> elemClass = elem.getClass();
            if (elemClass.isArray()) {
                Class<?> elemElemClass = elemClass.getComponentType();
                if (elemElemClass.isPrimitive()) {
                    if (Boolean.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((boolean[])elem));
                        continue;
                    }
                    if (Byte.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((byte[])elem));
                        continue;
                    }
                    if (Character.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((char[])elem));
                        continue;
                    }
                    if (Double.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((double[])elem));
                        continue;
                    }
                    if (Float.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((float[])elem));
                        continue;
                    }
                    if (Integer.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((int[])elem));
                        continue;
                    }
                    if (Long.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((long[])elem));
                        continue;
                    }
                    if (Short.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((short[])elem));
                        continue;
                    }
                    throw new AssertionError();
                }
                if (Arrays.deepToStringImplContains(origArrays, elem)) {
                    sb.append("[...]");
                    continue;
                }
                Object[] newArray = (Object[])elem;
                Object[] newOrigArrays = new Object[origArrays.length + 1];
                System.arraycopy(origArrays, 0, newOrigArrays, 0, origArrays.length);
                newOrigArrays[origArrays.length] = newArray;
                Arrays.deepToStringImpl(newArray, newOrigArrays, sb);
                continue;
            }
            sb.append(array2[i]);
        }
        sb.append(']');
    }

    private static boolean deepToStringImplContains(Object[] origArrays, Object array2) {
        if (origArrays == null || origArrays.length == 0) {
            return false;
        }
        for (Object element : origArrays) {
            if (element != array2) continue;
            return true;
        }
        return false;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static char[] copyOf(char[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static double[] copyOf(double[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static float[] copyOf(float[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static int[] copyOf(int[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static long[] copyOf(long[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static short[] copyOf(short[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        if (original == null) {
            throw new NullPointerException("original == null");
        }
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        if (newLength < 0) {
            throw new NegativeArraySizeException(Integer.toString(newLength));
        }
        return Arrays.copyOfRange(original, 0, newLength, newType);
    }

    public static boolean[] copyOfRange(boolean[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        boolean[] result = new boolean[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static byte[] copyOfRange(byte[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        byte[] result = new byte[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static char[] copyOfRange(char[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        char[] result = new char[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static double[] copyOfRange(double[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        double[] result = new double[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static float[] copyOfRange(float[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        float[] result = new float[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static int[] copyOfRange(int[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        int[] result = new int[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static long[] copyOfRange(long[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        long[] result = new long[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static short[] copyOfRange(short[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        short[] result = new short[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static <T> T[] copyOfRange(T[] original, int start, int end) {
        int originalLength = original.length;
        if (start > end) {
            throw new IllegalArgumentException();
        }
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        Object[] result = (Object[])Array.newInstance(original.getClass().getComponentType(), resultLength);
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static <T, U> T[] copyOfRange(U[] original, int start, int end, Class<? extends T[]> newType) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        Object[] result = (Object[])Array.newInstance(newType.getComponentType(), resultLength);
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayList<E>
    extends AbstractList<E>
    implements List<E>,
    Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        ArrayList(E[] storage) {
            if (storage == null) {
                throw new NullPointerException("storage == null");
            }
            this.a = storage;
        }

        @Override
        public boolean contains(Object object) {
            if (object != null) {
                for (E element : this.a) {
                    if (!object.equals(element)) continue;
                    return true;
                }
            } else {
                for (E element : this.a) {
                    if (element != null) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public E get(int location) {
            try {
                return this.a[location];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw java.util.ArrayList.throwIndexOutOfBoundsException(location, this.a.length);
            }
        }

        @Override
        public int indexOf(Object object) {
            if (object != null) {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            if (object != null) {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public E set(int location, E object) {
            E result = this.a[location];
            this.a[location] = object;
            return result;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] contents) {
            int size = this.size();
            if (size > contents.length) {
                Class<?> ct = contents.getClass().getComponentType();
                contents = (Object[])Array.newInstance(ct, size);
            }
            System.arraycopy(this.a, 0, contents, 0, size);
            if (size < contents.length) {
                contents[size] = null;
            }
            return contents;
        }
    }
}

