/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private volatile boolean removeOnCancel = false;
    private static final AtomicLong sequencer = new AtomicLong();

    final long now() {
        return System.nanoTime();
    }

    boolean canRunInCurrentRunState(boolean periodic) {
        return this.isRunningOrShutdown(periodic ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private void delayedExecute(RunnableScheduledFuture<?> task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            super.getQueue().add(task);
            if (this.isShutdown() && !this.canRunInCurrentRunState(task.isPeriodic()) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    void reExecutePeriodic(RunnableScheduledFuture<?> task) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(task);
            if (!this.canRunInCurrentRunState(true) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    @Override
    void onShutdown() {
        BlockingQueue<Runnable> q = super.getQueue();
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            for (Object e : q.toArray()) {
                if (!(e instanceof RunnableScheduledFuture)) continue;
                ((RunnableScheduledFuture)e).cancel(false);
            }
            q.clear();
        } else {
            for (Object e : q.toArray()) {
                RunnableScheduledFuture t;
                if (!(e instanceof RunnableScheduledFuture) || !(!(t = (RunnableScheduledFuture)e).isPeriodic() ? !keepDelayed : !keepPeriodic) && !t.isCancelled() || !q.remove(t)) continue;
                t.cancel(false);
            }
        }
        this.tryTerminate();
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return task;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return task;
    }

    public ScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), handler);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, handler);
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    long triggerTime(long delay) {
        return this.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)super.getQueue().peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(command, null, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<V> t = this.decorateTask(callable, new ScheduledFutureTask<V>(callable, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> sft = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(period));
        RunnableScheduledFuture<Object> t = this.decorateTask(command, sft);
        sft.outerTask = t;
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> sft = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(-delay));
        RunnableScheduledFuture<Object> t = this.decorateTask(command, sft);
        sft.outerTask = t;
        this.delayedExecute(t);
        return t;
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void setRemoveOnCancelPolicy(boolean value) {
        this.removeOnCancel = value;
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelayedWorkQueue
    extends AbstractQueue<Runnable>
    implements BlockingQueue<Runnable> {
        private static final int INITIAL_CAPACITY = 16;
        private RunnableScheduledFuture<?>[] queue = new RunnableScheduledFuture[16];
        private final ReentrantLock lock = new ReentrantLock();
        private int size = 0;
        private Thread leader = null;
        private final Condition available = this.lock.newCondition();

        DelayedWorkQueue() {
        }

        private void setIndex(RunnableScheduledFuture<?> f, int idx) {
            if (f instanceof ScheduledFutureTask) {
                ((ScheduledFutureTask)f).heapIndex = idx;
            }
        }

        private void siftUp(int k, RunnableScheduledFuture<?> key) {
            int parent;
            RunnableScheduledFuture<?> e;
            while (k > 0 && key.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
                this.queue[k] = e;
                this.setIndex(e, k);
                k = parent;
            }
            this.queue[k] = key;
            this.setIndex(key, k);
        }

        private void siftDown(int k, RunnableScheduledFuture<?> key) {
            int half = this.size >>> 1;
            while (k < half) {
                int child = (k << 1) + 1;
                RunnableScheduledFuture<?> c = this.queue[child];
                int right = child + 1;
                if (right < this.size && c.compareTo(this.queue[right]) > 0) {
                    child = right;
                    c = this.queue[child];
                }
                if (key.compareTo(c) <= 0) break;
                this.queue[k] = c;
                this.setIndex(c, k);
                k = child;
            }
            this.queue[k] = key;
            this.setIndex(key, k);
        }

        private void grow() {
            int oldCapacity = this.queue.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            this.queue = Arrays.copyOf(this.queue, newCapacity);
        }

        private int indexOf(Object x) {
            if (x != null) {
                if (x instanceof ScheduledFutureTask) {
                    int i = ((ScheduledFutureTask)x).heapIndex;
                    if (i >= 0 && i < this.size && this.queue[i] == x) {
                        return i;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        if (!x.equals(this.queue[i])) continue;
                        return i;
                    }
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object x) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                boolean bl = this.indexOf(x) != -1;
                Object var5_4 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object x) {
            int i;
            ReentrantLock lock;
            block5: {
                lock = this.lock;
                lock.lock();
                try {
                    i = this.indexOf(x);
                    if (i >= 0) break block5;
                    boolean bl = false;
                    Object var8_6 = null;
                    lock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            this.setIndex(this.queue[i], -1);
            int s = --this.size;
            RunnableScheduledFuture<?> replacement = this.queue[s];
            this.queue[s] = null;
            if (s != i) {
                this.siftDown(i, replacement);
                if (this.queue[i] == replacement) {
                    this.siftUp(i, replacement);
                }
            }
            boolean bl = true;
            Object var8_7 = null;
            lock.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int n = this.size;
                Object var4_3 = null;
                lock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                lock.unlock();
                throw throwable;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunnableScheduledFuture<?> peek() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture<?> runnableScheduledFuture = this.queue[0];
                Object var4_3 = null;
                lock.unlock();
                return runnableScheduledFuture;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(Runnable x) {
            if (x == null) {
                throw new NullPointerException();
            }
            RunnableScheduledFuture e = (RunnableScheduledFuture)x;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i = this.size;
                if (i >= this.queue.length) {
                    this.grow();
                }
                this.size = i + 1;
                if (i == 0) {
                    this.queue[0] = e;
                    this.setIndex(e, 0);
                } else {
                    this.siftUp(i, e);
                }
                if (this.queue[0] == e) {
                    this.leader = null;
                    this.available.signal();
                }
                Object var6_5 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                lock.unlock();
                throw throwable;
            }
            return true;
        }

        @Override
        public void put(Runnable e) {
            this.offer(e);
        }

        @Override
        public boolean add(Runnable e) {
            return this.offer(e);
        }

        @Override
        public boolean offer(Runnable e, long timeout, TimeUnit unit) {
            return this.offer(e);
        }

        private RunnableScheduledFuture<?> finishPoll(RunnableScheduledFuture<?> f) {
            int s = --this.size;
            RunnableScheduledFuture<?> x = this.queue[s];
            this.queue[s] = null;
            if (s != 0) {
                this.siftDown(0, x);
            }
            this.setIndex(f, -1);
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunnableScheduledFuture<?> poll() {
            RunnableScheduledFuture<?> first;
            ReentrantLock lock;
            block3: {
                lock = this.lock;
                lock.lock();
                try {
                    first = this.queue[0];
                    if (first != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L) break block3;
                    RunnableScheduledFuture<?> runnableScheduledFuture = null;
                    Object var5_5 = null;
                    lock.unlock();
                    return runnableScheduledFuture;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            RunnableScheduledFuture<?> runnableScheduledFuture = this.finishPoll(first);
            Object var5_6 = null;
            lock.unlock();
            return runnableScheduledFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public RunnableScheduledFuture<?> take() throws InterruptedException {
            lock = this.lock;
            lock.lockInterruptibly();
            while (true) lbl-1000:
            // 5 sources

            {
                first = this.queue[0];
                if (first == null) {
                    this.available.await();
                    continue;
                }
                delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) break block11;
                var5_4 = this.finishPoll(first);
                var9_6 = null;
                break;
            }
            catch (Throwable var8_9) {
                var9_7 = null;
                if (this.leader == null && this.queue[0] != null) {
                    this.available.signal();
                }
                lock.unlock();
                throw var8_9;
            }
            {
                block11: {
                    if (this.leader == null && this.queue[0] != null) {
                        this.available.signal();
                    }
                    lock.unlock();
                    return var5_4;
                }
                first = null;
                if (this.leader != null) {
                    this.available.await();
                    continue;
                }
                this.leader = thisThread = Thread.currentThread();
                try {
                    this.available.awaitNanos(delay);
                    var7_5 = null;
                    if (this.leader != thisThread) continue;
                    this.leader = null;
                    continue;
                }
                catch (Throwable var6_8) {
                    var7_5 = null;
                    if (this.leader == thisThread) {
                        this.leader = null;
                    }
                    throw var6_8;
                }
                ** while (true)
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public RunnableScheduledFuture<?> poll(long timeout, TimeUnit unit) throws InterruptedException {
            nanos = unit.toNanos(timeout);
            lock = this.lock;
            lock.lockInterruptibly();
            while (true) lbl-1000:
            // 5 sources

            {
                first = this.queue[0];
                if (first != null) ** GOTO lbl28
                if (nanos > 0L) break block14;
                var8_7 = null;
                var16_11 = null;
                break;
            }
            catch (Throwable var15_16) {
                var16_14 = null;
                if (this.leader == null && this.queue[0] != null) {
                    this.available.signal();
                }
                lock.unlock();
                throw var15_16;
            }
            {
                block16: {
                    block15: {
                        block14: {
                            if (this.leader == null && this.queue[0] != null) {
                                this.available.signal();
                            }
                            lock.unlock();
                            return var8_7;
                        }
                        nanos = this.available.awaitNanos(nanos);
                        continue;
lbl28:
                        // 1 sources

                        delay = first.getDelay(TimeUnit.NANOSECONDS);
                        if (delay > 0L) break block15;
                        var10_8 = this.finishPoll(first);
                        var16_12 = null;
                        if (this.leader == null && this.queue[0] != null) {
                            this.available.signal();
                        }
                        lock.unlock();
                        return var10_8;
                    }
                    if (nanos > 0L) break block16;
                    var10_8 = null;
                    var16_13 = null;
                    if (this.leader == null && this.queue[0] != null) {
                        this.available.signal();
                    }
                    lock.unlock();
                    return var10_8;
                }
                first = null;
                if (nanos < delay || this.leader != null) {
                    nanos = this.available.awaitNanos(nanos);
                    continue;
                }
                this.leader = thisThread = Thread.currentThread();
                try {
                    timeLeft = this.available.awaitNanos(delay);
                    nanos -= delay - timeLeft;
                    var14_10 = null;
                    if (this.leader != thisThread) continue;
                    this.leader = null;
                    continue;
                }
                catch (Throwable var13_15) {
                    var14_10 = null;
                    if (this.leader == thisThread) {
                        this.leader = null;
                    }
                    throw var13_15;
                }
                ** while (true)
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    RunnableScheduledFuture<?> t = this.queue[i];
                    if (t == null) continue;
                    this.queue[i] = null;
                    this.setIndex(t, -1);
                }
                this.size = 0;
                Object var5_4 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                lock.unlock();
                throw throwable;
            }
        }

        private RunnableScheduledFuture<?> peekExpired() {
            RunnableScheduledFuture<?> first = this.queue[0];
            return first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L ? null : first;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture<?> first;
                int n = 0;
                while ((first = this.peekExpired()) != null) {
                    c.add(first);
                    this.finishPoll(first);
                    ++n;
                }
                int n2 = n;
                Object var7_6 = null;
                lock.unlock();
                return n2;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            if (maxElements <= 0) {
                return 0;
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture<?> first;
                int n;
                for (n = 0; n < maxElements && (first = this.peekExpired()) != null; ++n) {
                    c.add(first);
                    this.finishPoll(first);
                }
                int n2 = n;
                Object var8_7 = null;
                lock.unlock();
                return n2;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Object[] objectArray = Arrays.copyOf(this.queue, this.size, Object[].class);
                Object var4_3 = null;
                lock.unlock();
                return objectArray;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            ReentrantLock lock;
            block4: {
                lock = this.lock;
                lock.lock();
                try {
                    if (a.length >= this.size) break block4;
                    T[] TArray = Arrays.copyOf(this.queue, this.size, a.getClass());
                    Object var5_5 = null;
                    lock.unlock();
                    return TArray;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            System.arraycopy(this.queue, 0, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            T[] TArray = a;
            Object var5_6 = null;
            lock.unlock();
            return TArray;
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Itr(Arrays.copyOf(this.queue, this.size));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Itr
        implements Iterator<Runnable> {
            final RunnableScheduledFuture[] array;
            int cursor = 0;
            int lastRet = -1;

            Itr(RunnableScheduledFuture[] array2) {
                this.array = array2;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.array.length;
            }

            @Override
            public Runnable next() {
                if (this.cursor >= this.array.length) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor;
                return this.array[this.cursor++];
            }

            @Override
            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                DelayedWorkQueue.this.remove(this.array[this.lastRet]);
                this.lastRet = -1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;
        RunnableScheduledFuture<V> outerTask;
        int heapIndex;

        ScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.outerTask = this;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.outerTask = this;
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.outerTask = this;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : ScheduledThreadPoolExecutor.this.triggerTime(-p);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && ScheduledThreadPoolExecutor.this.removeOnCancel && this.heapIndex >= 0) {
                ScheduledThreadPoolExecutor.this.remove(this);
            }
            return cancelled;
        }

        @Override
        public void run() {
            boolean periodic = this.isPeriodic();
            if (!ScheduledThreadPoolExecutor.this.canRunInCurrentRunState(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                ScheduledFutureTask.super.run();
            } else if (ScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                ScheduledThreadPoolExecutor.this.reExecutePeriodic(this.outerTask);
            }
        }
    }
}

