/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import libcore.io.Streams;

public class JarInputStream
extends ZipInputStream {
    private Manifest manifest;
    private boolean verified = false;
    private JarEntry currentJarEntry = null;
    private JarEntry pendingJarEntry = null;
    private boolean isMeta;
    private JarVerifier verifier = null;
    private OutputStream verStream;

    public JarInputStream(InputStream stream, boolean verify) throws IOException {
        super(stream);
        if (this.getNextJarEntry() == null) {
            return;
        }
        if (this.currentJarEntry.getName().equalsIgnoreCase("META-INF/")) {
            this.closeEntry();
            this.getNextJarEntry();
        }
        if (this.currentJarEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            byte[] manifestBytes = Streams.readFullyNoClose(this);
            this.manifest = new Manifest(manifestBytes, verify);
            this.closeEntry();
            if (verify) {
                HashMap<String, byte[]> metaEntries = new HashMap<String, byte[]>();
                metaEntries.put("META-INF/MANIFEST.MF", manifestBytes);
                this.verifier = new JarVerifier("JarInputStream", this.manifest, metaEntries);
            }
        }
        this.pendingJarEntry = this.currentJarEntry;
        this.currentJarEntry = null;
    }

    public JarInputStream(InputStream stream) throws IOException {
        this(stream, true);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public JarEntry getNextJarEntry() throws IOException {
        return (JarEntry)this.getNextEntry();
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        if (this.currentJarEntry == null) {
            return -1;
        }
        int r = super.read(buffer, byteOffset, byteCount);
        if (this.verifier != null && this.verStream != null && !this.verified) {
            if (r == -1) {
                this.verified = true;
                if (this.isMeta) {
                    this.verifier.addMetaEntry(this.currentJarEntry.getName(), ((ByteArrayOutputStream)this.verStream).toByteArray());
                    try {
                        this.verifier.readCertificates();
                    }
                    catch (SecurityException e) {
                        this.verifier = null;
                        throw e;
                    }
                } else {
                    ((JarVerifier.VerifierEntry)this.verStream).verify();
                }
            } else {
                this.verStream.write(buffer, byteOffset, r);
            }
        }
        return r;
    }

    public ZipEntry getNextEntry() throws IOException {
        if (this.pendingJarEntry != null) {
            JarEntry pending = this.pendingJarEntry;
            this.pendingJarEntry = null;
            this.currentJarEntry = pending;
            return pending;
        }
        this.currentJarEntry = (JarEntry)super.getNextEntry();
        if (this.currentJarEntry == null) {
            return null;
        }
        if (this.verifier != null) {
            int entrySize;
            this.isMeta = this.currentJarEntry.getName().toUpperCase(Locale.US).startsWith("META-INF/");
            this.verStream = this.isMeta ? new ByteArrayOutputStream((entrySize = (int)this.currentJarEntry.getSize()) > 0 ? entrySize : 8192) : this.verifier.initEntry(this.currentJarEntry.getName());
        }
        this.verified = false;
        return this.currentJarEntry;
    }

    public void closeEntry() throws IOException {
        if (this.pendingJarEntry != null) {
            return;
        }
        super.closeEntry();
        this.currentJarEntry = null;
    }

    protected ZipEntry createZipEntry(String name) {
        JarEntry entry = new JarEntry(name);
        if (this.manifest != null) {
            entry.setAttributes(this.manifest.getAttributes(name));
        }
        return entry;
    }
}

