/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.jar.ManifestReader;
import libcore.io.Base64;
import org.apache.harmony.security.utils.JarUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarVerifier {
    private static final String[] DIGEST_ALGORITHMS = new String[]{"SHA-512", "SHA-384", "SHA-256", "SHA1"};
    private final String jarName;
    private final Manifest manifest;
    private final HashMap<String, byte[]> metaEntries;
    private final int mainAttributesEnd;
    private final Hashtable<String, HashMap<String, Attributes>> signatures = new Hashtable(5);
    private final Hashtable<String, Certificate[]> certificates = new Hashtable(5);
    private final Hashtable<String, Certificate[]> verifiedEntries = new Hashtable();

    private static SecurityException invalidDigest(String signatureFile, String name, String jarName) {
        throw new SecurityException(signatureFile + " has invalid digest for " + name + " in " + jarName);
    }

    private static SecurityException failedVerification(String jarName, String signatureFile) {
        throw new SecurityException(jarName + " failed verification of " + signatureFile);
    }

    JarVerifier(String name, Manifest manifest, HashMap<String, byte[]> metaEntries) {
        this.jarName = name;
        this.manifest = manifest;
        this.metaEntries = metaEntries;
        this.mainAttributesEnd = manifest.getMainAttributesEnd();
    }

    VerifierEntry initEntry(String name) {
        if (this.manifest == null || this.signatures.isEmpty()) {
            return null;
        }
        Attributes attributes = this.manifest.getAttributes(name);
        if (attributes == null) {
            return null;
        }
        ArrayList certs = new ArrayList();
        for (Map.Entry<String, HashMap<String, Attributes>> entry : this.signatures.entrySet()) {
            String signatureFile;
            Certificate[] certChain;
            HashMap<String, Attributes> hm = entry.getValue();
            if (hm.get(name) == null || (certChain = this.certificates.get(signatureFile = entry.getKey())) == null) continue;
            Collections.addAll(certs, certChain);
        }
        if (certs.isEmpty()) {
            return null;
        }
        Certificate[] certificatesArray = certs.toArray(new Certificate[certs.size()]);
        for (int i = 0; i < DIGEST_ALGORITHMS.length; ++i) {
            String algorithm = DIGEST_ALGORITHMS[i];
            String hash = attributes.getValue(algorithm + "-Digest");
            if (hash == null) continue;
            byte[] hashBytes = hash.getBytes(StandardCharsets.ISO_8859_1);
            try {
                return new VerifierEntry(name, MessageDigest.getInstance(algorithm), hashBytes, certificatesArray, this.verifiedEntries);
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
        }
        return null;
    }

    void addMetaEntry(String name, byte[] buf) {
        this.metaEntries.put(name.toUpperCase(Locale.US), buf);
    }

    synchronized boolean readCertificates() {
        if (this.metaEntries.isEmpty()) {
            return false;
        }
        Iterator<String> it = this.metaEntries.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.endsWith(".DSA") && !key.endsWith(".RSA") && !key.endsWith(".EC")) continue;
            this.verifyCertificate(key);
            it.remove();
        }
        return true;
    }

    private void verifyCertificate(String certFile) {
        String digestAttribute;
        String signatureFile = certFile.substring(0, certFile.lastIndexOf(46)) + ".SF";
        byte[] sfBytes = this.metaEntries.get(signatureFile);
        if (sfBytes == null) {
            return;
        }
        byte[] manifestBytes = this.metaEntries.get("META-INF/MANIFEST.MF");
        if (manifestBytes == null) {
            return;
        }
        byte[] sBlockBytes = this.metaEntries.get(certFile);
        try {
            Certificate[] signerCertChain = JarUtils.verifySignature(new ByteArrayInputStream(sfBytes), new ByteArrayInputStream(sBlockBytes));
            if (signerCertChain != null) {
                this.certificates.put(signatureFile, signerCertChain);
            }
        }
        catch (IOException e) {
            return;
        }
        catch (GeneralSecurityException e) {
            throw JarVerifier.failedVerification(this.jarName, signatureFile);
        }
        Attributes attributes = new Attributes();
        HashMap<String, Attributes> entries = new HashMap<String, Attributes>();
        try {
            ManifestReader im = new ManifestReader(sfBytes, attributes);
            im.readEntries(entries, null);
        }
        catch (IOException e) {
            return;
        }
        if (attributes.get(Attributes.Name.SIGNATURE_VERSION) == null) {
            return;
        }
        boolean createdBySigntool = false;
        String createdBy = attributes.getValue("Created-By");
        if (createdBy != null) {
            boolean bl = createdBySigntool = createdBy.indexOf("signtool") != -1;
        }
        if (this.mainAttributesEnd > 0 && !createdBySigntool && !this.verify(attributes, digestAttribute = "-Digest-Manifest-Main-Attributes", manifestBytes, 0, this.mainAttributesEnd, false, true)) {
            throw JarVerifier.failedVerification(this.jarName, signatureFile);
        }
        String string2 = digestAttribute = createdBySigntool ? "-Digest" : "-Digest-Manifest";
        if (!this.verify(attributes, digestAttribute, manifestBytes, 0, manifestBytes.length, false, false)) {
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                Manifest.Chunk chunk = this.manifest.getChunk(entry.getKey());
                if (chunk == null) {
                    return;
                }
                if (this.verify(entry.getValue(), "-Digest", manifestBytes, chunk.start, chunk.end, createdBySigntool, false)) continue;
                throw JarVerifier.invalidDigest(signatureFile, entry.getKey(), this.jarName);
            }
        }
        this.metaEntries.put(signatureFile, null);
        this.signatures.put(signatureFile, entries);
    }

    boolean isSignedJar() {
        return this.certificates.size() > 0;
    }

    private boolean verify(Attributes attributes, String entry, byte[] data, int start, int end, boolean ignoreSecondEndline, boolean ignorable) {
        for (int i = 0; i < DIGEST_ALGORITHMS.length; ++i) {
            MessageDigest md;
            String algorithm = DIGEST_ALGORITHMS[i];
            String hash = attributes.getValue(algorithm + entry);
            if (hash == null) continue;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                continue;
            }
            if (ignoreSecondEndline && data[end - 1] == 10 && data[end - 2] == 10) {
                md.update(data, start, end - 1 - start);
            } else {
                md.update(data, start, end - start);
            }
            byte[] b = md.digest();
            byte[] hashBytes = hash.getBytes(StandardCharsets.ISO_8859_1);
            return MessageDigest.isEqual(b, Base64.decode(hashBytes));
        }
        return ignorable;
    }

    Certificate[] getCertificates(String name) {
        Certificate[] verifiedCerts = this.verifiedEntries.get(name);
        if (verifiedCerts == null) {
            return null;
        }
        return (Certificate[])verifiedCerts.clone();
    }

    void removeMetaEntries() {
        this.metaEntries.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VerifierEntry
    extends OutputStream {
        private final String name;
        private final MessageDigest digest;
        private final byte[] hash;
        private final Certificate[] certificates;
        private final Hashtable<String, Certificate[]> verifiedEntries;

        VerifierEntry(String name, MessageDigest digest, byte[] hash, Certificate[] certificates, Hashtable<String, Certificate[]> verifedEntries) {
            this.name = name;
            this.digest = digest;
            this.hash = hash;
            this.certificates = certificates;
            this.verifiedEntries = verifedEntries;
        }

        @Override
        public void write(int value) {
            this.digest.update((byte)value);
        }

        @Override
        public void write(byte[] buf, int off, int nbytes) {
            this.digest.update(buf, off, nbytes);
        }

        void verify() {
            byte[] d = this.digest.digest();
            if (!MessageDigest.isEqual(d, Base64.decode(this.hash))) {
                throw JarVerifier.invalidDigest("META-INF/MANIFEST.MF", this.name, this.name);
            }
            this.verifiedEntries.put(this.name, this.certificates);
        }
    }
}

